/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;

public class BrytonTrackRecordMesg
extends Mesg {
    private static final int ALTITUDE_FIELD_TYPE = 132;
    private static final int ALTITUDE_OFFSET = 500;
    private static final Profile.Type ALTITUDE_PROFILE_TYPE;
    private static final int ALTITUDE_SCALE = 5;
    public static final int AltitudeFieldNum = 3;
    private static final int GRADE_FIELD_TYPE = 131;
    private static final float GRADE_OFFSET = 0.0f;
    private static final Profile.Type GRADE_PROFILE_TYPE;
    private static final float GRADE_SCALE = 1.0f;
    public static final int GradeFieldNum = 4;
    private static final int LATITUDE_FIELD_TYPE = 133;
    private static final double LATITUDE_OFFSET = 0.0;
    private static final Profile.Type LATITUDE_PROFILE_TYPE;
    private static final double LATITUDE_SCALE = 1000000.0;
    private static final int LONGITUDE_FIELD_TYPE = 133;
    private static final double LONGITUDE_OFFSET = 0.0;
    private static final Profile.Type LONGITUDE_PROFILE_TYPE;
    private static final double LONGITUDE_SCALE = 1000000.0;
    public static final int LatitudeFieldNum = 1;
    public static final int LongitudeFieldNum = 2;
    public static final int MesgID = 63744;
    protected static final Mesg trackRecordMesg;

    static {
        LATITUDE_PROFILE_TYPE = Profile.Type.SINT32;
        LONGITUDE_PROFILE_TYPE = Profile.Type.SINT32;
        ALTITUDE_PROFILE_TYPE = Profile.Type.UINT16;
        GRADE_PROFILE_TYPE = Profile.Type.SINT16;
        trackRecordMesg = new Mesg("track_record", 63744);
    }

    public BrytonTrackRecordMesg() {
        super(Factory.createMesg(63744));
    }

    public BrytonTrackRecordMesg(Mesg mesg) {
        super(mesg);
    }

    public void addField() {
        this.fields.add(new Field("latitude", 1, 133, 1000000.0, 0.0, "", false, LATITUDE_PROFILE_TYPE));
        this.fields.add(new Field("longitude", 2, 133, 1000000.0, 0.0, "", false, LONGITUDE_PROFILE_TYPE));
        this.fields.add(new Field("altitude", 3, 132, 5.0, 500.0, "", false, ALTITUDE_PROFILE_TYPE));
    }

    public void addField(String string2) {
        string2.hashCode();
        if (string2.equals("grade")) {
            this.fields.add(new Field("grade", 4, 131, 1.0, 0.0, "", false, GRADE_PROFILE_TYPE));
        }
    }

    public Integer getAltitude() {
        int n = Fit.UINT16_INVALID;
        if (this.getFieldIntegerValue(3, 0, 65535) != null) {
            n = this.getFieldIntegerValue(3, 0, 65535) / 5 - 500;
        }
        return n;
    }

    public Float getGrade() {
        Float f = Float.valueOf(Fit.SINT16_INVALID.floatValue());
        if (this.getFieldFloatValue(4, 0, 65535) != null) {
            f = Float.valueOf(this.getFieldFloatValue(4, 0, 65535).floatValue() / 1.0f - 0.0f);
        }
        return f;
    }

    public Double getLatitude() {
        Double d = Fit.SINT16_INVALID.doubleValue();
        if (this.getFieldDoubleValue(1, 0, 65535) != null) {
            d = this.getFieldDoubleValue(1, 0, 65535) / 1000000.0 - 0.0;
        }
        return d;
    }

    public Double getLongitude() {
        Double d = Fit.SINT16_INVALID.doubleValue();
        if (this.getFieldDoubleValue(2, 0, 65535) != null) {
            d = this.getFieldDoubleValue(2, 0, 65535) / 1000000.0 - 0.0;
        }
        return d;
    }

    public void setAltitude(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 65535);
    }

    public void setGrade(Float f) {
        this.setFieldValue(4, 0, (Object)f, 65535);
    }

    public void setLatitude(Double d) {
        this.setFieldValue(1, 0, (Object)d, 65535);
    }

    public void setLongitude(Double d) {
        this.setFieldValue(2, 0, (Object)d, 65535);
    }
}

