/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Fit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateTime {
    public static final long INVALID = Fit.UINT32_INVALID;
    public static final long MIN = 0x10000000L;
    public static final long OFFSET = 631065600000L;
    private static final Map<Long, String> stringMap;
    private double fractional_timestamp;
    private long timestamp;

    static {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        stringMap = hashMap;
        hashMap.put(0x10000000L, "MIN");
    }

    public DateTime(long l) {
        this.timestamp = l;
        this.fractional_timestamp = 0.0;
    }

    public DateTime(long l, double d) {
        this.timestamp = l + (long)Math.floor(d);
        this.fractional_timestamp = d - Math.floor(d);
    }

    public DateTime(DateTime dateTime) {
        this(dateTime.getTimestamp(), dateTime.getFractionalTimestamp());
    }

    public DateTime(Date date) {
        this.timestamp = (date.getTime() - 631065600000L) / 1000L;
        this.fractional_timestamp = (double)((date.getTime() - 631065600000L) % 1000L) / 1000.0;
    }

    public static String getStringFromValue(Long l) {
        Map<Long, String> map = stringMap;
        if (map.containsKey(l)) {
            return map.get(l);
        }
        return "";
    }

    public static Long getValueFromString(String string2) {
        for (Map.Entry<Long, String> entry : stringMap.entrySet()) {
            if (!entry.getValue().equals(string2)) continue;
            return entry.getKey();
        }
        return INVALID;
    }

    public void add(double d) {
        this.add(new DateTime(0L, d));
    }

    public void add(long l) {
        this.add(new DateTime(l));
    }

    public void add(DateTime dateTime) {
        double d;
        this.timestamp += dateTime.getTimestamp().longValue();
        this.fractional_timestamp = d = this.fractional_timestamp + dateTime.getFractionalTimestamp();
        this.timestamp += (long)Math.floor(d);
        d = this.fractional_timestamp;
        this.fractional_timestamp = d - (double)((float)Math.floor(d));
    }

    public int compareTo(DateTime dateTime) {
        if (this.timestamp == dateTime.getTimestamp()) {
            return Double.compare(this.fractional_timestamp, dateTime.getFractionalTimestamp());
        }
        if (this.timestamp > dateTime.getTimestamp()) {
            return 1;
        }
        return -1;
    }

    public void convertSystemTimeToUTC(long l) {
        long l2 = this.timestamp;
        if (l2 < 0x10000000L) {
            this.timestamp = l2 + l;
        }
    }

    public boolean equals(DateTime dateTime) {
        boolean bl = this.getTimestamp().equals(dateTime.getTimestamp()) && this.getFractionalTimestamp().equals(dateTime.getFractionalTimestamp());
        return bl;
    }

    public Date getDate() {
        long l = Math.round(this.fractional_timestamp * 1000.0);
        return new Date(this.timestamp * 1000L + l + 631065600000L);
    }

    public Double getFractionalTimestamp() {
        return new Double(this.fractional_timestamp);
    }

    public Long getTimestamp() {
        return new Long(this.timestamp);
    }

    public String toString() {
        return this.getDate().toString();
    }
}

