/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import android.util.Log;
import com.garmin.fit.CRC;
import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.DeveloperFieldDescriptionListener;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FieldDescriptionMesg;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.Profile;
import com.garmin.fit.SubField;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class Decode {
    private static final int BUFFER_SIZE = 512;
    private static final long DECODE_DATA_RECORDS_ONLY = Long.MAX_VALUE;
    private static final int FIT_HEADER_SIZE_NO_CRC = 12;
    private static final int FIT_HEADER_SIZE_WITH_CRC = 14;
    private static final int FIT_PROTOCOL_VERSION_ONE = 1;
    private static boolean invalidDataSize = false;
    private Accumulator accumulator;
    private byte[] buffer;
    private int bytesRead;
    private int crc;
    private int currentByteIndex;
    private int currentByteOffset = 0;
    private ArrayList<DeveloperFieldDescriptionListener> devFieldDescListeners;
    private HashMap<Short, DeveloperDataIdMesg> developerDataIds;
    private HashMap<Short, HashMap<Short, FieldDescriptionMesg>> developerFields;
    private int fieldBytesLeft;
    private byte[] fieldData;
    private int fieldDataIndex;
    private int fieldIndex;
    private long fileBytesLeft;
    private long fileDataSize;
    private byte fileHdrOffset;
    private byte fileHdrSize;
    private boolean hasDevData;
    private String headerException;
    private InputStream in;
    private boolean instreamIsComplete = true;
    private boolean invalidFileDataSize = false;
    private int lastTimeOffset;
    private MesgDefinition[] localMesgDefs = new MesgDefinition[16];
    private int localMesgIndex;
    private Mesg mesg;
    private ArrayList<MesgDefinitionListener> mesgDefListeners;
    private ArrayList<MesgListener> mesgListeners;
    private int numFields;
    private boolean pause;
    private STATE state;
    private long systemTimeOffset = 0L;
    private long timestamp;
    String ts;
    String ts2;
    String ts3;
    String ts4;
    String ts5;
    Long tsLong;
    Long tsLong2;
    Long tsLong3;
    Long tsLong4;
    Long tsLong5;

    public Decode() {
        this.developerDataIds = new HashMap();
        this.developerFields = new HashMap();
        this.fieldData = new byte[255];
        this.accumulator = new Accumulator();
        this.mesgListeners = new ArrayList();
        this.mesgDefListeners = new ArrayList();
        this.devFieldDescListeners = new ArrayList();
        this.nextFile();
        this.bytesRead = 0;
        this.currentByteIndex = 0;
        this.buffer = new byte[512];
        if (Fit.debug) {
            System.out.printf("Fit.Decode: Starting decode...\n", new Object[0]);
        }
    }

    private void FlipFieldDataByteOrder(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n / 2; ++j) {
                byte[] byArray = this.fieldData;
                int n3 = i * n;
                int n4 = n3 + j;
                byte by = byArray[n4];
                n3 = n3 + n - j - 1;
                byArray[n4] = byArray[n3];
                byArray[n3] = by;
            }
        }
    }

    public void addListener(DeveloperFieldDescriptionListener developerFieldDescriptionListener) {
        if (developerFieldDescriptionListener != null && !this.devFieldDescListeners.contains(developerFieldDescriptionListener)) {
            this.devFieldDescListeners.add(developerFieldDescriptionListener);
        }
    }

    public void addListener(MesgDefinitionListener mesgDefinitionListener) {
        if (mesgDefinitionListener != null && !this.mesgDefListeners.contains(mesgDefinitionListener)) {
            this.mesgDefListeners.add(mesgDefinitionListener);
        }
    }

    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    public boolean bytesAvailable(InputStream inputStream) throws IOException {
        int n = this.currentByteIndex;
        boolean bl = true;
        if ((n <= 0 || n >= this.bytesRead) && inputStream.available() <= 0) {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkFileIntegrity(InputStream inputStream) {
        boolean bl = true;
        try {
            while (true) {
                int n;
                if (this.currentByteIndex < this.bytesRead) {
                    n = 1.$SwitchMap$com$garmin$fit$Decode$RETURN[this.read(this.buffer[this.currentByteIndex]).ordinal()];
                    boolean bl2 = bl;
                    if (n != 1) {
                        bl2 = bl;
                        if (n != 2) {
                            bl2 = bl;
                            if (n != 3) {
                                if (n != 4) {
                                    bl2 = false;
                                } else {
                                    this.nextFile();
                                    bl2 = bl;
                                }
                            }
                        }
                    }
                    ++this.currentByteIndex;
                    bl = bl2;
                    continue;
                }
                this.currentByteIndex = 0;
                byte[] byArray = this.buffer;
                this.bytesRead = n = inputStream.read(byArray, 0, byArray.length);
                if (n < 0) break;
            }
            return bl;
        }
        catch (FitRuntimeException fitRuntimeException) {
            if (this.getInvalidFileDataSize()) {
                this.nextFile();
            }
            this.bytesRead = 0;
            this.currentByteIndex = 0;
            return false;
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    protected void expandComponents(Field field, ArrayList<FieldComponent> arrayList) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            FieldComponent fieldComponent = arrayList.get(i);
            if (fieldComponent.fieldNum != 255) {
                Field field2 = Factory.createField(this.mesg.num, fieldComponent.fieldNum);
                SubField subField = field2.getSubField(this.mesg.getActiveSubFieldIndex(fieldComponent.fieldNum));
                field2.setIsExpanded(true);
                Long l = field.getBitsValue(n, fieldComponent.bits, field2.isSignedInteger());
                if (l == null) break;
                Number number = l;
                if (fieldComponent.accumulate) {
                    number = this.accumulator.accumulate(this.mesg.num, fieldComponent.fieldNum, l, fieldComponent.bits);
                }
                if (field2.components.size() == 1) {
                    number = ((double)((Long)number).longValue() / fieldComponent.scale - fieldComponent.offset + field2.components.get((int)0).offset) * field2.components.get((int)0).scale;
                    if (this.mesg.hasField(field2.num)) {
                        this.mesg.getField(field2.num).addRawValue(number);
                    } else {
                        field2.addRawValue(number);
                        this.mesg.addField(field2);
                    }
                } else if (field2.components.size() > 1) {
                    for (int j = 0; j < fieldComponent.bits; j += Fit.baseTypeSizes[field2.type & 0x1F]) {
                        long l2 = (1L << Fit.baseTypeSizes[field2.type & 0x1F]) - 1L;
                        if (this.mesg.hasField(field2.num)) {
                            this.mesg.getField(field2.num).addValue((Long)number & l2);
                        } else {
                            field2.addValue((Long)number & l2);
                            this.mesg.addField(field2);
                        }
                        number = (Long)number >>> Fit.baseTypeSizes[field2.type & 0x1F];
                    }
                } else {
                    number = subField == null ? Double.valueOf(((double)((Long)number).longValue() / fieldComponent.scale - fieldComponent.offset + field2.offset) * field2.scale) : Double.valueOf(((double)((Long)number).longValue() / fieldComponent.scale - fieldComponent.offset + subField.offset) * subField.scale);
                    if (this.mesg.hasField(field2.num)) {
                        this.mesg.getField(field2.num).addRawValue(number);
                    } else {
                        field2.addRawValue(number);
                        this.mesg.addField(field2);
                    }
                }
            }
            n += fieldComponent.bits;
        }
    }

    public boolean getInvalidFileDataSize() {
        return this.invalidFileDataSize;
    }

    public Mesg getMesg() {
        return this.mesg;
    }

    public void incompleteStream() {
        if (this.in == null) {
            this.instreamIsComplete = false;
            return;
        }
        throw new FitRuntimeException("Can't set incompleteStream option after Decode started!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFileFit(InputStream inputStream) {
        try {
            while (true) {
                int n;
                if (this.currentByteIndex < this.bytesRead) {
                    n = 1.$SwitchMap$com$garmin$fit$Decode$RETURN[this.read(this.buffer[this.currentByteIndex]).ordinal()];
                    if (n != 1 && n != 2 && n != 3) {
                        if (n == 4) return true;
                        return false;
                    }
                    if (this.state != STATE.FILE_HDR) {
                        return true;
                    }
                    ++this.currentByteIndex;
                    continue;
                }
                this.currentByteIndex = 0;
                byte[] byArray = this.buffer;
                this.bytesRead = n = inputStream.read(byArray, 0, byArray.length);
                if (n < 0) return false;
            }
        }
        catch (FitRuntimeException fitRuntimeException) {
            this.bytesRead = 0;
            this.currentByteIndex = 0;
            return false;
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    public void nextFile() {
        if (this.instreamIsComplete) {
            this.fileBytesLeft = 3L;
            this.fileHdrOffset = (byte)0;
            this.crc = 0;
            this.state = STATE.FILE_HDR;
            this.lastTimeOffset = 0;
            this.pause = false;
            invalidDataSize = false;
            this.invalidFileDataSize = false;
            this.headerException = null;
        }
    }

    public void pause() {
        this.pause = true;
    }

    /*
     * Unable to fully structure code
     */
    public RETURN read(byte var1_1) {
        if (Fit.debug) {
            if (this.fileBytesLeft == 2L) {
                System.out.printf("Fit.Decode: Expecting next 2 bytes to be end of file CRC = 0x%04X\n", new Object[]{this.crc});
            }
            System.out.printf("Fit.Decode: 0x%02X - %s\n", new Object[]{var1_1 & 255, this.state.toString()});
            var2_2 = new StringBuilder();
            var2_2.append("Fit.Decode: ");
            var2_2.append(this.state.toString());
            var2_2.append(" ,Value = ");
            var2_2.append(Integer.toHexString(var1_1));
            Log.d((String)"Grad Debug", (String)var2_2.toString());
        }
        if ((var3_3 = this.fileBytesLeft) > 0L && var3_3 != 0x7FFFFFFFFFFFFFFFL) {
            this.crc = CRC.get16(this.crc, var1_1);
            this.fileBytesLeft = var3_3 = this.fileBytesLeft - 1L;
            if (var3_3 == 1L && this.state.ordinal() > STATE.FILE_HDR.ordinal()) {
                if (this.state == STATE.RECORD) {
                    return RETURN.CONTINUE;
                }
                var2_2 = new StringBuilder();
                var2_2.append("FIT decode error: Decoder not in correct state after last data byte in file.  Check message definitions. Error at byte: ");
                var2_2.append(this.currentByteOffset);
                throw new FitRuntimeException(var2_2.toString());
            }
            if (this.fileBytesLeft == 0L && this.state.ordinal() > STATE.FILE_HDR.ordinal()) {
                if (this.crc == 0) {
                    return RETURN.END_OF_FILE;
                }
                var2_2 = new StringBuilder();
                var2_2.append("FIT decode error: File CRC failed. Error at byte: ");
                var2_2.append(this.currentByteOffset);
                throw new FitRuntimeException(var2_2.toString());
            }
        }
        switch (1.$SwitchMap$com$garmin$fit$Decode$STATE[this.state.ordinal()]) {
            default: {
                break;
            }
            case 16: {
                var2_2 = this.localMesgDefs[this.localMesgIndex];
                var5_4 = var2_2.developerFields.get(this.fieldIndex);
                while (this.fieldBytesLeft == 0) {
                    this.fieldDataIndex = 0;
                    this.fieldBytesLeft = var6_7 = var5_4.getSize();
                    if (var6_7 != 0) continue;
                    if (this.fieldIndex + 1 >= this.localMesgDefs[this.localMesgIndex].developerFields.size()) break;
                    var7_17 = this.localMesgDefs[this.localMesgIndex].developerFields;
                    this.fieldIndex = var6_7 = this.fieldIndex + 1;
                    this.fieldBytesLeft = ((DeveloperFieldDefinition)var7_17.get(var6_7)).getSize();
                }
                var7_17 = this.fieldData;
                var6_7 = this.fieldDataIndex;
                this.fieldDataIndex = var6_7 + 1;
                var7_17[var6_7] = var1_1;
                this.fieldBytesLeft = var6_7 = this.fieldBytesLeft - 1;
                if (var6_7 != 0) break;
                var7_17 = new DeveloperField(var5_4);
                if ((var5_4.getType() & 31) < 17) {
                    var8_19 = Fit.baseTypeSizes[var5_4.getType() & 31];
                    var6_7 = var5_4.getSize() / var8_19;
                    if ((var5_4.getType() & 128) != 0 && (var2_2.arch & 1) != 1) {
                        this.FlipFieldDataByteOrder(var8_19, var6_7);
                    }
                    var7_17.read(new ByteArrayInputStream(this.fieldData), var5_4.getSize());
                    if (var7_17.getNumValues() > 0) {
                        this.mesg.addDeveloperField((DeveloperField)var7_17);
                    }
                }
                this.fieldIndex = var6_7 = this.fieldIndex + 1;
                if (var6_7 < var2_2.developerFields.size()) break;
                this.state = STATE.RECORD;
                return RETURN.MESG;
            }
            case 15: {
                var5_5 = this.localMesgDefs[this.localMesgIndex].fields.get(this.fieldIndex);
                while (this.fieldBytesLeft == 0) {
                    this.fieldDataIndex = 0;
                    this.fieldBytesLeft = var6_8 = var5_5.size;
                    if (var6_8 != 0) continue;
                    if (this.fieldIndex + 1 >= this.localMesgDefs[this.localMesgIndex].fields.size()) break;
                    var2_2 = this.localMesgDefs[this.localMesgIndex].fields;
                    this.fieldIndex = var6_8 = this.fieldIndex + 1;
                    var5_5 = (FieldDefinition)var2_2.get(var6_8);
                }
                var2_2 = this.fieldData;
                var6_8 = this.fieldDataIndex;
                this.fieldDataIndex = var6_8 + 1;
                var2_2[var6_8] = (MesgDefinition)var1_1;
                this.fieldBytesLeft = var6_8 = this.fieldBytesLeft - 1;
                if (var6_8 != 0) break;
                if ((var5_5.type & 31) >= 17) ** GOTO lbl133
                var6_8 = Fit.baseTypeSizes[var5_5.type & 31];
                var8_20 = var5_5.size / var6_8;
                if ((var5_5.type & 128) != 0 && (this.localMesgDefs[this.localMesgIndex].arch & 1) != 1) {
                    this.FlipFieldDataByteOrder(var6_8, var8_20);
                }
                if ((var7_18 = Factory.createField(this.mesg.num, var5_5.num)) == null) ** GOTO lbl133
                var2_2 = var7_18;
                if (var7_18.getName().equals("unknown")) {
                    var2_2 = new Field("unknown", var5_5.num, var5_5.type, 1.0, 0.0, "", false, Profile.Type.fromBaseType(var5_5.type));
                }
                if (var2_2.type == var5_5.type) ** GOTO lbl-1000
                var8_20 = Fit.baseTypeSizes[var2_2.type & 31];
                if (var6_8 >= var8_20) ** GOTO lbl105
                var2_2.type = var5_5.type;
                ** GOTO lbl-1000
lbl105:
                // 1 sources

                if (var6_8 != var8_20) {
                    var6_8 = 0;
                } else lbl-1000:
                // 3 sources

                {
                    var6_8 = 1;
                }
                if (var6_8 != 0) {
                    var2_2.read(new ByteArrayInputStream(this.fieldData), var5_5.size);
                }
                if (var5_5.num == 253 && (var5_5 = var2_2.getLongValue()) != null) {
                    this.timestamp = var3_3 = var5_5.longValue();
                    this.lastTimeOffset = (int)(var3_3 & 31L);
                }
                if (var2_2.getIsAccumulated()) {
                    for (var6_8 = 0; var6_8 < var2_2.getNumValues(); ++var6_8) {
                        var3_3 = ((Number)var2_2.getRawValue(var6_8)).longValue();
                        var5_5 = this.mesg.fields.iterator();
                        block31: while (var5_5.hasNext()) {
                            var7_18 = var5_5.next().components.iterator();
                            var9_23 = var3_3;
                            while (true) {
                                var3_3 = var9_23;
                                if (!var7_18.hasNext()) continue block31;
                                var11_24 = (FieldComponent)var7_18.next();
                                if (var11_24.fieldNum != var2_2.num || !var11_24.accumulate) continue;
                                var9_23 = (long)(((double)var9_23 / var2_2.scale - var2_2.offset + var11_24.offset) * var11_24.scale);
                            }
                        }
                        this.accumulator.set(this.mesg.num, var2_2.getNum(), var3_3);
                    }
                }
                if (var2_2.getNumValues() > 0) {
                    this.mesg.addField((Field)var2_2);
                }
lbl133:
                // 5 sources

                this.fieldIndex = var6_8 = this.fieldIndex + 1;
                if (var6_8 < this.localMesgDefs[this.localMesgIndex].fields.size()) break;
                for (var6_8 = 0; var6_8 < this.mesg.fields.size(); ++var6_8) {
                    var2_2 = this.mesg;
                    var8_20 = var2_2.getActiveSubFieldIndex(var2_2.fields.get(var6_8).getNum());
                    if (var8_20 == 65535) {
                        if (this.mesg.fields.get((int)var6_8).components.size() <= 0) continue;
                        this.expandComponents(this.mesg.fields.get(var6_8), this.mesg.fields.get((int)var6_8).components);
                        continue;
                    }
                    if (this.mesg.fields.get((int)var6_8).subFields.get((int)var8_20).components.size() <= 0) continue;
                    this.expandComponents(this.mesg.fields.get(var6_8), this.mesg.fields.get((int)var6_8).subFields.get((int)var8_20).components);
                }
                if (this.localMesgDefs[this.localMesgIndex].getDeveloperFieldTotalSize() > 0) {
                    this.fieldIndex = 0;
                    this.fieldBytesLeft = 0;
                    this.state = STATE.DEV_FIELD_DATA;
                    break;
                }
                this.state = STATE.RECORD;
                return RETURN.MESG;
            }
            case 14: {
                var2_2 = this.localMesgDefs[this.localMesgIndex].developerFields.get(this.fieldIndex);
                var12_25 = var1_1;
                if (this.developerFields.containsKey(var12_25)) {
                    var2_2.setDeveloperDataIdMesg(this.developerDataIds.get(var12_25));
                    if (this.developerFields.get(var12_25).containsKey(var2_2.getNum())) {
                        var2_2.setFieldDescription(this.developerFields.get(var12_25).get(var2_2.getNum()));
                    }
                }
                this.fieldIndex = var6_9 = this.fieldIndex + 1;
                if (var6_9 >= this.numFields) {
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.DEV_FIELD_NUM;
                break;
            }
            case 13: {
                this.localMesgDefs[this.localMesgIndex].developerFields.get(this.fieldIndex).setSize(var1_1 & 255);
                this.state = STATE.DEV_FIELD_DEV_ID;
                break;
            }
            case 12: {
                this.localMesgDefs[this.localMesgIndex].developerFields.add(new DeveloperFieldDefinition());
                this.localMesgDefs[this.localMesgIndex].developerFields.get(this.fieldIndex).setNum((short)(var1_1 & 255));
                this.state = STATE.DEV_FIELD_SIZE;
                break;
            }
            case 11: {
                this.fieldIndex = 0;
                this.numFields = var6_10 = var1_1 & 255;
                if (var6_10 == 0) {
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.DEV_FIELD_NUM;
                break;
            }
            case 10: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).type = var1_1 & 255;
                this.fieldIndex = var6_11 = this.fieldIndex + 1;
                if (var6_11 >= this.numFields) {
                    if (this.hasDevData) {
                        this.state = STATE.NUM_DEV_FIELDS;
                        break;
                    }
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case 9: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).size = var1_1 & 255;
                this.state = STATE.FIELD_TYPE;
                break;
            }
            case 8: {
                this.localMesgDefs[this.localMesgIndex].fields.add(new FieldDefinition());
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).num = var1_1 & 255;
                this.state = STATE.FIELD_SIZE;
                break;
            }
            case 7: {
                this.numFields = var6_12 = var1_1 & 255;
                if (var6_12 == 0) {
                    if (this.hasDevData) {
                        this.state = STATE.NUM_DEV_FIELDS;
                        break;
                    }
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case 6: {
                var2_2 = this.localMesgDefs[this.localMesgIndex];
                var2_2.num = (var1_1 & 255) << 8 | var2_2.num;
                if (this.localMesgDefs[this.localMesgIndex].arch != 1) ** GOTO lbl222
                var2_2 = this.localMesgDefs;
                var6_13 = this.localMesgIndex;
                var2_2[var6_13].num = var2_2[var6_13].num >> 8 | (this.localMesgDefs[this.localMesgIndex].num & 255) << 8;
                ** GOTO lbl223
lbl222:
                // 1 sources

                if (this.localMesgDefs[this.localMesgIndex].arch != 0) ** GOTO lbl225
lbl223:
                // 2 sources

                this.state = STATE.NUM_FIELDS;
                break;
lbl225:
                // 1 sources

                var2_2 = new StringBuilder();
                var2_2.append("FIT decode error: Endian ");
                var2_2.append(this.localMesgDefs[this.localMesgIndex].arch);
                var2_2.append(" not supported. Error at byte: ");
                var2_2.append(this.currentByteOffset);
                throw new FitRuntimeException(var2_2.toString());
            }
            case 5: {
                this.localMesgDefs[this.localMesgIndex].num = var1_1 & 255;
                this.state = STATE.MESG_NUM_1;
                break;
            }
            case 4: {
                this.localMesgDefs[this.localMesgIndex].arch = var1_1 & 255;
                this.state = STATE.MESG_NUM_0;
                break;
            }
            case 3: {
                this.state = STATE.ARCH;
                break;
            }
            case 2: {
                this.fieldIndex = 0;
                this.fieldBytesLeft = 0;
                if (this.fileBytesLeft > 1L) {
                    if ((var1_1 & 128) != 0) {
                        var6_14 = var1_1 & 31;
                        this.localMesgIndex = var8_21 = (var1_1 & 96) >> 5;
                        var2_2 = this.localMesgDefs;
                        if (var2_2[var8_21] != null) {
                            var2_2 = Factory.createField(var2_2[var8_21].num, 253);
                            this.timestamp = var3_3 = this.timestamp + (long)(var6_14 - this.lastTimeOffset & 31);
                            this.lastTimeOffset = var6_14;
                            var2_2.setValue(var3_3);
                            this.mesg = var5_6 = Factory.createMesg(this.localMesgDefs[this.localMesgIndex].num);
                            var5_6.localNum = this.localMesgIndex;
                            this.mesg.systemTimeOffset = this.systemTimeOffset;
                            this.mesg.addField((Field)var2_2);
                            if (this.localMesgDefs[this.localMesgIndex].fields.size() != 0) {
                                this.state = STATE.FIELD_DATA;
                                break;
                            }
                            if (this.localMesgDefs[this.localMesgIndex].getDeveloperFieldTotalSize() > 0) {
                                this.state = STATE.DEV_FIELD_DATA;
                                break;
                            }
                            return RETURN.MESG;
                        }
                        var2_2 = new StringBuilder();
                        var2_2.append("FIT decode error: Missing message definition for local message number ");
                        var2_2.append(this.localMesgIndex);
                        var2_2.append(". Error at byte: ");
                        var2_2.append(this.currentByteOffset);
                        throw new FitRuntimeException(var2_2.toString());
                    }
                    this.localMesgIndex = var6_15 = var1_1 & 15;
                    if ((var1_1 & 64) != 0) {
                        this.localMesgDefs[var6_15] = new MesgDefinition();
                        var2_2 = this.localMesgDefs;
                        var2_2[var6_15].localNum = var6_15 = this.localMesgIndex;
                        this.hasDevData = false;
                        if ((var1_1 & 32) != 0) {
                            this.hasDevData = true;
                        }
                        this.state = STATE.RESERVED1;
                        break;
                    }
                    var2_2 = this.localMesgDefs;
                    if (var2_2[var6_15] != null) {
                        this.mesg = var2_2 = Factory.createMesg(var2_2[var6_15].num);
                        var2_2.localNum = this.localMesgIndex;
                        this.mesg.systemTimeOffset = this.systemTimeOffset;
                        if (this.localMesgDefs[this.localMesgIndex].fields.size() != 0) {
                            this.state = STATE.FIELD_DATA;
                            break;
                        }
                        if (this.localMesgDefs[this.localMesgIndex].getDeveloperFieldTotalSize() > 0) {
                            this.state = STATE.DEV_FIELD_DATA;
                            break;
                        }
                        return RETURN.MESG;
                    }
                    var2_2 = new StringBuilder();
                    var2_2.append("FIT decode error: Missing message definition for local message number ");
                    var2_2.append(this.localMesgIndex);
                    var2_2.append(". Error at byte: ");
                    var2_2.append(this.currentByteOffset);
                    throw new FitRuntimeException(var2_2.toString());
                }
                this.state = STATE.FILE_CRC_HIGH;
                break;
            }
            case 1: {
                var6_16 = this.fileHdrOffset;
                this.fileHdrOffset = (byte)(var6_16 + 1);
                if (var6_16 == 0) ** GOTO lbl416
                if (var6_16 == 1) ** GOTO lbl392
                if (var6_16 == 13) ** GOTO lbl388
                switch (var6_16) {
                    default: {
                        break;
                    }
                    case 11: {
                        if (var1_1 != 84) {
                            var2_2 = new StringBuilder();
                            var2_2.append("FIT decode error: File is not FIT format.  Check file header data type. Error at byte: ");
                            var2_2.append(this.currentByteOffset);
                            this.headerException = var2_2.toString();
                        }
                        if (this.headerException != null) {
                            if (this.fileHdrSize != 12) break;
                            throw new FitRuntimeException(this.headerException);
                        }
                        ** GOTO lbl418
                    }
                    case 10: {
                        if (var1_1 != 73) {
                            var2_2 = new StringBuilder();
                            var2_2.append("FIT decode error: File is not FIT format.  Check file header data type. Error at byte: ");
                            var2_2.append(this.currentByteOffset);
                            this.headerException = var2_2.toString();
                            break;
                        }
                        ** GOTO lbl418
                    }
                    case 9: {
                        if (var1_1 != 70) {
                            var2_2 = new StringBuilder();
                            var2_2.append("FIT decode error: File is not FIT format.  Check file header data type. Error at byte: ");
                            var2_2.append(this.currentByteOffset);
                            this.headerException = var2_2.toString();
                            break;
                        }
                        ** GOTO lbl418
                    }
                    case 8: {
                        if (var1_1 != 46) {
                            var2_2 = new StringBuilder();
                            var2_2.append("FIT decode error: File is not FIT format.  Check file header data type. Error at byte: ");
                            var2_2.append(this.currentByteOffset);
                            this.headerException = var2_2.toString();
                            break;
                        }
                        ** GOTO lbl418
                    }
                    case 7: {
                        this.fileDataSize = var3_3 = this.fileDataSize | (long)(var1_1 & 255) << 24;
                        if (!(var3_3 != 0L || Decode.invalidDataSize && this.invalidFileDataSize)) {
                            Decode.invalidDataSize = true;
                            this.invalidFileDataSize = true;
                            var2_2 = new StringBuilder();
                            var2_2.append("FIT decode error: File Size is 0. Error at byte: ");
                            var2_2.append(this.currentByteOffset);
                            this.headerException = var2_2.toString();
                            break;
                        }
                        ** GOTO lbl418
                    }
                    case 6: {
                        this.fileDataSize |= (long)(var1_1 & 255) << 16;
                        break;
                    }
                    case 5: {
                        this.fileDataSize |= (long)(var1_1 & 255) << 8;
                        break;
                    }
                    case 4: {
                        this.fileDataSize = var1_1 & 255;
                        break;
                    }
                }
                ** GOTO lbl418
lbl388:
                // 1 sources

                if (this.headerException != null) {
                    ++this.currentByteIndex;
                    throw new FitRuntimeException(this.headerException);
                }
                ** GOTO lbl418
lbl392:
                // 1 sources

                var6_16 = var1_1 & 240;
                if (var6_16 > Fit.PROTOCOL_VERSION_MAJOR << 4) {
                    var2_2 = new StringBuilder();
                    var2_2.append("FIT decode error: Protocol version ");
                    var2_2.append(var6_16 >> 4);
                    var2_2.append(".");
                    var2_2.append(var1_1 & 15);
                    var2_2.append(" not supported.  Must be ");
                    var2_2.append(Fit.PROTOCOL_VERSION_MAJOR);
                    var2_2.append(".15 or earlier.");
                    this.headerException = var2_2.toString();
                }
                if ((var6_16 = (int)this.fileHdrSize) != 12 && var6_16 != 14) {
                    this.fileBytesLeft += 2L;
                    this.fileHdrOffset = (byte)false;
                    this.headerException = null;
                    this.crc = 0;
                }
                ** GOTO lbl418
lbl416:
                // 1 sources

                this.fileHdrSize = var1_1;
                this.fileBytesLeft = var1_1 + 2;
lbl418:
                // 9 sources

                var6_16 = this.fileHdrOffset;
                var8_22 = this.fileHdrSize;
                if (var6_16 != var8_22 || var8_22 == 0) break;
                this.fileBytesLeft = Decode.invalidDataSize != false && this.invalidFileDataSize != false ? 0x7FFFFFFFFFFFFFFFL : this.fileDataSize + 2L;
                this.state = STATE.RECORD;
            }
        }
        return RETURN.CONTINUE;
    }

    public boolean read(InputStream inputStream) {
        this.in = inputStream;
        return this.resume();
    }

    public boolean read(InputStream inputStream, MesgListener mesgListener) {
        this.addListener(mesgListener);
        return this.read(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean read(InputStream inputStream, MesgListener mesgListener, MesgDefinitionListener mesgDefinitionListener) {
        this.addListener(mesgListener);
        this.addListener(mesgDefinitionListener);
        this.currentByteOffset = 0;
        boolean bl = true;
        try {
            while (this.bytesAvailable(inputStream) && bl) {
                bl = this.read(inputStream, mesgListener);
                this.nextFile();
            }
            return bl;
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean resume() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setInvalidFileDataSize(boolean bl) {
        this.invalidFileDataSize = bl;
    }

    public void setSystemTimeOffset(long l) {
        this.systemTimeOffset = l;
    }

    public void set_DataSize(int n) {
        this.buffer = new byte[n];
    }

    public void showInvalidValues() {
        if (this.in == null) {
            FieldBase.forceShowInvalids = true;
            return;
        }
        throw new FitRuntimeException("Can't set showInvalidValues option after Decode started!");
    }

    public void skipHeader() {
        if (this.in == null) {
            this.state = STATE.RECORD;
            this.fileBytesLeft = Long.MAX_VALUE;
            return;
        }
        throw new FitRuntimeException("Can't set skipHeader option after Decode started!");
    }

    private class AccumulatedField {
        long accumulatedValue;
        int destFieldNum;
        long lastValue;
        int mesgNum;

        AccumulatedField(int n, int n2) {
            this.mesgNum = n;
            this.destFieldNum = n2;
            this.lastValue = 0L;
            this.accumulatedValue = 0L;
        }

        public long accumulate(long l, int n) {
            long l2;
            this.accumulatedValue = l2 = this.accumulatedValue + ((1L << n) - 1L & l - this.lastValue);
            this.lastValue = l;
            return l2;
        }

        public long set(long l) {
            this.accumulatedValue = l;
            this.lastValue = l;
            return l;
        }
    }

    private class Accumulator {
        ArrayList<AccumulatedField> accumulatedFields = new ArrayList();

        Accumulator() {
        }

        public long accumulate(int n, int n2, long l, int n3) {
            int n4;
            AccumulatedField accumulatedField = null;
            for (n4 = 0; n4 < this.accumulatedFields.size(); ++n4) {
                accumulatedField = this.accumulatedFields.get(n4);
                if (accumulatedField.mesgNum == n && accumulatedField.destFieldNum == n2) break;
            }
            if (n4 == this.accumulatedFields.size()) {
                accumulatedField = new AccumulatedField(n, n2);
                this.accumulatedFields.add(accumulatedField);
            }
            return accumulatedField.accumulate(l, n3);
        }

        public void set(int n, int n2, long l) {
            int n3;
            AccumulatedField accumulatedField = null;
            for (n3 = 0; n3 < this.accumulatedFields.size(); ++n3) {
                accumulatedField = this.accumulatedFields.get(n3);
                if (accumulatedField.mesgNum == n && accumulatedField.destFieldNum == n2) break;
            }
            if (n3 == this.accumulatedFields.size()) {
                accumulatedField = new AccumulatedField(n, n2);
                this.accumulatedFields.add(accumulatedField);
            }
            accumulatedField.set(l);
        }
    }

    public static final class RETURN
    extends Enum<RETURN> {
        private static final /* synthetic */ RETURN[] $VALUES;
        public static final /* enum */ RETURN CONTINUE;
        public static final /* enum */ RETURN END_OF_FILE;
        public static final /* enum */ RETURN MESG;
        public static final /* enum */ RETURN MESG_DEF;

        static {
            RETURN rETURN;
            RETURN rETURN2;
            RETURN rETURN3;
            RETURN rETURN4;
            CONTINUE = rETURN4 = new RETURN();
            MESG = rETURN3 = new RETURN();
            MESG_DEF = rETURN2 = new RETURN();
            END_OF_FILE = rETURN = new RETURN();
            $VALUES = new RETURN[]{rETURN4, rETURN3, rETURN2, rETURN};
        }

        public static RETURN valueOf(String string2) {
            return Enum.valueOf(RETURN.class, string2);
        }

        public static RETURN[] values() {
            return (RETURN[])$VALUES.clone();
        }
    }

    private static final class STATE
    extends Enum<STATE> {
        private static final /* synthetic */ STATE[] $VALUES;
        public static final /* enum */ STATE ARCH;
        public static final /* enum */ STATE DEV_FIELD_DATA;
        public static final /* enum */ STATE DEV_FIELD_DEV_ID;
        public static final /* enum */ STATE DEV_FIELD_NUM;
        public static final /* enum */ STATE DEV_FIELD_SIZE;
        public static final /* enum */ STATE FIELD_DATA;
        public static final /* enum */ STATE FIELD_NUM;
        public static final /* enum */ STATE FIELD_SIZE;
        public static final /* enum */ STATE FIELD_TYPE;
        public static final /* enum */ STATE FILE_CRC_HIGH;
        public static final /* enum */ STATE FILE_HDR;
        public static final /* enum */ STATE MESG_NUM_0;
        public static final /* enum */ STATE MESG_NUM_1;
        public static final /* enum */ STATE NUM_DEV_FIELDS;
        public static final /* enum */ STATE NUM_FIELDS;
        public static final /* enum */ STATE RECORD;
        public static final /* enum */ STATE RESERVED1;

        static {
            STATE sTATE;
            STATE sTATE2;
            STATE sTATE3;
            STATE sTATE4;
            STATE sTATE5;
            STATE sTATE6;
            STATE sTATE7;
            STATE sTATE8;
            STATE sTATE9;
            STATE sTATE10;
            STATE sTATE11;
            STATE sTATE12;
            STATE sTATE13;
            STATE sTATE14;
            STATE sTATE15;
            STATE sTATE16;
            STATE sTATE17;
            FILE_HDR = sTATE17 = new STATE();
            RECORD = sTATE16 = new STATE();
            RESERVED1 = sTATE15 = new STATE();
            ARCH = sTATE14 = new STATE();
            MESG_NUM_0 = sTATE13 = new STATE();
            MESG_NUM_1 = sTATE12 = new STATE();
            NUM_FIELDS = sTATE11 = new STATE();
            FIELD_NUM = sTATE10 = new STATE();
            FIELD_SIZE = sTATE9 = new STATE();
            FIELD_TYPE = sTATE8 = new STATE();
            NUM_DEV_FIELDS = sTATE7 = new STATE();
            DEV_FIELD_NUM = sTATE6 = new STATE();
            DEV_FIELD_SIZE = sTATE5 = new STATE();
            DEV_FIELD_DEV_ID = sTATE4 = new STATE();
            FIELD_DATA = sTATE3 = new STATE();
            DEV_FIELD_DATA = sTATE2 = new STATE();
            FILE_CRC_HIGH = sTATE = new STATE();
            $VALUES = new STATE[]{sTATE17, sTATE16, sTATE15, sTATE14, sTATE13, sTATE12, sTATE11, sTATE10, sTATE9, sTATE8, sTATE7, sTATE6, sTATE5, sTATE4, sTATE3, sTATE2, sTATE};
        }

        public static STATE valueOf(String string2) {
            return Enum.valueOf(STATE.class, string2);
        }

        public static STATE[] values() {
            return (STATE[])$VALUES.clone();
        }
    }
}

