/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.AutoSyncFrequency;
import com.garmin.fit.BacklightMode;
import com.garmin.fit.Bool;
import com.garmin.fit.DateMode;
import com.garmin.fit.DateTime;
import com.garmin.fit.DisplayOrientation;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.Side;
import com.garmin.fit.Switch;
import com.garmin.fit.TimeMode;

public class DeviceSettingsMesg
extends Mesg {
    public static final int ActiveTimeZoneFieldNum = 0;
    public static final int ActivityTrackerEnabledFieldNum = 36;
    public static final int AutoActivityDetectFieldNum = 90;
    public static final int AutoSyncFrequencyFieldNum = 89;
    public static final int AutosyncMinStepsFieldNum = 58;
    public static final int AutosyncMinTimeFieldNum = 59;
    public static final int BacklightModeFieldNum = 12;
    public static final int BleAutoUploadEnabledFieldNum = 86;
    public static final int ClockTimeFieldNum = 39;
    public static final int DateModeFieldNum = 47;
    public static final int DefaultPageFieldNum = 57;
    public static final int DisplayOrientationFieldNum = 55;
    public static final int LactateThresholdAutodetectEnabledFieldNum = 80;
    public static final int MountingSideFieldNum = 56;
    public static final int MoveAlertEnabledFieldNum = 46;
    public static final int NumberOfScreensFieldNum = 94;
    public static final int PagesEnabledFieldNum = 40;
    public static final int SmartNotificationDisplayOrientationFieldNum = 95;
    public static final int TapInterfaceFieldNum = 134;
    public static final int TimeModeFieldNum = 4;
    public static final int TimeOffsetFieldNum = 2;
    public static final int TimeZoneOffsetFieldNum = 5;
    public static final int UtcOffsetFieldNum = 1;
    protected static final Mesg deviceSettingsMesg;

    static {
        Mesg mesg;
        deviceSettingsMesg = mesg = new Mesg("device_settings", 2);
        mesg.addField(new Field("active_time_zone", 0, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.addField(new Field("utc_offset", 1, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.addField(new Field("time_offset", 2, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("time_mode", 4, 0, 1.0, 0.0, "", false, Profile.Type.TIME_MODE));
        mesg.addField(new Field("time_zone_offset", 5, 1, 4.0, 0.0, "hr", false, Profile.Type.SINT8));
        mesg.addField(new Field("backlight_mode", 12, 0, 1.0, 0.0, "", false, Profile.Type.BACKLIGHT_MODE));
        mesg.addField(new Field("activity_tracker_enabled", 36, 0, 1.0, 0.0, "", false, Profile.Type.BOOL));
        mesg.addField(new Field("clock_time", 39, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
        mesg.addField(new Field("pages_enabled", 40, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("move_alert_enabled", 46, 0, 1.0, 0.0, "", false, Profile.Type.BOOL));
        mesg.addField(new Field("date_mode", 47, 0, 1.0, 0.0, "", false, Profile.Type.DATE_MODE));
        mesg.addField(new Field("display_orientation", 55, 0, 1.0, 0.0, "", false, Profile.Type.DISPLAY_ORIENTATION));
        mesg.addField(new Field("mounting_side", 56, 0, 1.0, 0.0, "", false, Profile.Type.SIDE));
        mesg.addField(new Field("default_page", 57, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("autosync_min_steps", 58, 132, 1.0, 0.0, "steps", false, Profile.Type.UINT16));
        mesg.addField(new Field("autosync_min_time", 59, 132, 1.0, 0.0, "minutes", false, Profile.Type.UINT16));
        mesg.addField(new Field("lactate_threshold_autodetect_enabled", 80, 0, 1.0, 0.0, "", false, Profile.Type.BOOL));
        mesg.addField(new Field("ble_auto_upload_enabled", 86, 0, 1.0, 0.0, "", false, Profile.Type.BOOL));
        mesg.addField(new Field("auto_sync_frequency", 89, 0, 1.0, 0.0, "", false, Profile.Type.AUTO_SYNC_FREQUENCY));
        mesg.addField(new Field("auto_activity_detect", 90, 134, 1.0, 0.0, "", false, Profile.Type.AUTO_ACTIVITY_DETECT));
        mesg.addField(new Field("number_of_screens", 94, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.addField(new Field("smart_notification_display_orientation", 95, 0, 1.0, 0.0, "", false, Profile.Type.DISPLAY_ORIENTATION));
        mesg.addField(new Field("tap_interface", 134, 0, 1.0, 0.0, "", false, Profile.Type.SWITCH));
    }

    public DeviceSettingsMesg() {
        super(Factory.createMesg(2));
    }

    public DeviceSettingsMesg(Mesg mesg) {
        super(mesg);
    }

    public Short getActiveTimeZone() {
        return this.getFieldShortValue(0, 0, 65535);
    }

    public Bool getActivityTrackerEnabled() {
        Short s = this.getFieldShortValue(36, 0, 65535);
        if (s == null) {
            return null;
        }
        return Bool.getByValue(s);
    }

    public Long getAutoActivityDetect() {
        return this.getFieldLongValue(90, 0, 65535);
    }

    public AutoSyncFrequency getAutoSyncFrequency() {
        Short s = this.getFieldShortValue(89, 0, 65535);
        if (s == null) {
            return null;
        }
        return AutoSyncFrequency.getByValue(s);
    }

    public Integer getAutosyncMinSteps() {
        return this.getFieldIntegerValue(58, 0, 65535);
    }

    public Integer getAutosyncMinTime() {
        return this.getFieldIntegerValue(59, 0, 65535);
    }

    public BacklightMode getBacklightMode() {
        Short s = this.getFieldShortValue(12, 0, 65535);
        if (s == null) {
            return null;
        }
        return BacklightMode.getByValue(s);
    }

    public Bool getBleAutoUploadEnabled() {
        Short s = this.getFieldShortValue(86, 0, 65535);
        if (s == null) {
            return null;
        }
        return Bool.getByValue(s);
    }

    public DateTime getClockTime() {
        return this.timestampToDateTime(this.getFieldLongValue(39, 0, 65535));
    }

    public DateMode getDateMode() {
        Short s = this.getFieldShortValue(47, 0, 65535);
        if (s == null) {
            return null;
        }
        return DateMode.getByValue(s);
    }

    public Integer getDefaultPage(int n) {
        return this.getFieldIntegerValue(57, n, 65535);
    }

    public Integer[] getDefaultPage() {
        return this.getFieldIntegerValues(57, 65535);
    }

    public DisplayOrientation getDisplayOrientation() {
        Short s = this.getFieldShortValue(55, 0, 65535);
        if (s == null) {
            return null;
        }
        return DisplayOrientation.getByValue(s);
    }

    public Bool getLactateThresholdAutodetectEnabled() {
        Short s = this.getFieldShortValue(80, 0, 65535);
        if (s == null) {
            return null;
        }
        return Bool.getByValue(s);
    }

    public Side getMountingSide() {
        Short s = this.getFieldShortValue(56, 0, 65535);
        if (s == null) {
            return null;
        }
        return Side.getByValue(s);
    }

    public Bool getMoveAlertEnabled() {
        Short s = this.getFieldShortValue(46, 0, 65535);
        if (s == null) {
            return null;
        }
        return Bool.getByValue(s);
    }

    public int getNumDefaultPage() {
        return this.getNumFieldValues(57, 65535);
    }

    public int getNumPagesEnabled() {
        return this.getNumFieldValues(40, 65535);
    }

    public int getNumTimeMode() {
        return this.getNumFieldValues(4, 65535);
    }

    public int getNumTimeOffset() {
        return this.getNumFieldValues(2, 65535);
    }

    public int getNumTimeZoneOffset() {
        return this.getNumFieldValues(5, 65535);
    }

    public Short getNumberOfScreens() {
        return this.getFieldShortValue(94, 0, 65535);
    }

    public Integer getPagesEnabled(int n) {
        return this.getFieldIntegerValue(40, n, 65535);
    }

    public Integer[] getPagesEnabled() {
        return this.getFieldIntegerValues(40, 65535);
    }

    public DisplayOrientation getSmartNotificationDisplayOrientation() {
        Short s = this.getFieldShortValue(95, 0, 65535);
        if (s == null) {
            return null;
        }
        return DisplayOrientation.getByValue(s);
    }

    public Switch getTapInterface() {
        Short s = this.getFieldShortValue(134, 0, 65535);
        if (s == null) {
            return null;
        }
        return Switch.getByValue(s);
    }

    public TimeMode getTimeMode(int n) {
        Short s = this.getFieldShortValue(4, n, 65535);
        if (s == null) {
            return null;
        }
        return TimeMode.getByValue(s);
    }

    public TimeMode[] getTimeMode() {
        Short[] shortArray = this.getFieldShortValues(4, 65535);
        TimeMode[] timeModeArray = new TimeMode[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            timeModeArray[i] = TimeMode.getByValue(shortArray[i]);
        }
        return timeModeArray;
    }

    public Long getTimeOffset(int n) {
        return this.getFieldLongValue(2, n, 65535);
    }

    public Long[] getTimeOffset() {
        return this.getFieldLongValues(2, 65535);
    }

    public Float getTimeZoneOffset(int n) {
        return this.getFieldFloatValue(5, n, 65535);
    }

    public Float[] getTimeZoneOffset() {
        return this.getFieldFloatValues(5, 65535);
    }

    public Long getUtcOffset() {
        return this.getFieldLongValue(1, 0, 65535);
    }

    public void setActiveTimeZone(Short s) {
        this.setFieldValue(0, 0, (Object)s, 65535);
    }

    public void setActivityTrackerEnabled(Bool bool2) {
        this.setFieldValue(36, 0, (Object)bool2.value, 65535);
    }

    public void setAutoActivityDetect(Long l) {
        this.setFieldValue(90, 0, (Object)l, 65535);
    }

    public void setAutoSyncFrequency(AutoSyncFrequency autoSyncFrequency) {
        this.setFieldValue(89, 0, (Object)autoSyncFrequency.value, 65535);
    }

    public void setAutosyncMinSteps(Integer n) {
        this.setFieldValue(58, 0, (Object)n, 65535);
    }

    public void setAutosyncMinTime(Integer n) {
        this.setFieldValue(59, 0, (Object)n, 65535);
    }

    public void setBacklightMode(BacklightMode backlightMode) {
        this.setFieldValue(12, 0, (Object)backlightMode.value, 65535);
    }

    public void setBleAutoUploadEnabled(Bool bool2) {
        this.setFieldValue(86, 0, (Object)bool2.value, 65535);
    }

    public void setClockTime(DateTime dateTime) {
        this.setFieldValue(39, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public void setDateMode(DateMode dateMode) {
        this.setFieldValue(47, 0, (Object)dateMode.value, 65535);
    }

    public void setDefaultPage(int n, Integer n2) {
        this.setFieldValue(57, n, (Object)n2, 65535);
    }

    public void setDisplayOrientation(DisplayOrientation displayOrientation) {
        this.setFieldValue(55, 0, (Object)displayOrientation.value, 65535);
    }

    public void setLactateThresholdAutodetectEnabled(Bool bool2) {
        this.setFieldValue(80, 0, (Object)bool2.value, 65535);
    }

    public void setMountingSide(Side side) {
        this.setFieldValue(56, 0, (Object)side.value, 65535);
    }

    public void setMoveAlertEnabled(Bool bool2) {
        this.setFieldValue(46, 0, (Object)bool2.value, 65535);
    }

    public void setNumberOfScreens(Short s) {
        this.setFieldValue(94, 0, (Object)s, 65535);
    }

    public void setPagesEnabled(int n, Integer n2) {
        this.setFieldValue(40, n, (Object)n2, 65535);
    }

    public void setSmartNotificationDisplayOrientation(DisplayOrientation displayOrientation) {
        this.setFieldValue(95, 0, (Object)displayOrientation.value, 65535);
    }

    public void setTapInterface(Switch switch_) {
        this.setFieldValue(134, 0, (Object)switch_.value, 65535);
    }

    public void setTimeMode(int n, TimeMode timeMode) {
        this.setFieldValue(4, n, (Object)timeMode.value, 65535);
    }

    public void setTimeOffset(int n, Long l) {
        this.setFieldValue(2, n, (Object)l, 65535);
    }

    public void setTimeZoneOffset(int n, Float f) {
        this.setFieldValue(5, n, (Object)f, 65535);
    }

    public void setUtcOffset(Long l) {
        this.setFieldValue(1, 0, (Object)l, 65535);
    }
}

