/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Bool;
import com.garmin.fit.DiveAlarmType;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.SubSport;
import com.garmin.fit.Tone;

public class DiveAlarmMesg
extends Mesg {
    public static final int AlarmTypeFieldNum = 3;
    public static final int DepthFieldNum = 0;
    public static final int DiveTypesFieldNum = 5;
    public static final int EnabledFieldNum = 2;
    public static final int MessageIndexFieldNum = 254;
    public static final int SoundFieldNum = 4;
    public static final int TimeFieldNum = 1;
    protected static final Mesg diveAlarmMesg;

    static {
        Mesg mesg;
        diveAlarmMesg = mesg = new Mesg("dive_alarm", 262);
        mesg.addField(new Field("message_index", 254, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        mesg.addField(new Field("depth", 0, 134, 1000.0, 0.0, "m", false, Profile.Type.UINT32));
        mesg.addField(new Field("time", 1, 133, 1.0, 0.0, "s", false, Profile.Type.SINT32));
        mesg.addField(new Field("enabled", 2, 0, 1.0, 0.0, "", false, Profile.Type.BOOL));
        mesg.addField(new Field("alarm_type", 3, 0, 1.0, 0.0, "", false, Profile.Type.DIVE_ALARM_TYPE));
        mesg.addField(new Field("sound", 4, 0, 1.0, 0.0, "", false, Profile.Type.TONE));
        mesg.addField(new Field("dive_types", 5, 0, 1.0, 0.0, "", false, Profile.Type.SUB_SPORT));
    }

    public DiveAlarmMesg() {
        super(Factory.createMesg(262));
    }

    public DiveAlarmMesg(Mesg mesg) {
        super(mesg);
    }

    public DiveAlarmType getAlarmType() {
        Short s = this.getFieldShortValue(3, 0, 65535);
        if (s == null) {
            return null;
        }
        return DiveAlarmType.getByValue(s);
    }

    public Float getDepth() {
        return this.getFieldFloatValue(0, 0, 65535);
    }

    public SubSport getDiveTypes(int n) {
        Short s = this.getFieldShortValue(5, n, 65535);
        if (s == null) {
            return null;
        }
        return SubSport.getByValue(s);
    }

    public SubSport[] getDiveTypes() {
        Short[] shortArray = this.getFieldShortValues(5, 65535);
        SubSport[] subSportArray = new SubSport[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            subSportArray[i] = SubSport.getByValue(shortArray[i]);
        }
        return subSportArray;
    }

    public Bool getEnabled() {
        Short s = this.getFieldShortValue(2, 0, 65535);
        if (s == null) {
            return null;
        }
        return Bool.getByValue(s);
    }

    public Integer getMessageIndex() {
        return this.getFieldIntegerValue(254, 0, 65535);
    }

    public int getNumDiveTypes() {
        return this.getNumFieldValues(5, 65535);
    }

    public Tone getSound() {
        Short s = this.getFieldShortValue(4, 0, 65535);
        if (s == null) {
            return null;
        }
        return Tone.getByValue(s);
    }

    public Integer getTime() {
        return this.getFieldIntegerValue(1, 0, 65535);
    }

    public void setAlarmType(DiveAlarmType diveAlarmType) {
        this.setFieldValue(3, 0, (Object)diveAlarmType.value, 65535);
    }

    public void setDepth(Float f) {
        this.setFieldValue(0, 0, (Object)f, 65535);
    }

    public void setDiveTypes(int n, SubSport subSport) {
        this.setFieldValue(5, n, (Object)subSport.value, 65535);
    }

    public void setEnabled(Bool bool2) {
        this.setFieldValue(2, 0, (Object)bool2.value, 65535);
    }

    public void setMessageIndex(Integer n) {
        this.setFieldValue(254, 0, (Object)n, 65535);
    }

    public void setSound(Tone tone) {
        this.setFieldValue(4, 0, (Object)tone.value, 65535);
    }

    public void setTime(Integer n) {
        this.setFieldValue(1, 0, (Object)n, 65535);
    }
}

