/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;

public class DiveSummaryMesg
extends Mesg {
    public static final int AvgDepthFieldNum = 2;
    public static final int BottomTimeFieldNum = 11;
    public static final int DiveNumberFieldNum = 10;
    public static final int EndCnsFieldNum = 6;
    public static final int EndN2FieldNum = 8;
    public static final int MaxDepthFieldNum = 3;
    public static final int O2ToxicityFieldNum = 9;
    public static final int ReferenceIndexFieldNum = 1;
    public static final int ReferenceMesgFieldNum = 0;
    public static final int StartCnsFieldNum = 5;
    public static final int StartN2FieldNum = 7;
    public static final int SurfaceIntervalFieldNum = 4;
    public static final int TimestampFieldNum = 253;
    protected static final Mesg diveSummaryMesg;

    static {
        Mesg mesg;
        diveSummaryMesg = mesg = new Mesg("dive_summary", 268);
        mesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        mesg.addField(new Field("reference_mesg", 0, 132, 1.0, 0.0, "", false, Profile.Type.MESG_NUM));
        mesg.addField(new Field("reference_index", 1, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        mesg.addField(new Field("avg_depth", 2, 134, 1000.0, 0.0, "m", false, Profile.Type.UINT32));
        mesg.addField(new Field("max_depth", 3, 134, 1000.0, 0.0, "m", false, Profile.Type.UINT32));
        mesg.addField(new Field("surface_interval", 4, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("start_cns", 5, 2, 1.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("end_cns", 6, 2, 1.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("start_n2", 7, 132, 1.0, 0.0, "percent", false, Profile.Type.UINT16));
        mesg.addField(new Field("end_n2", 8, 132, 1.0, 0.0, "percent", false, Profile.Type.UINT16));
        mesg.addField(new Field("o2_toxicity", 9, 132, 1.0, 0.0, "OTUs", false, Profile.Type.UINT16));
        mesg.addField(new Field("dive_number", 10, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.addField(new Field("bottom_time", 11, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
    }

    public DiveSummaryMesg() {
        super(Factory.createMesg(268));
    }

    public DiveSummaryMesg(Mesg mesg) {
        super(mesg);
    }

    public Float getAvgDepth() {
        return this.getFieldFloatValue(2, 0, 65535);
    }

    public Float getBottomTime() {
        return this.getFieldFloatValue(11, 0, 65535);
    }

    public Long getDiveNumber() {
        return this.getFieldLongValue(10, 0, 65535);
    }

    public Short getEndCns() {
        return this.getFieldShortValue(6, 0, 65535);
    }

    public Integer getEndN2() {
        return this.getFieldIntegerValue(8, 0, 65535);
    }

    public Float getMaxDepth() {
        return this.getFieldFloatValue(3, 0, 65535);
    }

    public Integer getO2Toxicity() {
        return this.getFieldIntegerValue(9, 0, 65535);
    }

    public Integer getReferenceIndex() {
        return this.getFieldIntegerValue(1, 0, 65535);
    }

    public Integer getReferenceMesg() {
        return this.getFieldIntegerValue(0, 0, 65535);
    }

    public Short getStartCns() {
        return this.getFieldShortValue(5, 0, 65535);
    }

    public Integer getStartN2() {
        return this.getFieldIntegerValue(7, 0, 65535);
    }

    public Long getSurfaceInterval() {
        return this.getFieldLongValue(4, 0, 65535);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setAvgDepth(Float f) {
        this.setFieldValue(2, 0, (Object)f, 65535);
    }

    public void setBottomTime(Float f) {
        this.setFieldValue(11, 0, (Object)f, 65535);
    }

    public void setDiveNumber(Long l) {
        this.setFieldValue(10, 0, (Object)l, 65535);
    }

    public void setEndCns(Short s) {
        this.setFieldValue(6, 0, (Object)s, 65535);
    }

    public void setEndN2(Integer n) {
        this.setFieldValue(8, 0, (Object)n, 65535);
    }

    public void setMaxDepth(Float f) {
        this.setFieldValue(3, 0, (Object)f, 65535);
    }

    public void setO2Toxicity(Integer n) {
        this.setFieldValue(9, 0, (Object)n, 65535);
    }

    public void setReferenceIndex(Integer n) {
        this.setFieldValue(1, 0, (Object)n, 65535);
    }

    public void setReferenceMesg(Integer n) {
        this.setFieldValue(0, 0, (Object)n, 65535);
    }

    public void setStartCns(Short s) {
        this.setFieldValue(5, 0, (Object)s, 65535);
    }

    public void setStartN2(Integer n) {
        this.setFieldValue(7, 0, (Object)n, 65535);
    }

    public void setSurfaceInterval(Long l) {
        this.setFieldValue(4, 0, (Object)l, 65535);
    }

    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }
}

