/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Event;
import com.garmin.fit.EventType;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Intensity;
import com.garmin.fit.LapTrigger;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgWithEvent;
import com.garmin.fit.Profile;
import com.garmin.fit.Sport;
import com.garmin.fit.SubField;
import com.garmin.fit.SubSport;
import com.garmin.fit.SwimStroke;

public class LapMesg
extends Mesg
implements MesgWithEvent {
    public static final int AvgAltitudeFieldNum = 42;
    public static final int AvgCadenceFieldNum = 17;
    public static final int AvgCadencePositionFieldNum = 108;
    public static final int AvgCombinedPedalSmoothnessFieldNum = 95;
    public static final int AvgFractionalCadenceFieldNum = 80;
    public static final int AvgGradeFieldNum = 45;
    public static final int AvgHeartRateFieldNum = 15;
    public static final int AvgLeftPcoFieldNum = 100;
    public static final int AvgLeftPedalSmoothnessFieldNum = 93;
    public static final int AvgLeftPowerPhaseFieldNum = 102;
    public static final int AvgLeftPowerPhasePeakFieldNum = 103;
    public static final int AvgLeftTorqueEffectivenessFieldNum = 91;
    public static final int AvgLevMotorPowerFieldNum = 115;
    public static final int AvgNegGradeFieldNum = 47;
    public static final int AvgNegVerticalSpeedFieldNum = 54;
    public static final int AvgPosGradeFieldNum = 46;
    public static final int AvgPosVerticalSpeedFieldNum = 53;
    public static final int AvgPowerFieldNum = 19;
    public static final int AvgPowerPositionFieldNum = 106;
    public static final int AvgRightPcoFieldNum = 101;
    public static final int AvgRightPedalSmoothnessFieldNum = 94;
    public static final int AvgRightPowerPhaseFieldNum = 104;
    public static final int AvgRightPowerPhasePeakFieldNum = 105;
    public static final int AvgRightTorqueEffectivenessFieldNum = 92;
    public static final int AvgSaturatedHemoglobinPercentFieldNum = 87;
    public static final int AvgSpeedFieldNum = 13;
    public static final int AvgStanceTimeBalanceFieldNum = 119;
    public static final int AvgStanceTimeFieldNum = 79;
    public static final int AvgStanceTimePercentFieldNum = 78;
    public static final int AvgStepLengthFieldNum = 120;
    public static final int AvgStrokeDistanceFieldNum = 37;
    public static final int AvgTemperatureFieldNum = 50;
    public static final int AvgTotalHemoglobinConcFieldNum = 84;
    public static final int AvgVamFieldNum = 121;
    public static final int AvgVerticalOscillationFieldNum = 77;
    public static final int AvgVerticalRatioFieldNum = 118;
    public static final int EndPositionLatFieldNum = 5;
    public static final int EndPositionLongFieldNum = 6;
    public static final int EnhancedAvgAltitudeFieldNum = 112;
    public static final int EnhancedAvgSpeedFieldNum = 110;
    public static final int EnhancedMaxAltitudeFieldNum = 114;
    public static final int EnhancedMaxSpeedFieldNum = 111;
    public static final int EnhancedMinAltitudeFieldNum = 113;
    public static final int EventFieldNum = 0;
    public static final int EventGroupFieldNum = 26;
    public static final int EventTypeFieldNum = 1;
    public static final int FirstLengthIndexFieldNum = 35;
    public static final int GpsAccuracyFieldNum = 44;
    public static final int IntensityFieldNum = 23;
    public static final int LapTriggerFieldNum = 24;
    public static final int LeftRightBalanceFieldNum = 34;
    public static final int LevBatteryConsumptionFieldNum = 117;
    public static final int MaxAltitudeFieldNum = 43;
    public static final int MaxCadenceFieldNum = 18;
    public static final int MaxCadencePositionFieldNum = 109;
    public static final int MaxFractionalCadenceFieldNum = 81;
    public static final int MaxHeartRateFieldNum = 16;
    public static final int MaxLevMotorPowerFieldNum = 116;
    public static final int MaxNegGradeFieldNum = 49;
    public static final int MaxNegVerticalSpeedFieldNum = 56;
    public static final int MaxPosGradeFieldNum = 48;
    public static final int MaxPosVerticalSpeedFieldNum = 55;
    public static final int MaxPowerFieldNum = 20;
    public static final int MaxPowerPositionFieldNum = 107;
    public static final int MaxSaturatedHemoglobinPercentFieldNum = 89;
    public static final int MaxSpeedFieldNum = 14;
    public static final int MaxTemperatureFieldNum = 51;
    public static final int MaxTotalHemoglobinConcFieldNum = 86;
    public static final int MesgID = 4864;
    public static final int MessageIndexFieldNum = 254;
    public static final int MinAltitudeFieldNum = 62;
    public static final int MinHeartRateFieldNum = 63;
    public static final int MinSaturatedHemoglobinPercentFieldNum = 88;
    public static final int MinTotalHemoglobinConcFieldNum = 85;
    public static final int NormalizedPowerFieldNum = 33;
    public static final int NumActiveLengthsFieldNum = 40;
    public static final int NumLengthsFieldNum = 32;
    public static final int OpponentScoreFieldNum = 74;
    public static final int PlayerScoreFieldNum = 83;
    public static final int RepetitionNumFieldNum = 61;
    public static final int SportFieldNum = 25;
    public static final int StandCountFieldNum = 99;
    public static final int StartPositionLatFieldNum = 3;
    public static final int StartPositionLongFieldNum = 4;
    public static final int StartTimeFieldNum = 2;
    public static final int StrokeCountFieldNum = 75;
    public static final int SubSportFieldNum = 39;
    public static final int SwimStrokeFieldNum = 38;
    public static final int TimeInCadenceZoneFieldNum = 59;
    public static final int TimeInHrZoneFieldNum = 57;
    public static final int TimeInPowerZoneFieldNum = 60;
    public static final int TimeInSpeedZoneFieldNum = 58;
    public static final int TimeStandingFieldNum = 98;
    public static final int TimestampFieldNum = 253;
    public static final int TotalAscentFieldNum = 21;
    public static final int TotalCaloriesFieldNum = 11;
    public static final int TotalCyclesFieldNum = 10;
    public static final int TotalDescentFieldNum = 22;
    public static final int TotalDistanceFieldNum = 9;
    public static final int TotalElapsedTimeFieldNum = 7;
    public static final int TotalFatCaloriesFieldNum = 12;
    public static final int TotalFractionalCyclesFieldNum = 82;
    public static final int TotalMovingTimeFieldNum = 52;
    public static final int TotalTimerTimeFieldNum = 8;
    public static final int TotalWorkFieldNum = 41;
    public static final int WktStepIndexFieldNum = 71;
    public static final int ZoneCountFieldNum = 76;
    protected static final Mesg lapMesg;

    static {
        Mesg mesg;
        lapMesg = mesg = new Mesg("lap", 4864);
        mesg.addField(new Field("message_index", 254, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        mesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        mesg.addField(new Field("event", 0, 0, 1.0, 0.0, "", false, Profile.Type.EVENT));
        mesg.addField(new Field("event_type", 1, 0, 1.0, 0.0, "", false, Profile.Type.EVENT_TYPE));
        mesg.addField(new Field("start_time", 2, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
        mesg.addField(new Field("start_position_lat", 3, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        mesg.addField(new Field("start_position_long", 4, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        mesg.addField(new Field("end_position_lat", 5, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        mesg.addField(new Field("end_position_long", 6, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        mesg.addField(new Field("total_elapsed_time", 7, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("total_timer_time", 8, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("total_distance", 9, 134, 100.0, 0.0, "m", false, Profile.Type.UINT32));
        mesg.addField(new Field("total_cycles", 10, 134, 1.0, 0.0, "cycles", false, Profile.Type.UINT32));
        mesg.fields.get((int)12).subFields.add(new SubField("total_strides", 134, 1.0, 0.0, "strides"));
        mesg.fields.get((int)12).subFields.get(0).addMap(25, 1L);
        mesg.fields.get((int)12).subFields.get(0).addMap(25, 11L);
        mesg.addField(new Field("total_calories", 11, 132, 1.0, 0.0, "kcal", false, Profile.Type.UINT16));
        mesg.addField(new Field("total_fat_calories", 12, 132, 1.0, 0.0, "kcal", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_speed", 13, 132, 1000.0, 0.0, "m/s", false, Profile.Type.UINT16));
        mesg.fields.get((int)15).components.add(new FieldComponent(110, false, 16, 1000.0, 0.0));
        mesg.addField(new Field("max_speed", 14, 132, 1000.0, 0.0, "m/s", false, Profile.Type.UINT16));
        mesg.fields.get((int)16).components.add(new FieldComponent(111, false, 16, 1000.0, 0.0));
        mesg.addField(new Field("avg_heart_rate", 15, 2, 1.0, 0.0, "bpm", false, Profile.Type.UINT8));
        mesg.addField(new Field("max_heart_rate", 16, 2, 1.0, 0.0, "bpm", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_cadence", 17, 2, 1.0, 0.0, "rpm", false, Profile.Type.UINT8));
        mesg.fields.get((int)19).subFields.add(new SubField("avg_running_cadence", 2, 1.0, 0.0, "strides/min"));
        mesg.fields.get((int)19).subFields.get(0).addMap(25, 1L);
        mesg.addField(new Field("max_cadence", 18, 2, 1.0, 0.0, "rpm", false, Profile.Type.UINT8));
        mesg.fields.get((int)20).subFields.add(new SubField("max_running_cadence", 2, 1.0, 0.0, "strides/min"));
        mesg.fields.get((int)20).subFields.get(0).addMap(25, 1L);
        mesg.addField(new Field("avg_power", 19, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        mesg.addField(new Field("max_power", 20, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        mesg.addField(new Field("total_ascent", 21, 132, 1.0, 0.0, "m", false, Profile.Type.UINT16));
        mesg.addField(new Field("total_descent", 22, 132, 1.0, 0.0, "m", false, Profile.Type.UINT16));
        mesg.addField(new Field("intensity", 23, 0, 1.0, 0.0, "", false, Profile.Type.INTENSITY));
        mesg.addField(new Field("lap_trigger", 24, 0, 1.0, 0.0, "", false, Profile.Type.LAP_TRIGGER));
        mesg.addField(new Field("sport", 25, 0, 1.0, 0.0, "", false, Profile.Type.SPORT));
        mesg.addField(new Field("event_group", 26, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.addField(new Field("num_lengths", 32, 132, 1.0, 0.0, "lengths", false, Profile.Type.UINT16));
        mesg.addField(new Field("normalized_power", 33, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        mesg.addField(new Field("left_right_balance", 34, 132, 1.0, 0.0, "", false, Profile.Type.LEFT_RIGHT_BALANCE_100));
        mesg.addField(new Field("first_length_index", 35, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_stroke_distance", 37, 132, 100.0, 0.0, "m", false, Profile.Type.UINT16));
        mesg.addField(new Field("swim_stroke", 38, 0, 1.0, 0.0, "", false, Profile.Type.SWIM_STROKE));
        mesg.addField(new Field("sub_sport", 39, 0, 1.0, 0.0, "", false, Profile.Type.SUB_SPORT));
        mesg.addField(new Field("num_active_lengths", 40, 132, 1.0, 0.0, "lengths", false, Profile.Type.UINT16));
        mesg.addField(new Field("total_work", 41, 134, 1.0, 0.0, "J", false, Profile.Type.UINT32));
        mesg.addField(new Field("avg_altitude", 42, 132, 5.0, 500.0, "m", false, Profile.Type.UINT16));
        mesg.fields.get((int)38).components.add(new FieldComponent(112, false, 16, 5.0, 500.0));
        mesg.addField(new Field("max_altitude", 43, 132, 5.0, 500.0, "m", false, Profile.Type.UINT16));
        mesg.fields.get((int)39).components.add(new FieldComponent(114, false, 16, 5.0, 500.0));
        mesg.addField(new Field("gps_accuracy", 44, 2, 1.0, 0.0, "m", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_grade", 45, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        mesg.addField(new Field("avg_pos_grade", 46, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        mesg.addField(new Field("avg_neg_grade", 47, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        mesg.addField(new Field("max_pos_grade", 48, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        mesg.addField(new Field("max_neg_grade", 49, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        mesg.addField(new Field("avg_temperature", 50, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
        mesg.addField(new Field("max_temperature", 51, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
        mesg.addField(new Field("total_moving_time", 52, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("avg_pos_vertical_speed", 53, 131, 1000.0, 0.0, "m/s", false, Profile.Type.SINT16));
        mesg.addField(new Field("avg_neg_vertical_speed", 54, 131, 1000.0, 0.0, "m/s", false, Profile.Type.SINT16));
        mesg.addField(new Field("max_pos_vertical_speed", 55, 131, 1000.0, 0.0, "m/s", false, Profile.Type.SINT16));
        mesg.addField(new Field("max_neg_vertical_speed", 56, 131, 1000.0, 0.0, "m/s", false, Profile.Type.SINT16));
        mesg.addField(new Field("time_in_hr_zone", 57, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("time_in_speed_zone", 58, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("time_in_cadence_zone", 59, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("time_in_power_zone", 60, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("repetition_num", 61, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("min_altitude", 62, 132, 5.0, 500.0, "m", false, Profile.Type.UINT16));
        mesg.fields.get((int)58).components.add(new FieldComponent(113, false, 16, 5.0, 500.0));
        mesg.addField(new Field("min_heart_rate", 63, 2, 1.0, 0.0, "bpm", false, Profile.Type.UINT8));
        mesg.addField(new Field("wkt_step_index", 71, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        mesg.addField(new Field("opponent_score", 74, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("stroke_count", 75, 132, 1.0, 0.0, "counts", false, Profile.Type.UINT16));
        mesg.addField(new Field("zone_count", 76, 132, 1.0, 0.0, "counts", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_vertical_oscillation", 77, 132, 10.0, 0.0, "mm", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_stance_time_percent", 78, 132, 100.0, 0.0, "percent", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_stance_time", 79, 132, 10.0, 0.0, "ms", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_fractional_cadence", 80, 2, 128.0, 0.0, "rpm", false, Profile.Type.UINT8));
        mesg.addField(new Field("max_fractional_cadence", 81, 2, 128.0, 0.0, "rpm", false, Profile.Type.UINT8));
        mesg.addField(new Field("total_fractional_cycles", 82, 2, 128.0, 0.0, "cycles", false, Profile.Type.UINT8));
        mesg.addField(new Field("player_score", 83, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_total_hemoglobin_conc", 84, 132, 100.0, 0.0, "g/dL", false, Profile.Type.UINT16));
        mesg.addField(new Field("min_total_hemoglobin_conc", 85, 132, 100.0, 0.0, "g/dL", false, Profile.Type.UINT16));
        mesg.addField(new Field("max_total_hemoglobin_conc", 86, 132, 100.0, 0.0, "g/dL", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_saturated_hemoglobin_percent", 87, 132, 10.0, 0.0, "%", false, Profile.Type.UINT16));
        mesg.addField(new Field("min_saturated_hemoglobin_percent", 88, 132, 10.0, 0.0, "%", false, Profile.Type.UINT16));
        mesg.addField(new Field("max_saturated_hemoglobin_percent", 89, 132, 10.0, 0.0, "%", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_left_torque_effectiveness", 91, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_right_torque_effectiveness", 92, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_left_pedal_smoothness", 93, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_right_pedal_smoothness", 94, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_combined_pedal_smoothness", 95, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("time_standing", 98, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("stand_count", 99, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_left_pco", 100, 1, 1.0, 0.0, "mm", false, Profile.Type.SINT8));
        mesg.addField(new Field("avg_right_pco", 101, 1, 1.0, 0.0, "mm", false, Profile.Type.SINT8));
        mesg.addField(new Field("avg_left_power_phase", 102, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_left_power_phase_peak", 103, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_right_power_phase", 104, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_right_power_phase_peak", 105, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_power_position", 106, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        mesg.addField(new Field("max_power_position", 107, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_cadence_position", 108, 2, 1.0, 0.0, "rpm", false, Profile.Type.UINT8));
        mesg.addField(new Field("max_cadence_position", 109, 2, 1.0, 0.0, "rpm", false, Profile.Type.UINT8));
        mesg.addField(new Field("enhanced_avg_speed", 110, 134, 1000.0, 0.0, "m/s", false, Profile.Type.UINT32));
        mesg.addField(new Field("enhanced_max_speed", 111, 134, 1000.0, 0.0, "m/s", false, Profile.Type.UINT32));
        mesg.addField(new Field("enhanced_avg_altitude", 112, 134, 5.0, 500.0, "m", false, Profile.Type.UINT32));
        mesg.addField(new Field("enhanced_min_altitude", 113, 134, 5.0, 500.0, "m", false, Profile.Type.UINT32));
        mesg.addField(new Field("enhanced_max_altitude", 114, 134, 5.0, 500.0, "m", false, Profile.Type.UINT32));
        mesg.addField(new Field("avg_lev_motor_power", 115, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        mesg.addField(new Field("max_lev_motor_power", 116, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        mesg.addField(new Field("lev_battery_consumption", 117, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("avg_vertical_ratio", 118, 132, 100.0, 0.0, "percent", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_stance_time_balance", 119, 132, 100.0, 0.0, "percent", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_step_length", 120, 132, 10.0, 0.0, "mm", false, Profile.Type.UINT16));
        mesg.addField(new Field("avg_vam", 121, 132, 1000.0, 0.0, "m/s", false, Profile.Type.UINT16));
    }

    public LapMesg() {
        super(Factory.createMesg(4864));
    }

    public LapMesg(Mesg mesg) {
        super(mesg);
    }

    public Float getAvgAltitude() {
        return this.getFieldFloatValue(42, 0, 65535);
    }

    public Short getAvgCadence() {
        return this.getFieldShortValue(17, 0, 65535);
    }

    public Short getAvgCadencePosition(int n) {
        return this.getFieldShortValue(108, n, 65535);
    }

    public Short[] getAvgCadencePosition() {
        return this.getFieldShortValues(108, 65535);
    }

    public Float getAvgCombinedPedalSmoothness() {
        return this.getFieldFloatValue(95, 0, 65535);
    }

    public Float getAvgFractionalCadence() {
        return this.getFieldFloatValue(80, 0, 65535);
    }

    public Float getAvgGrade() {
        return this.getFieldFloatValue(45, 0, 65535);
    }

    public Short getAvgHeartRate() {
        return this.getFieldShortValue(15, 0, 65535);
    }

    public Byte getAvgLeftPco() {
        return this.getFieldByteValue(100, 0, 65535);
    }

    public Float getAvgLeftPedalSmoothness() {
        return this.getFieldFloatValue(93, 0, 65535);
    }

    public Float getAvgLeftPowerPhase(int n) {
        return this.getFieldFloatValue(102, n, 65535);
    }

    public Float[] getAvgLeftPowerPhase() {
        return this.getFieldFloatValues(102, 65535);
    }

    public Float getAvgLeftPowerPhasePeak(int n) {
        return this.getFieldFloatValue(103, n, 65535);
    }

    public Float[] getAvgLeftPowerPhasePeak() {
        return this.getFieldFloatValues(103, 65535);
    }

    public Float getAvgLeftTorqueEffectiveness() {
        return this.getFieldFloatValue(91, 0, 65535);
    }

    public Integer getAvgLevMotorPower() {
        return this.getFieldIntegerValue(115, 0, 65535);
    }

    public Float getAvgNegGrade() {
        return this.getFieldFloatValue(47, 0, 65535);
    }

    public Float getAvgNegVerticalSpeed() {
        return this.getFieldFloatValue(54, 0, 65535);
    }

    public Float getAvgPosGrade() {
        return this.getFieldFloatValue(46, 0, 65535);
    }

    public Float getAvgPosVerticalSpeed() {
        return this.getFieldFloatValue(53, 0, 65535);
    }

    public Integer getAvgPower() {
        return this.getFieldIntegerValue(19, 0, 65535);
    }

    public Integer getAvgPowerPosition(int n) {
        return this.getFieldIntegerValue(106, n, 65535);
    }

    public Integer[] getAvgPowerPosition() {
        return this.getFieldIntegerValues(106, 65535);
    }

    public Byte getAvgRightPco() {
        return this.getFieldByteValue(101, 0, 65535);
    }

    public Float getAvgRightPedalSmoothness() {
        return this.getFieldFloatValue(94, 0, 65535);
    }

    public Float getAvgRightPowerPhase(int n) {
        return this.getFieldFloatValue(104, n, 65535);
    }

    public Float[] getAvgRightPowerPhase() {
        return this.getFieldFloatValues(104, 65535);
    }

    public Float getAvgRightPowerPhasePeak(int n) {
        return this.getFieldFloatValue(105, n, 65535);
    }

    public Float[] getAvgRightPowerPhasePeak() {
        return this.getFieldFloatValues(105, 65535);
    }

    public Float getAvgRightTorqueEffectiveness() {
        return this.getFieldFloatValue(92, 0, 65535);
    }

    public Short getAvgRunningCadence() {
        return this.getFieldShortValue(17, 0, 0);
    }

    public Float getAvgSaturatedHemoglobinPercent(int n) {
        return this.getFieldFloatValue(87, n, 65535);
    }

    public Float[] getAvgSaturatedHemoglobinPercent() {
        return this.getFieldFloatValues(87, 65535);
    }

    public Float getAvgSpeed() {
        return this.getFieldFloatValue(13, 0, 65535);
    }

    public Float getAvgStanceTime() {
        return this.getFieldFloatValue(79, 0, 65535);
    }

    public Float getAvgStanceTimeBalance() {
        return this.getFieldFloatValue(119, 0, 65535);
    }

    public Float getAvgStanceTimePercent() {
        return this.getFieldFloatValue(78, 0, 65535);
    }

    public Float getAvgStepLength() {
        return this.getFieldFloatValue(120, 0, 65535);
    }

    public Float getAvgStrokeDistance() {
        return this.getFieldFloatValue(37, 0, 65535);
    }

    public Byte getAvgTemperature() {
        return this.getFieldByteValue(50, 0, 65535);
    }

    public Float getAvgTotalHemoglobinConc(int n) {
        return this.getFieldFloatValue(84, n, 65535);
    }

    public Float[] getAvgTotalHemoglobinConc() {
        return this.getFieldFloatValues(84, 65535);
    }

    public Float getAvgVam() {
        return this.getFieldFloatValue(121, 0, 65535);
    }

    public Float getAvgVerticalOscillation() {
        return this.getFieldFloatValue(77, 0, 65535);
    }

    public Float getAvgVerticalRatio() {
        return this.getFieldFloatValue(118, 0, 65535);
    }

    public Integer getEndPositionLat() {
        return this.getFieldIntegerValue(5, 0, 65535);
    }

    public Integer getEndPositionLong() {
        return this.getFieldIntegerValue(6, 0, 65535);
    }

    public Float getEnhancedAvgAltitude() {
        return this.getFieldFloatValue(112, 0, 65535);
    }

    public Float getEnhancedAvgSpeed() {
        return this.getFieldFloatValue(110, 0, 65535);
    }

    public Float getEnhancedMaxAltitude() {
        return this.getFieldFloatValue(114, 0, 65535);
    }

    public Float getEnhancedMaxSpeed() {
        return this.getFieldFloatValue(111, 0, 65535);
    }

    public Float getEnhancedMinAltitude() {
        return this.getFieldFloatValue(113, 0, 65535);
    }

    @Override
    public Event getEvent() {
        Short s = this.getFieldShortValue(0, 0, 65535);
        if (s == null) {
            return null;
        }
        return Event.getByValue(s);
    }

    @Override
    public Short getEventGroup() {
        return this.getFieldShortValue(26, 0, 65535);
    }

    @Override
    public EventType getEventType() {
        Short s = this.getFieldShortValue(1, 0, 65535);
        if (s == null) {
            return null;
        }
        return EventType.getByValue(s);
    }

    public Integer getFirstLengthIndex() {
        return this.getFieldIntegerValue(35, 0, 65535);
    }

    public Short getGpsAccuracy() {
        return this.getFieldShortValue(44, 0, 65535);
    }

    public Intensity getIntensity() {
        Short s = this.getFieldShortValue(23, 0, 65535);
        if (s == null) {
            return null;
        }
        return Intensity.getByValue(s);
    }

    public LapTrigger getLapTrigger() {
        Short s = this.getFieldShortValue(24, 0, 65535);
        if (s == null) {
            return null;
        }
        return LapTrigger.getByValue(s);
    }

    public Integer getLeftRightBalance() {
        return this.getFieldIntegerValue(34, 0, 65535);
    }

    public Float getLevBatteryConsumption() {
        return this.getFieldFloatValue(117, 0, 65535);
    }

    public Float getMaxAltitude() {
        return this.getFieldFloatValue(43, 0, 65535);
    }

    public Short getMaxCadence() {
        return this.getFieldShortValue(18, 0, 65535);
    }

    public Short getMaxCadencePosition(int n) {
        return this.getFieldShortValue(109, n, 65535);
    }

    public Short[] getMaxCadencePosition() {
        return this.getFieldShortValues(109, 65535);
    }

    public Float getMaxFractionalCadence() {
        return this.getFieldFloatValue(81, 0, 65535);
    }

    public Short getMaxHeartRate() {
        return this.getFieldShortValue(16, 0, 65535);
    }

    public Integer getMaxLevMotorPower() {
        return this.getFieldIntegerValue(116, 0, 65535);
    }

    public Float getMaxNegGrade() {
        return this.getFieldFloatValue(49, 0, 65535);
    }

    public Float getMaxNegVerticalSpeed() {
        return this.getFieldFloatValue(56, 0, 65535);
    }

    public Float getMaxPosGrade() {
        return this.getFieldFloatValue(48, 0, 65535);
    }

    public Float getMaxPosVerticalSpeed() {
        return this.getFieldFloatValue(55, 0, 65535);
    }

    public Integer getMaxPower() {
        return this.getFieldIntegerValue(20, 0, 65535);
    }

    public Integer getMaxPowerPosition(int n) {
        return this.getFieldIntegerValue(107, n, 65535);
    }

    public Integer[] getMaxPowerPosition() {
        return this.getFieldIntegerValues(107, 65535);
    }

    public Short getMaxRunningCadence() {
        return this.getFieldShortValue(18, 0, 0);
    }

    public Float getMaxSaturatedHemoglobinPercent(int n) {
        return this.getFieldFloatValue(89, n, 65535);
    }

    public Float[] getMaxSaturatedHemoglobinPercent() {
        return this.getFieldFloatValues(89, 65535);
    }

    public Float getMaxSpeed() {
        return this.getFieldFloatValue(14, 0, 65535);
    }

    public Byte getMaxTemperature() {
        return this.getFieldByteValue(51, 0, 65535);
    }

    public Float getMaxTotalHemoglobinConc(int n) {
        return this.getFieldFloatValue(86, n, 65535);
    }

    public Float[] getMaxTotalHemoglobinConc() {
        return this.getFieldFloatValues(86, 65535);
    }

    public Integer getMessageIndex() {
        return this.getFieldIntegerValue(254, 0, 65535);
    }

    public Float getMinAltitude() {
        return this.getFieldFloatValue(62, 0, 65535);
    }

    public Short getMinHeartRate() {
        return this.getFieldShortValue(63, 0, 65535);
    }

    public Float getMinSaturatedHemoglobinPercent(int n) {
        return this.getFieldFloatValue(88, n, 65535);
    }

    public Float[] getMinSaturatedHemoglobinPercent() {
        return this.getFieldFloatValues(88, 65535);
    }

    public Float getMinTotalHemoglobinConc(int n) {
        return this.getFieldFloatValue(85, n, 65535);
    }

    public Float[] getMinTotalHemoglobinConc() {
        return this.getFieldFloatValues(85, 65535);
    }

    public Integer getNormalizedPower() {
        return this.getFieldIntegerValue(33, 0, 65535);
    }

    public Integer getNumActiveLengths() {
        return this.getFieldIntegerValue(40, 0, 65535);
    }

    public int getNumAvgCadencePosition() {
        return this.getNumFieldValues(108, 65535);
    }

    public int getNumAvgLeftPowerPhase() {
        return this.getNumFieldValues(102, 65535);
    }

    public int getNumAvgLeftPowerPhasePeak() {
        return this.getNumFieldValues(103, 65535);
    }

    public int getNumAvgPowerPosition() {
        return this.getNumFieldValues(106, 65535);
    }

    public int getNumAvgRightPowerPhase() {
        return this.getNumFieldValues(104, 65535);
    }

    public int getNumAvgRightPowerPhasePeak() {
        return this.getNumFieldValues(105, 65535);
    }

    public int getNumAvgSaturatedHemoglobinPercent() {
        return this.getNumFieldValues(87, 65535);
    }

    public int getNumAvgTotalHemoglobinConc() {
        return this.getNumFieldValues(84, 65535);
    }

    public Integer getNumLengths() {
        return this.getFieldIntegerValue(32, 0, 65535);
    }

    public int getNumMaxCadencePosition() {
        return this.getNumFieldValues(109, 65535);
    }

    public int getNumMaxPowerPosition() {
        return this.getNumFieldValues(107, 65535);
    }

    public int getNumMaxSaturatedHemoglobinPercent() {
        return this.getNumFieldValues(89, 65535);
    }

    public int getNumMaxTotalHemoglobinConc() {
        return this.getNumFieldValues(86, 65535);
    }

    public int getNumMinSaturatedHemoglobinPercent() {
        return this.getNumFieldValues(88, 65535);
    }

    public int getNumMinTotalHemoglobinConc() {
        return this.getNumFieldValues(85, 65535);
    }

    public int getNumStrokeCount() {
        return this.getNumFieldValues(75, 65535);
    }

    public int getNumTimeInCadenceZone() {
        return this.getNumFieldValues(59, 65535);
    }

    public int getNumTimeInHrZone() {
        return this.getNumFieldValues(57, 65535);
    }

    public int getNumTimeInPowerZone() {
        return this.getNumFieldValues(60, 65535);
    }

    public int getNumTimeInSpeedZone() {
        return this.getNumFieldValues(58, 65535);
    }

    public int getNumZoneCount() {
        return this.getNumFieldValues(76, 65535);
    }

    public Integer getOpponentScore() {
        return this.getFieldIntegerValue(74, 0, 65535);
    }

    public Integer getPlayerScore() {
        return this.getFieldIntegerValue(83, 0, 65535);
    }

    public Integer getRepetitionNum() {
        return this.getFieldIntegerValue(61, 0, 65535);
    }

    public Sport getSport() {
        Short s = this.getFieldShortValue(25, 0, 65535);
        if (s == null) {
            return null;
        }
        return Sport.getByValue(s);
    }

    public Integer getStandCount() {
        return this.getFieldIntegerValue(99, 0, 65535);
    }

    public Integer getStartPositionLat() {
        return this.getFieldIntegerValue(3, 0, 65535);
    }

    public Integer getStartPositionLong() {
        return this.getFieldIntegerValue(4, 0, 65535);
    }

    public DateTime getStartTime() {
        return this.timestampToDateTime(this.getFieldLongValue(2, 0, 65535));
    }

    public Integer getStrokeCount(int n) {
        return this.getFieldIntegerValue(75, n, 65535);
    }

    public Integer[] getStrokeCount() {
        return this.getFieldIntegerValues(75, 65535);
    }

    public SubSport getSubSport() {
        Short s = this.getFieldShortValue(39, 0, 65535);
        if (s == null) {
            return null;
        }
        return SubSport.getByValue(s);
    }

    public SwimStroke getSwimStroke() {
        Short s = this.getFieldShortValue(38, 0, 65535);
        if (s == null) {
            return null;
        }
        return SwimStroke.getByValue(s);
    }

    public Float getTimeInCadenceZone(int n) {
        return this.getFieldFloatValue(59, n, 65535);
    }

    public Float[] getTimeInCadenceZone() {
        return this.getFieldFloatValues(59, 65535);
    }

    public Float getTimeInHrZone(int n) {
        return this.getFieldFloatValue(57, n, 65535);
    }

    public Float[] getTimeInHrZone() {
        return this.getFieldFloatValues(57, 65535);
    }

    public Float getTimeInPowerZone(int n) {
        return this.getFieldFloatValue(60, n, 65535);
    }

    public Float[] getTimeInPowerZone() {
        return this.getFieldFloatValues(60, 65535);
    }

    public Float getTimeInSpeedZone(int n) {
        return this.getFieldFloatValue(58, n, 65535);
    }

    public Float[] getTimeInSpeedZone() {
        return this.getFieldFloatValues(58, 65535);
    }

    public Float getTimeStanding() {
        return this.getFieldFloatValue(98, 0, 65535);
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public Integer getTotalAscent() {
        return this.getFieldIntegerValue(21, 0, 65535);
    }

    public Integer getTotalCalories() {
        return this.getFieldIntegerValue(11, 0, 65535);
    }

    public Long getTotalCycles() {
        return this.getFieldLongValue(10, 0, 65535);
    }

    public Integer getTotalDescent() {
        return this.getFieldIntegerValue(22, 0, 65535);
    }

    public Float getTotalDistance() {
        return this.getFieldFloatValue(9, 0, 65535);
    }

    public Float getTotalElapsedTime() {
        return this.getFieldFloatValue(7, 0, 65535);
    }

    public Integer getTotalFatCalories() {
        return this.getFieldIntegerValue(12, 0, 65535);
    }

    public Float getTotalFractionalCycles() {
        return this.getFieldFloatValue(82, 0, 65535);
    }

    public Float getTotalMovingTime() {
        return this.getFieldFloatValue(52, 0, 65535);
    }

    public Long getTotalStrides() {
        return this.getFieldLongValue(10, 0, 0);
    }

    public Float getTotalTimerTime() {
        return this.getFieldFloatValue(8, 0, 65535);
    }

    public Long getTotalWork() {
        return this.getFieldLongValue(41, 0, 65535);
    }

    public Integer getWktStepIndex() {
        return this.getFieldIntegerValue(71, 0, 65535);
    }

    public Integer getZoneCount(int n) {
        return this.getFieldIntegerValue(76, n, 65535);
    }

    public Integer[] getZoneCount() {
        return this.getFieldIntegerValues(76, 65535);
    }

    public void setAvgAltitude(Float f) {
        this.setFieldValue(42, 0, (Object)f, 65535);
    }

    public void setAvgCadence(Short s) {
        this.setFieldValue(17, 0, (Object)s, 65535);
    }

    public void setAvgCadencePosition(int n, Short s) {
        this.setFieldValue(108, n, (Object)s, 65535);
    }

    public void setAvgCombinedPedalSmoothness(Float f) {
        this.setFieldValue(95, 0, (Object)f, 65535);
    }

    public void setAvgFractionalCadence(Float f) {
        this.setFieldValue(80, 0, (Object)f, 65535);
    }

    public void setAvgGrade(Float f) {
        this.setFieldValue(45, 0, (Object)f, 65535);
    }

    public void setAvgHeartRate(Short s) {
        this.setFieldValue(15, 0, (Object)s, 65535);
    }

    public void setAvgLeftPco(Byte by) {
        this.setFieldValue(100, 0, (Object)by, 65535);
    }

    public void setAvgLeftPedalSmoothness(Float f) {
        this.setFieldValue(93, 0, (Object)f, 65535);
    }

    public void setAvgLeftPowerPhase(int n, Float f) {
        this.setFieldValue(102, n, (Object)f, 65535);
    }

    public void setAvgLeftPowerPhasePeak(int n, Float f) {
        this.setFieldValue(103, n, (Object)f, 65535);
    }

    public void setAvgLeftTorqueEffectiveness(Float f) {
        this.setFieldValue(91, 0, (Object)f, 65535);
    }

    public void setAvgLevMotorPower(Integer n) {
        this.setFieldValue(115, 0, (Object)n, 65535);
    }

    public void setAvgNegGrade(Float f) {
        this.setFieldValue(47, 0, (Object)f, 65535);
    }

    public void setAvgNegVerticalSpeed(Float f) {
        this.setFieldValue(54, 0, (Object)f, 65535);
    }

    public void setAvgPosGrade(Float f) {
        this.setFieldValue(46, 0, (Object)f, 65535);
    }

    public void setAvgPosVerticalSpeed(Float f) {
        this.setFieldValue(53, 0, (Object)f, 65535);
    }

    public void setAvgPower(Integer n) {
        this.setFieldValue(19, 0, (Object)n, 65535);
    }

    public void setAvgPowerPosition(int n, Integer n2) {
        this.setFieldValue(106, n, (Object)n2, 65535);
    }

    public void setAvgRightPco(Byte by) {
        this.setFieldValue(101, 0, (Object)by, 65535);
    }

    public void setAvgRightPedalSmoothness(Float f) {
        this.setFieldValue(94, 0, (Object)f, 65535);
    }

    public void setAvgRightPowerPhase(int n, Float f) {
        this.setFieldValue(104, n, (Object)f, 65535);
    }

    public void setAvgRightPowerPhasePeak(int n, Float f) {
        this.setFieldValue(105, n, (Object)f, 65535);
    }

    public void setAvgRightTorqueEffectiveness(Float f) {
        this.setFieldValue(92, 0, (Object)f, 65535);
    }

    public void setAvgRunningCadence(Short s) {
        this.setFieldValue(17, 0, (Object)s, 0);
    }

    public void setAvgSaturatedHemoglobinPercent(int n, Float f) {
        this.setFieldValue(87, n, (Object)f, 65535);
    }

    public void setAvgSpeed(Float f) {
        this.setFieldValue(13, 0, (Object)f, 65535);
    }

    public void setAvgStanceTime(Float f) {
        this.setFieldValue(79, 0, (Object)f, 65535);
    }

    public void setAvgStanceTimeBalance(Float f) {
        this.setFieldValue(119, 0, (Object)f, 65535);
    }

    public void setAvgStanceTimePercent(Float f) {
        this.setFieldValue(78, 0, (Object)f, 65535);
    }

    public void setAvgStepLength(Float f) {
        this.setFieldValue(120, 0, (Object)f, 65535);
    }

    public void setAvgStrokeDistance(Float f) {
        this.setFieldValue(37, 0, (Object)f, 65535);
    }

    public void setAvgTemperature(Byte by) {
        this.setFieldValue(50, 0, (Object)by, 65535);
    }

    public void setAvgTotalHemoglobinConc(int n, Float f) {
        this.setFieldValue(84, n, (Object)f, 65535);
    }

    public void setAvgVam(Float f) {
        this.setFieldValue(121, 0, (Object)f, 65535);
    }

    public void setAvgVerticalOscillation(Float f) {
        this.setFieldValue(77, 0, (Object)f, 65535);
    }

    public void setAvgVerticalRatio(Float f) {
        this.setFieldValue(118, 0, (Object)f, 65535);
    }

    public void setEndPositionLat(Integer n) {
        this.setFieldValue(5, 0, (Object)n, 65535);
    }

    public void setEndPositionLong(Integer n) {
        this.setFieldValue(6, 0, (Object)n, 65535);
    }

    public void setEnhancedAvgAltitude(Float f) {
        this.setFieldValue(112, 0, (Object)f, 65535);
    }

    public void setEnhancedAvgSpeed(Float f) {
        this.setFieldValue(110, 0, (Object)f, 65535);
    }

    public void setEnhancedMaxAltitude(Float f) {
        this.setFieldValue(114, 0, (Object)f, 65535);
    }

    public void setEnhancedMaxSpeed(Float f) {
        this.setFieldValue(111, 0, (Object)f, 65535);
    }

    public void setEnhancedMinAltitude(Float f) {
        this.setFieldValue(113, 0, (Object)f, 65535);
    }

    @Override
    public void setEvent(Event event) {
        this.setFieldValue(0, 0, (Object)event.value, 65535);
    }

    @Override
    public void setEventGroup(Short s) {
        this.setFieldValue(26, 0, (Object)s, 65535);
    }

    @Override
    public void setEventType(EventType eventType) {
        this.setFieldValue(1, 0, (Object)eventType.value, 65535);
    }

    public void setFirstLengthIndex(Integer n) {
        this.setFieldValue(35, 0, (Object)n, 65535);
    }

    public void setGpsAccuracy(Short s) {
        this.setFieldValue(44, 0, (Object)s, 65535);
    }

    public void setIntensity(Intensity intensity) {
        this.setFieldValue(23, 0, (Object)intensity.value, 65535);
    }

    public void setLapTrigger(LapTrigger lapTrigger) {
        this.setFieldValue(24, 0, (Object)lapTrigger.value, 65535);
    }

    public void setLeftRightBalance(Integer n) {
        this.setFieldValue(34, 0, (Object)n, 65535);
    }

    public void setLevBatteryConsumption(Float f) {
        this.setFieldValue(117, 0, (Object)f, 65535);
    }

    public void setMaxAltitude(Float f) {
        this.setFieldValue(43, 0, (Object)f, 65535);
    }

    public void setMaxCadence(Short s) {
        this.setFieldValue(18, 0, (Object)s, 65535);
    }

    public void setMaxCadencePosition(int n, Short s) {
        this.setFieldValue(109, n, (Object)s, 65535);
    }

    public void setMaxFractionalCadence(Float f) {
        this.setFieldValue(81, 0, (Object)f, 65535);
    }

    public void setMaxHeartRate(Short s) {
        this.setFieldValue(16, 0, (Object)s, 65535);
    }

    public void setMaxLevMotorPower(Integer n) {
        this.setFieldValue(116, 0, (Object)n, 65535);
    }

    public void setMaxNegGrade(Float f) {
        this.setFieldValue(49, 0, (Object)f, 65535);
    }

    public void setMaxNegVerticalSpeed(Float f) {
        this.setFieldValue(56, 0, (Object)f, 65535);
    }

    public void setMaxPosGrade(Float f) {
        this.setFieldValue(48, 0, (Object)f, 65535);
    }

    public void setMaxPosVerticalSpeed(Float f) {
        this.setFieldValue(55, 0, (Object)f, 65535);
    }

    public void setMaxPower(Integer n) {
        this.setFieldValue(20, 0, (Object)n, 65535);
    }

    public void setMaxPowerPosition(int n, Integer n2) {
        this.setFieldValue(107, n, (Object)n2, 65535);
    }

    public void setMaxRunningCadence(Short s) {
        this.setFieldValue(18, 0, (Object)s, 0);
    }

    public void setMaxSaturatedHemoglobinPercent(int n, Float f) {
        this.setFieldValue(89, n, (Object)f, 65535);
    }

    public void setMaxSpeed(Float f) {
        this.setFieldValue(14, 0, (Object)f, 65535);
    }

    public void setMaxTemperature(Byte by) {
        this.setFieldValue(51, 0, (Object)by, 65535);
    }

    public void setMaxTotalHemoglobinConc(int n, Float f) {
        this.setFieldValue(86, n, (Object)f, 65535);
    }

    public void setMessageIndex(Integer n) {
        this.setFieldValue(254, 0, (Object)n, 65535);
    }

    public void setMinAltitude(Float f) {
        this.setFieldValue(62, 0, (Object)f, 65535);
    }

    public void setMinHeartRate(Short s) {
        this.setFieldValue(63, 0, (Object)s, 65535);
    }

    public void setMinSaturatedHemoglobinPercent(int n, Float f) {
        this.setFieldValue(88, n, (Object)f, 65535);
    }

    public void setMinTotalHemoglobinConc(int n, Float f) {
        this.setFieldValue(85, n, (Object)f, 65535);
    }

    public void setNormalizedPower(Integer n) {
        this.setFieldValue(33, 0, (Object)n, 65535);
    }

    public void setNumActiveLengths(Integer n) {
        this.setFieldValue(40, 0, (Object)n, 65535);
    }

    public void setNumLengths(Integer n) {
        this.setFieldValue(32, 0, (Object)n, 65535);
    }

    public void setOpponentScore(Integer n) {
        this.setFieldValue(74, 0, (Object)n, 65535);
    }

    public void setPlayerScore(Integer n) {
        this.setFieldValue(83, 0, (Object)n, 65535);
    }

    public void setRepetitionNum(Integer n) {
        this.setFieldValue(61, 0, (Object)n, 65535);
    }

    public void setSport(Sport sport) {
        this.setFieldValue(25, 0, (Object)sport.value, 65535);
    }

    public void setStandCount(Integer n) {
        this.setFieldValue(99, 0, (Object)n, 65535);
    }

    public void setStartPositionLat(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 65535);
    }

    public void setStartPositionLong(Integer n) {
        this.setFieldValue(4, 0, (Object)n, 65535);
    }

    public void setStartTime(DateTime dateTime) {
        this.setFieldValue(2, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public void setStrokeCount(int n, Integer n2) {
        this.setFieldValue(75, n, (Object)n2, 65535);
    }

    public void setSubSport(SubSport subSport) {
        this.setFieldValue(39, 0, (Object)subSport.value, 65535);
    }

    public void setSwimStroke(SwimStroke swimStroke) {
        this.setFieldValue(38, 0, (Object)swimStroke.value, 65535);
    }

    public void setTimeInCadenceZone(int n, Float f) {
        this.setFieldValue(59, n, (Object)f, 65535);
    }

    public void setTimeInHrZone(int n, Float f) {
        this.setFieldValue(57, n, (Object)f, 65535);
    }

    public void setTimeInPowerZone(int n, Float f) {
        this.setFieldValue(60, n, (Object)f, 65535);
    }

    public void setTimeInSpeedZone(int n, Float f) {
        this.setFieldValue(58, n, (Object)f, 65535);
    }

    public void setTimeStanding(Float f) {
        this.setFieldValue(98, 0, (Object)f, 65535);
    }

    @Override
    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public void setTotalAscent(Integer n) {
        this.setFieldValue(21, 0, (Object)n, 65535);
    }

    public void setTotalCalories(Integer n) {
        this.setFieldValue(11, 0, (Object)n, 65535);
    }

    public void setTotalCycles(Long l) {
        this.setFieldValue(10, 0, (Object)l, 65535);
    }

    public void setTotalDescent(Integer n) {
        this.setFieldValue(22, 0, (Object)n, 65535);
    }

    public void setTotalDistance(Float f) {
        this.setFieldValue(9, 0, (Object)f, 65535);
    }

    public void setTotalElapsedTime(Float f) {
        this.setFieldValue(7, 0, (Object)f, 65535);
    }

    public void setTotalFatCalories(Integer n) {
        this.setFieldValue(12, 0, (Object)n, 65535);
    }

    public void setTotalFractionalCycles(Float f) {
        this.setFieldValue(82, 0, (Object)f, 65535);
    }

    public void setTotalMovingTime(Float f) {
        this.setFieldValue(52, 0, (Object)f, 65535);
    }

    public void setTotalStrides(Long l) {
        this.setFieldValue(10, 0, (Object)l, 0);
    }

    public void setTotalTimerTime(Float f) {
        this.setFieldValue(8, 0, (Object)f, 65535);
    }

    public void setTotalWork(Long l) {
        this.setFieldValue(41, 0, (Object)l, 65535);
    }

    public void setWktStepIndex(Integer n) {
        this.setFieldValue(71, 0, (Object)n, 65535);
    }

    public void setZoneCount(int n, Integer n2) {
        this.setFieldValue(76, n, (Object)n2, 65535);
    }
}

