/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Fit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LocalDateTime {
    public static final long INVALID = Fit.UINT32_INVALID;
    public static final long MIN = 0x10000000L;
    public static final long OFFSET = 631065600000L;
    private static final Map<Long, String> stringMap;
    private long timestamp;

    static {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        stringMap = hashMap;
        hashMap.put(0x10000000L, "MIN");
    }

    public LocalDateTime(long l) {
        this.timestamp = l;
    }

    public LocalDateTime(Date date) {
        this.timestamp = (date.getTime() - 631065600000L) / 1000L;
    }

    public static String getStringFromValue(Long l) {
        Map<Long, String> map = stringMap;
        if (map.containsKey(l)) {
            return map.get(l);
        }
        return "";
    }

    public static Long getValueFromString(String string2) {
        for (Map.Entry<Long, String> entry : stringMap.entrySet()) {
            if (!entry.getValue().equals(string2)) continue;
            return entry.getKey();
        }
        return INVALID;
    }

    public void convertSystemTimeToLocal(long l) {
        long l2 = this.timestamp;
        if (l2 < 0x10000000L) {
            this.timestamp = l2 + l;
        }
    }

    public boolean equals(DateTime dateTime) {
        return this.getTimestamp().equals(dateTime.getTimestamp());
    }

    public Date getDate() {
        return new Date(this.timestamp * 1000L + 631065600000L);
    }

    public Long getTimestamp() {
        return new Long(this.timestamp);
    }

    public String toString() {
        return this.getDate().toString();
    }
}

