/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.FieldBase;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Mesg;
import java.util.ArrayList;
import java.util.Iterator;

public class SubField {
    protected ArrayList<FieldComponent> components;
    private ArrayList<SubFieldMap> maps;
    protected String name;
    protected double offset;
    protected double scale;
    protected int type;
    protected String units;

    protected SubField(SubField subField) {
        if (subField == null) {
            this.name = "unknown";
            this.type = 0;
            this.scale = 1.0;
            this.offset = 0.0;
            this.units = "";
            this.maps = new ArrayList();
            this.components = new ArrayList();
            return;
        }
        this.name = new String(subField.name);
        this.type = subField.type;
        this.scale = subField.scale;
        this.offset = subField.offset;
        this.units = new String(subField.units);
        this.maps = subField.maps;
        this.components = subField.components;
    }

    protected SubField(String string2, int n, double d, double d2, String string3) {
        this.name = new String(string2);
        this.type = n;
        this.scale = d;
        this.offset = d2;
        this.units = new String(string3);
        this.maps = new ArrayList();
        this.components = new ArrayList();
    }

    protected void addComponent(FieldComponent fieldComponent) {
        this.components.add(fieldComponent);
    }

    protected void addMap(int n, long l) {
        this.maps.add(new SubFieldMap(n, l));
    }

    public boolean canMesgSupport(Mesg mesg) {
        Iterator<SubFieldMap> iterator2 = this.maps.iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().canMesgSupport(mesg)) continue;
            return true;
        }
        return false;
    }

    protected String getName() {
        return this.name;
    }

    protected int getType() {
        return this.type;
    }

    protected String getUnits() {
        return this.units;
    }

    private class SubFieldMap {
        private int refFieldNum;
        private long refFieldValue;

        protected SubFieldMap(int n, long l) {
            this.refFieldNum = n;
            this.refFieldValue = l;
        }

        protected boolean canMesgSupport(Mesg object) {
            return (object = ((Mesg)object).getField(this.refFieldNum)) != null && (object = ((FieldBase)object).getLongValue(0, 65535)) != null && (Long)object == this.refFieldValue;
        }
    }
}

