/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.HrZoneCalc;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.PwrZoneCalc;

public class ZonesTargetMesg
extends Mesg {
    public static final int FunctionalThresholdPowerFieldNum = 3;
    public static final int HrCalcTypeFieldNum = 5;
    public static final int MaxHeartRateFieldNum = 1;
    public static final int PwrCalcTypeFieldNum = 7;
    public static final int ThresholdHeartRateFieldNum = 2;
    protected static final Mesg zonesTargetMesg;

    static {
        Mesg mesg;
        zonesTargetMesg = mesg = new Mesg("zones_target", 7);
        mesg.addField(new Field("max_heart_rate", 1, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.addField(new Field("threshold_heart_rate", 2, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.addField(new Field("functional_threshold_power", 3, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("hr_calc_type", 5, 0, 1.0, 0.0, "", false, Profile.Type.HR_ZONE_CALC));
        mesg.addField(new Field("pwr_calc_type", 7, 0, 1.0, 0.0, "", false, Profile.Type.PWR_ZONE_CALC));
    }

    public ZonesTargetMesg() {
        super(Factory.createMesg(7));
    }

    public ZonesTargetMesg(Mesg mesg) {
        super(mesg);
    }

    public Integer getFunctionalThresholdPower() {
        return this.getFieldIntegerValue(3, 0, 65535);
    }

    public HrZoneCalc getHrCalcType() {
        Short s = this.getFieldShortValue(5, 0, 65535);
        if (s == null) {
            return null;
        }
        return HrZoneCalc.getByValue(s);
    }

    public Short getMaxHeartRate() {
        return this.getFieldShortValue(1, 0, 65535);
    }

    public PwrZoneCalc getPwrCalcType() {
        Short s = this.getFieldShortValue(7, 0, 65535);
        if (s == null) {
            return null;
        }
        return PwrZoneCalc.getByValue(s);
    }

    public Short getThresholdHeartRate() {
        return this.getFieldShortValue(2, 0, 65535);
    }

    public void setFunctionalThresholdPower(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 65535);
    }

    public void setHrCalcType(HrZoneCalc hrZoneCalc) {
        this.setFieldValue(5, 0, (Object)hrZoneCalc.value, 65535);
    }

    public void setMaxHeartRate(Short s) {
        this.setFieldValue(1, 0, (Object)s, 65535);
    }

    public void setPwrCalcType(PwrZoneCalc pwrZoneCalc) {
        this.setFieldValue(7, 0, (Object)pwrZoneCalc.value, 65535);
    }

    public void setThresholdHeartRate(Short s) {
        this.setFieldValue(2, 0, (Object)s, 65535);
    }
}

