/*
 * Decompiled with CFR 0.152.
 */
package com.github.clans.fab;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageButton;
import com.github.clans.fab.Label;
import com.github.clans.fab.R;
import com.github.clans.fab.Util;

public class FloatingActionButton
extends ImageButton {
    private static final int BAR_MAX_LENGTH = 270;
    private static final double BAR_SPIN_CYCLE_TIME = 500.0;
    private static final long PAUSE_GROWING_TIME = 200L;
    private static final Xfermode PORTER_DUFF_CLEAR = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    public static final int SIZE_MINI = 1;
    public static final int SIZE_NORMAL = 0;
    private boolean mAnimateProgress;
    private Drawable mBackgroundDrawable;
    private Paint mBackgroundPaint;
    private float mBarExtraLength;
    private boolean mBarGrowingFromFront = true;
    private int mBarLength = 16;
    private boolean mButtonPositionSaved;
    private View.OnClickListener mClickListener;
    private int mColorDisabled;
    private int mColorNormal;
    private int mColorPressed;
    private int mColorRipple;
    private float mCurrentProgress;
    int mFabSize;
    GestureDetector mGestureDetector;
    private Animation mHideAnimation;
    private Drawable mIcon;
    private int mIconSize;
    private String mLabelText;
    private long mLastTimeAnimated;
    private float mOriginalX = -1.0f;
    private float mOriginalY = -1.0f;
    private long mPausedTimeWithoutGrowing = 0L;
    private int mProgress;
    private int mProgressBackgroundColor;
    private boolean mProgressBarEnabled;
    private RectF mProgressCircleBounds;
    private int mProgressColor;
    private boolean mProgressIndeterminate;
    private int mProgressMax = 100;
    private Paint mProgressPaint;
    private int mProgressWidth;
    int mShadowColor;
    int mShadowRadius = Util.dpToPx(this.getContext(), 4.0f);
    int mShadowXOffset = Util.dpToPx(this.getContext(), 1.0f);
    int mShadowYOffset = Util.dpToPx(this.getContext(), 3.0f);
    private boolean mShouldProgressIndeterminate;
    private boolean mShouldSetProgress;
    private boolean mShouldUpdateButtonPosition;
    private Animation mShowAnimation;
    private boolean mShowProgressBackground;
    boolean mShowShadow;
    private float mSpinSpeed = 195.0f;
    private float mTargetProgress;
    private double mTimeStartGrowing;
    private boolean mUsingElevation;
    private boolean mUsingElevationCompat;

    public FloatingActionButton(Context context) {
        this(context, null);
    }

    public FloatingActionButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public FloatingActionButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mIconSize = Util.dpToPx(this.getContext(), 24.0f);
        this.mProgressWidth = Util.dpToPx(this.getContext(), 6.0f);
        this.mProgressCircleBounds = new RectF();
        this.mBackgroundPaint = new Paint(1);
        this.mProgressPaint = new Paint(1);
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent motionEvent) {
                Label label = (Label)((Object)FloatingActionButton.this.getTag(R.id.fab_label));
                if (label != null) {
                    label.onActionDown();
                }
                FloatingActionButton.this.onActionDown();
                return super.onDown(motionEvent);
            }

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                Label label = (Label)((Object)FloatingActionButton.this.getTag(R.id.fab_label));
                if (label != null) {
                    label.onActionUp();
                }
                FloatingActionButton.this.onActionUp();
                return super.onSingleTapUp(motionEvent);
            }
        });
        this.init(context, attributeSet, n);
    }

    public FloatingActionButton(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mIconSize = Util.dpToPx(this.getContext(), 24.0f);
        this.mProgressWidth = Util.dpToPx(this.getContext(), 6.0f);
        this.mProgressCircleBounds = new RectF();
        this.mBackgroundPaint = new Paint(1);
        this.mProgressPaint = new Paint(1);
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new /* invalid duplicate definition of identical inner class */);
        this.init(context, attributeSet, n);
    }

    private float calculateCenterX() {
        return this.getMeasuredWidth() / 2;
    }

    private float calculateCenterY() {
        return this.getMeasuredHeight() / 2;
    }

    private int calculateMeasuredHeight() {
        int n;
        int n2 = n = this.getCircleSize() + this.calculateShadowHeight();
        if (this.mProgressBarEnabled) {
            n2 = n + this.mProgressWidth * 2;
        }
        return n2;
    }

    private int calculateMeasuredWidth() {
        int n;
        int n2 = n = this.getCircleSize() + this.calculateShadowWidth();
        if (this.mProgressBarEnabled) {
            n2 = n + this.mProgressWidth * 2;
        }
        return n2;
    }

    private Drawable createCircleDrawable(int n) {
        CircleDrawable circleDrawable = new CircleDrawable((Shape)new OvalShape());
        circleDrawable.getPaint().setColor(n);
        return circleDrawable;
    }

    private Drawable createFillDrawable() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        Drawable drawable2 = this.createCircleDrawable(this.mColorDisabled);
        stateListDrawable.addState(new int[]{-16842910}, drawable2);
        drawable2 = this.createCircleDrawable(this.mColorPressed);
        stateListDrawable.addState(new int[]{16842919}, drawable2);
        drawable2 = this.createCircleDrawable(this.mColorNormal);
        stateListDrawable.addState(new int[0], drawable2);
        if (Util.hasLollipop()) {
            int n = this.mColorRipple;
            stateListDrawable = new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{n}), (Drawable)stateListDrawable, null);
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setOval(0, 0, view.getWidth(), view.getHeight());
                }
            });
            this.setClipToOutline(true);
            this.mBackgroundDrawable = stateListDrawable;
            return stateListDrawable;
        }
        this.mBackgroundDrawable = stateListDrawable;
        return stateListDrawable;
    }

    private int getCircleSize() {
        Resources resources = this.getResources();
        int n = this.mFabSize == 0 ? R.dimen.fab_size_normal : R.dimen.fab_size_mini;
        return resources.getDimensionPixelSize(n);
    }

    private int getShadowX() {
        return this.mShadowRadius + Math.abs(this.mShadowXOffset);
    }

    private int getShadowY() {
        return this.mShadowRadius + Math.abs(this.mShadowYOffset);
    }

    private void init(Context context, AttributeSet attributeSet, int n) {
        context = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionButton, n, 0);
        this.mColorNormal = context.getColor(R.styleable.FloatingActionButton_fab_colorNormal, -2473162);
        this.mColorPressed = context.getColor(R.styleable.FloatingActionButton_fab_colorPressed, -1617853);
        this.mColorDisabled = context.getColor(R.styleable.FloatingActionButton_fab_colorDisabled, -5592406);
        this.mColorRipple = context.getColor(R.styleable.FloatingActionButton_fab_colorRipple, -1711276033);
        this.mShowShadow = context.getBoolean(R.styleable.FloatingActionButton_fab_showShadow, true);
        this.mShadowColor = context.getColor(R.styleable.FloatingActionButton_fab_shadowColor, 0x66000000);
        this.mShadowRadius = context.getDimensionPixelSize(R.styleable.FloatingActionButton_fab_shadowRadius, this.mShadowRadius);
        this.mShadowXOffset = context.getDimensionPixelSize(R.styleable.FloatingActionButton_fab_shadowXOffset, this.mShadowXOffset);
        this.mShadowYOffset = context.getDimensionPixelSize(R.styleable.FloatingActionButton_fab_shadowYOffset, this.mShadowYOffset);
        this.mFabSize = context.getInt(R.styleable.FloatingActionButton_fab_size, 0);
        this.mLabelText = context.getString(R.styleable.FloatingActionButton_fab_label);
        this.mShouldProgressIndeterminate = context.getBoolean(R.styleable.FloatingActionButton_fab_progress_indeterminate, false);
        this.mProgressColor = context.getColor(R.styleable.FloatingActionButton_fab_progress_color, -16738680);
        this.mProgressBackgroundColor = context.getColor(R.styleable.FloatingActionButton_fab_progress_backgroundColor, 0x4D000000);
        this.mProgressMax = context.getInt(R.styleable.FloatingActionButton_fab_progress_max, this.mProgressMax);
        this.mShowProgressBackground = context.getBoolean(R.styleable.FloatingActionButton_fab_progress_showBackground, true);
        if (context.hasValue(R.styleable.FloatingActionButton_fab_progress)) {
            this.mProgress = context.getInt(R.styleable.FloatingActionButton_fab_progress, 0);
            this.mShouldSetProgress = true;
        }
        if (context.hasValue(R.styleable.FloatingActionButton_fab_elevationCompat)) {
            float f = context.getDimensionPixelOffset(R.styleable.FloatingActionButton_fab_elevationCompat, 0);
            if (this.isInEditMode()) {
                this.setElevation(f);
            } else {
                this.setElevationCompat(f);
            }
        }
        this.initShowAnimation((TypedArray)context);
        this.initHideAnimation((TypedArray)context);
        context.recycle();
        if (this.isInEditMode()) {
            if (this.mShouldProgressIndeterminate) {
                this.setIndeterminate(true);
            } else if (this.mShouldSetProgress) {
                this.saveButtonOriginalPosition();
                this.setProgress(this.mProgress, false);
            }
        }
        this.setClickable(true);
    }

    private void initHideAnimation(TypedArray typedArray) {
        int n = typedArray.getResourceId(R.styleable.FloatingActionButton_fab_hideAnimation, R.anim.fab_scale_down);
        this.mHideAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)n);
    }

    private void initShowAnimation(TypedArray typedArray) {
        int n = typedArray.getResourceId(R.styleable.FloatingActionButton_fab_showAnimation, R.anim.fab_scale_up);
        this.mShowAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)n);
    }

    private void saveButtonOriginalPosition() {
        if (!this.mButtonPositionSaved) {
            if (this.mOriginalX == -1.0f) {
                this.mOriginalX = this.getX();
            }
            if (this.mOriginalY == -1.0f) {
                this.mOriginalY = this.getY();
            }
            this.mButtonPositionSaved = true;
        }
    }

    private void setBackgroundCompat(Drawable drawable2) {
        if (Util.hasJellyBean()) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    private void setupProgressBarPaints() {
        this.mBackgroundPaint.setColor(this.mProgressBackgroundColor);
        this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundPaint.setStrokeWidth((float)this.mProgressWidth);
        this.mProgressPaint.setColor(this.mProgressColor);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint.setStrokeWidth((float)this.mProgressWidth);
    }

    private void setupProgressBounds() {
        boolean bl = this.hasShadow();
        int n = 0;
        int n2 = bl ? this.getShadowX() : 0;
        if (this.hasShadow()) {
            n = this.getShadowY();
        }
        int n3 = this.mProgressWidth;
        this.mProgressCircleBounds = new RectF((float)(n3 / 2 + n2), (float)(n3 / 2 + n), (float)(this.calculateMeasuredWidth() - n2 - this.mProgressWidth / 2), (float)(this.calculateMeasuredHeight() - n - this.mProgressWidth / 2));
    }

    private void updateButtonPosition() {
        float f;
        float f2;
        if (this.mProgressBarEnabled) {
            f2 = this.mOriginalX > this.getX() ? this.getX() + (float)this.mProgressWidth : this.getX() - (float)this.mProgressWidth;
            if (this.mOriginalY > this.getY()) {
                float f3 = this.getY() + (float)this.mProgressWidth;
                f = f2;
                f2 = f3;
            } else {
                float f4 = this.getY() - (float)this.mProgressWidth;
                f = f2;
                f2 = f4;
            }
        } else {
            f = this.mOriginalX;
            f2 = this.mOriginalY;
        }
        this.setX(f);
        this.setY(f2);
    }

    private void updateProgressLength(long l) {
        long l2 = this.mPausedTimeWithoutGrowing;
        if (l2 >= 200L) {
            double d;
            this.mTimeStartGrowing = d = this.mTimeStartGrowing + (double)l;
            if (d > 500.0) {
                this.mTimeStartGrowing = d - 500.0;
                this.mPausedTimeWithoutGrowing = 0L;
                this.mBarGrowingFromFront ^= true;
            }
            float f = (float)Math.cos((this.mTimeStartGrowing / 500.0 + 1.0) * Math.PI) / 2.0f + 0.5f;
            float f2 = 270 - this.mBarLength;
            if (this.mBarGrowingFromFront) {
                this.mBarExtraLength = f * f2;
            } else {
                f = f2 * (1.0f - f);
                this.mCurrentProgress += this.mBarExtraLength - f;
                this.mBarExtraLength = f;
            }
        } else {
            this.mPausedTimeWithoutGrowing = l2 + l;
        }
    }

    int calculateShadowHeight() {
        int n = this.hasShadow() ? this.getShadowY() * 2 : 0;
        return n;
    }

    int calculateShadowWidth() {
        int n = this.hasShadow() ? this.getShadowX() * 2 : 0;
        return n;
    }

    public int getButtonSize() {
        return this.mFabSize;
    }

    public int getColorDisabled() {
        return this.mColorDisabled;
    }

    public int getColorNormal() {
        return this.mColorNormal;
    }

    public int getColorPressed() {
        return this.mColorPressed;
    }

    public int getColorRipple() {
        return this.mColorRipple;
    }

    Animation getHideAnimation() {
        return this.mHideAnimation;
    }

    protected Drawable getIconDrawable() {
        Drawable drawable2 = this.mIcon;
        if (drawable2 != null) {
            return drawable2;
        }
        return new ColorDrawable(0);
    }

    public String getLabelText() {
        return this.mLabelText;
    }

    Label getLabelView() {
        return (Label)((Object)this.getTag(R.id.fab_label));
    }

    public int getLabelVisibility() {
        Label label = this.getLabelView();
        if (label != null) {
            return label.getVisibility();
        }
        return -1;
    }

    public int getMax() {
        synchronized (this) {
            int n = this.mProgressMax;
            return n;
        }
    }

    View.OnClickListener getOnClickListener() {
        return this.mClickListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getProgress() {
        synchronized (this) {
            block4: {
                if (!this.mProgressIndeterminate) break block4;
                return 0;
            }
            return this.mProgress;
        }
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public int getShadowRadius() {
        return this.mShadowRadius;
    }

    public int getShadowXOffset() {
        return this.mShadowXOffset;
    }

    public int getShadowYOffset() {
        return this.mShadowYOffset;
    }

    Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    public boolean hasShadow() {
        boolean bl = !this.mUsingElevation && this.mShowShadow;
        return bl;
    }

    public void hide(boolean bl) {
        if (!this.isHidden()) {
            if (bl) {
                this.playHideAnimation();
            }
            super.setVisibility(4);
        }
    }

    public void hideButtonInMenu(boolean bl) {
        if (!this.isHidden() && this.getVisibility() != 8) {
            this.hide(bl);
            Label label = this.getLabelView();
            if (label != null) {
                label.hide(bl);
            }
            this.getHideAnimation().setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                    FloatingActionButton.this.setVisibility(8);
                    FloatingActionButton.this.getHideAnimation().setAnimationListener(null);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationStart(Animation animation) {
                }
            });
        }
    }

    public void hideProgress() {
        synchronized (this) {
            this.mProgressBarEnabled = false;
            this.mShouldUpdateButtonPosition = true;
            this.updateBackground();
            return;
        }
    }

    public boolean isHidden() {
        boolean bl = this.getVisibility() == 4;
        return bl;
    }

    public boolean isProgressBackgroundShown() {
        synchronized (this) {
            boolean bl = this.mShowProgressBackground;
            return bl;
        }
    }

    void onActionDown() {
        Drawable drawable2 = this.mBackgroundDrawable;
        if (drawable2 instanceof StateListDrawable) {
            ((StateListDrawable)drawable2).setState(new int[]{16842910, 16842919});
        } else if (Util.hasLollipop()) {
            drawable2 = (RippleDrawable)this.mBackgroundDrawable;
            drawable2.setState(new int[]{16842910, 16842919});
            drawable2.setHotspot(this.calculateCenterX(), this.calculateCenterY());
            drawable2.setVisible(true, true);
        }
    }

    void onActionUp() {
        Drawable drawable2 = this.mBackgroundDrawable;
        if (drawable2 instanceof StateListDrawable) {
            ((StateListDrawable)drawable2).setState(new int[]{16842910});
        } else if (Util.hasLollipop()) {
            drawable2 = (RippleDrawable)this.mBackgroundDrawable;
            drawable2.setState(new int[]{16842910});
            drawable2.setHotspot(this.calculateCenterX(), this.calculateCenterY());
            drawable2.setVisible(true, true);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mProgressBarEnabled) {
            if (this.mShowProgressBackground) {
                canvas.drawArc(this.mProgressCircleBounds, 360.0f, 360.0f, false, this.mBackgroundPaint);
            }
            boolean bl = false;
            boolean bl2 = this.mProgressIndeterminate;
            boolean bl3 = true;
            if (bl2) {
                long l = SystemClock.uptimeMillis() - this.mLastTimeAnimated;
                float f = (float)l * this.mSpinSpeed / 1000.0f;
                this.updateProgressLength(l);
                this.mCurrentProgress = f = this.mCurrentProgress + f;
                if (f > 360.0f) {
                    this.mCurrentProgress = f - 360.0f;
                }
                this.mLastTimeAnimated = SystemClock.uptimeMillis();
                f = this.mCurrentProgress;
                float f2 = this.mBarLength;
                float f3 = this.mBarExtraLength;
                if (this.isInEditMode()) {
                    f = 0.0f;
                    f3 = 135.0f;
                } else {
                    f -= 90.0f;
                    f3 = f2 + f3;
                }
                canvas.drawArc(this.mProgressCircleBounds, f, f3, false, this.mProgressPaint);
            } else {
                bl3 = bl;
                if (this.mCurrentProgress != this.mTargetProgress) {
                    float f = (float)(SystemClock.uptimeMillis() - this.mLastTimeAnimated) / 1000.0f * this.mSpinSpeed;
                    float f4 = this.mCurrentProgress;
                    float f5 = this.mTargetProgress;
                    this.mCurrentProgress = f4 > f5 ? Math.max(f4 - f, f5) : Math.min(f4 + f, f5);
                    this.mLastTimeAnimated = SystemClock.uptimeMillis();
                    bl3 = true;
                }
                canvas.drawArc(this.mProgressCircleBounds, -90.0f, this.mCurrentProgress, false, this.mProgressPaint);
            }
            if (bl3) {
                this.invalidate();
            }
        }
    }

    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(this.calculateMeasuredWidth(), this.calculateMeasuredHeight());
    }

    public void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof ProgressSavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        object = (ProgressSavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.mCurrentProgress = object.mCurrentProgress;
        this.mTargetProgress = object.mTargetProgress;
        this.mSpinSpeed = object.mSpinSpeed;
        this.mProgressWidth = object.mProgressWidth;
        this.mProgressColor = object.mProgressColor;
        this.mProgressBackgroundColor = object.mProgressBackgroundColor;
        this.mShouldProgressIndeterminate = object.mShouldProgressIndeterminate;
        this.mShouldSetProgress = object.mShouldSetProgress;
        this.mProgress = object.mProgress;
        this.mAnimateProgress = object.mAnimateProgress;
        this.mShowProgressBackground = object.mShowProgressBackground;
        this.mLastTimeAnimated = SystemClock.uptimeMillis();
    }

    public Parcelable onSaveInstanceState() {
        ProgressSavedState progressSavedState = new ProgressSavedState(super.onSaveInstanceState());
        progressSavedState.mCurrentProgress = this.mCurrentProgress;
        progressSavedState.mTargetProgress = this.mTargetProgress;
        progressSavedState.mSpinSpeed = this.mSpinSpeed;
        progressSavedState.mProgressWidth = this.mProgressWidth;
        progressSavedState.mProgressColor = this.mProgressColor;
        progressSavedState.mProgressBackgroundColor = this.mProgressBackgroundColor;
        progressSavedState.mShouldProgressIndeterminate = this.mProgressIndeterminate;
        boolean bl = this.mProgressBarEnabled && this.mProgress > 0 && !this.mProgressIndeterminate;
        progressSavedState.mShouldSetProgress = bl;
        progressSavedState.mProgress = this.mProgress;
        progressSavedState.mAnimateProgress = this.mAnimateProgress;
        progressSavedState.mShowProgressBackground = this.mShowProgressBackground;
        return progressSavedState;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.saveButtonOriginalPosition();
        if (this.mShouldProgressIndeterminate) {
            this.setIndeterminate(true);
            this.mShouldProgressIndeterminate = false;
        } else if (this.mShouldSetProgress) {
            this.setProgress(this.mProgress, this.mAnimateProgress);
            this.mShouldSetProgress = false;
        } else if (this.mShouldUpdateButtonPosition) {
            this.updateButtonPosition();
            this.mShouldUpdateButtonPosition = false;
        }
        super.onSizeChanged(n, n2, n3, n4);
        this.setupProgressBounds();
        this.setupProgressBarPaints();
        this.updateBackground();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mClickListener != null && this.isEnabled()) {
            Label label = (Label)((Object)this.getTag(R.id.fab_label));
            if (label == null) {
                return super.onTouchEvent(motionEvent);
            }
            int n = motionEvent.getAction();
            if (n != 1) {
                if (n == 3) {
                    if (label != null) {
                        label.onActionUp();
                    }
                    this.onActionUp();
                }
            } else {
                if (label != null) {
                    label.onActionUp();
                }
                this.onActionUp();
            }
            this.mGestureDetector.onTouchEvent(motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    void playHideAnimation() {
        this.mShowAnimation.cancel();
        this.startAnimation(this.mHideAnimation);
    }

    void playShowAnimation() {
        this.mHideAnimation.cancel();
        this.startAnimation(this.mShowAnimation);
    }

    public void setButtonSize(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Use @FabSize constants only!");
        }
        if (this.mFabSize != n) {
            this.mFabSize = n;
            this.updateBackground();
        }
    }

    public void setColorDisabled(int n) {
        if (n != this.mColorDisabled) {
            this.mColorDisabled = n;
            this.updateBackground();
        }
    }

    public void setColorDisabledResId(int n) {
        this.setColorDisabled(this.getResources().getColor(n));
    }

    public void setColorNormal(int n) {
        if (this.mColorNormal != n) {
            this.mColorNormal = n;
            this.updateBackground();
        }
    }

    public void setColorNormalResId(int n) {
        this.setColorNormal(this.getResources().getColor(n));
    }

    public void setColorPressed(int n) {
        if (n != this.mColorPressed) {
            this.mColorPressed = n;
            this.updateBackground();
        }
    }

    public void setColorPressedResId(int n) {
        this.setColorPressed(this.getResources().getColor(n));
    }

    public void setColorRipple(int n) {
        if (n != this.mColorRipple) {
            this.mColorRipple = n;
            this.updateBackground();
        }
    }

    public void setColorRippleResId(int n) {
        this.setColorRipple(this.getResources().getColor(n));
    }

    void setColors(int n, int n2, int n3) {
        this.mColorNormal = n;
        this.mColorPressed = n2;
        this.mColorRipple = n3;
    }

    public void setElevation(float f) {
        if (Util.hasLollipop() && f > 0.0f) {
            super.setElevation(f);
            if (!this.isInEditMode()) {
                this.mUsingElevation = true;
                this.mShowShadow = false;
            }
            this.updateBackground();
        }
    }

    public void setElevationCompat(float f) {
        this.mShadowColor = 0x26000000;
        float f2 = f / 2.0f;
        this.mShadowRadius = Math.round(f2);
        this.mShadowXOffset = 0;
        if (this.mFabSize == 0) {
            f2 = f;
        }
        this.mShadowYOffset = Math.round(f2);
        if (Util.hasLollipop()) {
            super.setElevation(f);
            this.mUsingElevationCompat = true;
            this.mShowShadow = false;
            this.updateBackground();
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (layoutParams != null) {
                this.setLayoutParams(layoutParams);
            }
        } else {
            this.mShowShadow = true;
            this.updateBackground();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Label label = (Label)((Object)this.getTag(R.id.fab_label));
        if (label != null) {
            label.setEnabled(bl);
        }
    }

    public void setHideAnimation(Animation animation) {
        this.mHideAnimation = animation;
    }

    public void setImageDrawable(Drawable drawable2) {
        if (this.mIcon != drawable2) {
            this.mIcon = drawable2;
            this.updateBackground();
        }
    }

    public void setImageResource(int n) {
        Drawable drawable2 = this.getResources().getDrawable(n);
        if (this.mIcon != drawable2) {
            this.mIcon = drawable2;
            this.updateBackground();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIndeterminate(boolean bl) {
        synchronized (this) {
            if (!bl) {
                this.mCurrentProgress = 0.0f;
            }
            this.mProgressBarEnabled = bl;
            this.mShouldUpdateButtonPosition = true;
            this.mProgressIndeterminate = bl;
            this.mLastTimeAnimated = SystemClock.uptimeMillis();
            this.setupProgressBounds();
            this.updateBackground();
            return;
        }
    }

    public void setLabelColors(int n, int n2, int n3) {
        Label label = this.getLabelView();
        int n4 = label.getPaddingLeft();
        int n5 = label.getPaddingTop();
        int n6 = label.getPaddingRight();
        int n7 = label.getPaddingBottom();
        label.setColors(n, n2, n3);
        label.updateBackground();
        label.setPadding(n4, n5, n6, n7);
    }

    public void setLabelText(String string2) {
        this.mLabelText = string2;
        Label label = this.getLabelView();
        if (label != null) {
            label.setText(string2);
        }
    }

    public void setLabelTextColor(int n) {
        this.getLabelView().setTextColor(n);
    }

    public void setLabelTextColor(ColorStateList colorStateList) {
        this.getLabelView().setTextColor(colorStateList);
    }

    public void setLabelVisibility(int n) {
        Label label = this.getLabelView();
        if (label != null) {
            label.setVisibility(n);
            boolean bl = n == 0;
            label.setHandleVisibilityChanges(bl);
        }
    }

    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof ViewGroup.MarginLayoutParams && this.mUsingElevationCompat) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            marginLayoutParams.leftMargin += this.getShadowX();
            marginLayoutParams.topMargin += this.getShadowY();
            marginLayoutParams.rightMargin += this.getShadowX();
            marginLayoutParams.bottomMargin += this.getShadowY();
        }
        super.setLayoutParams(layoutParams);
    }

    public void setMax(int n) {
        synchronized (this) {
            this.mProgressMax = n;
            return;
        }
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        super.setOnClickListener(onClickListener);
        this.mClickListener = onClickListener;
        onClickListener = (View)this.getTag(R.id.fab_label);
        if (onClickListener != null) {
            onClickListener.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (FloatingActionButton.this.mClickListener != null) {
                        FloatingActionButton.this.mClickListener.onClick((View)FloatingActionButton.this);
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setProgress(int n, boolean bl) {
        synchronized (this) {
            int n2;
            boolean bl2 = this.mProgressIndeterminate;
            if (bl2) {
                return;
            }
            this.mProgress = n;
            this.mAnimateProgress = bl;
            if (!this.mButtonPositionSaved) {
                this.mShouldSetProgress = true;
                return;
            }
            this.mProgressBarEnabled = true;
            this.mShouldUpdateButtonPosition = true;
            this.setupProgressBounds();
            this.saveButtonOriginalPosition();
            this.updateBackground();
            if (n < 0) {
                n2 = 0;
            } else {
                int n3 = this.mProgressMax;
                n2 = n;
                if (n > n3) {
                    n2 = n3;
                }
            }
            float f = n2;
            float f2 = this.mTargetProgress;
            if (f == f2) {
                return;
            }
            n = this.mProgressMax;
            f2 = n > 0 ? f / (float)n * 360.0f : 0.0f;
            this.mTargetProgress = f2;
            this.mLastTimeAnimated = SystemClock.uptimeMillis();
            if (!bl) {
                this.mCurrentProgress = this.mTargetProgress;
            }
            this.invalidate();
            return;
        }
    }

    public void setShadowColor(int n) {
        if (this.mShadowColor != n) {
            this.mShadowColor = n;
            this.updateBackground();
        }
    }

    public void setShadowColorResource(int n) {
        n = this.getResources().getColor(n);
        if (this.mShadowColor != n) {
            this.mShadowColor = n;
            this.updateBackground();
        }
    }

    public void setShadowRadius(float f) {
        this.mShadowRadius = Util.dpToPx(this.getContext(), f);
        this.requestLayout();
        this.updateBackground();
    }

    public void setShadowRadius(int n) {
        n = this.getResources().getDimensionPixelSize(n);
        if (this.mShadowRadius != n) {
            this.mShadowRadius = n;
            this.requestLayout();
            this.updateBackground();
        }
    }

    public void setShadowXOffset(float f) {
        this.mShadowXOffset = Util.dpToPx(this.getContext(), f);
        this.requestLayout();
        this.updateBackground();
    }

    public void setShadowXOffset(int n) {
        n = this.getResources().getDimensionPixelSize(n);
        if (this.mShadowXOffset != n) {
            this.mShadowXOffset = n;
            this.requestLayout();
            this.updateBackground();
        }
    }

    public void setShadowYOffset(float f) {
        this.mShadowYOffset = Util.dpToPx(this.getContext(), f);
        this.requestLayout();
        this.updateBackground();
    }

    public void setShadowYOffset(int n) {
        n = this.getResources().getDimensionPixelSize(n);
        if (this.mShadowYOffset != n) {
            this.mShadowYOffset = n;
            this.requestLayout();
            this.updateBackground();
        }
    }

    public void setShowAnimation(Animation animation) {
        this.mShowAnimation = animation;
    }

    public void setShowProgressBackground(boolean bl) {
        synchronized (this) {
            this.mShowProgressBackground = bl;
            return;
        }
    }

    public void setShowShadow(boolean bl) {
        if (this.mShowShadow != bl) {
            this.mShowShadow = bl;
            this.updateBackground();
        }
    }

    public void setVisibility(int n) {
        super.setVisibility(n);
        Label label = (Label)((Object)this.getTag(R.id.fab_label));
        if (label != null) {
            label.setVisibility(n);
        }
    }

    public void show(boolean bl) {
        if (this.isHidden()) {
            if (bl) {
                this.playShowAnimation();
            }
            super.setVisibility(0);
        }
    }

    public void showButtonInMenu(boolean bl) {
        if (this.getVisibility() == 0) {
            return;
        }
        this.setVisibility(4);
        this.show(bl);
        Label label = this.getLabelView();
        if (label != null) {
            label.show(bl);
        }
    }

    public void toggle(boolean bl) {
        if (this.isHidden()) {
            this.show(bl);
        } else {
            this.hide(bl);
        }
    }

    void updateBackground() {
        boolean bl = this.hasShadow();
        int n = 0;
        LayerDrawable layerDrawable = bl ? new LayerDrawable(new Drawable[]{new Shadow(), this.createFillDrawable(), this.getIconDrawable()}) : new LayerDrawable(new Drawable[]{this.createFillDrawable(), this.getIconDrawable()});
        int n2 = -1;
        if (this.getIconDrawable() != null) {
            n2 = Math.max(this.getIconDrawable().getIntrinsicWidth(), this.getIconDrawable().getIntrinsicHeight());
        }
        int n3 = this.getCircleSize();
        if (n2 <= 0) {
            n2 = this.mIconSize;
        }
        int n4 = (n3 - n2) / 2;
        n2 = this.hasShadow() ? this.mShadowRadius + Math.abs(this.mShadowXOffset) : 0;
        if (this.hasShadow()) {
            n = this.mShadowRadius + Math.abs(this.mShadowYOffset);
        }
        n3 = n;
        int n5 = n2;
        if (this.mProgressBarEnabled) {
            n3 = this.mProgressWidth;
            n5 = n2 + n3;
            n3 = n + n3;
        }
        n2 = this.hasShadow() ? 2 : 1;
        n = n5 + n4;
        layerDrawable.setLayerInset(n2, n, n3 += n4, n, n3);
        this.setBackgroundCompat((Drawable)layerDrawable);
    }

    private class CircleDrawable
    extends ShapeDrawable {
        private int circleInsetHorizontal;
        private int circleInsetVertical;

        private CircleDrawable() {
        }

        private CircleDrawable(Shape shape) {
            super(shape);
            boolean bl = FloatingActionButton.this.hasShadow();
            int n = 0;
            int n2 = bl ? FloatingActionButton.this.mShadowRadius + Math.abs(FloatingActionButton.this.mShadowXOffset) : 0;
            this.circleInsetHorizontal = n2;
            n2 = n;
            if (FloatingActionButton.this.hasShadow()) {
                n2 = FloatingActionButton.this.mShadowRadius;
                n2 = Math.abs(FloatingActionButton.this.mShadowYOffset) + n2;
            }
            this.circleInsetVertical = n2;
            if (FloatingActionButton.this.mProgressBarEnabled) {
                this.circleInsetHorizontal += FloatingActionButton.this.mProgressWidth;
                this.circleInsetVertical += FloatingActionButton.this.mProgressWidth;
            }
        }

        public void draw(Canvas canvas) {
            this.setBounds(this.circleInsetHorizontal, this.circleInsetVertical, FloatingActionButton.this.calculateMeasuredWidth() - this.circleInsetHorizontal, FloatingActionButton.this.calculateMeasuredHeight() - this.circleInsetVertical);
            super.draw(canvas);
        }
    }

    static class ProgressSavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<ProgressSavedState> CREATOR = new Parcelable.Creator<ProgressSavedState>(){

            public ProgressSavedState createFromParcel(Parcel parcel) {
                return new ProgressSavedState(parcel);
            }

            public ProgressSavedState[] newArray(int n) {
                return new ProgressSavedState[n];
            }
        };
        boolean mAnimateProgress;
        float mCurrentProgress;
        int mProgress;
        int mProgressBackgroundColor;
        boolean mProgressBarEnabled;
        boolean mProgressBarVisibilityChanged;
        int mProgressColor;
        boolean mProgressIndeterminate;
        int mProgressWidth;
        boolean mShouldProgressIndeterminate;
        boolean mShouldSetProgress;
        boolean mShowProgressBackground;
        float mSpinSpeed;
        float mTargetProgress;

        private ProgressSavedState(Parcel parcel) {
            super(parcel);
            this.mCurrentProgress = parcel.readFloat();
            this.mTargetProgress = parcel.readFloat();
            int n = parcel.readInt();
            boolean bl = true;
            boolean bl2 = n != 0;
            this.mProgressBarEnabled = bl2;
            this.mSpinSpeed = parcel.readFloat();
            this.mProgress = parcel.readInt();
            this.mProgressWidth = parcel.readInt();
            this.mProgressColor = parcel.readInt();
            this.mProgressBackgroundColor = parcel.readInt();
            bl2 = parcel.readInt() != 0;
            this.mProgressBarVisibilityChanged = bl2;
            bl2 = parcel.readInt() != 0;
            this.mProgressIndeterminate = bl2;
            bl2 = parcel.readInt() != 0;
            this.mShouldProgressIndeterminate = bl2;
            bl2 = parcel.readInt() != 0;
            this.mShouldSetProgress = bl2;
            bl2 = parcel.readInt() != 0;
            this.mAnimateProgress = bl2;
            bl2 = parcel.readInt() != 0 ? bl : false;
            this.mShowProgressBackground = bl2;
        }

        ProgressSavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeFloat(this.mCurrentProgress);
            parcel.writeFloat(this.mTargetProgress);
            parcel.writeInt(this.mProgressBarEnabled ? 1 : 0);
            parcel.writeFloat(this.mSpinSpeed);
            parcel.writeInt(this.mProgress);
            parcel.writeInt(this.mProgressWidth);
            parcel.writeInt(this.mProgressColor);
            parcel.writeInt(this.mProgressBackgroundColor);
            parcel.writeInt(this.mProgressBarVisibilityChanged ? 1 : 0);
            parcel.writeInt(this.mProgressIndeterminate ? 1 : 0);
            parcel.writeInt(this.mShouldProgressIndeterminate ? 1 : 0);
            parcel.writeInt(this.mShouldSetProgress ? 1 : 0);
            parcel.writeInt(this.mAnimateProgress ? 1 : 0);
            parcel.writeInt(this.mShowProgressBackground ? 1 : 0);
        }
    }

    private class Shadow
    extends Drawable {
        private Paint mErase;
        private Paint mPaint = new Paint(1);
        private float mRadius;

        private Shadow() {
            this.mErase = new Paint(1);
            this.init();
        }

        private void init() {
            FloatingActionButton.this.setLayerType(1, null);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(FloatingActionButton.this.mColorNormal);
            this.mErase.setXfermode(PORTER_DUFF_CLEAR);
            if (!FloatingActionButton.this.isInEditMode()) {
                this.mPaint.setShadowLayer((float)FloatingActionButton.this.mShadowRadius, (float)FloatingActionButton.this.mShadowXOffset, (float)FloatingActionButton.this.mShadowYOffset, FloatingActionButton.this.mShadowColor);
            }
            this.mRadius = FloatingActionButton.this.getCircleSize() / 2;
            if (FloatingActionButton.this.mProgressBarEnabled && FloatingActionButton.this.mShowProgressBackground) {
                this.mRadius += (float)FloatingActionButton.this.mProgressWidth;
            }
        }

        public void draw(Canvas canvas) {
            canvas.drawCircle(FloatingActionButton.this.calculateCenterX(), FloatingActionButton.this.calculateCenterY(), this.mRadius, this.mPaint);
            canvas.drawCircle(FloatingActionButton.this.calculateCenterX(), FloatingActionButton.this.calculateCenterY(), this.mRadius, this.mErase);
        }

        public int getOpacity() {
            return 0;
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }
    }
}

