/*
 * Decompiled with CFR 0.152.
 */
package com.github.clans.fab;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.animation.Animation;
import android.widget.TextView;
import com.github.clans.fab.FloatingActionButton;
import com.github.clans.fab.Util;

public class Label
extends TextView {
    private static final Xfermode PORTER_DUFF_CLEAR = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    private Drawable mBackgroundDrawable;
    private int mColorNormal;
    private int mColorPressed;
    private int mColorRipple;
    private int mCornerRadius;
    private FloatingActionButton mFab;
    GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent motionEvent) {
            Label.this.onActionDown();
            if (Label.this.mFab != null) {
                Label.this.mFab.onActionDown();
            }
            return super.onDown(motionEvent);
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            Label.this.onActionUp();
            if (Label.this.mFab != null) {
                Label.this.mFab.onActionUp();
            }
            return super.onSingleTapUp(motionEvent);
        }
    });
    private boolean mHandleVisibilityChanges = true;
    private Animation mHideAnimation;
    private int mRawHeight;
    private int mRawWidth;
    private int mShadowColor;
    private int mShadowRadius;
    private int mShadowXOffset;
    private int mShadowYOffset;
    private Animation mShowAnimation;
    private boolean mShowShadow = true;
    private boolean mUsingStyle;

    public Label(Context context) {
        super(context);
    }

    public Label(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public Label(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    private int calculateMeasuredHeight() {
        if (this.mRawHeight == 0) {
            this.mRawHeight = this.getMeasuredHeight();
        }
        return this.getMeasuredHeight() + this.calculateShadowHeight();
    }

    private int calculateMeasuredWidth() {
        if (this.mRawWidth == 0) {
            this.mRawWidth = this.getMeasuredWidth();
        }
        return this.getMeasuredWidth() + this.calculateShadowWidth();
    }

    private Drawable createFillDrawable() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        Object object = this.createRectDrawable(this.mColorPressed);
        stateListDrawable.addState(new int[]{16842919}, object);
        object = this.createRectDrawable(this.mColorNormal);
        stateListDrawable.addState(new int[0], object);
        if (Util.hasLollipop()) {
            object = new int[0];
            int n = this.mColorRipple;
            stateListDrawable = new RippleDrawable(new ColorStateList((int[][])new int[][]{(int[])object}, new int[]{n}), (Drawable)stateListDrawable, null);
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setOval(0, 0, view.getWidth(), view.getHeight());
                }
            });
            this.setClipToOutline(true);
            this.mBackgroundDrawable = stateListDrawable;
            return stateListDrawable;
        }
        this.mBackgroundDrawable = stateListDrawable;
        return stateListDrawable;
    }

    private Drawable createRectDrawable(int n) {
        int n2 = this.mCornerRadius;
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new RoundRectShape(new float[]{n2, n2, n2, n2, n2, n2, n2, n2}, null, null));
        shapeDrawable.getPaint().setColor(n);
        return shapeDrawable;
    }

    private void playHideAnimation() {
        if (this.mHideAnimation != null) {
            this.mShowAnimation.cancel();
            this.startAnimation(this.mHideAnimation);
        }
    }

    private void playShowAnimation() {
        if (this.mShowAnimation != null) {
            this.mHideAnimation.cancel();
            this.startAnimation(this.mShowAnimation);
        }
    }

    private void setBackgroundCompat(Drawable drawable2) {
        if (Util.hasJellyBean()) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    private void setShadow(FloatingActionButton floatingActionButton) {
        this.mShadowColor = floatingActionButton.getShadowColor();
        this.mShadowRadius = floatingActionButton.getShadowRadius();
        this.mShadowXOffset = floatingActionButton.getShadowXOffset();
        this.mShadowYOffset = floatingActionButton.getShadowYOffset();
        this.mShowShadow = floatingActionButton.hasShadow();
    }

    int calculateShadowHeight() {
        int n = this.mShowShadow ? this.mShadowRadius + Math.abs(this.mShadowYOffset) : 0;
        return n;
    }

    int calculateShadowWidth() {
        int n = this.mShowShadow ? this.mShadowRadius + Math.abs(this.mShadowXOffset) : 0;
        return n;
    }

    void hide(boolean bl) {
        if (bl) {
            this.playHideAnimation();
        }
        this.setVisibility(4);
    }

    boolean isHandleVisibilityChanges() {
        return this.mHandleVisibilityChanges;
    }

    void onActionDown() {
        Drawable drawable2;
        if (this.mUsingStyle) {
            this.mBackgroundDrawable = this.getBackground();
        }
        if ((drawable2 = this.mBackgroundDrawable) instanceof StateListDrawable) {
            ((StateListDrawable)drawable2).setState(new int[]{16842919});
        } else if (Util.hasLollipop() && (drawable2 = this.mBackgroundDrawable) instanceof RippleDrawable) {
            drawable2 = (RippleDrawable)drawable2;
            drawable2.setState(new int[]{16842910, 16842919});
            drawable2.setHotspot((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2));
            drawable2.setVisible(true, true);
        }
    }

    void onActionUp() {
        Drawable drawable2;
        if (this.mUsingStyle) {
            this.mBackgroundDrawable = this.getBackground();
        }
        if ((drawable2 = this.mBackgroundDrawable) instanceof StateListDrawable) {
            ((StateListDrawable)drawable2).setState(new int[0]);
        } else if (Util.hasLollipop() && (drawable2 = this.mBackgroundDrawable) instanceof RippleDrawable) {
            drawable2 = (RippleDrawable)drawable2;
            drawable2.setState(new int[0]);
            drawable2.setHotspot((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2));
            drawable2.setVisible(true, true);
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        this.setMeasuredDimension(this.calculateMeasuredWidth(), this.calculateMeasuredHeight());
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        FloatingActionButton floatingActionButton = this.mFab;
        if (floatingActionButton != null && floatingActionButton.getOnClickListener() != null && this.mFab.isEnabled()) {
            int n = motionEvent.getAction();
            if (n != 1) {
                if (n == 3) {
                    this.onActionUp();
                    this.mFab.onActionUp();
                }
            } else {
                this.onActionUp();
                this.mFab.onActionUp();
            }
            this.mGestureDetector.onTouchEvent(motionEvent);
            return super.onTouchEvent(motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    void setColors(int n, int n2, int n3) {
        this.mColorNormal = n;
        this.mColorPressed = n2;
        this.mColorRipple = n3;
    }

    void setCornerRadius(int n) {
        this.mCornerRadius = n;
    }

    void setFab(FloatingActionButton floatingActionButton) {
        this.mFab = floatingActionButton;
        this.setShadow(floatingActionButton);
    }

    void setHandleVisibilityChanges(boolean bl) {
        this.mHandleVisibilityChanges = bl;
    }

    void setHideAnimation(Animation animation) {
        this.mHideAnimation = animation;
    }

    void setShowAnimation(Animation animation) {
        this.mShowAnimation = animation;
    }

    void setShowShadow(boolean bl) {
        this.mShowShadow = bl;
    }

    void setUsingStyle(boolean bl) {
        this.mUsingStyle = bl;
    }

    void show(boolean bl) {
        if (bl) {
            this.playShowAnimation();
        }
        this.setVisibility(0);
    }

    void updateBackground() {
        LayerDrawable layerDrawable;
        if (this.mShowShadow) {
            layerDrawable = new LayerDrawable(new Drawable[]{new Shadow(), this.createFillDrawable()});
            layerDrawable.setLayerInset(1, this.mShadowRadius + Math.abs(this.mShadowXOffset), this.mShadowRadius + Math.abs(this.mShadowYOffset), this.mShadowRadius + Math.abs(this.mShadowXOffset), this.mShadowRadius + Math.abs(this.mShadowYOffset));
        } else {
            layerDrawable = new LayerDrawable(new Drawable[]{this.createFillDrawable()});
        }
        this.setBackgroundCompat((Drawable)layerDrawable);
    }

    private class Shadow
    extends Drawable {
        private Paint mErase;
        private Paint mPaint = new Paint(1);

        private Shadow() {
            this.mErase = new Paint(1);
            this.init();
        }

        private void init() {
            Label.this.setLayerType(1, null);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(Label.this.mColorNormal);
            this.mErase.setXfermode(PORTER_DUFF_CLEAR);
            if (!Label.this.isInEditMode()) {
                this.mPaint.setShadowLayer((float)Label.this.mShadowRadius, (float)Label.this.mShadowXOffset, (float)Label.this.mShadowYOffset, Label.this.mShadowColor);
            }
        }

        public void draw(Canvas canvas) {
            RectF rectF = new RectF((float)(Label.this.mShadowRadius + Math.abs(Label.this.mShadowXOffset)), (float)(Label.this.mShadowRadius + Math.abs(Label.this.mShadowYOffset)), (float)Label.this.mRawWidth, (float)Label.this.mRawHeight);
            canvas.drawRoundRect(rectF, (float)Label.this.mCornerRadius, (float)Label.this.mCornerRadius, this.mPaint);
            canvas.drawRoundRect(rectF, (float)Label.this.mCornerRadius, (float)Label.this.mCornerRadius, this.mErase);
        }

        public int getOpacity() {
            return 0;
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }
    }
}

