/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.animation.Easing;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.components.ComponentBase;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.PieRadarChartTouchListener;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;

public abstract class PieRadarChartBase<T extends ChartData<? extends IDataSet<? extends Entry>>>
extends Chart<T> {
    protected float mMinOffset = 0.0f;
    private float mRawRotationAngle = 270.0f;
    protected boolean mRotateEnabled = true;
    private float mRotationAngle = 270.0f;

    public PieRadarChartBase(Context context) {
        super(context);
    }

    public PieRadarChartBase(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public PieRadarChartBase(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    protected void calcMinMax() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void calculateOffsets() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        Object object;
        block22: {
            block8: {
                block21: {
                    block20: {
                        block16: {
                            block11: {
                                block15: {
                                    block13: {
                                        block18: {
                                            block14: {
                                                block19: {
                                                    block17: {
                                                        int n;
                                                        block9: {
                                                            block12: {
                                                                block10: {
                                                                    object = this.mLegend;
                                                                    f8 = 0.0f;
                                                                    f7 = 0.0f;
                                                                    f6 = 0.0f;
                                                                    f5 = 0.0f;
                                                                    f4 = 0.0f;
                                                                    if (object == null || !this.mLegend.isEnabled() || this.mLegend.isDrawInsideEnabled()) break block8;
                                                                    f3 = Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent());
                                                                    n = 2.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendOrientation[this.mLegend.getOrientation().ordinal()];
                                                                    if (n == 1) break block9;
                                                                    if (n == 2) break block10;
                                                                    f8 = f4;
                                                                    break block11;
                                                                }
                                                                if (this.mLegend.getVerticalAlignment() == Legend.LegendVerticalAlignment.TOP) break block12;
                                                                f8 = f4;
                                                                if (this.mLegend.getVerticalAlignment() != Legend.LegendVerticalAlignment.BOTTOM) break block11;
                                                            }
                                                            f3 = this.getRequiredLegendOffset();
                                                            f8 = Math.min(this.mLegend.mNeededHeight + f3, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                                                            n = 2.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendVerticalAlignment[this.mLegend.getVerticalAlignment().ordinal()];
                                                            f3 = f8;
                                                            if (n == 1) break block13;
                                                            f3 = f8;
                                                            if (n == 2) break block14;
                                                            f8 = f4;
                                                            break block11;
                                                        }
                                                        if (this.mLegend.getHorizontalAlignment() != Legend.LegendHorizontalAlignment.LEFT && this.mLegend.getHorizontalAlignment() != Legend.LegendHorizontalAlignment.RIGHT) {
                                                            f3 = 0.0f;
                                                        } else if (this.mLegend.getVerticalAlignment() == Legend.LegendVerticalAlignment.CENTER) {
                                                            f3 += Utils.convertDpToPixel(13.0f);
                                                        } else {
                                                            f5 = f3 + Utils.convertDpToPixel(8.0f);
                                                            f2 = this.mLegend.mNeededHeight;
                                                            f = this.mLegend.mTextHeightMax;
                                                            MPPointF mPPointF = this.getCenter();
                                                            f3 = this.mLegend.getHorizontalAlignment() == Legend.LegendHorizontalAlignment.RIGHT ? (float)this.getWidth() - f5 + 15.0f : f5 - 15.0f;
                                                            f = f2 + f + 15.0f;
                                                            f2 = this.distanceToCenter(f3, f);
                                                            object = this.getPosition(mPPointF, this.getRadius(), this.getAngleForPoint(f3, f));
                                                            f3 = this.distanceToCenter(((MPPointF)object).x, ((MPPointF)object).y);
                                                            float f9 = Utils.convertDpToPixel(5.0f);
                                                            f3 = f >= mPPointF.y && (float)this.getHeight() - f5 > (float)this.getWidth() ? f5 : (f2 < f3 ? f9 + (f3 - f2) : 0.0f);
                                                            MPPointF.recycleInstance(mPPointF);
                                                            MPPointF.recycleInstance((MPPointF)object);
                                                        }
                                                        n = 2.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendHorizontalAlignment[this.mLegend.getHorizontalAlignment().ordinal()];
                                                        if (n == 1) break block15;
                                                        if (n == 2) break block16;
                                                        if (n != 3) break block17;
                                                        n = 2.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendVerticalAlignment[this.mLegend.getVerticalAlignment().ordinal()];
                                                        if (n == 1) break block18;
                                                        if (n == 2) break block19;
                                                    }
                                                    f8 = f4;
                                                    break block11;
                                                }
                                                f3 = Math.min(this.mLegend.mNeededHeight, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                                            }
                                            f6 = f3;
                                            f3 = 0.0f;
                                            f8 = f7;
                                            break block20;
                                        }
                                        f3 = Math.min(this.mLegend.mNeededHeight, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                                    }
                                    f7 = f3;
                                    f3 = 0.0f;
                                    f4 = 0.0f;
                                    f8 = f6;
                                    f6 = f4;
                                    break block21;
                                }
                                f8 = f3;
                            }
                            f3 = 0.0f;
                        }
                        f6 = 0.0f;
                    }
                    f7 = 0.0f;
                }
                f5 = f8 + this.getRequiredBaseOffset();
                f8 = f3 + this.getRequiredBaseOffset();
                f4 = f7 + this.getRequiredBaseOffset();
                f3 = f6 + this.getRequiredBaseOffset();
                f7 = f5;
                f6 = f4;
                break block22;
            }
            f8 = 0.0f;
            f3 = 0.0f;
            f6 = 0.0f;
            f7 = f5;
        }
        f4 = f5 = Utils.convertDpToPixel(this.mMinOffset);
        if (this instanceof RadarChart) {
            object = this.getXAxis();
            f4 = f5;
            if (((ComponentBase)object).isEnabled()) {
                f4 = f5;
                if (((AxisBase)object).isDrawLabelsEnabled()) {
                    f4 = Math.max(f5, (float)((XAxis)object).mLabelRotatedWidth);
                }
            }
        }
        f2 = this.getExtraTopOffset();
        f = this.getExtraRightOffset();
        f5 = this.getExtraBottomOffset();
        f7 = Math.max(f4, f7 + this.getExtraLeftOffset());
        f6 = Math.max(f4, f6 + f2);
        f8 = Math.max(f4, f8 + f);
        f3 = Math.max(f4, Math.max(this.getRequiredBaseOffset(), f3 + f5));
        this.mViewPortHandler.restrainViewPort(f7, f6, f8, f3);
        if (this.mLogEnabled) {
            object = new StringBuilder();
            ((StringBuilder)object).append("offsetLeft: ");
            ((StringBuilder)object).append(f7);
            ((StringBuilder)object).append(", offsetTop: ");
            ((StringBuilder)object).append(f6);
            ((StringBuilder)object).append(", offsetRight: ");
            ((StringBuilder)object).append(f8);
            ((StringBuilder)object).append(", offsetBottom: ");
            ((StringBuilder)object).append(f3);
            Log.i((String)"MPAndroidChart", (String)((StringBuilder)object).toString());
        }
    }

    public void computeScroll() {
        if (this.mChartTouchListener instanceof PieRadarChartTouchListener) {
            ((PieRadarChartTouchListener)this.mChartTouchListener).computeScroll();
        }
    }

    public float distanceToCenter(float f, float f2) {
        MPPointF mPPointF = this.getCenterOffsets();
        f = f > mPPointF.x ? (f -= mPPointF.x) : mPPointF.x - f;
        f2 = f2 > mPPointF.y ? (f2 -= mPPointF.y) : mPPointF.y - f2;
        f = (float)Math.sqrt(Math.pow(f, 2.0) + Math.pow(f2, 2.0));
        MPPointF.recycleInstance(mPPointF);
        return f;
    }

    public float getAngleForPoint(float f, float f2) {
        float f3;
        MPPointF mPPointF = this.getCenterOffsets();
        double d = f - mPPointF.x;
        double d2 = f2 - mPPointF.y;
        f2 = f3 = (float)Math.toDegrees(Math.acos(d2 / Math.sqrt(d * d + d2 * d2)));
        if (f > mPPointF.x) {
            f2 = 360.0f - f3;
        }
        f = f2 += 90.0f;
        if (f2 > 360.0f) {
            f = f2 - 360.0f;
        }
        MPPointF.recycleInstance(mPPointF);
        return f;
    }

    public float getDiameter() {
        RectF rectF = this.mViewPortHandler.getContentRect();
        rectF.left += this.getExtraLeftOffset();
        rectF.top += this.getExtraTopOffset();
        rectF.right -= this.getExtraRightOffset();
        rectF.bottom -= this.getExtraBottomOffset();
        return Math.min(rectF.width(), rectF.height());
    }

    public abstract int getIndexForAngle(float var1);

    @Override
    public int getMaxVisibleCount() {
        return this.mData.getEntryCount();
    }

    public float getMinOffset() {
        return this.mMinOffset;
    }

    public MPPointF getPosition(MPPointF mPPointF, float f, float f2) {
        MPPointF mPPointF2 = MPPointF.getInstance(0.0f, 0.0f);
        this.getPosition(mPPointF, f, f2, mPPointF2);
        return mPPointF2;
    }

    public void getPosition(MPPointF mPPointF, float f, float f2, MPPointF mPPointF2) {
        double d = mPPointF.x;
        double d2 = f;
        double d3 = f2;
        mPPointF2.x = (float)(d + Math.cos(Math.toRadians(d3)) * d2);
        mPPointF2.y = (float)((double)mPPointF.y + d2 * Math.sin(Math.toRadians(d3)));
    }

    public abstract float getRadius();

    public float getRawRotationAngle() {
        return this.mRawRotationAngle;
    }

    protected abstract float getRequiredBaseOffset();

    protected abstract float getRequiredLegendOffset();

    public float getRotationAngle() {
        return this.mRotationAngle;
    }

    @Override
    public float getYChartMax() {
        return 0.0f;
    }

    @Override
    public float getYChartMin() {
        return 0.0f;
    }

    @Override
    protected void init() {
        super.init();
        this.mChartTouchListener = new PieRadarChartTouchListener(this);
    }

    public boolean isRotationEnabled() {
        return this.mRotateEnabled;
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mData == null) {
            return;
        }
        this.calcMinMax();
        if (this.mLegend != null) {
            this.mLegendRenderer.computeLegend(this.mData);
        }
        this.calculateOffsets();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mTouchEnabled && this.mChartTouchListener != null) {
            return this.mChartTouchListener.onTouch((View)this, motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setMinOffset(float f) {
        this.mMinOffset = f;
    }

    public void setRotationAngle(float f) {
        this.mRawRotationAngle = f;
        this.mRotationAngle = Utils.getNormalizedAngle(f);
    }

    public void setRotationEnabled(boolean bl) {
        this.mRotateEnabled = bl;
    }

    public void spin(int n, float f, float f2, Easing.EasingFunction easingFunction) {
        this.setRotationAngle(f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, (String)"rotationAngle", (float[])new float[]{f, f2});
        objectAnimator.setDuration((long)n);
        objectAnimator.setInterpolator((TimeInterpolator)easingFunction);
        objectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                PieRadarChartBase.this.postInvalidate();
            }
        });
        objectAnimator.start();
    }
}

