/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.graphics.DashPathEffect;
import android.graphics.Paint;
import com.github.mikephil.charting.components.ComponentBase;
import com.github.mikephil.charting.components.LegendEntry;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.List;

public class Legend
extends ComponentBase {
    private List<Boolean> mCalculatedLabelBreakPoints;
    private List<FSize> mCalculatedLabelSizes;
    private List<FSize> mCalculatedLineSizes;
    private LegendDirection mDirection;
    private boolean mDrawInside = false;
    private LegendEntry[] mEntries = new LegendEntry[0];
    private LegendEntry[] mExtraEntries;
    private DashPathEffect mFormLineDashEffect = null;
    private float mFormLineWidth = 3.0f;
    private float mFormSize = 8.0f;
    private float mFormToTextSpace = 5.0f;
    private LegendHorizontalAlignment mHorizontalAlignment = LegendHorizontalAlignment.LEFT;
    private boolean mIsLegendCustom = false;
    private float mMaxSizePercent = 0.95f;
    public float mNeededHeight = 0.0f;
    public float mNeededWidth = 0.0f;
    private LegendOrientation mOrientation;
    private LegendForm mShape;
    private float mStackSpace = 3.0f;
    public float mTextHeightMax = 0.0f;
    public float mTextWidthMax = 0.0f;
    private LegendVerticalAlignment mVerticalAlignment = LegendVerticalAlignment.BOTTOM;
    private boolean mWordWrapEnabled = false;
    private float mXEntrySpace = 6.0f;
    private float mYEntrySpace = 0.0f;

    public Legend() {
        this.mOrientation = LegendOrientation.HORIZONTAL;
        this.mDirection = LegendDirection.LEFT_TO_RIGHT;
        this.mShape = LegendForm.SQUARE;
        this.mCalculatedLabelSizes = new ArrayList<FSize>(16);
        this.mCalculatedLabelBreakPoints = new ArrayList<Boolean>(16);
        this.mCalculatedLineSizes = new ArrayList<FSize>(16);
        this.mTextSize = Utils.convertDpToPixel(10.0f);
        this.mXOffset = Utils.convertDpToPixel(5.0f);
        this.mYOffset = Utils.convertDpToPixel(3.0f);
    }

    public Legend(LegendEntry[] legendEntryArray) {
        this();
        if (legendEntryArray != null) {
            this.mEntries = legendEntryArray;
            return;
        }
        throw new IllegalArgumentException("entries array is NULL");
    }

    public void calculateDimensions(Paint paint, ViewPortHandler object) {
        block24: {
            int n;
            int n2;
            Object object2;
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            block23: {
                float f6;
                f5 = Utils.convertDpToPixel(this.mFormSize);
                f4 = Utils.convertDpToPixel(this.mStackSpace);
                f3 = Utils.convertDpToPixel(this.mFormToTextSpace);
                f2 = Utils.convertDpToPixel(this.mXEntrySpace);
                f = Utils.convertDpToPixel(this.mYEntrySpace);
                boolean bl = this.mWordWrapEnabled;
                object2 = this.mEntries;
                n2 = ((LegendEntry[])object2).length;
                this.mTextWidthMax = this.getMaximumEntryWidth(paint);
                this.mTextHeightMax = this.getMaximumEntryHeight(paint);
                n = 1.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendOrientation[this.mOrientation.ordinal()];
                if (n == 1) break block23;
                if (n != 2) break block24;
                float f7 = Utils.getLineHeight(paint);
                float f8 = Utils.getLineSpacing(paint);
                float f9 = object.contentWidth();
                float f10 = this.mMaxSizePercent;
                this.mCalculatedLabelBreakPoints.clear();
                this.mCalculatedLabelSizes.clear();
                this.mCalculatedLineSizes.clear();
                int n3 = -1;
                float f11 = 0.0f;
                float f12 = 0.0f;
                float f13 = 0.0f;
                object = object2;
                float f14 = f4;
                float f15 = f5;
                for (n = 0; n < n2; ++n) {
                    String string2;
                    int n4;
                    block26: {
                        float f16;
                        block25: {
                            object2 = object[n];
                            n4 = ((LegendEntry)object2).form != LegendForm.NONE ? 1 : 0;
                            f6 = Float.isNaN(((LegendEntry)object2).formSize) ? f15 : Utils.convertDpToPixel(((LegendEntry)object2).formSize);
                            string2 = ((LegendEntry)object2).label;
                            this.mCalculatedLabelBreakPoints.add(false);
                            f5 = n3 == -1 ? 0.0f : f12 + f14;
                            if (string2 != null) {
                                this.mCalculatedLabelSizes.add(Utils.calcTextSize(paint, string2));
                                f6 = n4 != 0 ? f3 + f6 : 0.0f;
                                f6 = f5 + f6 + this.mCalculatedLabelSizes.get((int)n).width;
                                n4 = n3;
                            } else {
                                this.mCalculatedLabelSizes.add(FSize.getInstance(0.0f, 0.0f));
                                if (n4 == 0) {
                                    f6 = 0.0f;
                                }
                                f5 += f6;
                                f6 = f5;
                                n4 = n3;
                                if (n3 == -1) {
                                    n4 = n;
                                    f6 = f5;
                                }
                            }
                            if (string2 != null) break block25;
                            f5 = f11;
                            f4 = f13;
                            if (n != n2 - 1) break block26;
                        }
                        f12 = (n3 = (int)((f16 = f13 - 0.0f) == 0.0f ? 0 : (f16 > 0.0f ? 1 : -1))) == 0 ? 0.0f : f2;
                        if (bl && n3 != 0 && !(f9 * f10 - f13 >= f12 + f6)) {
                            this.mCalculatedLineSizes.add(FSize.getInstance(f13, f7));
                            f5 = Math.max(f11, f13);
                            object2 = this.mCalculatedLabelBreakPoints;
                            n3 = n4 > -1 ? n4 : n;
                            object2.set(n3, true);
                            f11 = f6;
                        } else {
                            f5 = f11;
                            f11 = f13 + (f12 + f6);
                        }
                        if (n == n2 - 1) {
                            this.mCalculatedLineSizes.add(FSize.getInstance(f11, f7));
                            f5 = Math.max(f5, f11);
                        }
                        f4 = f11;
                    }
                    if (string2 != null) {
                        n4 = -1;
                    }
                    n3 = n4;
                    f11 = f5;
                    f12 = f6;
                    f13 = f4;
                }
                this.mNeededWidth = f11;
                f6 = this.mCalculatedLineSizes.size();
                n = this.mCalculatedLineSizes.size() == 0 ? 0 : this.mCalculatedLineSizes.size() - 1;
                this.mNeededHeight = f7 * f6 + (f8 + f) * (float)n;
                break block24;
            }
            float f17 = Utils.getLineHeight(paint);
            float f18 = 0.0f;
            f2 = 0.0f;
            float f19 = 0.0f;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                object = object2[i];
                boolean bl = object.form != LegendForm.NONE;
                float f20 = Float.isNaN(object.formSize) ? f5 : Utils.convertDpToPixel(object.formSize);
                object = object.label;
                if (n == 0) {
                    f2 = 0.0f;
                }
                float f21 = f2;
                if (bl) {
                    f21 = f2;
                    if (n != 0) {
                        f21 = f2 + f4;
                    }
                    f21 += f20;
                }
                if (object != null) {
                    if (bl && n == 0) {
                        f2 = f21 + f3;
                    } else {
                        f2 = f21;
                        if (n != 0) {
                            f19 = Math.max(f19, f21);
                            f18 += f17 + f;
                            f2 = 0.0f;
                            n = 0;
                        }
                    }
                    f21 = Utils.calcTextWidth(paint, (String)object);
                    f18 += f17 + f;
                    f2 += f21;
                } else {
                    f2 = f21 += f20;
                    if (i < n2 - 1) {
                        f2 = f21 + f4;
                    }
                    n = 1;
                }
                f19 = Math.max(f19, f2);
            }
            this.mNeededWidth = f19;
            this.mNeededHeight = f18;
        }
        this.mNeededHeight += this.mYOffset;
        this.mNeededWidth += this.mXOffset;
    }

    public List<Boolean> getCalculatedLabelBreakPoints() {
        return this.mCalculatedLabelBreakPoints;
    }

    public List<FSize> getCalculatedLabelSizes() {
        return this.mCalculatedLabelSizes;
    }

    public List<FSize> getCalculatedLineSizes() {
        return this.mCalculatedLineSizes;
    }

    public LegendDirection getDirection() {
        return this.mDirection;
    }

    public LegendEntry[] getEntries() {
        return this.mEntries;
    }

    public LegendEntry[] getExtraEntries() {
        return this.mExtraEntries;
    }

    public LegendForm getForm() {
        return this.mShape;
    }

    public DashPathEffect getFormLineDashEffect() {
        return this.mFormLineDashEffect;
    }

    public float getFormLineWidth() {
        return this.mFormLineWidth;
    }

    public float getFormSize() {
        return this.mFormSize;
    }

    public float getFormToTextSpace() {
        return this.mFormToTextSpace;
    }

    public LegendHorizontalAlignment getHorizontalAlignment() {
        return this.mHorizontalAlignment;
    }

    public float getMaxSizePercent() {
        return this.mMaxSizePercent;
    }

    public float getMaximumEntryHeight(Paint paint) {
        LegendEntry[] legendEntryArray = this.mEntries;
        int n = legendEntryArray.length;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            float f2;
            String string2 = legendEntryArray[i].label;
            if (string2 == null) {
                f2 = f;
            } else {
                float f3 = Utils.calcTextHeight(paint, string2);
                f2 = f;
                if (f3 > f) {
                    f2 = f3;
                }
            }
            f = f2;
        }
        return f;
    }

    public float getMaximumEntryWidth(Paint paint) {
        float f = Utils.convertDpToPixel(this.mFormToTextSpace);
        LegendEntry[] legendEntryArray = this.mEntries;
        int n = legendEntryArray.length;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < n; ++i) {
            Object object = legendEntryArray[i];
            float f4 = Float.isNaN(((LegendEntry)object).formSize) ? this.mFormSize : ((LegendEntry)object).formSize;
            float f5 = Utils.convertDpToPixel(f4);
            f4 = f3;
            if (f5 > f3) {
                f4 = f5;
            }
            if ((object = ((LegendEntry)object).label) == null) {
                f3 = f2;
            } else {
                f5 = Utils.calcTextWidth(paint, (String)object);
                f3 = f2;
                if (f5 > f2) {
                    f3 = f5;
                }
            }
            f2 = f3;
            f3 = f4;
        }
        return f2 + f3 + f;
    }

    public LegendOrientation getOrientation() {
        return this.mOrientation;
    }

    public float getStackSpace() {
        return this.mStackSpace;
    }

    public LegendVerticalAlignment getVerticalAlignment() {
        return this.mVerticalAlignment;
    }

    public float getXEntrySpace() {
        return this.mXEntrySpace;
    }

    public float getYEntrySpace() {
        return this.mYEntrySpace;
    }

    public boolean isDrawInsideEnabled() {
        return this.mDrawInside;
    }

    public boolean isLegendCustom() {
        return this.mIsLegendCustom;
    }

    public boolean isWordWrapEnabled() {
        return this.mWordWrapEnabled;
    }

    public void resetCustom() {
        this.mIsLegendCustom = false;
    }

    public void setCustom(List<LegendEntry> list) {
        this.mEntries = list.toArray(new LegendEntry[list.size()]);
        this.mIsLegendCustom = true;
    }

    public void setCustom(LegendEntry[] legendEntryArray) {
        this.mEntries = legendEntryArray;
        this.mIsLegendCustom = true;
    }

    public void setDirection(LegendDirection legendDirection) {
        this.mDirection = legendDirection;
    }

    public void setDrawInside(boolean bl) {
        this.mDrawInside = bl;
    }

    public void setEntries(List<LegendEntry> list) {
        this.mEntries = list.toArray(new LegendEntry[list.size()]);
    }

    public void setExtra(List<LegendEntry> list) {
        this.mExtraEntries = list.toArray(new LegendEntry[list.size()]);
    }

    public void setExtra(int[] nArray, String[] stringArray) {
        ArrayList<LegendEntry> arrayList = new ArrayList<LegendEntry>();
        for (int i = 0; i < Math.min(nArray.length, stringArray.length); ++i) {
            LegendEntry legendEntry = new LegendEntry();
            legendEntry.formColor = nArray[i];
            legendEntry.label = stringArray[i];
            if (legendEntry.formColor != 1122868 && legendEntry.formColor != 0) {
                if (legendEntry.formColor == 0x112233) {
                    legendEntry.form = LegendForm.EMPTY;
                }
            } else {
                legendEntry.form = LegendForm.NONE;
            }
            arrayList.add(legendEntry);
        }
        this.mExtraEntries = arrayList.toArray(new LegendEntry[arrayList.size()]);
    }

    public void setExtra(LegendEntry[] legendEntryArray) {
        LegendEntry[] legendEntryArray2 = legendEntryArray;
        if (legendEntryArray == null) {
            legendEntryArray2 = new LegendEntry[]{};
        }
        this.mExtraEntries = legendEntryArray2;
    }

    public void setForm(LegendForm legendForm) {
        this.mShape = legendForm;
    }

    public void setFormLineDashEffect(DashPathEffect dashPathEffect) {
        this.mFormLineDashEffect = dashPathEffect;
    }

    public void setFormLineWidth(float f) {
        this.mFormLineWidth = f;
    }

    public void setFormSize(float f) {
        this.mFormSize = f;
    }

    public void setFormToTextSpace(float f) {
        this.mFormToTextSpace = f;
    }

    public void setHorizontalAlignment(LegendHorizontalAlignment legendHorizontalAlignment) {
        this.mHorizontalAlignment = legendHorizontalAlignment;
    }

    public void setMaxSizePercent(float f) {
        this.mMaxSizePercent = f;
    }

    public void setOrientation(LegendOrientation legendOrientation) {
        this.mOrientation = legendOrientation;
    }

    public void setStackSpace(float f) {
        this.mStackSpace = f;
    }

    public void setVerticalAlignment(LegendVerticalAlignment legendVerticalAlignment) {
        this.mVerticalAlignment = legendVerticalAlignment;
    }

    public void setWordWrapEnabled(boolean bl) {
        this.mWordWrapEnabled = bl;
    }

    public void setXEntrySpace(float f) {
        this.mXEntrySpace = f;
    }

    public void setYEntrySpace(float f) {
        this.mYEntrySpace = f;
    }

    public static final class LegendDirection
    extends Enum<LegendDirection> {
        private static final /* synthetic */ LegendDirection[] $VALUES;
        public static final /* enum */ LegendDirection LEFT_TO_RIGHT;
        public static final /* enum */ LegendDirection RIGHT_TO_LEFT;

        static {
            LegendDirection legendDirection;
            LegendDirection legendDirection2;
            LEFT_TO_RIGHT = legendDirection2 = new LegendDirection();
            RIGHT_TO_LEFT = legendDirection = new LegendDirection();
            $VALUES = new LegendDirection[]{legendDirection2, legendDirection};
        }

        public static LegendDirection valueOf(String string2) {
            return Enum.valueOf(LegendDirection.class, string2);
        }

        public static LegendDirection[] values() {
            return (LegendDirection[])$VALUES.clone();
        }
    }

    public static final class LegendForm
    extends Enum<LegendForm> {
        private static final /* synthetic */ LegendForm[] $VALUES;
        public static final /* enum */ LegendForm CIRCLE;
        public static final /* enum */ LegendForm DEFAULT;
        public static final /* enum */ LegendForm EMPTY;
        public static final /* enum */ LegendForm LINE;
        public static final /* enum */ LegendForm NONE;
        public static final /* enum */ LegendForm SQUARE;

        static {
            LegendForm legendForm;
            LegendForm legendForm2;
            LegendForm legendForm3;
            LegendForm legendForm4;
            LegendForm legendForm5;
            LegendForm legendForm6;
            NONE = legendForm6 = new LegendForm();
            EMPTY = legendForm5 = new LegendForm();
            DEFAULT = legendForm4 = new LegendForm();
            SQUARE = legendForm3 = new LegendForm();
            CIRCLE = legendForm2 = new LegendForm();
            LINE = legendForm = new LegendForm();
            $VALUES = new LegendForm[]{legendForm6, legendForm5, legendForm4, legendForm3, legendForm2, legendForm};
        }

        public static LegendForm valueOf(String string2) {
            return Enum.valueOf(LegendForm.class, string2);
        }

        public static LegendForm[] values() {
            return (LegendForm[])$VALUES.clone();
        }
    }

    public static final class LegendHorizontalAlignment
    extends Enum<LegendHorizontalAlignment> {
        private static final /* synthetic */ LegendHorizontalAlignment[] $VALUES;
        public static final /* enum */ LegendHorizontalAlignment CENTER;
        public static final /* enum */ LegendHorizontalAlignment LEFT;
        public static final /* enum */ LegendHorizontalAlignment RIGHT;

        static {
            LegendHorizontalAlignment legendHorizontalAlignment;
            LegendHorizontalAlignment legendHorizontalAlignment2;
            LegendHorizontalAlignment legendHorizontalAlignment3;
            LEFT = legendHorizontalAlignment3 = new LegendHorizontalAlignment();
            CENTER = legendHorizontalAlignment2 = new LegendHorizontalAlignment();
            RIGHT = legendHorizontalAlignment = new LegendHorizontalAlignment();
            $VALUES = new LegendHorizontalAlignment[]{legendHorizontalAlignment3, legendHorizontalAlignment2, legendHorizontalAlignment};
        }

        public static LegendHorizontalAlignment valueOf(String string2) {
            return Enum.valueOf(LegendHorizontalAlignment.class, string2);
        }

        public static LegendHorizontalAlignment[] values() {
            return (LegendHorizontalAlignment[])$VALUES.clone();
        }
    }

    public static final class LegendOrientation
    extends Enum<LegendOrientation> {
        private static final /* synthetic */ LegendOrientation[] $VALUES;
        public static final /* enum */ LegendOrientation HORIZONTAL;
        public static final /* enum */ LegendOrientation VERTICAL;

        static {
            LegendOrientation legendOrientation;
            LegendOrientation legendOrientation2;
            HORIZONTAL = legendOrientation2 = new LegendOrientation();
            VERTICAL = legendOrientation = new LegendOrientation();
            $VALUES = new LegendOrientation[]{legendOrientation2, legendOrientation};
        }

        public static LegendOrientation valueOf(String string2) {
            return Enum.valueOf(LegendOrientation.class, string2);
        }

        public static LegendOrientation[] values() {
            return (LegendOrientation[])$VALUES.clone();
        }
    }

    public static final class LegendVerticalAlignment
    extends Enum<LegendVerticalAlignment> {
        private static final /* synthetic */ LegendVerticalAlignment[] $VALUES;
        public static final /* enum */ LegendVerticalAlignment BOTTOM;
        public static final /* enum */ LegendVerticalAlignment CENTER;
        public static final /* enum */ LegendVerticalAlignment TOP;

        static {
            LegendVerticalAlignment legendVerticalAlignment;
            LegendVerticalAlignment legendVerticalAlignment2;
            LegendVerticalAlignment legendVerticalAlignment3;
            TOP = legendVerticalAlignment3 = new LegendVerticalAlignment();
            CENTER = legendVerticalAlignment2 = new LegendVerticalAlignment();
            BOTTOM = legendVerticalAlignment = new LegendVerticalAlignment();
            $VALUES = new LegendVerticalAlignment[]{legendVerticalAlignment3, legendVerticalAlignment2, legendVerticalAlignment};
        }

        public static LegendVerticalAlignment valueOf(String string2) {
            return Enum.valueOf(LegendVerticalAlignment.class, string2);
        }

        public static LegendVerticalAlignment[] values() {
            return (LegendVerticalAlignment[])$VALUES.clone();
        }
    }
}

