/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Range;

public class BarEntry
extends Entry {
    private float mNegativeSum;
    private float mPositiveSum;
    private Range[] mRanges;
    private float[] mYVals;

    public BarEntry(float f, float f2) {
        super(f, f2);
    }

    public BarEntry(float f, float f2, Drawable drawable2) {
        super(f, f2, drawable2);
    }

    public BarEntry(float f, float f2, Drawable drawable2, Object object) {
        super(f, f2, drawable2, object);
    }

    public BarEntry(float f, float f2, Object object) {
        super(f, f2, object);
    }

    public BarEntry(float f, float[] fArray) {
        super(f, BarEntry.calcSum(fArray));
        this.mYVals = fArray;
        this.calcPosNegSum();
        this.calcRanges();
    }

    public BarEntry(float f, float[] fArray, Drawable drawable2) {
        super(f, BarEntry.calcSum(fArray), drawable2);
        this.mYVals = fArray;
        this.calcPosNegSum();
        this.calcRanges();
    }

    public BarEntry(float f, float[] fArray, Drawable drawable2, Object object) {
        super(f, BarEntry.calcSum(fArray), drawable2, object);
        this.mYVals = fArray;
        this.calcPosNegSum();
        this.calcRanges();
    }

    public BarEntry(float f, float[] fArray, Object object) {
        super(f, BarEntry.calcSum(fArray), object);
        this.mYVals = fArray;
        this.calcPosNegSum();
        this.calcRanges();
    }

    private void calcPosNegSum() {
        float[] fArray = this.mYVals;
        if (fArray == null) {
            this.mNegativeSum = 0.0f;
            this.mPositiveSum = 0.0f;
            return;
        }
        int n = fArray.length;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            float f3 = fArray[i];
            if (f3 <= 0.0f) {
                f += Math.abs(f3);
                continue;
            }
            f2 += f3;
        }
        this.mNegativeSum = f;
        this.mPositiveSum = f2;
    }

    private static float calcSum(float[] fArray) {
        float f = 0.0f;
        if (fArray == null) {
            return 0.0f;
        }
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            f += fArray[i];
        }
        return f;
    }

    protected void calcRanges() {
        float[] fArray = this.getYVals();
        if (fArray != null && fArray.length != 0) {
            Range[] rangeArray;
            this.mRanges = new Range[fArray.length];
            float f = -this.getNegativeSum();
            float f2 = 0.0f;
            for (int i = 0; i < (rangeArray = this.mRanges).length; ++i) {
                float f3 = fArray[i];
                if (f3 < 0.0f) {
                    f3 = f - f3;
                    rangeArray[i] = new Range(f, f3);
                    f = f3;
                    continue;
                }
                rangeArray[i] = new Range(f2, f3 += f2);
                f2 = f3;
            }
        }
    }

    @Override
    public BarEntry copy() {
        BarEntry barEntry = new BarEntry(this.getX(), this.getY(), this.getData());
        barEntry.setVals(this.mYVals);
        return barEntry;
    }

    @Deprecated
    public float getBelowSum(int n) {
        return this.getSumBelow(n);
    }

    public float getNegativeSum() {
        return this.mNegativeSum;
    }

    public float getPositiveSum() {
        return this.mPositiveSum;
    }

    public Range[] getRanges() {
        return this.mRanges;
    }

    public float getSumBelow(int n) {
        float[] fArray = this.mYVals;
        float f = 0.0f;
        if (fArray == null) {
            return 0.0f;
        }
        for (int i = fArray.length - 1; i > n && i >= 0; --i) {
            f += this.mYVals[i];
        }
        return f;
    }

    @Override
    public float getY() {
        return super.getY();
    }

    public float[] getYVals() {
        return this.mYVals;
    }

    public boolean isStacked() {
        boolean bl = this.mYVals != null;
        return bl;
    }

    public void setVals(float[] fArray) {
        this.setY(BarEntry.calcSum(fArray));
        this.mYVals = fArray;
        this.calcPosNegSum();
        this.calcRanges();
    }
}

