/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDataSet<T extends Entry>
implements IDataSet<T> {
    protected YAxis.AxisDependency mAxisDependency = YAxis.AxisDependency.LEFT;
    protected List<Integer> mColors = null;
    protected boolean mDrawIcons = true;
    protected boolean mDrawValues = true;
    private Legend.LegendForm mForm = Legend.LegendForm.DEFAULT;
    private DashPathEffect mFormLineDashEffect = null;
    private float mFormLineWidth;
    private float mFormSize = Float.NaN;
    protected boolean mHighlightEnabled = true;
    protected MPPointF mIconsOffset;
    private String mLabel = "DataSet";
    protected List<Integer> mValueColors = null;
    protected transient IValueFormatter mValueFormatter;
    protected float mValueTextSize = 17.0f;
    protected Typeface mValueTypeface;
    protected boolean mVisible = true;

    public BaseDataSet() {
        this.mFormLineWidth = Float.NaN;
        this.mIconsOffset = new MPPointF();
        this.mColors = new ArrayList<Integer>();
        this.mValueColors = new ArrayList<Integer>();
        this.mColors.add(Color.rgb((int)140, (int)234, (int)255));
        this.mValueColors.add(-16777216);
    }

    public BaseDataSet(String string2) {
        this();
        this.mLabel = string2;
    }

    public void addColor(int n) {
        if (this.mColors == null) {
            this.mColors = new ArrayList<Integer>();
        }
        this.mColors.add(n);
    }

    @Override
    public boolean contains(T t) {
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if (!this.getEntryForIndex(i).equals(t)) continue;
            return true;
        }
        return false;
    }

    protected void copy(BaseDataSet baseDataSet) {
        baseDataSet.mAxisDependency = this.mAxisDependency;
        baseDataSet.mColors = this.mColors;
        baseDataSet.mDrawIcons = this.mDrawIcons;
        baseDataSet.mDrawValues = this.mDrawValues;
        baseDataSet.mForm = this.mForm;
        baseDataSet.mFormLineDashEffect = this.mFormLineDashEffect;
        baseDataSet.mFormLineWidth = this.mFormLineWidth;
        baseDataSet.mFormSize = this.mFormSize;
        baseDataSet.mHighlightEnabled = this.mHighlightEnabled;
        baseDataSet.mIconsOffset = this.mIconsOffset;
        baseDataSet.mValueColors = this.mValueColors;
        baseDataSet.mValueFormatter = this.mValueFormatter;
        baseDataSet.mValueColors = this.mValueColors;
        baseDataSet.mValueTextSize = this.mValueTextSize;
        baseDataSet.mVisible = this.mVisible;
    }

    @Override
    public YAxis.AxisDependency getAxisDependency() {
        return this.mAxisDependency;
    }

    @Override
    public int getColor() {
        return this.mColors.get(0);
    }

    @Override
    public int getColor(int n) {
        List<Integer> list = this.mColors;
        return list.get(n % list.size());
    }

    @Override
    public List<Integer> getColors() {
        return this.mColors;
    }

    @Override
    public Legend.LegendForm getForm() {
        return this.mForm;
    }

    @Override
    public DashPathEffect getFormLineDashEffect() {
        return this.mFormLineDashEffect;
    }

    @Override
    public float getFormLineWidth() {
        return this.mFormLineWidth;
    }

    @Override
    public float getFormSize() {
        return this.mFormSize;
    }

    @Override
    public MPPointF getIconsOffset() {
        return this.mIconsOffset;
    }

    @Override
    public int getIndexInEntries(int n) {
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if ((float)n != ((Entry)this.getEntryForIndex(i)).getX()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    public List<Integer> getValueColors() {
        return this.mValueColors;
    }

    @Override
    public IValueFormatter getValueFormatter() {
        if (this.needsFormatter()) {
            return Utils.getDefaultValueFormatter();
        }
        return this.mValueFormatter;
    }

    @Override
    public int getValueTextColor() {
        return this.mValueColors.get(0);
    }

    @Override
    public int getValueTextColor(int n) {
        List<Integer> list = this.mValueColors;
        return list.get(n % list.size());
    }

    @Override
    public float getValueTextSize() {
        return this.mValueTextSize;
    }

    @Override
    public Typeface getValueTypeface() {
        return this.mValueTypeface;
    }

    @Override
    public boolean isDrawIconsEnabled() {
        return this.mDrawIcons;
    }

    @Override
    public boolean isDrawValuesEnabled() {
        return this.mDrawValues;
    }

    @Override
    public boolean isHighlightEnabled() {
        return this.mHighlightEnabled;
    }

    @Override
    public boolean isVisible() {
        return this.mVisible;
    }

    @Override
    public boolean needsFormatter() {
        boolean bl = this.mValueFormatter == null;
        return bl;
    }

    public void notifyDataSetChanged() {
        this.calcMinMax();
    }

    @Override
    public boolean removeEntry(int n) {
        return this.removeEntry(this.getEntryForIndex(n));
    }

    @Override
    public boolean removeEntryByXValue(float f) {
        return this.removeEntry(this.getEntryForXValue(f, Float.NaN));
    }

    @Override
    public boolean removeFirst() {
        if (this.getEntryCount() > 0) {
            return this.removeEntry(this.getEntryForIndex(0));
        }
        return false;
    }

    @Override
    public boolean removeLast() {
        if (this.getEntryCount() > 0) {
            return this.removeEntry(this.getEntryForIndex(this.getEntryCount() - 1));
        }
        return false;
    }

    public void resetColors() {
        if (this.mColors == null) {
            this.mColors = new ArrayList<Integer>();
        }
        this.mColors.clear();
    }

    @Override
    public void setAxisDependency(YAxis.AxisDependency axisDependency) {
        this.mAxisDependency = axisDependency;
    }

    public void setColor(int n) {
        this.resetColors();
        this.mColors.add(n);
    }

    public void setColor(int n, int n2) {
        this.setColor(Color.argb((int)n2, (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n)));
    }

    public void setColors(List<Integer> list) {
        this.mColors = list;
    }

    public void setColors(int ... nArray) {
        this.mColors = ColorTemplate.createColors(nArray);
    }

    public void setColors(int[] nArray, int n) {
        this.resetColors();
        for (int n2 : nArray) {
            this.addColor(Color.argb((int)n, (int)Color.red((int)n2), (int)Color.green((int)n2), (int)Color.blue((int)n2)));
        }
    }

    public void setColors(int[] nArray, Context context) {
        if (this.mColors == null) {
            this.mColors = new ArrayList<Integer>();
        }
        this.mColors.clear();
        for (int n : nArray) {
            this.mColors.add(context.getResources().getColor(n));
        }
    }

    @Override
    public void setDrawIcons(boolean bl) {
        this.mDrawIcons = bl;
    }

    @Override
    public void setDrawValues(boolean bl) {
        this.mDrawValues = bl;
    }

    public void setForm(Legend.LegendForm legendForm) {
        this.mForm = legendForm;
    }

    public void setFormLineDashEffect(DashPathEffect dashPathEffect) {
        this.mFormLineDashEffect = dashPathEffect;
    }

    public void setFormLineWidth(float f) {
        this.mFormLineWidth = f;
    }

    public void setFormSize(float f) {
        this.mFormSize = f;
    }

    @Override
    public void setHighlightEnabled(boolean bl) {
        this.mHighlightEnabled = bl;
    }

    @Override
    public void setIconsOffset(MPPointF mPPointF) {
        this.mIconsOffset.x = mPPointF.x;
        this.mIconsOffset.y = mPPointF.y;
    }

    @Override
    public void setLabel(String string2) {
        this.mLabel = string2;
    }

    @Override
    public void setValueFormatter(IValueFormatter iValueFormatter) {
        if (iValueFormatter == null) {
            return;
        }
        this.mValueFormatter = iValueFormatter;
    }

    @Override
    public void setValueTextColor(int n) {
        this.mValueColors.clear();
        this.mValueColors.add(n);
    }

    @Override
    public void setValueTextColors(List<Integer> list) {
        this.mValueColors = list;
    }

    @Override
    public void setValueTextSize(float f) {
        this.mValueTextSize = Utils.convertDpToPixel(f);
    }

    @Override
    public void setValueTypeface(Typeface typeface) {
        this.mValueTypeface = typeface;
    }

    @Override
    public void setVisible(boolean bl) {
        this.mVisible = bl;
    }
}

