/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Typeface;
import android.util.Log;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ChartData<T extends IDataSet<? extends Entry>> {
    protected List<T> mDataSets;
    protected float mLeftAxisMax = -3.4028235E38f;
    protected float mLeftAxisMin;
    protected float mRightAxisMax = -3.4028235E38f;
    protected float mRightAxisMin;
    protected float mXMax = -3.4028235E38f;
    protected float mXMin;
    protected float mYMax = -3.4028235E38f;
    protected float mYMin = Float.MAX_VALUE;

    public ChartData() {
        this.mXMin = Float.MAX_VALUE;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMin = Float.MAX_VALUE;
        this.mDataSets = new ArrayList<T>();
    }

    public ChartData(List<T> list) {
        this.mXMin = Float.MAX_VALUE;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMin = Float.MAX_VALUE;
        this.mDataSets = list;
        this.notifyDataChanged();
    }

    public ChartData(T ... TArray) {
        this.mXMin = Float.MAX_VALUE;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMin = Float.MAX_VALUE;
        this.mDataSets = this.arrayToList((IDataSet[])TArray);
        this.notifyDataChanged();
    }

    private List<T> arrayToList(T[] TArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(TArray[i]);
        }
        return arrayList;
    }

    public void addDataSet(T t) {
        if (t == null) {
            return;
        }
        this.calcMinMax(t);
        this.mDataSets.add(t);
    }

    public void addEntry(Entry entry, int n) {
        if (this.mDataSets.size() > n && n >= 0) {
            IDataSet iDataSet = (IDataSet)this.mDataSets.get(n);
            if (!iDataSet.addEntry(entry)) {
                return;
            }
            this.calcMinMax(entry, iDataSet.getAxisDependency());
        } else {
            Log.e((String)"addEntry", (String)"Cannot add Entry because dataSetIndex too high or too low.");
        }
    }

    protected void calcMinMax() {
        Object object = this.mDataSets;
        if (object == null) {
            return;
        }
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        object = object.iterator();
        while (object.hasNext()) {
            this.calcMinMax((IDataSet)object.next());
        }
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        object = this.getFirstLeft(this.mDataSets);
        if (object != null) {
            this.mLeftAxisMax = object.getYMax();
            this.mLeftAxisMin = object.getYMin();
            object = this.mDataSets.iterator();
            while (object.hasNext()) {
                IDataSet iDataSet = (IDataSet)object.next();
                if (iDataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
                if (iDataSet.getYMin() < this.mLeftAxisMin) {
                    this.mLeftAxisMin = iDataSet.getYMin();
                }
                if (!(iDataSet.getYMax() > this.mLeftAxisMax)) continue;
                this.mLeftAxisMax = iDataSet.getYMax();
            }
        }
        if ((object = this.getFirstRight(this.mDataSets)) != null) {
            this.mRightAxisMax = object.getYMax();
            this.mRightAxisMin = object.getYMin();
            for (IDataSet iDataSet : this.mDataSets) {
                if (iDataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
                if (iDataSet.getYMin() < this.mRightAxisMin) {
                    this.mRightAxisMin = iDataSet.getYMin();
                }
                if (!(iDataSet.getYMax() > this.mRightAxisMax)) continue;
                this.mRightAxisMax = iDataSet.getYMax();
            }
        }
    }

    protected void calcMinMax(Entry entry, YAxis.AxisDependency axisDependency) {
        if (this.mYMax < entry.getY()) {
            this.mYMax = entry.getY();
        }
        if (this.mYMin > entry.getY()) {
            this.mYMin = entry.getY();
        }
        if (this.mXMax < entry.getX()) {
            this.mXMax = entry.getX();
        }
        if (this.mXMin > entry.getX()) {
            this.mXMin = entry.getX();
        }
        if (axisDependency == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMax < entry.getY()) {
                this.mLeftAxisMax = entry.getY();
            }
            if (this.mLeftAxisMin > entry.getY()) {
                this.mLeftAxisMin = entry.getY();
            }
        } else {
            if (this.mRightAxisMax < entry.getY()) {
                this.mRightAxisMax = entry.getY();
            }
            if (this.mRightAxisMin > entry.getY()) {
                this.mRightAxisMin = entry.getY();
            }
        }
    }

    protected void calcMinMax(T t) {
        if (this.mYMax < t.getYMax()) {
            this.mYMax = t.getYMax();
        }
        if (this.mYMin > t.getYMin()) {
            this.mYMin = t.getYMin();
        }
        if (this.mXMax < t.getXMax()) {
            this.mXMax = t.getXMax();
        }
        if (this.mXMin > t.getXMin()) {
            this.mXMin = t.getXMin();
        }
        if (t.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMax < t.getYMax()) {
                this.mLeftAxisMax = t.getYMax();
            }
            if (this.mLeftAxisMin > t.getYMin()) {
                this.mLeftAxisMin = t.getYMin();
            }
        } else {
            if (this.mRightAxisMax < t.getYMax()) {
                this.mRightAxisMax = t.getYMax();
            }
            if (this.mRightAxisMin > t.getYMin()) {
                this.mRightAxisMin = t.getYMin();
            }
        }
    }

    public void calcMinMaxY(float f, float f2) {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            ((IDataSet)iterator2.next()).calcMinMaxY(f, f2);
        }
        this.calcMinMax();
    }

    public void clearValues() {
        List<T> list = this.mDataSets;
        if (list != null) {
            list.clear();
        }
        this.notifyDataChanged();
    }

    public boolean contains(T t) {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            if (!((IDataSet)iterator2.next()).equals(t)) continue;
            return true;
        }
        return false;
    }

    public int[] getColors() {
        int n;
        if (this.mDataSets == null) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.mDataSets.size(); ++n) {
            n3 += ((IDataSet)this.mDataSets.get(n)).getColors().size();
        }
        int[] nArray = new int[n3];
        n = 0;
        for (n3 = n2; n3 < this.mDataSets.size(); ++n3) {
            Iterator<Integer> iterator2 = ((IDataSet)this.mDataSets.get(n3)).getColors().iterator();
            while (iterator2.hasNext()) {
                nArray[n] = iterator2.next();
                ++n;
            }
        }
        return nArray;
    }

    public T getDataSetByIndex(int n) {
        List<T> list = this.mDataSets;
        if (list != null && n >= 0 && n < list.size()) {
            return (T)((IDataSet)this.mDataSets.get(n));
        }
        return null;
    }

    public T getDataSetByLabel(String string2, boolean bl) {
        int n = this.getDataSetIndexByLabel(this.mDataSets, string2, bl);
        if (n >= 0 && n < this.mDataSets.size()) {
            return (T)((IDataSet)this.mDataSets.get(n));
        }
        return null;
    }

    public int getDataSetCount() {
        List<T> list = this.mDataSets;
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public T getDataSetForEntry(Entry entry) {
        if (entry == null) {
            return null;
        }
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            IDataSet iDataSet = (IDataSet)this.mDataSets.get(i);
            for (int j = 0; j < iDataSet.getEntryCount(); ++j) {
                if (!entry.equalTo((Entry)iDataSet.getEntryForXValue(entry.getX(), entry.getY()))) continue;
                return (T)iDataSet;
            }
        }
        return null;
    }

    protected int getDataSetIndexByLabel(List<T> list, String string2, boolean bl) {
        int n;
        int n2 = 0;
        if (bl) {
            for (n = n2; n < list.size(); ++n) {
                if (!string2.equalsIgnoreCase(((IDataSet)list.get(n)).getLabel())) continue;
                return n;
            }
        } else {
            for (n = 0; n < list.size(); ++n) {
                if (!string2.equals(((IDataSet)list.get(n)).getLabel())) continue;
                return n;
            }
        }
        return -1;
    }

    public String[] getDataSetLabels() {
        String[] stringArray = new String[this.mDataSets.size()];
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            stringArray[i] = ((IDataSet)this.mDataSets.get(i)).getLabel();
        }
        return stringArray;
    }

    public List<T> getDataSets() {
        return this.mDataSets;
    }

    public int getEntryCount() {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            n += ((IDataSet)iterator2.next()).getEntryCount();
        }
        return n;
    }

    public Entry getEntryForHighlight(Highlight highlight) {
        if (highlight.getDataSetIndex() >= this.mDataSets.size()) {
            return null;
        }
        return ((IDataSet)this.mDataSets.get(highlight.getDataSetIndex())).getEntryForXValue(highlight.getX(), highlight.getY());
    }

    protected T getFirstLeft(List<T> object) {
        Iterator<T> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (IDataSet)iterator2.next();
            if (object.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
            return (T)object;
        }
        return null;
    }

    public T getFirstRight(List<T> object) {
        object = object.iterator();
        while (object.hasNext()) {
            IDataSet iDataSet = (IDataSet)object.next();
            if (iDataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
            return (T)iDataSet;
        }
        return null;
    }

    public int getIndexOfDataSet(T t) {
        return this.mDataSets.indexOf(t);
    }

    public T getMaxEntryCountSet() {
        List<T> list = this.mDataSets;
        if (list != null && !list.isEmpty()) {
            list = (IDataSet)this.mDataSets.get(0);
            for (IDataSet iDataSet : this.mDataSets) {
                if (iDataSet.getEntryCount() <= list.getEntryCount()) continue;
                list = iDataSet;
            }
            return (T)list;
        }
        return null;
    }

    public float getXMax() {
        return this.mXMax;
    }

    public float getXMin() {
        return this.mXMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public float getYMax(YAxis.AxisDependency axisDependency) {
        float f;
        if (axisDependency == YAxis.AxisDependency.LEFT) {
            float f2;
            float f3 = f2 = this.mLeftAxisMax;
            if (f2 == -3.4028235E38f) {
                f3 = this.mRightAxisMax;
            }
            return f3;
        }
        float f4 = f = this.mRightAxisMax;
        if (f == -3.4028235E38f) {
            f4 = this.mLeftAxisMax;
        }
        return f4;
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMin(YAxis.AxisDependency axisDependency) {
        float f;
        if (axisDependency == YAxis.AxisDependency.LEFT) {
            float f2;
            float f3 = f2 = this.mLeftAxisMin;
            if (f2 == Float.MAX_VALUE) {
                f3 = this.mRightAxisMin;
            }
            return f3;
        }
        float f4 = f = this.mRightAxisMin;
        if (f == Float.MAX_VALUE) {
            f4 = this.mLeftAxisMin;
        }
        return f4;
    }

    public boolean isHighlightEnabled() {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            if (((IDataSet)iterator2.next()).isHighlightEnabled()) continue;
            return false;
        }
        return true;
    }

    public void notifyDataChanged() {
        this.calcMinMax();
    }

    public boolean removeDataSet(int n) {
        if (n < this.mDataSets.size() && n >= 0) {
            return this.removeDataSet((IDataSet)this.mDataSets.get(n));
        }
        return false;
    }

    public boolean removeDataSet(T t) {
        if (t == null) {
            return false;
        }
        boolean bl = this.mDataSets.remove(t);
        if (bl) {
            this.notifyDataChanged();
        }
        return bl;
    }

    public boolean removeEntry(float f, int n) {
        if (n >= this.mDataSets.size()) {
            return false;
        }
        Object t = ((IDataSet)this.mDataSets.get(n)).getEntryForXValue(f, Float.NaN);
        if (t == null) {
            return false;
        }
        return this.removeEntry((Entry)t, n);
    }

    public boolean removeEntry(Entry entry, int n) {
        IDataSet iDataSet;
        if (entry != null && n < this.mDataSets.size() && (iDataSet = (IDataSet)this.mDataSets.get(n)) != null) {
            boolean bl = iDataSet.removeEntry(entry);
            if (bl) {
                this.notifyDataChanged();
            }
            return bl;
        }
        return false;
    }

    public void setDrawValues(boolean bl) {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            ((IDataSet)iterator2.next()).setDrawValues(bl);
        }
    }

    public void setHighlightEnabled(boolean bl) {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            ((IDataSet)iterator2.next()).setHighlightEnabled(bl);
        }
    }

    public void setValueFormatter(IValueFormatter iValueFormatter) {
        if (iValueFormatter == null) {
            return;
        }
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            ((IDataSet)iterator2.next()).setValueFormatter(iValueFormatter);
        }
    }

    public void setValueTextColor(int n) {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            ((IDataSet)iterator2.next()).setValueTextColor(n);
        }
    }

    public void setValueTextColors(List<Integer> list) {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            ((IDataSet)iterator2.next()).setValueTextColors(list);
        }
    }

    public void setValueTextSize(float f) {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            ((IDataSet)iterator2.next()).setValueTextSize(f);
        }
    }

    public void setValueTypeface(Typeface typeface) {
        Iterator<T> iterator2 = this.mDataSets.iterator();
        while (iterator2.hasNext()) {
            ((IDataSet)iterator2.next()).setValueTypeface(typeface);
        }
    }
}

