/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.formatter;

import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.formatter.IAxisValueFormatter;
import java.util.Collection;

public class IndexAxisValueFormatter
implements IAxisValueFormatter {
    private int mValueCount = 0;
    private String[] mValues = new String[0];

    public IndexAxisValueFormatter() {
    }

    public IndexAxisValueFormatter(Collection<String> collection) {
        if (collection != null) {
            this.setValues(collection.toArray(new String[collection.size()]));
        }
    }

    public IndexAxisValueFormatter(String[] stringArray) {
        if (stringArray != null) {
            this.setValues(stringArray);
        }
    }

    @Override
    public String getFormattedValue(float f, AxisBase axisBase) {
        int n = Math.round(f);
        if (n >= 0 && n < this.mValueCount && n == (int)f) {
            return this.mValues[n];
        }
        return "";
    }

    public String[] getValues() {
        return this.mValues;
    }

    public void setValues(String[] stringArray) {
        String[] stringArray2 = stringArray;
        if (stringArray == null) {
            stringArray2 = new String[]{};
        }
        this.mValues = stringArray2;
        this.mValueCount = stringArray2.length;
    }
}

