/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public abstract class AxisRenderer
extends Renderer {
    protected AxisBase mAxis;
    protected Paint mAxisLabelPaint;
    protected Paint mAxisLinePaint;
    protected Paint mGridPaint;
    protected Paint mLimitLinePaint;
    protected Transformer mTrans;

    public AxisRenderer(ViewPortHandler viewPortHandler, Transformer transformer, AxisBase axisBase) {
        super(viewPortHandler);
        this.mTrans = transformer;
        this.mAxis = axisBase;
        if (this.mViewPortHandler != null) {
            this.mAxisLabelPaint = new Paint(1);
            viewPortHandler = new Paint();
            this.mGridPaint = viewPortHandler;
            viewPortHandler.setColor(-7829368);
            this.mGridPaint.setStrokeWidth(1.0f);
            this.mGridPaint.setStyle(Paint.Style.STROKE);
            this.mGridPaint.setAlpha(90);
            viewPortHandler = new Paint();
            this.mAxisLinePaint = viewPortHandler;
            viewPortHandler.setColor(-16777216);
            this.mAxisLinePaint.setStrokeWidth(1.0f);
            this.mAxisLinePaint.setStyle(Paint.Style.STROKE);
            viewPortHandler = new Paint(1);
            this.mLimitLinePaint = viewPortHandler;
            viewPortHandler.setStyle(Paint.Style.STROKE);
        }
    }

    public void computeAxis(float f, float f2, boolean bl) {
        float f3 = f;
        float f4 = f2;
        if (this.mViewPortHandler != null) {
            f3 = f;
            f4 = f2;
            if (this.mViewPortHandler.contentWidth() > 10.0f) {
                f3 = f;
                f4 = f2;
                if (!this.mViewPortHandler.isFullyZoomedOutY()) {
                    double d;
                    MPPointD mPPointD = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop());
                    MPPointD mPPointD2 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom());
                    if (!bl) {
                        f = (float)mPPointD2.y;
                        d = mPPointD.y;
                    } else {
                        f = (float)mPPointD.y;
                        d = mPPointD2.y;
                    }
                    f4 = (float)d;
                    MPPointD.recycleInstance(mPPointD);
                    MPPointD.recycleInstance(mPPointD2);
                    f3 = f;
                }
            }
        }
        this.computeAxisValues(f3, f4);
    }

    protected void computeAxisValues(float f, float f2) {
        int n = this.mAxis.getLabelCount();
        double d = Math.abs(f2 - f);
        if (n != 0 && !(d <= 0.0) && !Double.isInfinite(d)) {
            double d2;
            double d3;
            double d4 = d3 = (double)Utils.roundToNextSignificant(d / (double)n);
            if (this.mAxis.isGranularityEnabled()) {
                d4 = d3;
                if (d3 < (double)this.mAxis.getGranularity()) {
                    d4 = this.mAxis.getGranularity();
                }
            }
            double d5 = Utils.roundToNextSignificant(Math.pow(10.0, (int)Math.log10(d4)));
            d3 = d4;
            if ((int)(d4 / d5) > 5) {
                d3 = d5 * 10.0;
                d3 = Math.floor(d3) == 0.0 ? d4 : Math.floor(d3);
            }
            int n2 = this.mAxis.isCenterAxisLabelsEnabled();
            if (this.mAxis.isForceLabelsEnabled()) {
                d4 = (float)d / (float)(n - 1);
                this.mAxis.mEntryCount = n;
                if (this.mAxis.mEntries.length < n) {
                    this.mAxis.mEntries = new float[n];
                }
                d2 = 0.0;
                while (true) {
                    n2 = n;
                    d = d4;
                    if (d2 < n) {
                        this.mAxis.mEntries[d2] = f;
                        f = (float)((double)f + d4);
                        ++d2;
                        continue;
                    }
                    break;
                }
            } else {
                double d6 = d3 - 0.0;
                d2 = d6 == 0.0 ? 0 : (d6 > 0.0 ? 1 : -1);
                d = d2 == false ? 0.0 : Math.ceil((double)f / d3) * d3;
                d4 = d;
                if (this.mAxis.isCenterAxisLabelsEnabled()) {
                    d4 = d - d3;
                }
                d = d2 == false ? 0.0 : Utils.nextUp(Math.floor((double)f2 / d3) * d3);
                if (d2 != false && d != d4) {
                    d5 = d4;
                    while (true) {
                        d2 = n2;
                        if (d5 <= d) {
                            ++n2;
                            d5 += d3;
                            continue;
                        }
                        break;
                    }
                } else {
                    d2 = n2;
                    if (d == d4) {
                        d2 = n2;
                        if (n2 == 0) {
                            d2 = 1.0;
                        }
                    }
                }
                this.mAxis.mEntryCount = (int)d2;
                if (this.mAxis.mEntries.length < d2) {
                    this.mAxis.mEntries = new float[d2];
                }
                n = 0;
                while (true) {
                    n2 = (int)d2;
                    d = d3;
                    if (n >= d2) break;
                    d = d4;
                    if (d4 == 0.0) {
                        d = 0.0;
                    }
                    this.mAxis.mEntries[n] = (float)d;
                    d4 = d + d3;
                    ++n;
                }
            }
            this.mAxis.mDecimals = d < 1.0 ? (int)Math.ceil(-Math.log10(d)) : 0;
            if (this.mAxis.isCenterAxisLabelsEnabled()) {
                if (this.mAxis.mCenteredEntries.length < n2) {
                    this.mAxis.mCenteredEntries = new float[n2];
                }
                f = (float)d / 2.0f;
                for (d2 = 0.0; d2 < n2; ++d2) {
                    this.mAxis.mCenteredEntries[d2] = this.mAxis.mEntries[d2] + f;
                }
            }
            return;
        }
        this.mAxis.mEntries = new float[0];
        this.mAxis.mCenteredEntries = new float[0];
        this.mAxis.mEntryCount = 0;
    }

    public Paint getPaintAxisLabels() {
        return this.mAxisLabelPaint;
    }

    public Paint getPaintAxisLine() {
        return this.mAxisLinePaint;
    }

    public Paint getPaintGrid() {
        return this.mGridPaint;
    }

    public Transformer getTransformer() {
        return this.mTrans;
    }

    public abstract void renderAxisLabels(Canvas var1);

    public abstract void renderAxisLine(Canvas var1);

    public abstract void renderGridLines(Canvas var1);

    public abstract void renderLimitLines(Canvas var1);
}

