/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.utils.Fill;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class BarChartRenderer
extends BarLineScatterCandleBubbleRenderer {
    protected Paint mBarBorderPaint;
    protected BarBuffer[] mBarBuffers;
    protected RectF mBarRect = new RectF();
    private RectF mBarShadowRectBuffer = new RectF();
    protected BarDataProvider mChart;
    protected Paint mShadowPaint;

    public BarChartRenderer(BarDataProvider barDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = barDataProvider;
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setColor(Color.rgb((int)0, (int)0, (int)0));
        this.mHighlightPaint.setAlpha(120);
        barDataProvider = new Paint(1);
        this.mShadowPaint = barDataProvider;
        barDataProvider.setStyle(Paint.Style.FILL);
        barDataProvider = new Paint(1);
        this.mBarBorderPaint = barDataProvider;
        barDataProvider.setStyle(Paint.Style.STROKE);
    }

    @Override
    public void drawData(Canvas canvas) {
        BarData barData = this.mChart.getBarData();
        for (int i = 0; i < barData.getDataSetCount(); ++i) {
            IBarDataSet iBarDataSet = (IBarDataSet)barData.getDataSetByIndex(i);
            if (!iBarDataSet.isVisible()) continue;
            this.drawDataSet(canvas, iBarDataSet, i);
        }
    }

    protected void drawDataSet(Canvas canvas, IBarDataSet iBarDataSet, int n) {
        int n2;
        int n3;
        float f;
        Object object = this.mChart.getTransformer(iBarDataSet.getAxisDependency());
        this.mBarBorderPaint.setColor(iBarDataSet.getBarBorderColor());
        this.mBarBorderPaint.setStrokeWidth(Utils.convertDpToPixel(iBarDataSet.getBarBorderWidth()));
        float f2 = iBarDataSet.getBarBorderWidth();
        int n4 = 0;
        int n5 = 1;
        boolean bl = f2 > 0.0f;
        float f3 = this.mAnimator.getPhaseX();
        float f4 = this.mAnimator.getPhaseY();
        if (this.mChart.isDrawBarShadowEnabled()) {
            this.mShadowPaint.setColor(iBarDataSet.getBarShadowColor());
            f = this.mChart.getBarData().getBarWidth() / 2.0f;
            n3 = Math.min((int)Math.ceil((float)iBarDataSet.getEntryCount() * f3), iBarDataSet.getEntryCount());
            for (n2 = 0; n2 < n3; ++n2) {
                f2 = ((BarEntry)iBarDataSet.getEntryForIndex(n2)).getX();
                this.mBarShadowRectBuffer.left = f2 - f;
                this.mBarShadowRectBuffer.right = f2 + f;
                ((Transformer)object).rectValueToPixel(this.mBarShadowRectBuffer);
                if (!this.mViewPortHandler.isInBoundsLeft(this.mBarShadowRectBuffer.right)) continue;
                if (!this.mViewPortHandler.isInBoundsRight(this.mBarShadowRectBuffer.left)) break;
                this.mBarShadowRectBuffer.top = this.mViewPortHandler.contentTop();
                this.mBarShadowRectBuffer.bottom = this.mViewPortHandler.contentBottom();
                canvas.drawRect(this.mBarShadowRectBuffer, this.mShadowPaint);
            }
        }
        BarBuffer barBuffer = this.mBarBuffers[n];
        barBuffer.setPhases(f3, f4);
        barBuffer.setDataSet(n);
        barBuffer.setInverted(this.mChart.isInverted(iBarDataSet.getAxisDependency()));
        barBuffer.setBarWidth(this.mChart.getBarData().getBarWidth());
        barBuffer.feed(iBarDataSet);
        ((Transformer)object).pointValuesToPixel(barBuffer.buffer);
        n = iBarDataSet.getFills() != null && !iBarDataSet.getFills().isEmpty() ? 1 : 0;
        n2 = iBarDataSet.getColors().size() == 1 ? n5 : 0;
        boolean bl2 = this.mChart.isInverted(iBarDataSet.getAxisDependency());
        if (n2 != 0) {
            this.mRenderPaint.setColor(iBarDataSet.getColor());
        }
        n5 = 0;
        while (n4 < barBuffer.size()) {
            Object object2 = this.mViewPortHandler;
            object = barBuffer.buffer;
            n3 = n4 + 2;
            if (((ViewPortHandler)object2).isInBoundsLeft((float)object[n3])) {
                if (!this.mViewPortHandler.isInBoundsRight(barBuffer.buffer[n4])) break;
                if (n2 == 0) {
                    this.mRenderPaint.setColor(iBarDataSet.getColor(n5));
                }
                if (n != 0) {
                    object2 = iBarDataSet.getFill(n5);
                    Paint paint = this.mRenderPaint;
                    f2 = barBuffer.buffer[n4];
                    f4 = barBuffer.buffer[n4 + 1];
                    f = barBuffer.buffer[n3];
                    f3 = barBuffer.buffer[n4 + 3];
                    object = bl2 ? Fill.Direction.DOWN : Fill.Direction.UP;
                    ((Fill)object2).fillRect(canvas, paint, f2, f4, f, f3, (Fill.Direction)((Object)object));
                } else {
                    canvas.drawRect(barBuffer.buffer[n4], barBuffer.buffer[n4 + 1], barBuffer.buffer[n3], barBuffer.buffer[n4 + 3], this.mRenderPaint);
                }
                if (bl) {
                    canvas.drawRect(barBuffer.buffer[n4], barBuffer.buffer[n4 + 1], barBuffer.buffer[n3], barBuffer.buffer[n4 + 3], this.mBarBorderPaint);
                }
            }
            n4 += 4;
            ++n5;
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        BarData barData = this.mChart.getBarData();
        for (Highlight highlight : highlightArray) {
            float f;
            float f2;
            BarEntry barEntry;
            Object object = (IBarDataSet)barData.getDataSetByIndex(highlight.getDataSetIndex());
            if (object == null || !object.isHighlightEnabled() || !this.isInBoundsX(barEntry = (BarEntry)object.getEntryForXValue(highlight.getX(), highlight.getY()), (IBarLineScatterCandleBubbleDataSet)object)) continue;
            Transformer transformer = this.mChart.getTransformer(object.getAxisDependency());
            this.mHighlightPaint.setColor(object.getHighLightColor());
            this.mHighlightPaint.setAlpha(object.getHighLightAlpha());
            boolean bl = highlight.getStackIndex() >= 0 && barEntry.isStacked();
            if (bl) {
                if (this.mChart.isHighlightFullBarEnabled()) {
                    f2 = barEntry.getPositiveSum();
                    f = -barEntry.getNegativeSum();
                } else {
                    object = barEntry.getRanges()[highlight.getStackIndex()];
                    f2 = ((Range)object).from;
                    f = ((Range)object).to;
                }
            } else {
                f2 = barEntry.getY();
                f = 0.0f;
            }
            this.prepareBarHighlight(barEntry.getX(), f2, f, barData.getBarWidth() / 2.0f, transformer);
            this.setHighlightDrawPos(highlight, this.mBarRect);
            canvas.drawRect(this.mBarRect, this.mHighlightPaint);
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            Object object = this.mChart.getBarData().getDataSets();
            float f = Utils.convertDpToPixel(4.5f);
            boolean bl = this.mChart.isDrawValueAboveBarEnabled();
            for (int i = 0; i < this.mChart.getBarData().getDataSetCount(); ++i) {
                Object object2;
                float f2;
                IBarDataSet iBarDataSet = (IBarDataSet)object.get(i);
                if (!this.shouldDrawValues(iBarDataSet)) {
                    f2 = f;
                    object2 = object;
                } else {
                    float f3;
                    int n;
                    int n2;
                    Object object3;
                    Object object4;
                    int n3;
                    this.applyValueTextStyle(iBarDataSet);
                    boolean bl2 = this.mChart.isInverted(iBarDataSet.getAxisDependency());
                    float f4 = Utils.calcTextHeight(this.mValuePaint, "8");
                    float f5 = bl ? -f : f4 + f;
                    float f6 = bl ? f4 + f : -f;
                    float f7 = f5;
                    f2 = f6;
                    if (bl2) {
                        f7 = -f5 - f4;
                        f2 = -f6 - f4;
                    }
                    Object object5 = this.mBarBuffers[i];
                    float f8 = this.mAnimator.getPhaseY();
                    Object object6 = MPPointF.getInstance(iBarDataSet.getIconsOffset());
                    ((MPPointF)object6).x = Utils.convertDpToPixel(((MPPointF)object6).x);
                    ((MPPointF)object6).y = Utils.convertDpToPixel(((MPPointF)object6).y);
                    if (!iBarDataSet.isStacked()) {
                        n3 = 0;
                        object2 = object;
                        object4 = object5;
                        object = object6;
                        while ((float)n3 < (float)((BarBuffer)object4).buffer.length * this.mAnimator.getPhaseX() && this.mViewPortHandler.isInBoundsRight(f6 = (((BarBuffer)object4).buffer[n3] + ((BarBuffer)object4).buffer[n3 + 2]) / 2.0f)) {
                            object3 = this.mViewPortHandler;
                            object6 = ((BarBuffer)object4).buffer;
                            n2 = n3 + 1;
                            if (((ViewPortHandler)object3).isInBoundsY((float)object6[n2]) && this.mViewPortHandler.isInBoundsLeft(f6)) {
                                n = n3 / 4;
                                object5 = (BarEntry)iBarDataSet.getEntryForIndex(n);
                                f4 = ((BarEntry)object5).getY();
                                if (iBarDataSet.isDrawValuesEnabled()) {
                                    object6 = iBarDataSet.getValueFormatter();
                                    f5 = f4 >= 0.0f ? ((BarBuffer)object4).buffer[n2] + f7 : ((BarBuffer)object4).buffer[n3 + 3] + f2;
                                    this.drawValue(canvas, (IValueFormatter)object6, f4, (Entry)object5, i, f6, f5, iBarDataSet.getValueTextColor(n));
                                }
                                object6 = object;
                                object3 = object4;
                                if (((BaseEntry)object5).getIcon() != null && iBarDataSet.isDrawIconsEnabled()) {
                                    object5 = ((BaseEntry)object5).getIcon();
                                    f5 = f4 >= 0.0f ? ((BarBuffer)object3).buffer[n2] + f7 : ((BarBuffer)object3).buffer[n3 + 3] + f2;
                                    f4 = ((MPPointF)object6).x;
                                    f3 = ((MPPointF)object6).y;
                                    Utils.drawImage(canvas, (Drawable)object5, (int)(f6 + f4), (int)(f5 + f3), object5.getIntrinsicWidth(), object5.getIntrinsicHeight());
                                }
                            }
                            n3 += 4;
                        }
                        bl2 = bl;
                        object3 = object;
                    } else {
                        object4 = object6;
                        object6 = object;
                        object = this.mChart.getTransformer(iBarDataSet.getAxisDependency());
                        n3 = 0;
                        n2 = 0;
                        f5 = f;
                        while (true) {
                            Object object7;
                            Object object8;
                            f = f5;
                            bl2 = bl;
                            object3 = object4;
                            object2 = object6;
                            if (!((float)n3 < (float)iBarDataSet.getEntryCount() * this.mAnimator.getPhaseX())) break;
                            BarEntry barEntry = (BarEntry)iBarDataSet.getEntryForIndex(n3);
                            object2 = barEntry.getYVals();
                            f3 = (((BarBuffer)object5).buffer[n2] + ((BarBuffer)object5).buffer[n2 + 2]) / 2.0f;
                            int n4 = iBarDataSet.getValueTextColor(n3);
                            if (object2 == null) {
                                if (!this.mViewPortHandler.isInBoundsRight(f3)) {
                                    f = f5;
                                    bl2 = bl;
                                    object3 = object4;
                                    object2 = object6;
                                    break;
                                }
                                object8 = this.mViewPortHandler;
                                object3 = ((BarBuffer)object5).buffer;
                                n = n2 + 1;
                                if (!((ViewPortHandler)object8).isInBoundsY((float)object3[n]) || !this.mViewPortHandler.isInBoundsLeft(f3)) continue;
                                if (iBarDataSet.isDrawValuesEnabled()) {
                                    object3 = iBarDataSet.getValueFormatter();
                                    f6 = barEntry.getY();
                                    f4 = ((BarBuffer)object5).buffer[n];
                                    f = barEntry.getY() >= 0.0f ? f7 : f2;
                                    this.drawValue(canvas, (IValueFormatter)object3, f6, barEntry, i, f3, f4 + f, n4);
                                }
                                if (barEntry.getIcon() != null && iBarDataSet.isDrawIconsEnabled()) {
                                    object3 = barEntry.getIcon();
                                    f6 = ((BarBuffer)object5).buffer[n];
                                    f = barEntry.getY() >= 0.0f ? f7 : f2;
                                    f4 = ((MPPointF)object4).x;
                                    object7 = ((MPPointF)object4).y;
                                    Utils.drawImage(canvas, (Drawable)object3, (int)(f3 + f4), (int)(f6 + f + object7), object3.getIntrinsicWidth(), object3.getIntrinsicHeight());
                                }
                            } else {
                                float f9;
                                object8 = object2;
                                int n5 = ((Object)object8).length * 2;
                                object3 = new float[n5];
                                f = -barEntry.getNegativeSum();
                                int n6 = 0;
                                n = 0;
                                f4 = 0.0f;
                                while (n6 < n5) {
                                    f6 = (float)object8[n];
                                    float f10 = f6 - 0.0f;
                                    f9 = f10 == 0.0f ? 0 : (f10 > 0.0f ? 1 : -1);
                                    if (f9 != false || f4 != 0.0f && f != 0.0f) {
                                        if (f9 >= 0) {
                                            f4 += f6;
                                            f6 = f4;
                                        } else {
                                            object7 = f - f6;
                                            f6 = f;
                                            f = object7;
                                        }
                                    }
                                    object3[n6 + 1] = f6 * f8;
                                    n6 += 2;
                                    ++n;
                                }
                                ((Transformer)object).pointValuesToPixel((float[])object3);
                                n = n5;
                                for (n6 = 0; n6 < n; n6 += 2) {
                                    f9 = n6 / 2;
                                    f6 = (float)object8[f9];
                                    n5 = f6 == 0.0f && f == 0.0f && f4 > 0.0f || f6 < 0.0f ? 1 : 0;
                                    object7 = object3[n6 + 1];
                                    f6 = n5 != 0 ? f2 : f7;
                                    f6 = object7 + f6;
                                    if (!this.mViewPortHandler.isInBoundsRight(f3)) break;
                                    if (!this.mViewPortHandler.isInBoundsY(f6) || !this.mViewPortHandler.isInBoundsLeft(f3)) continue;
                                    if (iBarDataSet.isDrawValuesEnabled()) {
                                        this.drawValue(canvas, iBarDataSet.getValueFormatter(), (float)object8[f9], barEntry, i, f3, f6, n4);
                                    }
                                    if (barEntry.getIcon() == null || !iBarDataSet.isDrawIconsEnabled()) continue;
                                    Drawable drawable2 = barEntry.getIcon();
                                    Utils.drawImage(canvas, drawable2, (int)(f3 + ((MPPointF)object4).x), (int)(f6 + ((MPPointF)object4).y), drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                                }
                            }
                            n2 = object2 == null ? (n2 += 4) : (n2 += ((Object)object2).length * 4);
                            ++n3;
                        }
                    }
                    f2 = f;
                    bl = bl2;
                    MPPointF.recycleInstance((MPPointF)object3);
                }
                object = object2;
                f = f2;
            }
        }
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new BarBuffer[barData.getDataSetCount()];
        for (int i = 0; i < this.mBarBuffers.length; ++i) {
            IBarDataSet iBarDataSet = (IBarDataSet)barData.getDataSetByIndex(i);
            BarBuffer[] barBufferArray = this.mBarBuffers;
            int n = iBarDataSet.getEntryCount();
            int n2 = iBarDataSet.isStacked() ? iBarDataSet.getStackSize() : 1;
            barBufferArray[i] = new BarBuffer(n * 4 * n2, barData.getDataSetCount(), iBarDataSet.isStacked());
        }
    }

    protected void prepareBarHighlight(float f, float f2, float f3, float f4, Transformer transformer) {
        this.mBarRect.set(f - f4, f2, f + f4, f3);
        transformer.rectToPixelPhase(this.mBarRect, this.mAnimator.getPhaseY());
    }

    protected void setHighlightDrawPos(Highlight highlight, RectF rectF) {
        highlight.setDraw(rectF.centerX(), rectF.top);
    }
}

