/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class BubbleChartRenderer
extends BarLineScatterCandleBubbleRenderer {
    private float[] _hsvBuffer;
    protected BubbleDataProvider mChart;
    private float[] pointBuffer;
    private float[] sizeBuffer = new float[4];

    public BubbleChartRenderer(BubbleDataProvider bubbleDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.pointBuffer = new float[2];
        this._hsvBuffer = new float[3];
        this.mChart = bubbleDataProvider;
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(Utils.convertDpToPixel(1.5f));
    }

    @Override
    public void drawData(Canvas canvas) {
        for (IBubbleDataSet iBubbleDataSet : this.mChart.getBubbleData().getDataSets()) {
            if (!iBubbleDataSet.isVisible()) continue;
            this.drawDataSet(canvas, iBubbleDataSet);
        }
    }

    protected void drawDataSet(Canvas canvas, IBubbleDataSet iBubbleDataSet) {
        if (iBubbleDataSet.getEntryCount() < 1) {
            return;
        }
        Transformer transformer = this.mChart.getTransformer(iBubbleDataSet.getAxisDependency());
        float f = this.mAnimator.getPhaseY();
        this.mXBounds.set(this.mChart, iBubbleDataSet);
        Object object = this.sizeBuffer;
        object[0] = 0.0f;
        object[2] = 1.0f;
        transformer.pointValuesToPixel((float[])object);
        boolean bl = iBubbleDataSet.isNormalizeSizeEnabled();
        object = this.sizeBuffer;
        float f2 = Math.abs(object[2] - object[0]);
        f2 = Math.min(Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop()), f2);
        for (int i = this.mXBounds.min; i <= this.mXBounds.range + this.mXBounds.min; ++i) {
            object = (BubbleEntry)iBubbleDataSet.getEntryForIndex(i);
            this.pointBuffer[0] = object.getX();
            this.pointBuffer[1] = object.getY() * f;
            transformer.pointValuesToPixel(this.pointBuffer);
            float f3 = this.getShapeSize(object.getSize(), iBubbleDataSet.getMaxSize(), f2, bl) / 2.0f;
            if (!this.mViewPortHandler.isInBoundsTop(this.pointBuffer[1] + f3) || !this.mViewPortHandler.isInBoundsBottom(this.pointBuffer[1] - f3) || !this.mViewPortHandler.isInBoundsLeft(this.pointBuffer[0] + f3)) continue;
            if (!this.mViewPortHandler.isInBoundsRight(this.pointBuffer[0] - f3)) break;
            int n = iBubbleDataSet.getColor(i);
            this.mRenderPaint.setColor(n);
            object = this.pointBuffer;
            canvas.drawCircle(object[0], object[1], f3, this.mRenderPaint);
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        float f = this.mAnimator.getPhaseY();
        for (Highlight highlight : highlightArray) {
            Object object;
            Object object2 = (IBubbleDataSet)bubbleData.getDataSetByIndex(highlight.getDataSetIndex());
            if (object2 == null || !object2.isHighlightEnabled() || ((BaseEntry)(object = (BubbleEntry)object2.getEntryForXValue(highlight.getX(), highlight.getY()))).getY() != highlight.getY() || !this.isInBoundsX((Entry)object, (IBarLineScatterCandleBubbleDataSet)object2)) continue;
            Object object3 = this.mChart.getTransformer(object2.getAxisDependency());
            float[] fArray = this.sizeBuffer;
            fArray[0] = 0.0f;
            fArray[2] = 1.0f;
            ((Transformer)object3).pointValuesToPixel(fArray);
            boolean bl = object2.isNormalizeSizeEnabled();
            fArray = this.sizeBuffer;
            float f2 = Math.abs(fArray[2] - fArray[0]);
            f2 = Math.min(Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop()), f2);
            this.pointBuffer[0] = ((Entry)object).getX();
            this.pointBuffer[1] = ((BaseEntry)object).getY() * f;
            ((Transformer)object3).pointValuesToPixel(this.pointBuffer);
            object3 = this.pointBuffer;
            highlight.setDraw((float)object3[0], (float)object3[1]);
            f2 = this.getShapeSize(((BubbleEntry)object).getSize(), object2.getMaxSize(), f2, bl) / 2.0f;
            if (!this.mViewPortHandler.isInBoundsTop(this.pointBuffer[1] + f2) || !this.mViewPortHandler.isInBoundsBottom(this.pointBuffer[1] - f2) || !this.mViewPortHandler.isInBoundsLeft(this.pointBuffer[0] + f2)) continue;
            if (!this.mViewPortHandler.isInBoundsRight(this.pointBuffer[0] - f2)) break;
            int n = object2.getColor((int)((Entry)object).getX());
            Color.RGBToHSV((int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n), (float[])this._hsvBuffer);
            object = this._hsvBuffer;
            object[2] = object[2] * 0.5f;
            n = Color.HSVToColor((int)Color.alpha((int)n), (float[])this._hsvBuffer);
            this.mHighlightPaint.setColor(n);
            this.mHighlightPaint.setStrokeWidth(object2.getHighlightCircleWidth());
            object2 = this.pointBuffer;
            canvas.drawCircle((float)object2[0], (float)object2[1], f2, this.mHighlightPaint);
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        Object object = this.mChart.getBubbleData();
        if (object == null) {
            return;
        }
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List list = ((ChartData)object).getDataSets();
            float f = Utils.calcTextHeight(this.mValuePaint, "1");
            for (int i = 0; i < list.size(); ++i) {
                IBubbleDataSet iBubbleDataSet = (IBubbleDataSet)list.get(i);
                if (!this.shouldDrawValues(iBubbleDataSet) || iBubbleDataSet.getEntryCount() < 1) continue;
                this.applyValueTextStyle(iBubbleDataSet);
                float f2 = Math.max(0.0f, Math.min(1.0f, this.mAnimator.getPhaseX()));
                float f3 = this.mAnimator.getPhaseY();
                this.mXBounds.set(this.mChart, iBubbleDataSet);
                float[] fArray = this.mChart.getTransformer(iBubbleDataSet.getAxisDependency()).generateTransformedValuesBubble(iBubbleDataSet, f3, this.mXBounds.min, this.mXBounds.max);
                if (f2 != 1.0f) {
                    f3 = f2;
                }
                object = MPPointF.getInstance(iBubbleDataSet.getIconsOffset());
                ((MPPointF)object).x = Utils.convertDpToPixel(((MPPointF)object).x);
                ((MPPointF)object).y = Utils.convertDpToPixel(((MPPointF)object).y);
                for (int j = 0; j < fArray.length; j += 2) {
                    int n = j / 2;
                    int n2 = iBubbleDataSet.getValueTextColor(this.mXBounds.min + n);
                    n2 = Color.argb((int)Math.round(255.0f * f3), (int)Color.red((int)n2), (int)Color.green((int)n2), (int)Color.blue((int)n2));
                    float f4 = fArray[j];
                    f2 = fArray[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(f4)) break;
                    if (!this.mViewPortHandler.isInBoundsLeft(f4) || !this.mViewPortHandler.isInBoundsY(f2)) continue;
                    BubbleEntry bubbleEntry = (BubbleEntry)iBubbleDataSet.getEntryForIndex(n + this.mXBounds.min);
                    if (iBubbleDataSet.isDrawValuesEnabled()) {
                        this.drawValue(canvas, iBubbleDataSet.getValueFormatter(), bubbleEntry.getSize(), bubbleEntry, i, f4, f2 + 0.5f * f, n2);
                    }
                    Object object2 = object;
                    if (bubbleEntry.getIcon() == null || !iBubbleDataSet.isDrawIconsEnabled()) continue;
                    bubbleEntry = bubbleEntry.getIcon();
                    Utils.drawImage(canvas, (Drawable)bubbleEntry, (int)(f4 + ((MPPointF)object2).x), (int)(f2 + ((MPPointF)object2).y), bubbleEntry.getIntrinsicWidth(), bubbleEntry.getIntrinsicHeight());
                }
                MPPointF.recycleInstance((MPPointF)object);
            }
        }
    }

    protected float getShapeSize(float f, float f2, float f3, boolean bl) {
        float f4 = f;
        if (bl) {
            f4 = f2 == 0.0f ? 1.0f : (float)Math.sqrt(f / f2);
        }
        return f3 * f4;
    }

    @Override
    public void initBuffers() {
    }
}

