/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.buffer.HorizontalBarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.ChartInterface;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.utils.Fill;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class HorizontalBarChartRenderer
extends BarChartRenderer {
    private RectF mBarShadowRectBuffer = new RectF();

    public HorizontalBarChartRenderer(BarDataProvider barDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(barDataProvider, chartAnimator, viewPortHandler);
        this.mValuePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    protected void drawDataSet(Canvas canvas, IBarDataSet iBarDataSet, int n) {
        int n2;
        Object object;
        float f;
        int n3;
        int n4;
        float f2;
        Object object2 = this.mChart.getTransformer(iBarDataSet.getAxisDependency());
        this.mBarBorderPaint.setColor(iBarDataSet.getBarBorderColor());
        this.mBarBorderPaint.setStrokeWidth(Utils.convertDpToPixel(iBarDataSet.getBarBorderWidth()));
        float f3 = iBarDataSet.getBarBorderWidth();
        int n5 = 0;
        int n6 = 1;
        boolean bl = f3 > 0.0f;
        float f4 = this.mAnimator.getPhaseX();
        f3 = this.mAnimator.getPhaseY();
        if (this.mChart.isDrawBarShadowEnabled()) {
            this.mShadowPaint.setColor(iBarDataSet.getBarShadowColor());
            f2 = this.mChart.getBarData().getBarWidth() / 2.0f;
            n4 = Math.min((int)Math.ceil((float)iBarDataSet.getEntryCount() * f4), iBarDataSet.getEntryCount());
            for (n3 = 0; n3 < n4; ++n3) {
                f = ((BarEntry)iBarDataSet.getEntryForIndex(n3)).getX();
                this.mBarShadowRectBuffer.top = f - f2;
                this.mBarShadowRectBuffer.bottom = f + f2;
                ((Transformer)object2).rectValueToPixel(this.mBarShadowRectBuffer);
                if (!this.mViewPortHandler.isInBoundsTop(this.mBarShadowRectBuffer.bottom)) continue;
                if (!this.mViewPortHandler.isInBoundsBottom(this.mBarShadowRectBuffer.top)) break;
                this.mBarShadowRectBuffer.left = this.mViewPortHandler.contentLeft();
                this.mBarShadowRectBuffer.right = this.mViewPortHandler.contentRight();
                canvas.drawRect(this.mBarShadowRectBuffer, this.mShadowPaint);
            }
        }
        BarBuffer barBuffer = this.mBarBuffers[n];
        barBuffer.setPhases(f4, f3);
        barBuffer.setDataSet(n);
        barBuffer.setInverted(this.mChart.isInverted(iBarDataSet.getAxisDependency()));
        barBuffer.setBarWidth(this.mChart.getBarData().getBarWidth());
        barBuffer.feed(iBarDataSet);
        ((Transformer)object2).pointValuesToPixel(barBuffer.buffer);
        n = iBarDataSet.getFills() != null && !iBarDataSet.getFills().isEmpty() ? 1 : 0;
        n3 = iBarDataSet.getColors().size() == 1 ? n6 : 0;
        boolean bl2 = this.mChart.isInverted(iBarDataSet.getAxisDependency());
        if (n3 != 0) {
            this.mRenderPaint.setColor(iBarDataSet.getColor());
        }
        n6 = 0;
        while (n5 < barBuffer.size() && ((ViewPortHandler)(object2 = this.mViewPortHandler)).isInBoundsTop((object = barBuffer.buffer)[n2 = n5 + 3])) {
            object2 = this.mViewPortHandler;
            object = barBuffer.buffer;
            n4 = n5 + 1;
            if (((ViewPortHandler)object2).isInBoundsBottom(object[n4])) {
                if (n3 == 0) {
                    this.mRenderPaint.setColor(iBarDataSet.getColor(n5 / 4));
                }
                if (n != 0) {
                    object = iBarDataSet.getFill(n6);
                    Paint paint = this.mRenderPaint;
                    f2 = barBuffer.buffer[n5];
                    f4 = barBuffer.buffer[n4];
                    f3 = barBuffer.buffer[n5 + 2];
                    f = barBuffer.buffer[n2];
                    object2 = bl2 ? Fill.Direction.LEFT : Fill.Direction.RIGHT;
                    object.fillRect(canvas, paint, f2, f4, f3, f, (Fill.Direction)((Object)object2));
                } else {
                    canvas.drawRect(barBuffer.buffer[n5], barBuffer.buffer[n4], barBuffer.buffer[n5 + 2], barBuffer.buffer[n2], this.mRenderPaint);
                }
                if (bl) {
                    canvas.drawRect(barBuffer.buffer[n5], barBuffer.buffer[n4], barBuffer.buffer[n5 + 2], barBuffer.buffer[n2], this.mBarBorderPaint);
                }
            }
            n5 += 4;
            ++n6;
        }
    }

    protected void drawValue(Canvas canvas, String string2, float f, float f2, int n) {
        this.mValuePaint.setColor(n);
        canvas.drawText(string2, f, f2, this.mValuePaint);
    }

    @Override
    public void drawValues(Canvas canvas) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List list = this.mChart.getBarData().getDataSets();
            float f = Utils.convertDpToPixel(5.0f);
            boolean bl = this.mChart.isDrawValueAboveBarEnabled();
            for (int i = 0; i < this.mChart.getBarData().getDataSetCount(); ++i) {
                float f2;
                IBarDataSet iBarDataSet = (IBarDataSet)list.get(i);
                if (!this.shouldDrawValues(iBarDataSet)) {
                    f2 = f;
                } else {
                    reference var23_23;
                    float f3;
                    float f4;
                    reference var20_20;
                    int n;
                    Object object;
                    Object object2;
                    List list2;
                    float f5;
                    int n2;
                    boolean bl2 = this.mChart.isInverted(iBarDataSet.getAxisDependency());
                    this.applyValueTextStyle(iBarDataSet);
                    float f6 = (float)Utils.calcTextHeight(this.mValuePaint, "10") / 2.0f;
                    Object object3 = iBarDataSet.getValueFormatter();
                    Object object4 = this.mBarBuffers[i];
                    float f7 = this.mAnimator.getPhaseY();
                    List list3 = MPPointF.getInstance(iBarDataSet.getIconsOffset());
                    ((MPPointF)((Object)list3)).x = Utils.convertDpToPixel(((MPPointF)((Object)list3)).x);
                    ((MPPointF)((Object)list3)).y = Utils.convertDpToPixel(((MPPointF)((Object)list3)).y);
                    if (!iBarDataSet.isStacked()) {
                        n2 = 0;
                        f5 = f6;
                        list2 = list;
                        object2 = object3;
                        object = object4;
                        list = list3;
                        while ((float)n2 < (float)((BarBuffer)object).buffer.length * this.mAnimator.getPhaseX()) {
                            list3 = (List)((BarBuffer)object).buffer;
                            n = n2 + 1;
                            var20_20 = (list3[n] + ((BarBuffer)object).buffer[n2 + 3]) / 2.0f;
                            if (!this.mViewPortHandler.isInBoundsTop(((BarBuffer)object).buffer[n])) break;
                            if (this.mViewPortHandler.isInBoundsX(((BarBuffer)object).buffer[n2]) && this.mViewPortHandler.isInBoundsBottom(((BarBuffer)object).buffer[n])) {
                                object4 = (BarEntry)iBarDataSet.getEntryForIndex(n2 / 4);
                                f6 = ((BarEntry)object4).getY();
                                object3 = object2.getFormattedValue(f6, (Entry)object4, i, this.mViewPortHandler);
                                f7 = Utils.calcTextWidth(this.mValuePaint, (String)object3);
                                f4 = bl ? f : -(f7 + f);
                                f2 = bl ? -(f7 + f) : f;
                                list3 = (List)((BarBuffer)object).buffer;
                                n = n2 + 2;
                                f3 = f2 - (list3[n] - ((BarBuffer)object).buffer[n2]);
                                var23_23 = (reference)f4;
                                f2 = f3;
                                if (bl2) {
                                    var23_23 = (reference)(-f4 - f7);
                                    f2 = -f3 - f7;
                                }
                                if (iBarDataSet.isDrawValuesEnabled()) {
                                    f3 = ((BarBuffer)object).buffer[n];
                                    f4 = f6 >= 0.0f ? (float)var23_23 : f2;
                                    this.drawValue(canvas, (String)object3, f4 + f3, (float)(var20_20 + f5), iBarDataSet.getValueTextColor(n2 / 2));
                                }
                                list3 = list;
                                if (((BaseEntry)object4).getIcon() != null && iBarDataSet.isDrawIconsEnabled()) {
                                    object4 = ((BaseEntry)object4).getIcon();
                                    f4 = ((BarBuffer)object).buffer[n];
                                    if (!(f6 >= 0.0f)) {
                                        var23_23 = (reference)f2;
                                    }
                                    f3 = ((MPPointF)((Object)list3)).x;
                                    f2 = ((MPPointF)((Object)list3)).y;
                                    Utils.drawImage(canvas, (Drawable)object4, (int)(f4 + var23_23 + f3), (int)(var20_20 + f2), object4.getIntrinsicWidth(), object4.getIntrinsicHeight());
                                }
                            }
                            n2 += 4;
                        }
                        object = list;
                        list = list2;
                        f2 = f;
                    } else {
                        list2 = list;
                        object2 = list3;
                        Transformer transformer = this.mChart.getTransformer(iBarDataSet.getAxisDependency());
                        n = 0;
                        n2 = 0;
                        while (true) {
                            int n3;
                            Object object5;
                            object = object2;
                            list = list2;
                            f2 = f;
                            if (!((float)n < (float)iBarDataSet.getEntryCount() * this.mAnimator.getPhaseX())) break;
                            list3 = (BarEntry)iBarDataSet.getEntryForIndex(n);
                            int n4 = iBarDataSet.getValueTextColor(n);
                            list = (List)((BarEntry)((Object)list3)).getYVals();
                            if (list == null) {
                                object = this.mViewPortHandler;
                                object5 = ((BarBuffer)object4).buffer;
                                n3 = n2 + 1;
                                if (!((ViewPortHandler)object).isInBoundsTop((float)object5[n3])) {
                                    object = object2;
                                    list = list2;
                                    f2 = f;
                                    break;
                                }
                                if (!this.mViewPortHandler.isInBoundsX(((BarBuffer)object4).buffer[n2]) || !this.mViewPortHandler.isInBoundsBottom(((BarBuffer)object4).buffer[n3])) continue;
                                object = object3.getFormattedValue(((BarEntry)((Object)list3)).getY(), (Entry)((Object)list3), i, this.mViewPortHandler);
                                f3 = Utils.calcTextWidth(this.mValuePaint, (String)object);
                                var23_23 = bl ? (reference)f : (reference)(-(f3 + f));
                                f4 = bl ? -(f3 + f) : f;
                                f5 = (float)var23_23;
                                f2 = f4;
                                if (bl2) {
                                    f5 = (float)(-var23_23 - f3);
                                    f2 = -f4 - f3;
                                }
                                var23_23 = (reference)f5;
                                if (iBarDataSet.isDrawValuesEnabled()) {
                                    f5 = ((BarBuffer)object4).buffer[n2 + 2];
                                    f4 = ((BarEntry)((Object)list3)).getY() >= 0.0f ? (float)var23_23 : f2;
                                    this.drawValue(canvas, (String)object, f5 + f4, ((BarBuffer)object4).buffer[n3] + f6, n4);
                                }
                                if (((BaseEntry)((Object)list3)).getIcon() != null && iBarDataSet.isDrawIconsEnabled()) {
                                    object = ((BaseEntry)((Object)list3)).getIcon();
                                    f4 = ((BarBuffer)object4).buffer[n2 + 2];
                                    if (!(((BarEntry)((Object)list3)).getY() >= 0.0f)) {
                                        var23_23 = (reference)f2;
                                    }
                                    f5 = ((BarBuffer)object4).buffer[n3];
                                    f2 = ((MPPointF)object2).x;
                                    f3 = ((MPPointF)object2).y;
                                    Utils.drawImage(canvas, (Drawable)object, (int)(f4 + var23_23 + f2), (int)(f5 + f3), object.getIntrinsicWidth(), object.getIntrinsicHeight());
                                }
                            } else {
                                object5 = list;
                                int n5 = ((Object)object5).length * 2;
                                object = new float[n5];
                                f2 = -((BarEntry)((Object)list3)).getNegativeSum();
                                int n6 = 0;
                                n3 = 0;
                                var20_20 = (reference)0.0f;
                                while (n6 < n5) {
                                    var23_23 = object5[n3];
                                    reference cfr_temp_0 = var23_23 - 0.0f;
                                    Object object6 = cfr_temp_0 == 0 ? 0 : (cfr_temp_0 > 0 ? 1 : -1);
                                    if (object6 != false || var20_20 != 0.0f && f2 != 0.0f) {
                                        if (object6 >= 0) {
                                            var20_20 += var23_23;
                                            var23_23 = var20_20;
                                        } else {
                                            f4 = f2 - var23_23;
                                            var23_23 = (reference)f2;
                                            f2 = f4;
                                        }
                                    }
                                    object[n6] = var23_23 * f7;
                                    n6 += 2;
                                    ++n3;
                                }
                                transformer.pointValuesToPixel((float[])object);
                                n3 = n5;
                                for (n6 = 0; n6 < n3; n6 += 2) {
                                    Object object7 = object5[n6 / 2];
                                    String string2 = object3.getFormattedValue((float)object7, (Entry)((Object)list3), i, this.mViewPortHandler);
                                    float f8 = Utils.calcTextWidth(this.mValuePaint, string2);
                                    f4 = bl ? f : -(f8 + f);
                                    f5 = bl ? -(f8 + f) : f;
                                    f3 = f4;
                                    var23_23 = (reference)f5;
                                    if (bl2) {
                                        f3 = -f4 - f8;
                                        var23_23 = (reference)(-f5 - f8);
                                    }
                                    n5 = object7 == 0.0f && f2 == 0.0f && var20_20 > 0.0f || object7 < 0.0f ? 1 : 0;
                                    f4 = (float)object[n6];
                                    if (n5 != 0) {
                                        f3 = (float)var23_23;
                                    }
                                    f4 += f3;
                                    var23_23 = (reference)((((BarBuffer)object4).buffer[n2 + 1] + ((BarBuffer)object4).buffer[n2 + 3]) / 2.0f);
                                    if (!this.mViewPortHandler.isInBoundsTop((float)var23_23)) break;
                                    if (!this.mViewPortHandler.isInBoundsX(f4) || !this.mViewPortHandler.isInBoundsBottom((float)var23_23)) continue;
                                    if (iBarDataSet.isDrawValuesEnabled()) {
                                        this.drawValue(canvas, string2, f4, (float)(var23_23 + f6), n4);
                                    }
                                    if (((BaseEntry)((Object)list3)).getIcon() == null || !iBarDataSet.isDrawIconsEnabled()) continue;
                                    string2 = ((BaseEntry)((Object)list3)).getIcon();
                                    Utils.drawImage(canvas, (Drawable)string2, (int)(f4 + ((MPPointF)object2).x), (int)(var23_23 + ((MPPointF)object2).y), string2.getIntrinsicWidth(), string2.getIntrinsicHeight());
                                }
                            }
                            n2 = list == null ? (n2 += 4) : (n2 += ((List<T>)list).length * 4);
                            ++n;
                        }
                    }
                    MPPointF.recycleInstance(object);
                }
                f = f2;
            }
        }
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new HorizontalBarBuffer[barData.getDataSetCount()];
        for (int i = 0; i < this.mBarBuffers.length; ++i) {
            IBarDataSet iBarDataSet = (IBarDataSet)barData.getDataSetByIndex(i);
            BarBuffer[] barBufferArray = this.mBarBuffers;
            int n = iBarDataSet.getEntryCount();
            int n2 = iBarDataSet.isStacked() ? iBarDataSet.getStackSize() : 1;
            barBufferArray[i] = new HorizontalBarBuffer(n * 4 * n2, barData.getDataSetCount(), iBarDataSet.isStacked());
        }
    }

    @Override
    protected boolean isDrawingValuesAllowed(ChartInterface chartInterface) {
        boolean bl = (float)chartInterface.getData().getEntryCount() < (float)chartInterface.getMaxVisibleCount() * this.mViewPortHandler.getScaleY();
        return bl;
    }

    @Override
    protected void prepareBarHighlight(float f, float f2, float f3, float f4, Transformer transformer) {
        this.mBarRect.set(f2, f - f4, f3, f + f4);
        transformer.rectToPixelPhaseHorizontal(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    protected void setHighlightDrawPos(Highlight highlight, RectF rectF) {
        highlight.setDraw(rectF.centerY(), rectF.right);
    }
}

