/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.LineDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;

public class LineChartRenderer
extends LineRadarRenderer {
    protected Path cubicFillPath;
    protected Path cubicPath;
    protected Canvas mBitmapCanvas;
    protected Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    protected LineDataProvider mChart;
    protected Paint mCirclePaintInner;
    private float[] mCirclesBuffer;
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Path mGenerateFilledPathBuffer;
    private HashMap<IDataSet, DataSetImageCache> mImageCaches;
    private float[] mLineBuffer;

    public LineChartRenderer(LineDataProvider lineDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.cubicPath = new Path();
        this.cubicFillPath = new Path();
        this.mLineBuffer = new float[4];
        this.mGenerateFilledPathBuffer = new Path();
        this.mImageCaches = new HashMap();
        this.mCirclesBuffer = new float[2];
        this.mChart = lineDataProvider;
        lineDataProvider = new Paint(1);
        this.mCirclePaintInner = lineDataProvider;
        lineDataProvider.setStyle(Paint.Style.FILL);
        this.mCirclePaintInner.setColor(-1);
    }

    private void generateFilledPath(ILineDataSet iLineDataSet, int n, int n2, Path path) {
        float f = iLineDataSet.getFillFormatter().getFillLinePosition(iLineDataSet, this.mChart);
        float f2 = this.mAnimator.getPhaseY();
        boolean bl = iLineDataSet.getMode() == LineDataSet.Mode.STEPPED;
        path.reset();
        Object object = iLineDataSet.getEntryForIndex(n);
        path.moveTo(((Entry)object).getX(), f);
        path.lineTo(((Entry)object).getX(), ((BaseEntry)object).getY() * f2);
        Entry entry = null;
        ++n;
        while (n <= n2) {
            entry = (Entry)iLineDataSet.getEntryForIndex(n);
            if (bl) {
                path.lineTo(entry.getX(), ((BaseEntry)object).getY() * f2);
            }
            path.lineTo(entry.getX(), entry.getY() * f2);
            ++n;
            object = entry;
        }
        if (entry != null) {
            path.lineTo(entry.getX(), f);
        }
        path.close();
    }

    protected void drawCircles(Canvas canvas) {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        float f = this.mAnimator.getPhaseY();
        Object object = this.mCirclesBuffer;
        object[0] = 0.0f;
        object[1] = 0.0f;
        List list = this.mChart.getLineData().getDataSets();
        block0: for (int i = 0; i < list.size(); ++i) {
            Object object2;
            ILineDataSet iLineDataSet = (ILineDataSet)list.get(i);
            if (!iLineDataSet.isVisible() || !iLineDataSet.isDrawCirclesEnabled() || iLineDataSet.getEntryCount() == 0) continue;
            this.mCirclePaintInner.setColor(iLineDataSet.getCircleHoleColor());
            Transformer transformer = this.mChart.getTransformer(iLineDataSet.getAxisDependency());
            this.mXBounds.set(this.mChart, iLineDataSet);
            float f2 = iLineDataSet.getCircleRadius();
            float f3 = iLineDataSet.getCircleHoleRadius();
            boolean bl = iLineDataSet.isDrawCircleHoleEnabled() && f3 < f2 && f3 > 0.0f;
            boolean bl2 = bl && iLineDataSet.getCircleHoleColor() == 0x112233;
            if (this.mImageCaches.containsKey(iLineDataSet)) {
                object = this.mImageCaches.get(iLineDataSet);
            } else {
                object = new DataSetImageCache();
                this.mImageCaches.put(iLineDataSet, (DataSetImageCache)object);
            }
            if (((DataSetImageCache)object).init(iLineDataSet)) {
                ((DataSetImageCache)object).fill(iLineDataSet, bl, bl2);
            }
            int n = this.mXBounds.range;
            int n2 = this.mXBounds.min;
            for (int j = this.mXBounds.min; j <= n + n2 && (object2 = iLineDataSet.getEntryForIndex(j)) != null; ++j) {
                Bitmap bitmap;
                this.mCirclesBuffer[0] = ((Entry)object2).getX();
                this.mCirclesBuffer[1] = ((BaseEntry)object2).getY() * f;
                transformer.pointValuesToPixel(this.mCirclesBuffer);
                if (!this.mViewPortHandler.isInBoundsRight(this.mCirclesBuffer[0])) continue block0;
                if (!this.mViewPortHandler.isInBoundsLeft(this.mCirclesBuffer[0]) || !this.mViewPortHandler.isInBoundsY(this.mCirclesBuffer[1]) || (bitmap = ((DataSetImageCache)object).getBitmap(j)) == null) continue;
                object2 = this.mCirclesBuffer;
                canvas.drawBitmap(bitmap, (float)(object2[0] - f2), (float)(object2[1] - f2), null);
            }
        }
    }

    protected void drawCubicBezier(ILineDataSet iLineDataSet) {
        float f = this.mAnimator.getPhaseY();
        Transformer transformer = this.mChart.getTransformer(iLineDataSet.getAxisDependency());
        this.mXBounds.set(this.mChart, iLineDataSet);
        float f2 = iLineDataSet.getCubicIntensity();
        this.cubicPath.reset();
        if (this.mXBounds.range >= 1) {
            int n = this.mXBounds.min + 1;
            int n2 = this.mXBounds.min;
            n2 = this.mXBounds.range;
            Object t = iLineDataSet.getEntryForIndex(Math.max(n - 2, 0));
            Object t2 = iLineDataSet.getEntryForIndex(Math.max(n - 1, 0));
            int n3 = -1;
            if (t2 == null) {
                return;
            }
            this.cubicPath.moveTo(((Entry)t2).getX(), ((BaseEntry)t2).getY() * f);
            n = this.mXBounds.min + 1;
            Object t3 = t2;
            while (n <= this.mXBounds.range + this.mXBounds.min) {
                if (n3 != n) {
                    t2 = iLineDataSet.getEntryForIndex(n);
                }
                n2 = n + 1;
                if (n2 < iLineDataSet.getEntryCount()) {
                    n = n2;
                }
                Object t4 = iLineDataSet.getEntryForIndex(n);
                float f3 = ((Entry)t2).getX();
                float f4 = ((Entry)t).getX();
                float f5 = ((BaseEntry)t2).getY();
                float f6 = ((BaseEntry)t).getY();
                float f7 = ((Entry)t4).getX();
                float f8 = ((Entry)t3).getX();
                float f9 = ((BaseEntry)t4).getY();
                float f10 = ((BaseEntry)t3).getY();
                this.cubicPath.cubicTo(((Entry)t3).getX() + (f3 - f4) * f2, (((BaseEntry)t3).getY() + (f5 - f6) * f2) * f, ((Entry)t2).getX() - (f7 - f8) * f2, (((BaseEntry)t2).getY() - (f9 - f10) * f2) * f, ((Entry)t2).getX(), ((BaseEntry)t2).getY() * f);
                t = t3;
                t3 = t2;
                t2 = t4;
                n3 = n;
                n = n2;
            }
        }
        if (iLineDataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            this.drawCubicFill(this.mBitmapCanvas, iLineDataSet, this.cubicFillPath, transformer, this.mXBounds);
        }
        this.mRenderPaint.setColor(iLineDataSet.getColor());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        transformer.pathValueToPixel(this.cubicPath);
        this.mBitmapCanvas.drawPath(this.cubicPath, this.mRenderPaint);
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubicFill(Canvas canvas, ILineDataSet iLineDataSet, Path path, Transformer transformer, BarLineScatterCandleBubbleRenderer.XBounds xBounds) {
        float f = iLineDataSet.getFillFormatter().getFillLinePosition(iLineDataSet, this.mChart);
        path.lineTo(((Entry)iLineDataSet.getEntryForIndex(xBounds.min + xBounds.range)).getX(), f);
        path.lineTo(((Entry)iLineDataSet.getEntryForIndex(xBounds.min)).getX(), f);
        path.close();
        transformer.pathValueToPixel(path);
        transformer = iLineDataSet.getFillDrawable();
        if (transformer != null) {
            this.drawFilledPath(canvas, path, (Drawable)transformer);
        } else {
            this.drawFilledPath(canvas, path, iLineDataSet.getFillColor(), iLineDataSet.getFillAlpha());
        }
    }

    @Override
    public void drawData(Canvas canvas) {
        block5: {
            Bitmap bitmap;
            block4: {
                int n;
                int n2;
                block3: {
                    n2 = (int)this.mViewPortHandler.getChartWidth();
                    n = (int)this.mViewPortHandler.getChartHeight();
                    Object object = this.mDrawBitmap;
                    object = object == null ? null : (Bitmap)((Reference)object).get();
                    if (object == null || object.getWidth() != n2) break block3;
                    bitmap = object;
                    if (object.getHeight() == n) break block4;
                }
                if (n2 <= 0 || n <= 0) break block5;
                bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)this.mBitmapConfig);
                this.mDrawBitmap = new WeakReference<Bitmap>(bitmap);
                this.mBitmapCanvas = new Canvas(bitmap);
            }
            bitmap.eraseColor(0);
            for (ILineDataSet iLineDataSet : this.mChart.getLineData().getDataSets()) {
                if (!iLineDataSet.isVisible()) continue;
                this.drawDataSet(canvas, iLineDataSet);
            }
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mRenderPaint);
        }
    }

    protected void drawDataSet(Canvas canvas, ILineDataSet iLineDataSet) {
        if (iLineDataSet.getEntryCount() < 1) {
            return;
        }
        this.mRenderPaint.setStrokeWidth(iLineDataSet.getLineWidth());
        this.mRenderPaint.setPathEffect((PathEffect)iLineDataSet.getDashPathEffect());
        int n = 1.$SwitchMap$com$github$mikephil$charting$data$LineDataSet$Mode[iLineDataSet.getMode().ordinal()];
        if (n != 3) {
            if (n != 4) {
                this.drawLinear(canvas, iLineDataSet);
            } else {
                this.drawHorizontalBezier(iLineDataSet);
            }
        } else {
            this.drawCubicBezier(iLineDataSet);
        }
        this.mRenderPaint.setPathEffect(null);
    }

    @Override
    public void drawExtras(Canvas canvas) {
        this.drawCircles(canvas);
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        LineData lineData = this.mChart.getLineData();
        for (Highlight highlight : highlightArray) {
            Object object;
            ILineDataSet iLineDataSet = (ILineDataSet)lineData.getDataSetByIndex(highlight.getDataSetIndex());
            if (iLineDataSet == null || !iLineDataSet.isHighlightEnabled() || !this.isInBoundsX((Entry)(object = iLineDataSet.getEntryForXValue(highlight.getX(), highlight.getY())), iLineDataSet)) continue;
            object = this.mChart.getTransformer(iLineDataSet.getAxisDependency()).getPixelForValues(((Entry)object).getX(), ((BaseEntry)object).getY() * this.mAnimator.getPhaseY());
            highlight.setDraw((float)((MPPointD)object).x, (float)((MPPointD)object).y);
            this.drawHighlightLines(canvas, (float)((MPPointD)object).x, (float)((MPPointD)object).y, iLineDataSet);
        }
    }

    protected void drawHorizontalBezier(ILineDataSet iLineDataSet) {
        float f = this.mAnimator.getPhaseY();
        Transformer transformer = this.mChart.getTransformer(iLineDataSet.getAxisDependency());
        this.mXBounds.set(this.mChart, iLineDataSet);
        this.cubicPath.reset();
        if (this.mXBounds.range >= 1) {
            Object t = iLineDataSet.getEntryForIndex(this.mXBounds.min);
            this.cubicPath.moveTo(((Entry)t).getX(), ((BaseEntry)t).getY() * f);
            for (int i = this.mXBounds.min + 1; i <= this.mXBounds.range + this.mXBounds.min; ++i) {
                Object t2 = iLineDataSet.getEntryForIndex(i);
                float f2 = ((Entry)t).getX() + (((Entry)t2).getX() - ((Entry)t).getX()) / 2.0f;
                this.cubicPath.cubicTo(f2, ((BaseEntry)t).getY() * f, f2, ((BaseEntry)t2).getY() * f, ((Entry)t2).getX(), ((BaseEntry)t2).getY() * f);
                t = t2;
            }
        }
        if (iLineDataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            this.drawCubicFill(this.mBitmapCanvas, iLineDataSet, this.cubicFillPath, transformer, this.mXBounds);
        }
        this.mRenderPaint.setColor(iLineDataSet.getColor());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        transformer.pathValueToPixel(this.cubicPath);
        this.mBitmapCanvas.drawPath(this.cubicPath, this.mRenderPaint);
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawLinear(Canvas object, ILineDataSet iLineDataSet) {
        int n = iLineDataSet.getEntryCount();
        boolean bl = iLineDataSet.isDrawSteppedEnabled();
        int n2 = bl ? 4 : 2;
        Transformer transformer = this.mChart.getTransformer(iLineDataSet.getAxisDependency());
        float f = this.mAnimator.getPhaseY();
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        Object object2 = iLineDataSet.isDashedLineEnabled() ? this.mBitmapCanvas : object;
        this.mXBounds.set(this.mChart, iLineDataSet);
        if (iLineDataSet.isDrawFilledEnabled() && n > 0) {
            this.drawLinearFill((Canvas)object, iLineDataSet, transformer, this.mXBounds);
        }
        if (iLineDataSet.getColors().size() > 1) {
            n = n2 * 2;
            if (this.mLineBuffer.length <= n) {
                this.mLineBuffer = new float[n * 2];
            }
            int n3 = this.mXBounds.min;
            int n4 = this.mXBounds.range;
            for (n2 = this.mXBounds.min; n2 < n3 + n4; ++n2) {
                object = iLineDataSet.getEntryForIndex(n2);
                if (object == null) continue;
                this.mLineBuffer[0] = object.getX();
                this.mLineBuffer[1] = object.getY() * f;
                if (n2 < this.mXBounds.max) {
                    object = iLineDataSet.getEntryForIndex(n2 + 1);
                    if (object == null) break;
                    if (bl) {
                        this.mLineBuffer[2] = object.getX();
                        float[] fArray = this.mLineBuffer;
                        fArray[3] = fArray[1];
                        fArray[4] = fArray[2];
                        fArray[5] = fArray[3];
                        fArray[6] = object.getX();
                        this.mLineBuffer[7] = object.getY() * f;
                    } else {
                        this.mLineBuffer[2] = object.getX();
                        this.mLineBuffer[3] = object.getY() * f;
                    }
                } else {
                    object = this.mLineBuffer;
                    object[2] = object[0];
                    object[3] = object[1];
                }
                object = this.mLineBuffer;
                Object object3 = object[0];
                Object object4 = object[1];
                Object object5 = object[n - 2];
                Object object6 = object[n - 1];
                if (object3 == object5 && object4 == object6) continue;
                transformer.pointValuesToPixel((float[])object);
                if (this.mViewPortHandler.isInBoundsRight((float)object3)) {
                    if (!this.mViewPortHandler.isInBoundsLeft((float)object5) || !this.mViewPortHandler.isInBoundsTop(Math.max((float)object4, (float)object6)) || !this.mViewPortHandler.isInBoundsBottom(Math.min((float)object4, (float)object6))) continue;
                    this.mRenderPaint.setColor(iLineDataSet.getColor(n2));
                    object2.drawLines(this.mLineBuffer, 0, n, this.mRenderPaint);
                    continue;
                }
                break;
            }
        } else {
            int n5 = this.mLineBuffer.length;
            if (n5 < Math.max(n *= n2, n2) * 2) {
                this.mLineBuffer = new float[Math.max(n, n2) * 4];
            }
            if (iLineDataSet.getEntryForIndex(this.mXBounds.min) != null) {
                n5 = 0;
                for (n = this.mXBounds.min; n <= this.mXBounds.range + this.mXBounds.min; ++n) {
                    int n6 = n == 0 ? 0 : n - 1;
                    Object object7 = iLineDataSet.getEntryForIndex(n6);
                    object = iLineDataSet.getEntryForIndex(n);
                    n6 = n5;
                    if (object7 != null) {
                        if (object == null) {
                            n6 = n5;
                        } else {
                            float[] fArray = this.mLineBuffer;
                            int n7 = n5 + 1;
                            fArray[n5] = ((Entry)object7).getX();
                            fArray = this.mLineBuffer;
                            n6 = n7 + 1;
                            fArray[n7] = ((BaseEntry)object7).getY() * f;
                            n5 = n6;
                            if (bl) {
                                fArray = this.mLineBuffer;
                                n7 = n6 + 1;
                                fArray[n6] = object.getX();
                                fArray = this.mLineBuffer;
                                n5 = n7 + 1;
                                fArray[n7] = ((BaseEntry)object7).getY() * f;
                                fArray = this.mLineBuffer;
                                n6 = n5 + 1;
                                fArray[n5] = object.getX();
                                fArray = this.mLineBuffer;
                                n5 = n6 + 1;
                                fArray[n6] = ((BaseEntry)object7).getY() * f;
                            }
                            object7 = this.mLineBuffer;
                            n6 = n5 + 1;
                            object7[n5] = object.getX();
                            this.mLineBuffer[n6] = object.getY() * f;
                            ++n6;
                        }
                    }
                    n5 = n6;
                }
                if (n5 > 0) {
                    transformer.pointValuesToPixel(this.mLineBuffer);
                    n2 = Math.max((this.mXBounds.range + 1) * n2, n2);
                    this.mRenderPaint.setColor(iLineDataSet.getColor());
                    object2.drawLines(this.mLineBuffer, 0, n2 * 2, this.mRenderPaint);
                }
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawLinearFill(Canvas canvas, ILineDataSet iLineDataSet, Transformer transformer, BarLineScatterCandleBubbleRenderer.XBounds xBounds) {
        int n;
        int n2;
        Path path = this.mGenerateFilledPathBuffer;
        int n3 = xBounds.min;
        int n4 = xBounds.range + xBounds.min;
        int n5 = 0;
        do {
            int n6;
            n2 = n5 * 128 + n3;
            n = n6 = n2 + 128;
            if (n6 > n4) {
                n = n4;
            }
            if (n2 <= n) {
                this.generateFilledPath(iLineDataSet, n2, n, path);
                transformer.pathValueToPixel(path);
                xBounds = iLineDataSet.getFillDrawable();
                if (xBounds != null) {
                    this.drawFilledPath(canvas, path, (Drawable)xBounds);
                } else {
                    this.drawFilledPath(canvas, path, iLineDataSet.getFillColor(), iLineDataSet.getFillAlpha());
                }
            }
            ++n5;
        } while (n2 <= n);
    }

    @Override
    public void drawValues(Canvas canvas) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List list = this.mChart.getLineData().getDataSets();
            for (int i = 0; i < list.size(); ++i) {
                int n;
                ILineDataSet iLineDataSet = (ILineDataSet)list.get(i);
                if (!this.shouldDrawValues(iLineDataSet) || iLineDataSet.getEntryCount() < 1) continue;
                this.applyValueTextStyle(iLineDataSet);
                Object object = this.mChart.getTransformer(iLineDataSet.getAxisDependency());
                int n2 = n = (int)(iLineDataSet.getCircleRadius() * 1.75f);
                if (!iLineDataSet.isDrawCirclesEnabled()) {
                    n2 = n / 2;
                }
                this.mXBounds.set(this.mChart, iLineDataSet);
                float[] fArray = ((Transformer)object).generateTransformedValuesLine(iLineDataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), this.mXBounds.min, this.mXBounds.max);
                object = MPPointF.getInstance(iLineDataSet.getIconsOffset());
                ((MPPointF)object).x = Utils.convertDpToPixel(((MPPointF)object).x);
                ((MPPointF)object).y = Utils.convertDpToPixel(((MPPointF)object).y);
                for (n = 0; n < fArray.length; n += 2) {
                    float f = fArray[n];
                    float f2 = fArray[n + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(f)) break;
                    if (!this.mViewPortHandler.isInBoundsLeft(f) || !this.mViewPortHandler.isInBoundsY(f2)) continue;
                    int n3 = n / 2;
                    Object object2 = iLineDataSet.getEntryForIndex(this.mXBounds.min + n3);
                    if (iLineDataSet.isDrawValuesEnabled()) {
                        this.drawValue(canvas, iLineDataSet.getValueFormatter(), ((BaseEntry)object2).getY(), (Entry)object2, i, f, f2 - (float)n2, iLineDataSet.getValueTextColor(n3));
                    }
                    Object object3 = object;
                    if (((BaseEntry)object2).getIcon() == null || !iLineDataSet.isDrawIconsEnabled()) continue;
                    object2 = ((BaseEntry)object2).getIcon();
                    Utils.drawImage(canvas, object2, (int)(f + ((MPPointF)object3).x), (int)(f2 + ((MPPointF)object3).y), object2.getIntrinsicWidth(), object2.getIntrinsicHeight());
                }
                MPPointF.recycleInstance((MPPointF)object);
            }
        }
    }

    public Bitmap.Config getBitmapConfig() {
        return this.mBitmapConfig;
    }

    @Override
    public void initBuffers() {
    }

    public void releaseBitmap() {
        Object object = this.mBitmapCanvas;
        if (object != null) {
            object.setBitmap(null);
            this.mBitmapCanvas = null;
        }
        if ((object = this.mDrawBitmap) != null) {
            if ((object = (Bitmap)((Reference)object).get()) != null) {
                object.recycle();
            }
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }

    public void setBitmapConfig(Bitmap.Config config) {
        this.mBitmapConfig = config;
        this.releaseBitmap();
    }

    private class DataSetImageCache {
        private Bitmap[] circleBitmaps;
        private Path mCirclePathBuffer = new Path();

        private DataSetImageCache() {
        }

        protected void fill(ILineDataSet iLineDataSet, boolean bl, boolean bl2) {
            int n = iLineDataSet.getCircleColorCount();
            float f = iLineDataSet.getCircleRadius();
            float f2 = iLineDataSet.getCircleHoleRadius();
            for (int i = 0; i < n; ++i) {
                Bitmap.Config config = Bitmap.Config.ARGB_4444;
                int n2 = (int)((double)f * 2.1);
                config = Bitmap.createBitmap((int)n2, (int)n2, (Bitmap.Config)config);
                Canvas canvas = new Canvas((Bitmap)config);
                this.circleBitmaps[i] = config;
                LineChartRenderer.this.mRenderPaint.setColor(iLineDataSet.getCircleColor(i));
                if (bl2) {
                    this.mCirclePathBuffer.reset();
                    this.mCirclePathBuffer.addCircle(f, f, f, Path.Direction.CW);
                    this.mCirclePathBuffer.addCircle(f, f, f2, Path.Direction.CCW);
                    canvas.drawPath(this.mCirclePathBuffer, LineChartRenderer.this.mRenderPaint);
                    continue;
                }
                canvas.drawCircle(f, f, f, LineChartRenderer.this.mRenderPaint);
                if (!bl) continue;
                canvas.drawCircle(f, f, f2, LineChartRenderer.this.mCirclePaintInner);
            }
        }

        protected Bitmap getBitmap(int n) {
            Bitmap[] bitmapArray = this.circleBitmaps;
            return bitmapArray[n % bitmapArray.length];
        }

        protected boolean init(ILineDataSet bitmapArray) {
            int n = bitmapArray.getCircleColorCount();
            bitmapArray = this.circleBitmaps;
            boolean bl = true;
            if (bitmapArray == null) {
                this.circleBitmaps = new Bitmap[n];
            } else if (bitmapArray.length != n) {
                this.circleBitmaps = new Bitmap[n];
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

