/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.renderer.AxisRenderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class XAxisRenderer
extends AxisRenderer {
    protected RectF mGridClippingRect;
    protected RectF mLimitLineClippingRect;
    private Path mLimitLinePath;
    float[] mLimitLineSegmentsBuffer;
    protected float[] mRenderGridLinesBuffer;
    protected Path mRenderGridLinesPath = new Path();
    protected float[] mRenderLimitLinesBuffer;
    protected XAxis mXAxis;

    public XAxisRenderer(ViewPortHandler viewPortHandler, XAxis xAxis, Transformer transformer) {
        super(viewPortHandler, transformer, xAxis);
        this.mRenderGridLinesBuffer = new float[2];
        this.mGridClippingRect = new RectF();
        this.mRenderLimitLinesBuffer = new float[2];
        this.mLimitLineClippingRect = new RectF();
        this.mLimitLineSegmentsBuffer = new float[4];
        this.mLimitLinePath = new Path();
        this.mXAxis = xAxis;
        this.mAxisLabelPaint.setColor(-16777216);
        this.mAxisLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mAxisLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
    }

    @Override
    public void computeAxis(float f, float f2, boolean bl) {
        float f3 = f;
        float f4 = f2;
        if (this.mViewPortHandler.contentWidth() > 10.0f) {
            f3 = f;
            f4 = f2;
            if (!this.mViewPortHandler.isFullyZoomedOutX()) {
                double d;
                MPPointD mPPointD = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop());
                MPPointD mPPointD2 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop());
                if (bl) {
                    f = (float)mPPointD2.x;
                    d = mPPointD.x;
                } else {
                    f = (float)mPPointD.x;
                    d = mPPointD2.x;
                }
                f4 = (float)d;
                MPPointD.recycleInstance(mPPointD);
                MPPointD.recycleInstance(mPPointD2);
                f3 = f;
            }
        }
        this.computeAxisValues(f3, f4);
    }

    @Override
    protected void computeAxisValues(float f, float f2) {
        super.computeAxisValues(f, f2);
        this.computeSize();
    }

    protected void computeSize() {
        Object object = this.mXAxis.getLongestLabel();
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        FSize fSize = Utils.calcTextSize(this.mAxisLabelPaint, (String)object);
        float f = fSize.width;
        float f2 = Utils.calcTextHeight(this.mAxisLabelPaint, "Q");
        object = Utils.getSizeOfRotatedRectangleByDegrees(f, f2, this.mXAxis.getLabelRotationAngle());
        this.mXAxis.mLabelWidth = Math.round(f);
        this.mXAxis.mLabelHeight = Math.round(f2);
        this.mXAxis.mLabelRotatedWidth = Math.round(((FSize)object).width);
        this.mXAxis.mLabelRotatedHeight = Math.round(((FSize)object).height);
        FSize.recycleInstance((FSize)object);
        FSize.recycleInstance(fSize);
    }

    protected void drawGridLine(Canvas canvas, float f, float f2, Path path) {
        path.moveTo(f, this.mViewPortHandler.contentBottom());
        path.lineTo(f, this.mViewPortHandler.contentTop());
        canvas.drawPath(path, this.mGridPaint);
        path.reset();
    }

    protected void drawLabel(Canvas canvas, String string2, float f, float f2, MPPointF mPPointF, float f3) {
        Utils.drawXAxisValue(canvas, string2, f, f2, this.mAxisLabelPaint, mPPointF, f3);
    }

    protected void drawLabels(Canvas canvas, float f, MPPointF mPPointF) {
        int n;
        float f2 = this.mXAxis.getLabelRotationAngle();
        boolean bl = this.mXAxis.isCenterAxisLabelsEnabled();
        int n2 = this.mXAxis.mEntryCount * 2;
        float[] fArray = new float[n2];
        for (n = 0; n < n2; n += 2) {
            fArray[n] = bl ? this.mXAxis.mCenteredEntries[n / 2] : this.mXAxis.mEntries[n / 2];
        }
        this.mTrans.pointValuesToPixel(fArray);
        for (n = 0; n < n2; n += 2) {
            float f3 = fArray[n];
            if (!this.mViewPortHandler.isInBoundsX(f3)) continue;
            Object object = this.mXAxis.getValueFormatter();
            float[] fArray2 = this.mXAxis.mEntries;
            int n3 = n / 2;
            object = object.getFormattedValue(fArray2[n3], this.mXAxis);
            float f4 = f3;
            if (this.mXAxis.isAvoidFirstLastClippingEnabled()) {
                if (n3 == this.mXAxis.mEntryCount - 1 && this.mXAxis.mEntryCount > 1) {
                    float f5 = Utils.calcTextWidth(this.mAxisLabelPaint, (String)object);
                    f4 = f3;
                    if (f5 > this.mViewPortHandler.offsetRight() * 2.0f) {
                        f4 = f3;
                        if (f3 + f5 > this.mViewPortHandler.getChartWidth()) {
                            f4 = f3 - f5 / 2.0f;
                        }
                    }
                } else {
                    f4 = f3;
                    if (n == 0) {
                        f4 = f3 + (float)Utils.calcTextWidth(this.mAxisLabelPaint, (String)object) / 2.0f;
                    }
                }
            }
            this.drawLabel(canvas, (String)object, f4, f, mPPointF, f2);
        }
    }

    public RectF getGridClippingRect() {
        this.mGridClippingRect.set(this.mViewPortHandler.getContentRect());
        this.mGridClippingRect.inset(-this.mAxis.getGridLineWidth(), 0.0f);
        return this.mGridClippingRect;
    }

    @Override
    public void renderAxisLabels(Canvas canvas) {
        if (this.mXAxis.isEnabled() && this.mXAxis.isDrawLabelsEnabled()) {
            float f = this.mXAxis.getYOffset();
            this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
            this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
            this.mAxisLabelPaint.setColor(this.mXAxis.getTextColor());
            MPPointF mPPointF = MPPointF.getInstance(0.0f, 0.0f);
            if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
                mPPointF.x = 0.5f;
                mPPointF.y = 1.0f;
                this.drawLabels(canvas, this.mViewPortHandler.contentTop() - f, mPPointF);
            } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE) {
                mPPointF.x = 0.5f;
                mPPointF.y = 1.0f;
                this.drawLabels(canvas, this.mViewPortHandler.contentTop() + f + (float)this.mXAxis.mLabelRotatedHeight, mPPointF);
            } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
                mPPointF.x = 0.5f;
                mPPointF.y = 0.0f;
                this.drawLabels(canvas, this.mViewPortHandler.contentBottom() + f, mPPointF);
            } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE) {
                mPPointF.x = 0.5f;
                mPPointF.y = 0.0f;
                this.drawLabels(canvas, this.mViewPortHandler.contentBottom() - f - (float)this.mXAxis.mLabelRotatedHeight, mPPointF);
            } else {
                mPPointF.x = 0.5f;
                mPPointF.y = 1.0f;
                this.drawLabels(canvas, this.mViewPortHandler.contentTop() - f, mPPointF);
                mPPointF.x = 0.5f;
                mPPointF.y = 0.0f;
                this.drawLabels(canvas, this.mViewPortHandler.contentBottom() + f, mPPointF);
            }
            MPPointF.recycleInstance(mPPointF);
        }
    }

    @Override
    public void renderAxisLine(Canvas canvas) {
        if (this.mXAxis.isDrawAxisLineEnabled() && this.mXAxis.isEnabled()) {
            this.mAxisLinePaint.setColor(this.mXAxis.getAxisLineColor());
            this.mAxisLinePaint.setStrokeWidth(this.mXAxis.getAxisLineWidth());
            this.mAxisLinePaint.setPathEffect((PathEffect)this.mXAxis.getAxisLineDashPathEffect());
            if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP || this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
                canvas.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mAxisLinePaint);
            }
            if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
                canvas.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
            }
        }
    }

    @Override
    public void renderGridLines(Canvas canvas) {
        if (this.mXAxis.isDrawGridLinesEnabled() && this.mXAxis.isEnabled()) {
            Object object;
            int n;
            int n2 = canvas.save();
            canvas.clipRect(this.getGridClippingRect());
            if (this.mRenderGridLinesBuffer.length != this.mAxis.mEntryCount * 2) {
                this.mRenderGridLinesBuffer = new float[this.mXAxis.mEntryCount * 2];
            }
            float[] fArray = this.mRenderGridLinesBuffer;
            int n3 = 0;
            for (n = 0; n < fArray.length; n += 2) {
                object = this.mXAxis.mEntries;
                int n4 = n / 2;
                fArray[n] = object[n4];
                fArray[n + 1] = this.mXAxis.mEntries[n4];
            }
            this.mTrans.pointValuesToPixel(fArray);
            this.setupGridPaint();
            object = this.mRenderGridLinesPath;
            object.reset();
            for (n = n3; n < fArray.length; n += 2) {
                this.drawGridLine(canvas, fArray[n], fArray[n + 1], (Path)object);
            }
            canvas.restoreToCount(n2);
        }
    }

    public void renderLimitLineLabel(Canvas canvas, LimitLine object, float[] fArray, float f) {
        String string2 = object.getLabel();
        if (string2 != null && !string2.equals("")) {
            this.mLimitLinePaint.setStyle(object.getTextStyle());
            this.mLimitLinePaint.setPathEffect(null);
            this.mLimitLinePaint.setColor(object.getTextColor());
            this.mLimitLinePaint.setStrokeWidth(0.5f);
            this.mLimitLinePaint.setTextSize(object.getTextSize());
            float f2 = object.getLineWidth() + object.getXOffset();
            object = object.getLabelPosition();
            if (object == LimitLine.LimitLabelPosition.RIGHT_TOP) {
                float f3 = Utils.calcTextHeight(this.mLimitLinePaint, string2);
                this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                canvas.drawText(string2, fArray[0] + f2, this.mViewPortHandler.contentTop() + f + f3, this.mLimitLinePaint);
            } else if (object == LimitLine.LimitLabelPosition.RIGHT_BOTTOM) {
                this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                canvas.drawText(string2, fArray[0] + f2, this.mViewPortHandler.contentBottom() - f, this.mLimitLinePaint);
            } else if (object == LimitLine.LimitLabelPosition.LEFT_TOP) {
                this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                float f4 = Utils.calcTextHeight(this.mLimitLinePaint, string2);
                canvas.drawText(string2, fArray[0] - f2, this.mViewPortHandler.contentTop() + f + f4, this.mLimitLinePaint);
            } else {
                this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                canvas.drawText(string2, fArray[0] - f2, this.mViewPortHandler.contentBottom() - f, this.mLimitLinePaint);
            }
        }
    }

    public void renderLimitLineLine(Canvas canvas, LimitLine limitLine, float[] object) {
        float[] fArray = this.mLimitLineSegmentsBuffer;
        fArray[0] = object[0];
        fArray[1] = this.mViewPortHandler.contentTop();
        fArray = this.mLimitLineSegmentsBuffer;
        fArray[2] = object[0];
        fArray[3] = this.mViewPortHandler.contentBottom();
        this.mLimitLinePath.reset();
        object = this.mLimitLinePath;
        fArray = this.mLimitLineSegmentsBuffer;
        object.moveTo(fArray[0], fArray[1]);
        object = this.mLimitLinePath;
        fArray = this.mLimitLineSegmentsBuffer;
        object.lineTo(fArray[2], fArray[3]);
        this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
        this.mLimitLinePaint.setColor(limitLine.getLineColor());
        this.mLimitLinePaint.setStrokeWidth(limitLine.getLineWidth());
        this.mLimitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
        canvas.drawPath(this.mLimitLinePath, this.mLimitLinePaint);
    }

    @Override
    public void renderLimitLines(Canvas canvas) {
        List<LimitLine> list = this.mXAxis.getLimitLines();
        if (list != null && list.size() > 0) {
            float[] fArray = this.mRenderLimitLinesBuffer;
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            for (int i = 0; i < list.size(); ++i) {
                LimitLine limitLine = list.get(i);
                if (!limitLine.isEnabled()) continue;
                int n = canvas.save();
                this.mLimitLineClippingRect.set(this.mViewPortHandler.getContentRect());
                this.mLimitLineClippingRect.inset(-limitLine.getLineWidth(), 0.0f);
                canvas.clipRect(this.mLimitLineClippingRect);
                fArray[0] = limitLine.getLimit();
                fArray[1] = 0.0f;
                this.mTrans.pointValuesToPixel(fArray);
                this.renderLimitLineLine(canvas, limitLine, fArray);
                this.renderLimitLineLabel(canvas, limitLine, fArray, limitLine.getYOffset() + 2.0f);
                canvas.restoreToCount(n);
            }
        }
    }

    protected void setupGridPaint() {
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        this.mGridPaint.setPathEffect((PathEffect)this.mXAxis.getGridDashPathEffect());
    }
}

