/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class YAxisRendererRadarChart
extends YAxisRenderer {
    private RadarChart mChart;
    private Path mRenderLimitLinesPathBuffer = new Path();

    public YAxisRendererRadarChart(ViewPortHandler viewPortHandler, YAxis yAxis, RadarChart radarChart) {
        super(viewPortHandler, yAxis, null);
        this.mChart = radarChart;
    }

    @Override
    protected void computeAxisValues(float f, float f2) {
        int n = this.mAxis.getLabelCount();
        double d = Math.abs(f2 - f);
        if (n != 0 && !(d <= 0.0) && !Double.isInfinite(d)) {
            double d2;
            int n2;
            double d3;
            double d4 = d3 = (double)Utils.roundToNextSignificant(d / (double)n);
            if (this.mAxis.isGranularityEnabled()) {
                d4 = d3;
                if (d3 < (double)this.mAxis.getGranularity()) {
                    d4 = this.mAxis.getGranularity();
                }
            }
            d3 = Utils.roundToNextSignificant(Math.pow(10.0, (int)Math.log10(d4)));
            double d5 = d4;
            if ((int)(d4 / d3) > 5) {
                d5 = Math.floor(d3 *= 10.0) == 0.0 ? d4 : Math.floor(d3);
            }
            int n3 = this.mAxis.isCenterAxisLabelsEnabled();
            if (this.mAxis.isForceLabelsEnabled()) {
                f2 = (float)d / (float)(n - 1);
                this.mAxis.mEntryCount = n;
                if (this.mAxis.mEntries.length < n) {
                    this.mAxis.mEntries = new float[n];
                }
                n2 = 0;
                while (true) {
                    d2 = n;
                    if (n2 < n) {
                        this.mAxis.mEntries[n2] = f;
                        f += f2;
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else {
                double d6 = d5 - 0.0;
                d2 = d6 == 0.0 ? 0 : (d6 > 0.0 ? 1 : -1);
                d3 = d2 == false ? 0.0 : Math.ceil((double)f / d5) * d5;
                d4 = d3;
                if (n3 != 0) {
                    d4 = d3 - d5;
                }
                d3 = d2 == false ? 0.0 : Utils.nextUp(Math.floor((double)f2 / d5) * d5);
                if (d2 != false) {
                    d2 = n3;
                    d = d4;
                    while (true) {
                        n2 = (int)d2;
                        if (d <= d3) {
                            ++d2;
                            d += d5;
                            continue;
                        }
                        break;
                    }
                } else {
                    n2 = n3;
                }
                this.mAxis.mEntryCount = n = n2 + 1;
                if (this.mAxis.mEntries.length < n) {
                    this.mAxis.mEntries = new float[n];
                }
                n2 = 0;
                while (true) {
                    d2 = n;
                    if (n2 >= n) break;
                    d3 = d4;
                    if (d4 == 0.0) {
                        d3 = 0.0;
                    }
                    this.mAxis.mEntries[n2] = (float)d3;
                    d4 = d3 + d5;
                    ++n2;
                }
            }
            this.mAxis.mDecimals = d5 < 1.0 ? (int)Math.ceil(-Math.log10(d5)) : 0;
            if (n3 != 0) {
                if (this.mAxis.mCenteredEntries.length < d2) {
                    this.mAxis.mCenteredEntries = new float[d2];
                }
                f = (this.mAxis.mEntries[1] - this.mAxis.mEntries[0]) / 2.0f;
                for (n3 = 0; n3 < d2; ++n3) {
                    this.mAxis.mCenteredEntries[n3] = this.mAxis.mEntries[n3] + f;
                }
            }
            this.mAxis.mAxisMinimum = this.mAxis.mEntries[0];
            this.mAxis.mAxisMaximum = this.mAxis.mEntries[d2 - true];
            this.mAxis.mAxisRange = Math.abs(this.mAxis.mAxisMaximum - this.mAxis.mAxisMinimum);
            return;
        }
        this.mAxis.mEntries = new float[0];
        this.mAxis.mCenteredEntries = new float[0];
        this.mAxis.mEntryCount = 0;
    }

    @Override
    public void renderAxisLabels(Canvas canvas) {
        if (this.mYAxis.isEnabled() && this.mYAxis.isDrawLabelsEnabled()) {
            this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
            this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
            this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
            MPPointF mPPointF = this.mChart.getCenterOffsets();
            MPPointF mPPointF2 = MPPointF.getInstance(0.0f, 0.0f);
            float f = this.mChart.getFactor();
            int n = this.mYAxis.isDrawTopYLabelEntryEnabled() ? this.mYAxis.mEntryCount : this.mYAxis.mEntryCount - 1;
            float f2 = this.mYAxis.getLabelXOffset();
            for (int i = this.mYAxis.isDrawBottomYLabelEntryEnabled() ^ 1; i < n; ++i) {
                Utils.getPosition(mPPointF, (this.mYAxis.mEntries[i] - this.mYAxis.mAxisMinimum) * f, this.mChart.getRotationAngle(), mPPointF2);
                canvas.drawText(this.mYAxis.getFormattedLabel(i), mPPointF2.x + f2, mPPointF2.y, this.mAxisLabelPaint);
            }
            MPPointF.recycleInstance(mPPointF);
            MPPointF.recycleInstance(mPPointF2);
        }
    }

    @Override
    public void renderLimitLines(Canvas canvas) {
        List<LimitLine> list = this.mYAxis.getLimitLines();
        if (list == null) {
            return;
        }
        float f = this.mChart.getSliceAngle();
        float f2 = this.mChart.getFactor();
        MPPointF mPPointF = this.mChart.getCenterOffsets();
        MPPointF mPPointF2 = MPPointF.getInstance(0.0f, 0.0f);
        for (int i = 0; i < list.size(); ++i) {
            LimitLine limitLine = list.get(i);
            if (!limitLine.isEnabled()) continue;
            this.mLimitLinePaint.setColor(limitLine.getLineColor());
            this.mLimitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
            this.mLimitLinePaint.setStrokeWidth(limitLine.getLineWidth());
            float f3 = limitLine.getLimit();
            float f4 = this.mChart.getYChartMin();
            limitLine = this.mRenderLimitLinesPathBuffer;
            limitLine.reset();
            for (int j = 0; j < ((IRadarDataSet)((RadarData)this.mChart.getData()).getMaxEntryCountSet()).getEntryCount(); ++j) {
                Utils.getPosition(mPPointF, (f3 - f4) * f2, (float)j * f + this.mChart.getRotationAngle(), mPPointF2);
                if (j == 0) {
                    limitLine.moveTo(mPPointF2.x, mPPointF2.y);
                    continue;
                }
                limitLine.lineTo(mPPointF2.x, mPPointF2.y);
            }
            limitLine.close();
            canvas.drawPath((Path)limitLine, this.mLimitLinePaint);
        }
        MPPointF.recycleInstance(mPPointF);
        MPPointF.recycleInstance(mPPointF2);
    }
}

