/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.View;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;

public class ViewPortHandler {
    protected Matrix mCenterViewPortMatrixBuffer;
    protected float mChartHeight = 0.0f;
    protected float mChartWidth = 0.0f;
    protected RectF mContentRect;
    protected final Matrix mMatrixTouch = new Matrix();
    private float mMaxScaleX;
    private float mMaxScaleY;
    private float mMinScaleX = 1.0f;
    private float mMinScaleY = 1.0f;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mTransOffsetX = 0.0f;
    private float mTransOffsetY = 0.0f;
    private float mTransX = 0.0f;
    private float mTransY = 0.0f;
    protected final float[] matrixBuffer;
    protected float[] valsBufferForFitScreen;

    public ViewPortHandler() {
        this.mContentRect = new RectF();
        this.mMaxScaleY = Float.MAX_VALUE;
        this.mMaxScaleX = Float.MAX_VALUE;
        this.valsBufferForFitScreen = new float[9];
        this.mCenterViewPortMatrixBuffer = new Matrix();
        this.matrixBuffer = new float[9];
    }

    public boolean canZoomInMoreX() {
        boolean bl = this.mScaleX < this.mMaxScaleX;
        return bl;
    }

    public boolean canZoomInMoreY() {
        boolean bl = this.mScaleY < this.mMaxScaleY;
        return bl;
    }

    public boolean canZoomOutMoreX() {
        boolean bl = this.mScaleX > this.mMinScaleX;
        return bl;
    }

    public boolean canZoomOutMoreY() {
        boolean bl = this.mScaleY > this.mMinScaleY;
        return bl;
    }

    public void centerViewPort(float[] fArray, View view) {
        Matrix matrix = this.mCenterViewPortMatrixBuffer;
        matrix.reset();
        matrix.set(this.mMatrixTouch);
        float f = fArray[0];
        float f2 = this.offsetLeft();
        float f3 = fArray[1];
        float f4 = this.offsetTop();
        matrix.postTranslate(-(f - f2), -(f3 - f4));
        this.refresh(matrix, view, true);
    }

    public float contentBottom() {
        return this.mContentRect.bottom;
    }

    public float contentHeight() {
        return this.mContentRect.height();
    }

    public float contentLeft() {
        return this.mContentRect.left;
    }

    public float contentRight() {
        return this.mContentRect.right;
    }

    public float contentTop() {
        return this.mContentRect.top;
    }

    public float contentWidth() {
        return this.mContentRect.width();
    }

    public Matrix fitScreen() {
        Matrix matrix = new Matrix();
        this.fitScreen(matrix);
        return matrix;
    }

    public void fitScreen(Matrix matrix) {
        this.mMinScaleX = 1.0f;
        this.mMinScaleY = 1.0f;
        matrix.set(this.mMatrixTouch);
        float[] fArray = this.valsBufferForFitScreen;
        for (int i = 0; i < 9; ++i) {
            fArray[i] = 0.0f;
        }
        matrix.getValues(fArray);
        fArray[2] = 0.0f;
        fArray[5] = 0.0f;
        fArray[0] = 1.0f;
        fArray[4] = 1.0f;
        matrix.setValues(fArray);
    }

    public float getChartHeight() {
        return this.mChartHeight;
    }

    public float getChartWidth() {
        return this.mChartWidth;
    }

    public MPPointF getContentCenter() {
        return MPPointF.getInstance(this.mContentRect.centerX(), this.mContentRect.centerY());
    }

    public RectF getContentRect() {
        return this.mContentRect;
    }

    public Matrix getMatrixTouch() {
        return this.mMatrixTouch;
    }

    public float getMaxScaleX() {
        return this.mMaxScaleX;
    }

    public float getMaxScaleY() {
        return this.mMaxScaleY;
    }

    public float getMinScaleX() {
        return this.mMinScaleX;
    }

    public float getMinScaleY() {
        return this.mMinScaleY;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public float getSmallestContentExtension() {
        return Math.min(this.mContentRect.width(), this.mContentRect.height());
    }

    public float getTransX() {
        return this.mTransX;
    }

    public float getTransY() {
        return this.mTransY;
    }

    public boolean hasChartDimens() {
        return this.mChartHeight > 0.0f && this.mChartWidth > 0.0f;
    }

    public boolean hasNoDragOffset() {
        boolean bl = this.mTransOffsetX <= 0.0f && this.mTransOffsetY <= 0.0f;
        return bl;
    }

    public boolean isFullyZoomedOut() {
        boolean bl = this.isFullyZoomedOutX() && this.isFullyZoomedOutY();
        return bl;
    }

    public boolean isFullyZoomedOutX() {
        float f = this.mScaleX;
        float f2 = this.mMinScaleX;
        boolean bl = !(f > f2) && !(f2 > 1.0f);
        return bl;
    }

    public boolean isFullyZoomedOutY() {
        float f = this.mScaleY;
        float f2 = this.mMinScaleY;
        boolean bl = !(f > f2) && !(f2 > 1.0f);
        return bl;
    }

    public boolean isInBounds(float f, float f2) {
        boolean bl = this.isInBoundsX(f) && this.isInBoundsY(f2);
        return bl;
    }

    public boolean isInBoundsBottom(float f) {
        boolean bl = this.mContentRect.bottom >= (f = (float)((int)(f * 100.0f)) / 100.0f);
        return bl;
    }

    public boolean isInBoundsLeft(float f) {
        boolean bl = this.mContentRect.left <= f + 1.0f;
        return bl;
    }

    public boolean isInBoundsRight(float f) {
        boolean bl = this.mContentRect.right >= (f = (float)((int)(f * 100.0f)) / 100.0f) - 1.0f;
        return bl;
    }

    public boolean isInBoundsTop(float f) {
        boolean bl = this.mContentRect.top <= f;
        return bl;
    }

    public boolean isInBoundsX(float f) {
        boolean bl = this.isInBoundsLeft(f) && this.isInBoundsRight(f);
        return bl;
    }

    public boolean isInBoundsY(float f) {
        boolean bl = this.isInBoundsTop(f) && this.isInBoundsBottom(f);
        return bl;
    }

    public void limitTransAndScale(Matrix matrix, RectF object) {
        matrix.getValues(this.matrixBuffer);
        float[] fArray = this.matrixBuffer;
        float f = fArray[2];
        float f2 = fArray[0];
        float f3 = fArray[5];
        float f4 = fArray[4];
        this.mScaleX = Math.min(Math.max(this.mMinScaleX, f2), this.mMaxScaleX);
        this.mScaleY = Math.min(Math.max(this.mMinScaleY, f4), this.mMaxScaleY);
        f4 = 0.0f;
        if (object != null) {
            f4 = object.width();
            f2 = object.height();
        } else {
            f2 = 0.0f;
        }
        this.mTransX = Math.min(Math.max(f, -f4 * (this.mScaleX - 1.0f) - this.mTransOffsetX), this.mTransOffsetX);
        this.mTransY = f4 = Math.max(Math.min(f3, f2 * (this.mScaleY - 1.0f) + this.mTransOffsetY), -this.mTransOffsetY);
        object = this.matrixBuffer;
        object[2] = (RectF)this.mTransX;
        object[0] = (RectF)this.mScaleX;
        object[5] = (RectF)f4;
        object[4] = (RectF)this.mScaleY;
        matrix.setValues((float[])object);
    }

    public float offsetBottom() {
        return this.mChartHeight - this.mContentRect.bottom;
    }

    public float offsetLeft() {
        return this.mContentRect.left;
    }

    public float offsetRight() {
        return this.mChartWidth - this.mContentRect.right;
    }

    public float offsetTop() {
        return this.mContentRect.top;
    }

    public Matrix refresh(Matrix matrix, View view, boolean bl) {
        this.mMatrixTouch.set(matrix);
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
        if (bl) {
            view.invalidate();
        }
        matrix.set(this.mMatrixTouch);
        return matrix;
    }

    public void resetZoom(Matrix matrix) {
        matrix.reset();
        matrix.set(this.mMatrixTouch);
        matrix.postScale(1.0f, 1.0f, 0.0f, 0.0f);
    }

    public void restrainViewPort(float f, float f2, float f3, float f4) {
        this.mContentRect.set(f, f2, this.mChartWidth - f3, this.mChartHeight - f4);
    }

    public void setChartDimens(float f, float f2) {
        float f3 = this.offsetLeft();
        float f4 = this.offsetTop();
        float f5 = this.offsetRight();
        float f6 = this.offsetBottom();
        this.mChartHeight = f2;
        this.mChartWidth = f;
        this.restrainViewPort(f3, f4, f5, f6);
    }

    public void setDragOffsetX(float f) {
        this.mTransOffsetX = Utils.convertDpToPixel(f);
    }

    public void setDragOffsetY(float f) {
        this.mTransOffsetY = Utils.convertDpToPixel(f);
    }

    public void setMaximumScaleX(float f) {
        float f2 = f;
        if (f == 0.0f) {
            f2 = Float.MAX_VALUE;
        }
        this.mMaxScaleX = f2;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public void setMaximumScaleY(float f) {
        float f2 = f;
        if (f == 0.0f) {
            f2 = Float.MAX_VALUE;
        }
        this.mMaxScaleY = f2;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public void setMinMaxScaleX(float f, float f2) {
        float f3 = f;
        if (f < 1.0f) {
            f3 = 1.0f;
        }
        f = f2;
        if (f2 == 0.0f) {
            f = Float.MAX_VALUE;
        }
        this.mMinScaleX = f3;
        this.mMaxScaleX = f;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public void setMinMaxScaleY(float f, float f2) {
        float f3 = f;
        if (f < 1.0f) {
            f3 = 1.0f;
        }
        f = f2;
        if (f2 == 0.0f) {
            f = Float.MAX_VALUE;
        }
        this.mMinScaleY = f3;
        this.mMaxScaleY = f;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public void setMinimumScaleX(float f) {
        float f2 = f;
        if (f < 1.0f) {
            f2 = 1.0f;
        }
        this.mMinScaleX = f2;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public void setMinimumScaleY(float f) {
        float f2 = f;
        if (f < 1.0f) {
            f2 = 1.0f;
        }
        this.mMinScaleY = f2;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public Matrix setZoom(float f, float f2) {
        Matrix matrix = new Matrix();
        this.setZoom(f, f2, matrix);
        return matrix;
    }

    public Matrix setZoom(float f, float f2, float f3, float f4) {
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        matrix.setScale(f, f2, f3, f4);
        return matrix;
    }

    public void setZoom(float f, float f2, Matrix matrix) {
        matrix.reset();
        matrix.set(this.mMatrixTouch);
        matrix.setScale(f, f2);
    }

    public Matrix translate(float[] fArray) {
        Matrix matrix = new Matrix();
        this.translate(fArray, matrix);
        return matrix;
    }

    public void translate(float[] fArray, Matrix matrix) {
        matrix.reset();
        matrix.set(this.mMatrixTouch);
        float f = fArray[0];
        float f2 = this.offsetLeft();
        float f3 = fArray[1];
        float f4 = this.offsetTop();
        matrix.postTranslate(-(f - f2), -(f3 - f4));
    }

    public Matrix zoom(float f, float f2) {
        Matrix matrix = new Matrix();
        this.zoom(f, f2, matrix);
        return matrix;
    }

    public Matrix zoom(float f, float f2, float f3, float f4) {
        Matrix matrix = new Matrix();
        this.zoom(f, f2, f3, f4, matrix);
        return matrix;
    }

    public void zoom(float f, float f2, float f3, float f4, Matrix matrix) {
        matrix.reset();
        matrix.set(this.mMatrixTouch);
        matrix.postScale(f, f2, f3, f4);
    }

    public void zoom(float f, float f2, Matrix matrix) {
        matrix.reset();
        matrix.set(this.mMatrixTouch);
        matrix.postScale(f, f2);
    }

    public Matrix zoomIn(float f, float f2) {
        Matrix matrix = new Matrix();
        this.zoomIn(f, f2, matrix);
        return matrix;
    }

    public void zoomIn(float f, float f2, Matrix matrix) {
        matrix.reset();
        matrix.set(this.mMatrixTouch);
        matrix.postScale(1.4f, 1.4f, f, f2);
    }

    public Matrix zoomOut(float f, float f2) {
        Matrix matrix = new Matrix();
        this.zoomOut(f, f2, matrix);
        return matrix;
    }

    public void zoomOut(float f, float f2, Matrix matrix) {
        matrix.reset();
        matrix.set(this.mMatrixTouch);
        matrix.postScale(0.7f, 0.7f, f, f2);
    }
}

