/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBlockDevice
implements BlockDeviceDriver {
    private static final String TAG = "ByteBlockDevice";
    private int blockSize;
    private int logicalOffsetToAdd;
    private BlockDeviceDriver targetBlockDevice;

    public ByteBlockDevice(BlockDeviceDriver blockDeviceDriver) {
        this(blockDeviceDriver, 0);
    }

    public ByteBlockDevice(BlockDeviceDriver blockDeviceDriver, int n) {
        this.targetBlockDevice = blockDeviceDriver;
        this.blockSize = blockDeviceDriver.getBlockSize();
        this.logicalOffsetToAdd = n;
    }

    @Override
    public int getBlockSize() {
        return this.targetBlockDevice.getBlockSize();
    }

    @Override
    public void init() throws IOException {
        this.targetBlockDevice.init();
    }

    @Override
    public void read(long l, ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2;
        long l2;
        int n = this.blockSize;
        long l3 = l2 = l / (long)n + (long)this.logicalOffsetToAdd;
        if (l % (long)n != 0L) {
            byteBuffer2 = ByteBuffer.allocate(n);
            this.targetBlockDevice.read(l2, byteBuffer2);
            byteBuffer2.clear();
            byteBuffer2.position((int)(l % (long)this.blockSize));
            n = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
            byteBuffer2.limit(byteBuffer2.position() + n);
            byteBuffer.put(byteBuffer2);
            l3 = l2 + 1L;
        }
        if (byteBuffer.remaining() > 0) {
            int n2 = byteBuffer.remaining();
            if (n2 % (n = this.blockSize) != 0) {
                n = n - byteBuffer.remaining() % this.blockSize + byteBuffer.remaining();
                byteBuffer2 = ByteBuffer.allocate(n);
                byteBuffer2.limit(n);
            } else {
                byteBuffer2 = byteBuffer;
            }
            this.targetBlockDevice.read(l3, byteBuffer2);
            if (byteBuffer.remaining() % this.blockSize != 0) {
                System.arraycopy(byteBuffer2.array(), 0, byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
            }
            byteBuffer.position(byteBuffer.limit());
        }
    }

    @Override
    public void write(long l, ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2;
        long l2;
        int n = this.blockSize;
        long l3 = l2 = l / (long)n + (long)this.logicalOffsetToAdd;
        if (l % (long)n != 0L) {
            byteBuffer2 = ByteBuffer.allocate(n);
            this.targetBlockDevice.read(l2, byteBuffer2);
            byteBuffer2.clear();
            byteBuffer2.position((int)(l % (long)this.blockSize));
            n = Math.min(byteBuffer2.remaining(), byteBuffer.remaining());
            byteBuffer2.put(byteBuffer.array(), byteBuffer.position(), n);
            byteBuffer.position(byteBuffer.position() + n);
            byteBuffer2.clear();
            this.targetBlockDevice.write(l2, byteBuffer2);
            l3 = l2 + 1L;
        }
        if (byteBuffer.remaining() > 0) {
            n = byteBuffer.remaining();
            int n2 = this.blockSize;
            byteBuffer2 = byteBuffer;
            if (n % n2 != 0) {
                n = n2 - byteBuffer.remaining() % this.blockSize + byteBuffer.remaining();
                byteBuffer2 = ByteBuffer.allocate(n);
                byteBuffer2.limit(n);
                System.arraycopy(byteBuffer.array(), byteBuffer.position(), byteBuffer2.array(), 0, byteBuffer.remaining());
                byteBuffer.position(byteBuffer.limit());
            }
            this.targetBlockDevice.write(l3, byteBuffer2);
        }
    }
}

