/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.scsi;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.scsi.commands.CommandBlockWrapper;
import com.github.mjdev.libaums.driver.scsi.commands.CommandStatusWrapper;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiInquiry;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiInquiryResponse;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiRead10;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiReadCapacity;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiReadCapacityResponse;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiTestUnitReady;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiWrite10;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ScsiBlockDevice
implements BlockDeviceDriver {
    private static final String TAG = "ScsiBlockDevice";
    private int blockSize;
    private CommandStatusWrapper csw;
    private ByteBuffer cswBuffer;
    private int lastBlockAddress;
    private ByteBuffer outBuffer;
    private ScsiRead10 readCommand;
    private UsbCommunication usbCommunication;
    private ScsiWrite10 writeCommand = new ScsiWrite10();

    public ScsiBlockDevice(UsbCommunication usbCommunication) {
        this.readCommand = new ScsiRead10();
        this.csw = new CommandStatusWrapper();
        this.usbCommunication = usbCommunication;
        this.outBuffer = ByteBuffer.allocate(31);
        this.cswBuffer = ByteBuffer.allocate(13);
    }

    private boolean transferCommand(CommandBlockWrapper object, ByteBuffer comparable) throws IOException {
        byte[] byArray = this.outBuffer.array();
        boolean bl = false;
        Arrays.fill(byArray, (byte)0);
        this.outBuffer.clear();
        ((CommandBlockWrapper)object).serialize(this.outBuffer);
        this.outBuffer.clear();
        if (this.usbCommunication.bulkOutTransfer(this.outBuffer) == byArray.length) {
            int n = ((CommandBlockWrapper)object).getdCbwDataTransferLength();
            if (n > 0) {
                if (((CommandBlockWrapper)object).getDirection() == CommandBlockWrapper.Direction.IN) {
                    int n2;
                    int n3 = 0;
                    do {
                        n3 = n2 = n3 + this.usbCommunication.bulkInTransfer((ByteBuffer)comparable);
                    } while (n2 < n);
                    if (n2 != n) {
                        comparable = new StringBuilder();
                        ((StringBuilder)comparable).append("Unexpected command size (");
                        ((StringBuilder)comparable).append(n2);
                        ((StringBuilder)comparable).append(") on response to ");
                        ((StringBuilder)comparable).append(object);
                        throw new IOException(((StringBuilder)comparable).toString());
                    }
                } else {
                    int n4;
                    int n5 = 0;
                    do {
                        n5 = n4 = n5 + this.usbCommunication.bulkOutTransfer((ByteBuffer)comparable);
                    } while (n4 < n);
                    if (n4 != n) {
                        comparable = new StringBuilder();
                        ((StringBuilder)comparable).append("Could not write all bytes: ");
                        ((StringBuilder)comparable).append(object);
                        throw new IOException(((StringBuilder)comparable).toString());
                    }
                }
            }
            this.cswBuffer.clear();
            if (this.usbCommunication.bulkInTransfer(this.cswBuffer) == 13) {
                this.cswBuffer.clear();
                this.csw.read(this.cswBuffer);
                if (this.csw.getbCswStatus() == 0) {
                    if (this.csw.getdCswTag() == ((CommandBlockWrapper)object).getdCbwTag()) {
                        if (this.csw.getbCswStatus() == 0) {
                            bl = true;
                        }
                        return bl;
                    }
                    throw new IOException("wrong csw tag!");
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Unsuccessful Csw status: ");
                ((StringBuilder)object).append(this.csw.getbCswStatus());
                throw new IOException(((StringBuilder)object).toString());
            }
            throw new IOException("Unexpected command size while expecting csw");
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append("Writing all bytes on command ");
        ((StringBuilder)comparable).append(object);
        ((StringBuilder)comparable).append(" failed!");
        throw new IOException(((StringBuilder)comparable).toString());
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public void init() throws IOException {
        Object object = ByteBuffer.allocate(36);
        this.transferCommand(new ScsiInquiry((byte)((ByteBuffer)object).array().length), (ByteBuffer)object);
        ((ByteBuffer)object).clear();
        ScsiInquiryResponse scsiInquiryResponse = ScsiInquiryResponse.read((ByteBuffer)object);
        String string2 = TAG;
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append("inquiry response: ");
        ((StringBuilder)object2).append(scsiInquiryResponse);
        Log.d((String)string2, (String)((StringBuilder)object2).toString());
        if (scsiInquiryResponse.getPeripheralQualifier() == 0 && scsiInquiryResponse.getPeripheralDeviceType() == 0) {
            if (!this.transferCommand(new ScsiTestUnitReady(), null)) {
                Log.w((String)string2, (String)"unit not ready!");
            }
            object2 = new ScsiReadCapacity();
            ((ByteBuffer)object).clear();
            this.transferCommand((CommandBlockWrapper)object2, (ByteBuffer)object);
            ((ByteBuffer)object).clear();
            object = ScsiReadCapacityResponse.read((ByteBuffer)object);
            this.blockSize = ((ScsiReadCapacityResponse)object).getBlockLength();
            this.lastBlockAddress = ((ScsiReadCapacityResponse)object).getLogicalBlockAddress();
            object = new StringBuilder();
            ((StringBuilder)object).append("Block size: ");
            ((StringBuilder)object).append(this.blockSize);
            Log.i((String)string2, (String)((StringBuilder)object).toString());
            object = new StringBuilder();
            ((StringBuilder)object).append("Last block address: ");
            ((StringBuilder)object).append(this.lastBlockAddress);
            Log.i((String)string2, (String)((StringBuilder)object).toString());
            return;
        }
        throw new IOException("unsupported PeripheralQualifier or PeripheralDeviceType");
    }

    @Override
    public void read(long l, ByteBuffer object) throws IOException {
        synchronized (this) {
            if (((Buffer)object).remaining() % this.blockSize == 0) {
                this.readCommand.init((int)l, ((Buffer)object).remaining(), this.blockSize);
                this.transferCommand(this.readCommand, (ByteBuffer)object);
                ((ByteBuffer)object).position(((Buffer)object).limit());
                return;
            }
            object = new IllegalArgumentException("dest.remaining() must be multiple of blockSize!");
            throw object;
        }
    }

    @Override
    public void write(long l, ByteBuffer object) throws IOException {
        synchronized (this) {
            if (((Buffer)object).remaining() % this.blockSize == 0) {
                this.writeCommand.init((int)l, ((Buffer)object).remaining(), this.blockSize);
                this.transferCommand(this.writeCommand, (ByteBuffer)object);
                ((ByteBuffer)object).position(((Buffer)object).limit());
                return;
            }
            object = new IllegalArgumentException("src.remaining() must be multiple of blockSize!");
            throw object;
        }
    }
}

