/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.scsi.commands;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ScsiInquiryResponse {
    private byte peripheralDeviceType;
    private byte peripheralQualifier;
    boolean removableMedia;
    byte responseDataFormat;
    byte spcVersion;

    private ScsiInquiryResponse() {
    }

    public static ScsiInquiryResponse read(ByteBuffer byteBuffer) {
        ScsiInquiryResponse scsiInquiryResponse = new ScsiInquiryResponse();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte by = byteBuffer.get();
        scsiInquiryResponse.peripheralQualifier = (byte)(by & 0xFFFFFFE0);
        scsiInquiryResponse.peripheralDeviceType = (byte)(by & 0x1F);
        boolean bl = byteBuffer.get() == 128;
        scsiInquiryResponse.removableMedia = bl;
        scsiInquiryResponse.spcVersion = byteBuffer.get();
        scsiInquiryResponse.responseDataFormat = (byte)(byteBuffer.get() & 7);
        return scsiInquiryResponse;
    }

    public byte getPeripheralDeviceType() {
        return this.peripheralDeviceType;
    }

    public byte getPeripheralQualifier() {
        return this.peripheralQualifier;
    }

    public byte getResponseDataFormat() {
        return this.responseDataFormat;
    }

    public byte getSpcVersion() {
        return this.spcVersion;
    }

    public boolean isRemovableMedia() {
        return this.removableMedia;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ScsiInquiryResponse [peripheralQualifier=");
        stringBuilder.append(this.peripheralQualifier);
        stringBuilder.append(", peripheralDeviceType=");
        stringBuilder.append(this.peripheralDeviceType);
        stringBuilder.append(", removableMedia=");
        stringBuilder.append(this.removableMedia);
        stringBuilder.append(", spcVersion=");
        stringBuilder.append(this.spcVersion);
        stringBuilder.append(", responseDataFormat=");
        stringBuilder.append(this.responseDataFormat);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

