/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.scsi.commands;

import com.github.mjdev.libaums.driver.scsi.commands.CommandBlockWrapper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ScsiRead10
extends CommandBlockWrapper {
    private static final byte LENGTH = 10;
    private static final byte OPCODE = 40;
    private int blockAddress;
    private int blockSize;
    private short transferBlocks;
    private int transferBytes;

    public ScsiRead10() {
        super(0, CommandBlockWrapper.Direction.IN, (byte)0, (byte)10);
    }

    public ScsiRead10(int n, int n2, int n3) {
        super(n2, CommandBlockWrapper.Direction.IN, (byte)0, (byte)10);
        this.init(n, n2, n3);
    }

    public void init(int n, int n2, int n3) {
        this.dCbwDataTransferLength = n2;
        this.blockAddress = n;
        this.transferBytes = n2;
        this.blockSize = n3;
        n = (short)(n2 / n3);
        if (n2 % n3 == 0) {
            this.transferBlocks = (short)n;
            return;
        }
        throw new IllegalArgumentException("transfer bytes is not a multiple of block size");
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put((byte)40);
        byteBuffer.put((byte)0);
        byteBuffer.putInt(this.blockAddress);
        byteBuffer.put((byte)0);
        byteBuffer.putShort(this.transferBlocks);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ScsiRead10 [blockAddress=");
        stringBuilder.append(this.blockAddress);
        stringBuilder.append(", transferBytes=");
        stringBuilder.append(this.transferBytes);
        stringBuilder.append(", blockSize=");
        stringBuilder.append(this.blockSize);
        stringBuilder.append(", transferBlocks=");
        stringBuilder.append(this.transferBlocks);
        stringBuilder.append(", getdCbwDataTransferLength()=");
        stringBuilder.append(this.getdCbwDataTransferLength());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

