/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import android.util.Log;
import com.github.mjdev.libaums.fs.UsbFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class UsbFileInputStream
extends InputStream {
    private static final String TAG = "UsbFileInputStream";
    private long currentByteOffset = 0L;
    private UsbFile file;

    public UsbFileInputStream(UsbFile usbFile) {
        if (!usbFile.isDirectory()) {
            this.file = usbFile;
            return;
        }
        throw new UnsupportedOperationException("UsbFileInputStream cannot be created on directory!");
    }

    @Override
    public int available() throws IOException {
        Log.d((String)TAG, (String)"available");
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public int read() throws IOException {
        if (this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(512);
        byteBuffer.limit(1);
        this.file.read(this.currentByteOffset, byteBuffer);
        ++this.currentByteOffset;
        byteBuffer.flip();
        return byteBuffer.get();
    }

    @Override
    public int read(byte[] object) throws IOException {
        if (this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        long l = this.file.getLength();
        l = Math.min((long)((byte[])object).length, l - this.currentByteOffset);
        object = ByteBuffer.wrap((byte[])object);
        int n = (int)l;
        ((ByteBuffer)object).limit(n);
        this.file.read(this.currentByteOffset, (ByteBuffer)object);
        this.currentByteOffset += l;
        return n;
    }

    @Override
    public int read(byte[] object, int n, int n2) throws IOException {
        if (this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        long l = this.file.getLength();
        l = Math.min((long)n2, l - this.currentByteOffset);
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).position(n);
        n2 = (int)l;
        ((ByteBuffer)object).limit(n + n2);
        this.file.read(this.currentByteOffset, (ByteBuffer)object);
        this.currentByteOffset += l;
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        l = Math.min(l, this.file.getLength() - this.currentByteOffset);
        this.currentByteOffset += l;
        return l;
    }
}

