/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import com.github.mjdev.libaums.fs.UsbFile;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class UsbFileOutputStream
extends OutputStream {
    private long currentByteOffset = 0L;
    private UsbFile file;

    public UsbFileOutputStream(UsbFile usbFile) {
        if (!usbFile.isDirectory()) {
            this.file = usbFile;
            return;
        }
        throw new UnsupportedOperationException("UsbFileOutputStream cannot be created on directory!");
    }

    @Override
    public void close() throws IOException {
        this.file.setLength(this.currentByteOffset);
        this.file.close();
    }

    @Override
    public void flush() throws IOException {
        this.file.flush();
    }

    @Override
    public void write(int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[]{(byte)n});
        this.file.write(this.currentByteOffset, byteBuffer);
        ++this.currentByteOffset;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.file.write(this.currentByteOffset, byteBuffer);
        this.currentByteOffset += (long)byArray.length;
    }

    @Override
    public void write(byte[] object, int n, int n2) throws IOException {
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).position(n);
        ((ByteBuffer)object).limit(n + n2);
        this.file.write(this.currentByteOffset, (ByteBuffer)object);
        this.currentByteOffset += (long)n2;
    }
}

