/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FsInfoStructure;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;

public class FAT {
    private static final int FAT32_EOF_CLUSTER = 0xFFFFFF8;
    private static final String TAG = "FAT";
    private BlockDeviceDriver blockDevice;
    private int[] fatNumbers;
    private long[] fatOffset;
    private FsInfoStructure fsInfoStructure;

    FAT(BlockDeviceDriver object, Fat32BootSector fat32BootSector, FsInfoStructure object2) {
        int n;
        this.blockDevice = object;
        this.fsInfoStructure = object2;
        boolean bl = fat32BootSector.isFatMirrored();
        int n2 = 0;
        if (!bl) {
            n = fat32BootSector.getValidFat();
            this.fatNumbers = new int[]{n};
            object2 = TAG;
            object = new StringBuilder();
            ((StringBuilder)object).append("fat is not mirrored, fat ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(" is valid");
            Log.i((String)object2, (String)((StringBuilder)object).toString());
        } else {
            int n3 = fat32BootSector.getFatCount();
            this.fatNumbers = new int[n3];
            for (n = 0; n < n3; ++n) {
                this.fatNumbers[n] = n;
            }
            object2 = TAG;
            object = new StringBuilder();
            ((StringBuilder)object).append("fat is mirrored, fat count: ");
            ((StringBuilder)object).append(n3);
            Log.i((String)object2, (String)((StringBuilder)object).toString());
        }
        this.fatOffset = new long[this.fatNumbers.length];
        for (n = n2; n < ((Object)(object = (Object)this.fatOffset)).length; ++n) {
            object[n] = fat32BootSector.getFatOffset(this.fatNumbers[n]);
        }
    }

    Long[] alloc(Long[] objectArray, int n) throws IOException {
        int n2;
        Object object;
        Object object2;
        long[] lArray;
        long l;
        ArrayList<Long> arrayList = new ArrayList<Long>(objectArray.length + n);
        arrayList.addAll(Arrays.asList(objectArray));
        int n3 = this.blockDevice.getBlockSize() * 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l2 = objectArray.length != 0 ? objectArray[objectArray.length - 1] : -1L;
        long l3 = l = this.fsInfoStructure.getLastAllocatedClusterHint();
        if (l == (long)FsInfoStructure.INVALID_VALUE) {
            l3 = 2L;
        }
        int n4 = n;
        l = -1L;
        long l4 = l3;
        while (n4 > 0) {
            lArray = this.fatOffset;
            l3 = lArray[0];
            object2 = 4L * ++l4;
            long l5 = n3;
            object = (l3 + object2) / l5 * l5;
            long l6 = lArray[0];
            l3 = l;
            if (l != object) {
                byteBuffer.clear();
                this.blockDevice.read((long)object, byteBuffer);
                l3 = object;
            }
            n2 = n4;
            if (byteBuffer.getInt((int)((l6 + object2) % l5)) == 0) {
                arrayList.add(l4);
                n2 = n4 - 1;
            }
            n4 = n2;
            l = l3;
        }
        if (l2 != -1L) {
            lArray = this.fatOffset;
            l3 = lArray[0];
            object = l2 * 4L;
            l4 = n3;
            l2 = (l3 + object) / l4 * l4;
            object2 = lArray[0];
            l3 = l;
            if (l != l2) {
                byteBuffer.clear();
                this.blockDevice.read(l2, byteBuffer);
                l3 = l2;
            }
            byteBuffer.putInt((int)((object2 + object) % l4), (int)((Long)arrayList.get(objectArray.length)).longValue());
            l = l3;
        }
        n4 = objectArray.length;
        while (n4 < arrayList.size() - 1) {
            l2 = (Long)arrayList.get(n4);
            objectArray = this.fatOffset;
            l3 = objectArray[0];
            object = l2 * 4L;
            l4 = n3;
            l2 = (l3 + object) / l4 * l4;
            object2 = objectArray[0];
            l3 = l;
            if (l != l2) {
                byteBuffer.clear();
                this.blockDevice.write(l, byteBuffer);
                byteBuffer.clear();
                this.blockDevice.read(l2, byteBuffer);
                l3 = l2;
            }
            n2 = (int)((object2 + object) % l4);
            byteBuffer.putInt(n2, (int)((Long)arrayList.get(++n4)).longValue());
            l = l3;
        }
        l3 = (Long)arrayList.get(arrayList.size() - 1);
        objectArray = this.fatOffset;
        object = objectArray[0];
        l2 = 4L * l3;
        l4 = n3;
        object2 = (object + l2) / l4 * l4;
        object = objectArray[0];
        if (l != object2) {
            byteBuffer.clear();
            this.blockDevice.write(l, byteBuffer);
            byteBuffer.clear();
            this.blockDevice.read((long)object2, byteBuffer);
        }
        byteBuffer.putInt((int)((object + l2) % l4), 0xFFFFFF8);
        byteBuffer.clear();
        this.blockDevice.write((long)object2, byteBuffer);
        this.fsInfoStructure.setLastAllocatedClusterHint(l3);
        this.fsInfoStructure.decreaseClusterCount(n);
        this.fsInfoStructure.write();
        Log.i((String)TAG, (String)"allocating clusters finished");
        return arrayList.toArray(new Long[0]);
    }

    Long[] free(Long[] longArray, int n) throws IOException {
        int n2 = longArray.length - n;
        int n3 = this.blockDevice.getBlockSize() * 2;
        Comparable<ByteBuffer> comparable = ByteBuffer.allocate(n3);
        ((ByteBuffer)comparable).order(ByteOrder.LITTLE_ENDIAN);
        if (n2 >= 0) {
            long l;
            long l2;
            long l3;
            Object object;
            long l4;
            long l5 = -1L;
            for (int i = n2; i < longArray.length; ++i) {
                l4 = longArray[i];
                object = this.fatOffset;
                l3 = object[0];
                l2 = l4 * 4L;
                l = n3;
                l4 = (l3 + l2) / l * l;
                long l6 = object[0];
                l3 = l5;
                if (l5 != l4) {
                    if (l5 != -1L) {
                        ((ByteBuffer)comparable).clear();
                        this.blockDevice.write(l5, (ByteBuffer)comparable);
                    }
                    ((ByteBuffer)comparable).clear();
                    this.blockDevice.read(l4, (ByteBuffer)comparable);
                    l3 = l4;
                }
                ((ByteBuffer)comparable).putInt((int)((l6 + l2) % l), 0);
                l5 = l3;
            }
            if (n2 > 0) {
                l3 = longArray[n2 - 1];
                object = this.fatOffset;
                l2 = object[0];
                l4 = l3 * 4L;
                l3 = n3;
                l2 = (l2 + l4) / l3 * l3;
                l = object[0];
                if (l5 != l2) {
                    ((ByteBuffer)comparable).clear();
                    this.blockDevice.write(l5, (ByteBuffer)comparable);
                    ((ByteBuffer)comparable).clear();
                    this.blockDevice.read(l2, (ByteBuffer)comparable);
                }
                ((ByteBuffer)comparable).putInt((int)((l + l4) % l3), 0xFFFFFF8);
                ((ByteBuffer)comparable).clear();
                this.blockDevice.write(l2, (ByteBuffer)comparable);
            } else {
                ((ByteBuffer)comparable).clear();
                this.blockDevice.write(l5, (ByteBuffer)comparable);
            }
            object = TAG;
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("freed ");
            ((StringBuilder)comparable).append(n);
            ((StringBuilder)comparable).append(" clusters");
            Log.i((String)object, (String)((StringBuilder)comparable).toString());
            this.fsInfoStructure.decreaseClusterCount(-n);
            this.fsInfoStructure.write();
            return Arrays.copyOfRange(longArray, 0, n2);
        }
        throw new IllegalStateException("trying to remove more clusters in chain than currently exist!");
    }

    Long[] getChain(long l) throws IOException {
        if (l == 0L) {
            return new Long[0];
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = this.blockDevice.getBlockSize() * 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l2 = -1L;
        long l3 = l;
        l = l2;
        do {
            arrayList.add(l3);
            long[] lArray = this.fatOffset;
            l2 = lArray[0];
            long l4 = l3 * 4L;
            long l5 = n;
            l2 = (l2 + l4) / l5 * l5;
            long l6 = lArray[0];
            l3 = l;
            if (l != l2) {
                byteBuffer.clear();
                this.blockDevice.read(l2, byteBuffer);
                l3 = l2;
            }
            l2 = byteBuffer.getInt((int)((l6 + l4) % l5));
            l = l3;
            l3 = l2;
        } while (l2 < 0xFFFFFF8L);
        return arrayList.toArray(new Long[0]);
    }
}

