/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FatDirectory;
import com.github.mjdev.libaums.fs.fat32.FsInfoStructure;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Fat32FileSystem
implements FileSystem {
    private static final String TAG = "Fat32FileSystem";
    private Fat32BootSector bootSector;
    private FAT fat;
    private FsInfoStructure fsInfoStructure;
    private FatDirectory rootDirectory;

    private Fat32FileSystem(BlockDeviceDriver blockDeviceDriver, ByteBuffer object) throws IOException {
        this.bootSector = object = Fat32BootSector.read((ByteBuffer)object);
        this.fsInfoStructure = FsInfoStructure.read(blockDeviceDriver, ((Fat32BootSector)object).getFsInfoStartSector() * this.bootSector.getBytesPerSector());
        this.fat = object = new FAT(blockDeviceDriver, this.bootSector, this.fsInfoStructure);
        this.rootDirectory = FatDirectory.readRoot(blockDeviceDriver, (FAT)object, this.bootSector);
        Log.d((String)TAG, (String)this.bootSector.toString());
    }

    public static Fat32FileSystem read(BlockDeviceDriver blockDeviceDriver) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(512);
        blockDeviceDriver.read(0L, byteBuffer);
        byteBuffer.flip();
        if ((char)byteBuffer.get(82) == 'F' && (char)byteBuffer.get(83) == 'A' && (char)byteBuffer.get(84) == 'T' && (char)byteBuffer.get(85) == '3' && (char)byteBuffer.get(86) == '2' && (char)byteBuffer.get(87) == ' ' && (char)byteBuffer.get(88) == ' ' && (char)byteBuffer.get(89) == ' ') {
            return new Fat32FileSystem(blockDeviceDriver, byteBuffer);
        }
        return null;
    }

    @Override
    public long getCapacity() {
        return this.bootSector.getTotalNumberOfSectors() * (long)this.bootSector.getBytesPerSector();
    }

    @Override
    public int getChunkSize() {
        return this.bootSector.getBytesPerCluster();
    }

    @Override
    public long getFreeSpace() {
        return this.fsInfoStructure.getFreeClusterCount() * (long)this.bootSector.getBytesPerCluster();
    }

    @Override
    public long getOccupiedSpace() {
        return this.getCapacity() - this.getFreeSpace();
    }

    @Override
    public UsbFile getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getVolumeLabel() {
        String string2;
        String string3 = string2 = this.rootDirectory.getVolumeLabel();
        if (string2 == null) {
            string3 = this.bootSector.getVolumeLabel();
        }
        return string3;
    }
}

