/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.AbstractUsbFile;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.fat32.ClusterChain;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FatDirectoryEntry;
import com.github.mjdev.libaums.fs.fat32.FatFile;
import com.github.mjdev.libaums.fs.fat32.FatLfnDirectoryEntry;
import com.github.mjdev.libaums.fs.fat32.ShortName;
import com.github.mjdev.libaums.fs.fat32.ShortNameGenerator;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FatDirectory
extends AbstractUsbFile {
    private static String TAG = "FatDirectory";
    private BlockDeviceDriver blockDevice;
    private Fat32BootSector bootSector;
    private ClusterChain chain;
    private List<FatLfnDirectoryEntry> entries;
    private FatLfnDirectoryEntry entry;
    private FAT fat;
    private boolean hasBeenInited;
    private Map<String, FatLfnDirectoryEntry> lfnMap;
    private FatDirectory parent;
    private Map<ShortName, FatDirectoryEntry> shortNameMap;
    private String volumeLabel;

    private FatDirectory(BlockDeviceDriver blockDeviceDriver, FAT fAT, Fat32BootSector fat32BootSector, FatDirectory fatDirectory) {
        this.blockDevice = blockDeviceDriver;
        this.fat = fAT;
        this.bootSector = fat32BootSector;
        this.parent = fatDirectory;
        this.lfnMap = new HashMap<String, FatLfnDirectoryEntry>();
        this.shortNameMap = new HashMap<ShortName, FatDirectoryEntry>();
    }

    private void addEntry(FatLfnDirectoryEntry fatLfnDirectoryEntry, FatDirectoryEntry fatDirectoryEntry) {
        this.entries.add(fatLfnDirectoryEntry);
        this.lfnMap.put(fatLfnDirectoryEntry.getName().toLowerCase(Locale.getDefault()), fatLfnDirectoryEntry);
        this.shortNameMap.put(fatDirectoryEntry.getShortName(), fatDirectoryEntry);
    }

    static FatDirectory create(FatLfnDirectoryEntry fatLfnDirectoryEntry, BlockDeviceDriver object, FAT fAT, Fat32BootSector fat32BootSector, FatDirectory fatDirectory) {
        object = new FatDirectory((BlockDeviceDriver)object, fAT, fat32BootSector, fatDirectory);
        ((FatDirectory)object).entry = fatLfnDirectoryEntry;
        return object;
    }

    private void init() throws IOException {
        if (this.chain == null) {
            this.chain = new ClusterChain(this.entry.getStartCluster(), this.blockDevice, this.fat, this.bootSector);
        }
        if (this.entries == null) {
            this.entries = new ArrayList<FatLfnDirectoryEntry>();
        }
        if (this.entries.size() == 0 && !this.hasBeenInited) {
            this.readEntries();
        }
        this.hasBeenInited = true;
    }

    private void readEntries() throws IOException {
        Object object;
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)this.chain.getLength());
        this.chain.read(0L, byteBuffer);
        ArrayList<FatDirectoryEntry> arrayList = new ArrayList<FatDirectoryEntry>();
        byteBuffer.flip();
        while (byteBuffer.remaining() > 0 && (object = FatDirectoryEntry.read(byteBuffer)) != null) {
            if (((FatDirectoryEntry)object).isLfnEntry()) {
                arrayList.add((FatDirectoryEntry)object);
                continue;
            }
            if (((FatDirectoryEntry)object).isVolumeLabel()) {
                if (!this.isRoot()) {
                    Log.w((String)TAG, (String)"volume label in non root dir!");
                }
                this.volumeLabel = ((FatDirectoryEntry)object).getVolumeLabel();
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("volume label: ");
                ((StringBuilder)object).append(this.volumeLabel);
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                continue;
            }
            if (((FatDirectoryEntry)object).isDeleted()) {
                arrayList.clear();
                continue;
            }
            this.addEntry(FatLfnDirectoryEntry.read((FatDirectoryEntry)object, arrayList), (FatDirectoryEntry)object);
            arrayList.clear();
        }
    }

    static FatDirectory readRoot(BlockDeviceDriver blockDeviceDriver, FAT fAT, Fat32BootSector fat32BootSector) throws IOException {
        FatDirectory fatDirectory = new FatDirectory(blockDeviceDriver, fAT, fat32BootSector, null);
        fatDirectory.chain = new ClusterChain(fat32BootSector.getRootDirStartCluster(), blockDeviceDriver, fAT, fat32BootSector);
        fatDirectory.init();
        return fatDirectory;
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public FatDirectory createDirectory(String object) throws IOException {
        if (!this.lfnMap.containsKey(((String)object).toLowerCase(Locale.getDefault()))) {
            this.init();
            Object object2 = ShortNameGenerator.generateShortName((String)object, this.shortNameMap.keySet());
            object = FatLfnDirectoryEntry.createNew((String)object, (ShortName)object2);
            ((FatLfnDirectoryEntry)object).setDirectory();
            long l = this.fat.alloc(new Long[0], 1)[0];
            ((FatLfnDirectoryEntry)object).setStartCluster(l);
            Object object3 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("adding entry: ");
            stringBuilder.append(object);
            stringBuilder.append(" with short name: ");
            stringBuilder.append(object2);
            Log.d((String)object3, (String)stringBuilder.toString());
            this.addEntry((FatLfnDirectoryEntry)object, ((FatLfnDirectoryEntry)object).getActualEntry());
            this.write();
            object2 = FatDirectory.create((FatLfnDirectoryEntry)object, this.blockDevice, this.fat, this.bootSector, this);
            ((FatDirectory)object2).hasBeenInited = true;
            ((FatDirectory)object2).entries = new ArrayList<FatLfnDirectoryEntry>();
            object3 = FatLfnDirectoryEntry.createNew(null, new ShortName(".", ""));
            ((FatLfnDirectoryEntry)object3).setDirectory();
            ((FatLfnDirectoryEntry)object3).setStartCluster(l);
            FatLfnDirectoryEntry.copyDateTime((FatLfnDirectoryEntry)object, (FatLfnDirectoryEntry)object3);
            super.addEntry((FatLfnDirectoryEntry)object3, ((FatLfnDirectoryEntry)object3).getActualEntry());
            object3 = FatLfnDirectoryEntry.createNew(null, new ShortName("..", ""));
            ((FatLfnDirectoryEntry)object3).setDirectory();
            l = this.isRoot() ? 0L : this.entry.getStartCluster();
            ((FatLfnDirectoryEntry)object3).setStartCluster(l);
            FatLfnDirectoryEntry.copyDateTime((FatLfnDirectoryEntry)object, (FatLfnDirectoryEntry)object3);
            super.addEntry((FatLfnDirectoryEntry)object3, ((FatLfnDirectoryEntry)object3).getActualEntry());
            ((FatDirectory)object2).write();
            return object2;
        }
        throw new IOException("Item already exists!");
    }

    @Override
    public FatFile createFile(String string2) throws IOException {
        if (!this.lfnMap.containsKey(string2.toLowerCase(Locale.getDefault()))) {
            this.init();
            ShortName shortName = ShortNameGenerator.generateShortName(string2, this.shortNameMap.keySet());
            FatLfnDirectoryEntry fatLfnDirectoryEntry = FatLfnDirectoryEntry.createNew(string2, shortName);
            fatLfnDirectoryEntry.setStartCluster(this.fat.alloc(new Long[0], 1)[0]);
            string2 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("adding entry: ");
            stringBuilder.append(fatLfnDirectoryEntry);
            stringBuilder.append(" with short name: ");
            stringBuilder.append(shortName);
            Log.d((String)string2, (String)stringBuilder.toString());
            this.addEntry(fatLfnDirectoryEntry, fatLfnDirectoryEntry.getActualEntry());
            this.write();
            return FatFile.create(fatLfnDirectoryEntry, this.blockDevice, this.fat, this.bootSector, this);
        }
        throw new IOException("Item already exists!");
    }

    @Override
    public long createdAt() {
        if (!this.isRoot()) {
            return this.entry.getActualEntry().getCreatedDateTime();
        }
        throw new IllegalStateException("root dir!");
    }

    @Override
    public void delete() throws IOException {
        if (!this.isRoot()) {
            this.init();
            UsbFile[] usbFileArray = this.listFiles();
            int n = usbFileArray.length;
            for (int i = 0; i < n; ++i) {
                usbFileArray[i].delete();
            }
            this.parent.removeEntry(this.entry);
            this.parent.write();
            this.chain.setLength(0L);
            return;
        }
        throw new IllegalStateException("Root dir cannot be deleted!");
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public long getLength() {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public String getName() {
        Object object = this.entry;
        object = object != null ? ((FatLfnDirectoryEntry)object).getName() : "/";
        return object;
    }

    @Override
    public UsbFile getParent() {
        return this.parent;
    }

    String getVolumeLabel() {
        return this.volumeLabel;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isRoot() {
        boolean bl = this.entry == null;
        return bl;
    }

    @Override
    public long lastAccessed() {
        if (!this.isRoot()) {
            return this.entry.getActualEntry().getLastAccessedDateTime();
        }
        throw new IllegalStateException("root dir!");
    }

    @Override
    public long lastModified() {
        if (!this.isRoot()) {
            return this.entry.getActualEntry().getLastModifiedDateTime();
        }
        throw new IllegalStateException("root dir!");
    }

    @Override
    public String[] list() throws IOException {
        this.init();
        ArrayList<String> arrayList = new ArrayList<String>(this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            String string2 = this.entries.get(i).getName();
            if (string2.equals(".") || string2.equals("..")) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public UsbFile[] listFiles() throws IOException {
        this.init();
        ArrayList<AbstractUsbFile> arrayList = new ArrayList<AbstractUsbFile>(this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entries.get(i);
            String string2 = fatLfnDirectoryEntry.getName();
            if (string2.equals(".") || string2.equals("..")) continue;
            if (fatLfnDirectoryEntry.isDirectory()) {
                arrayList.add(FatDirectory.create(fatLfnDirectoryEntry, this.blockDevice, this.fat, this.bootSector, this));
                continue;
            }
            arrayList.add(FatFile.create(fatLfnDirectoryEntry, this.blockDevice, this.fat, this.bootSector, this));
        }
        return arrayList.toArray(new UsbFile[arrayList.size()]);
    }

    void move(FatLfnDirectoryEntry fatLfnDirectoryEntry, UsbFile usbFile) throws IOException {
        if (usbFile.isDirectory()) {
            if (usbFile instanceof FatDirectory) {
                usbFile = (FatDirectory)usbFile;
                if (!((FatDirectory)usbFile).lfnMap.containsKey(fatLfnDirectoryEntry.getName().toLowerCase(Locale.getDefault()))) {
                    this.init();
                    super.init();
                    this.removeEntry(fatLfnDirectoryEntry);
                    super.addEntry(fatLfnDirectoryEntry, fatLfnDirectoryEntry.getActualEntry());
                    this.write();
                    ((FatDirectory)usbFile).write();
                    return;
                }
                throw new IOException("item already exists in destination!");
            }
            throw new IllegalStateException("cannot move between different filesystems!");
        }
        throw new IllegalStateException("destination cannot be a file!");
    }

    @Override
    public void moveTo(UsbFile object) throws IOException {
        if (!this.isRoot()) {
            if (object.isDirectory()) {
                if (object instanceof FatDirectory) {
                    FatDirectory fatDirectory = (FatDirectory)object;
                    if (!fatDirectory.lfnMap.containsKey(this.entry.getName().toLowerCase(Locale.getDefault()))) {
                        this.init();
                        fatDirectory.init();
                        this.parent.removeEntry(this.entry);
                        object = this.entry;
                        fatDirectory.addEntry((FatLfnDirectoryEntry)object, ((FatLfnDirectoryEntry)object).getActualEntry());
                        this.parent.write();
                        fatDirectory.write();
                        this.parent = fatDirectory;
                        return;
                    }
                    throw new IOException("item already exists in destination!");
                }
                throw new IllegalStateException("cannot move between different filesystems!");
            }
            throw new IllegalStateException("destination cannot be a file!");
        }
        throw new IllegalStateException("cannot move root dir!");
    }

    @Override
    public void read(long l, ByteBuffer byteBuffer) throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }

    void removeEntry(FatLfnDirectoryEntry fatLfnDirectoryEntry) {
        this.entries.remove(fatLfnDirectoryEntry);
        this.lfnMap.remove(fatLfnDirectoryEntry.getName().toLowerCase(Locale.getDefault()));
        this.shortNameMap.remove(fatLfnDirectoryEntry.getActualEntry().getShortName());
    }

    void renameEntry(FatLfnDirectoryEntry fatLfnDirectoryEntry, String string2) throws IOException {
        if (fatLfnDirectoryEntry.getName().equals(string2)) {
            return;
        }
        this.removeEntry(fatLfnDirectoryEntry);
        fatLfnDirectoryEntry.setName(string2, ShortNameGenerator.generateShortName(string2, this.shortNameMap.keySet()));
        this.addEntry(fatLfnDirectoryEntry, fatLfnDirectoryEntry.getActualEntry());
        this.write();
    }

    @Override
    public void setLength(long l) {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void setName(String string2) throws IOException {
        if (!this.isRoot()) {
            this.parent.renameEntry(this.entry, string2);
            return;
        }
        throw new IllegalStateException("Cannot rename root dir!");
    }

    void write() throws IOException {
        this.init();
        boolean bl = this.isRoot();
        int n = 0;
        boolean bl2 = bl && this.volumeLabel != null;
        Object object = this.entries.iterator();
        while (object.hasNext()) {
            n += object.next().getEntryCount();
        }
        int n2 = n;
        if (bl2) {
            n2 = n + 1;
        }
        long l = n2 * 32;
        this.chain.setLength(l);
        object = ByteBuffer.allocate((int)this.chain.getLength());
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        if (bl2) {
            FatDirectoryEntry.createVolumeLabel(this.volumeLabel).serialize((ByteBuffer)object);
        }
        Iterator<FatLfnDirectoryEntry> iterator2 = this.entries.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().serialize((ByteBuffer)object);
        }
        if (l % (long)this.bootSector.getBytesPerCluster() != 0L || l == 0L) {
            ((ByteBuffer)object).put(new byte[((Buffer)object).remaining()]);
        }
        ((ByteBuffer)object).flip();
        this.chain.write(0L, (ByteBuffer)object);
    }

    @Override
    public void write(long l, ByteBuffer byteBuffer) throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }
}

