/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.ByteBlockDevice;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.FileSystemFactory;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;

public class Partition
extends ByteBlockDevice {
    private static final String TAG = "Partition";
    private FileSystem fileSystem;

    private Partition(BlockDeviceDriver blockDeviceDriver, PartitionTableEntry partitionTableEntry) {
        super(blockDeviceDriver, partitionTableEntry.getLogicalBlockAddress());
    }

    public static Partition createPartition(PartitionTableEntry partitionTableEntry, BlockDeviceDriver blockDeviceDriver) throws IOException {
        try {
            Partition partition = new Partition(blockDeviceDriver, partitionTableEntry);
            partition.fileSystem = FileSystemFactory.createFileSystem(partitionTableEntry, partition);
            return partition;
        }
        catch (FileSystemFactory.UnsupportedFileSystemException unsupportedFileSystemException) {
            Log.w((String)TAG, (String)"Unsupported fs on partition");
            return null;
        }
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getVolumeLabel() {
        return this.fileSystem.getVolumeLabel();
    }
}

