/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition.fs;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.util.ArrayList;
import java.util.List;

public class FileSystemPartitionTable
implements PartitionTable {
    private static final String TAG = "FileSystemPartitionTable";
    List<PartitionTableEntry> entries = new ArrayList<PartitionTableEntry>();

    public FileSystemPartitionTable(BlockDeviceDriver blockDeviceDriver, FileSystem fileSystem) {
        String string2 = TAG;
        Log.i((String)string2, (String)"Found a device without partition table, yay!");
        int n = (int)fileSystem.getCapacity() / blockDeviceDriver.getBlockSize();
        if (fileSystem.getCapacity() % (long)blockDeviceDriver.getBlockSize() != 0L) {
            Log.w((String)string2, (String)"fs capacity is not multiple of block size");
        }
        this.entries.add(new PartitionTableEntry(fileSystem.getType(), 0, n));
    }

    @Override
    public List<PartitionTableEntry> getPartitionTableEntries() {
        return this.entries;
    }

    @Override
    public int getSize() {
        return 0;
    }
}

