/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition.mbr;

import android.util.Log;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MasterBootRecord
implements PartitionTable {
    private static final int TABLE_ENTRY_SIZE = 16;
    private static final int TABLE_OFFSET = 446;
    private static final String TAG;
    private static Map<Integer, Integer> partitionTypes;
    private List<PartitionTableEntry> partitions = new ArrayList<PartitionTableEntry>();

    static {
        partitionTypes = new HashMap<Integer, Integer>(){
            {
                Integer n = 2;
                this.put(11, n);
                this.put(12, n);
                this.put(27, n);
                this.put(28, n);
                Integer n2 = 1;
                this.put(n2, 0);
                Integer n3 = 4;
                this.put(n3, n2);
                n = 6;
                this.put(n, n2);
                this.put(14, n2);
                this.put(131, 3);
                this.put(7, n);
                this.put(175, n3);
            }
        };
        TAG = "MasterBootRecord";
    }

    private MasterBootRecord() {
    }

    public static MasterBootRecord read(ByteBuffer byteBuffer) throws IOException {
        MasterBootRecord masterBootRecord = new MasterBootRecord();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (byteBuffer.limit() >= 512) {
            if (byteBuffer.get(510) == 85 && byteBuffer.get(511) == -86) {
                for (int i = 0; i < 4; ++i) {
                    int n = i * 16 + 446;
                    byte by = byteBuffer.get(n + 4);
                    if (by == 0) continue;
                    if (by != 5 && by != 15) {
                        Object object;
                        Object object2 = object = partitionTypes.get(by & 0xFF);
                        if (object == null) {
                            object = TAG;
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Unknown partition type");
                            ((StringBuilder)object2).append(by);
                            Log.d((String)object, (String)((StringBuilder)object2).toString());
                            object2 = -1;
                        }
                        object2 = new PartitionTableEntry((Integer)object2, byteBuffer.getInt(n + 8), byteBuffer.getInt(n + 12));
                        masterBootRecord.partitions.add((PartitionTableEntry)object2);
                        continue;
                    }
                    Log.w((String)TAG, (String)"extended partitions are currently unsupported!");
                }
                return masterBootRecord;
            }
            Log.i((String)TAG, (String)"not a valid mbr partition table!");
            return null;
        }
        throw new IOException("Size mismatch!");
    }

    @Override
    public List<PartitionTableEntry> getPartitionTableEntries() {
        return this.partitions;
    }

    @Override
    public int getSize() {
        return 512;
    }
}

