/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import com.github.mjdev.libaums.ErrNo;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class JellyBeanMr2Communication
implements UsbCommunication {
    private UsbDeviceConnection deviceConnection;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;

    JellyBeanMr2Communication(UsbDeviceConnection usbDeviceConnection, UsbEndpoint usbEndpoint, UsbEndpoint usbEndpoint2) {
        this.deviceConnection = usbDeviceConnection;
        this.outEndpoint = usbEndpoint;
        this.inEndpoint = usbEndpoint2;
    }

    @Override
    public int bulkInTransfer(ByteBuffer comparable) throws IOException {
        int n = this.deviceConnection.bulkTransfer(this.inEndpoint, ((ByteBuffer)comparable).array(), ((Buffer)((Object)comparable)).position(), ((Buffer)((Object)comparable)).remaining(), 5000);
        if (n != -1) {
            ((ByteBuffer)comparable).position(((Buffer)((Object)comparable)).position() + n);
            return n;
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append("Could not read from device, result == -1 errno ");
        ((StringBuilder)comparable).append(ErrNo.getErrno());
        ((StringBuilder)comparable).append(" ");
        ((StringBuilder)comparable).append(ErrNo.getErrstr());
        throw new IOException(((StringBuilder)comparable).toString());
    }

    @Override
    public int bulkOutTransfer(ByteBuffer comparable) throws IOException {
        int n = this.deviceConnection.bulkTransfer(this.outEndpoint, ((ByteBuffer)comparable).array(), ((Buffer)((Object)comparable)).position(), ((Buffer)((Object)comparable)).remaining(), 5000);
        if (n != -1) {
            ((ByteBuffer)comparable).position(((Buffer)((Object)comparable)).position() + n);
            return n;
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append("Could not write to device, result == -1 errno ");
        ((StringBuilder)comparable).append(ErrNo.getErrno());
        ((StringBuilder)comparable).append(" ");
        ((StringBuilder)comparable).append(ErrNo.getErrstr());
        throw new IOException(((StringBuilder)comparable).toString());
    }
}

