/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.os.Build;
import android.util.Log;
import com.github.mjdev.libaums.usb.HoneyCombMr1Communication;
import com.github.mjdev.libaums.usb.JellyBeanMr2Communication;
import com.github.mjdev.libaums.usb.UsbCommunication;
import com.github.mjdev.libaums.usb.UsbRequestCommunication;

public class UsbCommunicationFactory {
    private static final String TAG = "UsbCommunicationFactory";
    private static UnderlyingUsbCommunication underlyingUsbCommunication = UnderlyingUsbCommunication.DEVICE_CONNECTION_SYNC;

    public static UsbCommunication createUsbCommunication(UsbDeviceConnection object, UsbEndpoint usbEndpoint, UsbEndpoint usbEndpoint2) {
        if (underlyingUsbCommunication == UnderlyingUsbCommunication.DEVICE_CONNECTION_SYNC) {
            if (Build.VERSION.SDK_INT >= 18) {
                object = new JellyBeanMr2Communication((UsbDeviceConnection)object, usbEndpoint, usbEndpoint2);
            } else {
                Log.i((String)TAG, (String)"using workaround usb communication");
                object = new HoneyCombMr1Communication((UsbDeviceConnection)object, usbEndpoint, usbEndpoint2);
            }
        } else {
            object = new UsbRequestCommunication((UsbDeviceConnection)object, usbEndpoint, usbEndpoint2);
        }
        return object;
    }

    public static void setUnderlyingUsbCommunication(UnderlyingUsbCommunication underlyingUsbCommunication) {
        UsbCommunicationFactory.underlyingUsbCommunication = underlyingUsbCommunication;
    }

    public static final class UnderlyingUsbCommunication
    extends Enum<UnderlyingUsbCommunication> {
        private static final /* synthetic */ UnderlyingUsbCommunication[] $VALUES;
        public static final /* enum */ UnderlyingUsbCommunication DEVICE_CONNECTION_SYNC;
        public static final /* enum */ UnderlyingUsbCommunication USB_REQUEST_ASYNC;

        static {
            UnderlyingUsbCommunication underlyingUsbCommunication;
            UnderlyingUsbCommunication underlyingUsbCommunication2;
            USB_REQUEST_ASYNC = underlyingUsbCommunication2 = new UnderlyingUsbCommunication();
            DEVICE_CONNECTION_SYNC = underlyingUsbCommunication = new UnderlyingUsbCommunication();
            $VALUES = new UnderlyingUsbCommunication[]{underlyingUsbCommunication2, underlyingUsbCommunication};
        }

        public static UnderlyingUsbCommunication valueOf(String string2) {
            return Enum.valueOf(UnderlyingUsbCommunication.class, string2);
        }

        public static UnderlyingUsbCommunication[] values() {
            return (UnderlyingUsbCommunication[])$VALUES.clone();
        }
    }
}

