/*
 * Decompiled with CFR 0.152.
 */
package com.gogolook.developmode;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.text.Html;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.gogolook.developmode.BasicDevelopMode;
import com.gogolook.developmode.DevConfig;
import com.gogolook.developmode.DevShowLogsActivity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;

public class BasicRageShake {
    public static final String IS_RAGESHAKE_ENABLE_KEY = "develop_is_rage_shake_enable";
    private static final int MAX_LOG = 16;
    private static BasicRageShake instance;
    private static ArrayBlockingQueue<String> mLogQueue;
    boolean isShow;
    private BasicDevelopMode mBasicDevelopMode;
    private ArrayList<Pair<String, String>> mButtons = new ArrayList();
    protected Context mContext;
    private Stack<Context> mContextStack;
    protected String mDialogScreenshotPath;
    protected String mLogcatPath;
    private String mMainPath;
    private MySensorEventListener mMySensorEventListener;
    protected String mScreenshotPath;
    private String mTitle;
    private WeakReference<View> mView;
    private SharedPreferences sharedPreference;

    static {
        mLogQueue = new ArrayBlockingQueue(16, false);
    }

    public BasicRageShake(Context context, BasicDevelopMode object) {
        String[] stringArray;
        int n = 0;
        this.isShow = false;
        this.mContext = context;
        this.mContextStack = new Stack();
        mLogQueue.clear();
        this.mBasicDevelopMode = object == null ? BasicDevelopMode.getInstance() : object;
        this.mMainPath = new File(context.getCacheDir().getAbsolutePath(), "/rageshake").getAbsolutePath();
        object = new File(this.mMainPath);
        if (!((File)object).exists()) {
            ((File)object).mkdir();
        }
        if ((stringArray = ((File)object).list()) != null) {
            int n2 = stringArray.length;
            while (n < n2) {
                new File((File)object, stringArray[n]).delete();
                ++n;
            }
        }
        this.sharedPreference = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public static BasicRageShake getInstance(Context context, BasicDevelopMode basicDevelopMode) {
        if (instance == null) {
            instance = new BasicRageShake(context, basicDevelopMode);
        }
        if (!BasicRageShake.instance.mContext.equals(context)) {
            BasicRageShake.instance.mContext = context;
        }
        return instance;
    }

    public static CheckBox getRageShakeButton(Context context) {
        return BasicRageShake.getRageShakeButton(context, null);
    }

    public static CheckBox getRageShakeButton(final Context context, final BasicDevelopMode basicDevelopMode) {
        CheckBox checkBox = new CheckBox(context);
        checkBox.setTextColor(-16777216);
        checkBox.setGravity(17);
        checkBox.setTextSize(20.0f);
        checkBox.setText((CharSequence)"Enable Rage Shake");
        checkBox.setChecked(BasicRageShake.getInstance(context, basicDevelopMode).isRageShakeEnable());
        if (DevConfig.IS_RC) {
            checkBox.setVisibility(8);
        } else {
            checkBox.setVisibility(0);
        }
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                if (bl) {
                    BasicRageShake.getInstance(context, basicDevelopMode).enableRageShake();
                } else {
                    BasicRageShake.getInstance(context, basicDevelopMode).disableRageShake();
                }
            }
        });
        return checkBox;
    }

    private Activity getTopActivity() {
        for (int i = this.mContextStack.size() - 1; i >= 0; --i) {
            if (!(this.mContextStack.get(i) instanceof Activity)) continue;
            return (Activity)this.mContextStack.get(i);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logcat() {
        Object object;
        Object object2;
        CharSequence charSequence = new StringBuilder();
        try {
            object2 = Runtime.getRuntime().exec(new String[]{"logcat", "-v", "time", "-d"});
            Object object3 = new InputStreamReader(((Process)object2).getInputStream());
            object = new BufferedReader((Reader)object3, 4096);
            object3 = System.getProperty("line.separator");
            while ((object2 = ((BufferedReader)object).readLine()) != null) {
                ((StringBuilder)charSequence).append((String)object2);
                ((StringBuilder)charSequence).append((String)object3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        charSequence = ((StringBuilder)charSequence).toString();
        object = new StringBuilder();
        ((StringBuilder)object).append(this.mMainPath);
        ((StringBuilder)object).append(File.separator);
        ((StringBuilder)object).append("rageshake_log.txt");
        this.mLogcatPath = ((StringBuilder)object).toString();
        object = new File(this.mLogcatPath);
        if (((File)object).exists()) {
            ((File)object).delete();
        }
        try {
            ((File)object).createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            object2 = new FileOutputStream(((File)object).getAbsolutePath());
            ((FileOutputStream)object2).write(((String)charSequence).getBytes());
            ((FileOutputStream)object2).close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void popup() {
        if (!this.isShow) {
            this.screenshot();
            this.screenshotDialog();
            this.logcat();
            if (this.mContextStack.isEmpty()) {
                return;
            }
            final Context context = this.mContextStack.peek();
            final Dialog dialog = new Dialog(context);
            RageShakeView rageShakeView = new RageShakeView(context);
            TextView textView = rageShakeView.titleText;
            CheckBox checkBox = rageShakeView.rageshakeCheckBox;
            TextView textView2 = rageShakeView.reportText;
            TextView textView3 = rageShakeView.shareText;
            TextView textView4 = rageShakeView.logcatText;
            TextView textView5 = rageShakeView.apiLogcatText;
            TextView textView6 = rageShakeView.monitorNetworkText;
            for (final Pair<String, String> object : this.mButtons) {
                rageShakeView.addMoreButton((String)object.first, (String)object.second).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        BasicRageShake.this.onButtonClickListener((String)object.first);
                        dialog.dismiss();
                    }
                });
            }
            if (TextUtils.isEmpty((CharSequence)this.mTitle)) {
                Object object2 = this.mContextStack.peek().getClass().getName();
                String[] stringArray = ((String)object2).split("\\.");
                if (stringArray.length > 0) {
                    object2 = stringArray[stringArray.length - 1];
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Current Page:\n");
                stringBuilder.append((String)object2);
                stringBuilder.append(".java");
                textView.setText((CharSequence)stringBuilder.toString());
            } else {
                textView.setText((CharSequence)Html.fromHtml((String)this.mTitle));
            }
            textView.setSingleLine(false);
            checkBox.setChecked(this.isRageShakeEnable());
            checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                    if (bl) {
                        BasicRageShake.this.enableRageShake();
                    } else {
                        BasicRageShake.this.disableRageShake();
                        Toast.makeText((Context)context, (CharSequence)"To enable RageSake, change setting in Debug Mode, please.", (int)1).show();
                    }
                }
            });
            textView2.setOnClickListener(new View.OnClickListener(){

                public void onClick(View object) {
                    Object object2 = BasicRageShake.this.mScreenshotPath;
                    object = null;
                    object2 = object2 != null ? new File(BasicRageShake.this.mScreenshotPath) : null;
                    File file = new File(BasicRageShake.this.mLogcatPath);
                    if (BasicRageShake.this.mDialogScreenshotPath != null) {
                        object = new File(BasicRageShake.this.mDialogScreenshotPath);
                    }
                    Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
                    intent.setType("plain/text");
                    intent.putExtra("android.intent.extra.EMAIL", DevConfig.RECIEVERS);
                    Serializable serializable = new StringBuilder();
                    ((StringBuilder)serializable).append("[Rage Report][");
                    ((StringBuilder)serializable).append((Object)context.getApplicationInfo().loadLabel(context.getPackageManager()));
                    ((StringBuilder)serializable).append("][");
                    ((StringBuilder)serializable).append(Build.MODEL);
                    ((StringBuilder)serializable).append(" - ");
                    ((StringBuilder)serializable).append(Build.MANUFACTURER);
                    ((StringBuilder)serializable).append("]");
                    intent.putExtra("android.intent.extra.SUBJECT", ((StringBuilder)serializable).toString());
                    serializable = new ArrayList();
                    if (object2 != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("file://");
                        stringBuilder.append(((File)object2).getAbsolutePath());
                        ((ArrayList)serializable).add(Uri.parse((String)stringBuilder.toString()));
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("file://");
                    ((StringBuilder)object2).append(file.getAbsolutePath());
                    ((ArrayList)serializable).add(Uri.parse((String)((StringBuilder)object2).toString()));
                    if (object != null) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("file://");
                        ((StringBuilder)object2).append(((File)object).getAbsolutePath());
                        ((ArrayList)serializable).add(Uri.parse((String)((StringBuilder)object2).toString()));
                    }
                    intent.putParcelableArrayListExtra("android.intent.extra.STREAM", (ArrayList)serializable);
                    intent.setFlags(0x10000000);
                    context.startActivity(intent);
                    dialog.dismiss();
                }
            });
            if (this.mScreenshotPath != null) {
                textView3.setVisibility(0);
                textView3.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        view = new Intent("android.intent.action.SEND");
                        File file = new File(BasicRageShake.this.mScreenshotPath);
                        view.setType("image/jpeg");
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("file://");
                        stringBuilder.append(file.getAbsolutePath());
                        view.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)stringBuilder.toString()));
                        view = Intent.createChooser((Intent)view, (CharSequence)"Share Screenshot");
                        view.setFlags(0x10000000);
                        context.startActivity((Intent)view);
                        dialog.dismiss();
                    }
                });
            } else {
                textView3.setVisibility(8);
            }
            if (this.mDialogScreenshotPath != null) {
                textView3.setVisibility(0);
                textView3.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        view = new Intent("android.intent.action.SEND");
                        File file = new File(BasicRageShake.this.mDialogScreenshotPath);
                        view.setType("image/jpeg");
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("file://");
                        stringBuilder.append(file.getAbsolutePath());
                        view.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)stringBuilder.toString()));
                        view = Intent.createChooser((Intent)view, (CharSequence)"Share Screenshot");
                        view.setFlags(0x10000000);
                        context.startActivity((Intent)view);
                        dialog.dismiss();
                    }
                });
            } else {
                textView3.setVisibility(8);
            }
            textView4.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    view = new Intent();
                    view.setClass(context, DevShowLogsActivity.class);
                    view.setFlags(0x10000000);
                    view.putExtra("logcat", true);
                    context.startActivity((Intent)view);
                    dialog.dismiss();
                }
            });
            textView5.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    view = new Intent();
                    view.setClass(context, DevShowLogsActivity.class);
                    view.setFlags(0x10000000);
                    view.putExtra("logcat", false);
                    context.startActivity((Intent)view);
                    dialog.dismiss();
                }
            });
            textView6.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (!BasicRageShake.this.mBasicDevelopMode.isNetworkMonitoring()) {
                        BasicRageShake.this.mBasicDevelopMode.startNetworkMonitor();
                    } else {
                        BasicRageShake.this.mBasicDevelopMode.stopNetworkMonitor();
                    }
                    dialog.dismiss();
                }
            });
            dialog.requestWindowFeature(1);
            dialog.setContentView((View)rageShakeView);
            dialog.getWindow().setType(2010);
            dialog.show();
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialogInterface) {
                    BasicRageShake.this.isShow = false;
                }
            });
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        dialog.dismiss();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                }
            }, 10000L);
            this.isShow = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void screenshot() {
        Object object = this.getTopActivity();
        Bitmap bitmap = null;
        if (object == null) {
            this.mScreenshotPath = null;
            return;
        }
        String string2 = new SimpleDateFormat("yyyy_M_dd_HH_mm_ss").format(System.currentTimeMillis());
        Comparable<StringBuilder> comparable = new StringBuilder();
        ((StringBuilder)comparable).append(this.mMainPath);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append("rageshake_screenshot_");
        ((StringBuilder)comparable).append(string2);
        ((StringBuilder)comparable).append(".jpg");
        this.mScreenshotPath = ((StringBuilder)comparable).toString();
        comparable = object.getWindow().getDecorView().getRootView();
        comparable.setDrawingCacheEnabled(true);
        object = comparable.getDrawingCache();
        if (object != null) {
            bitmap = Bitmap.createBitmap((Bitmap)object);
        }
        comparable.setDrawingCacheEnabled(false);
        if (bitmap == null) return;
        comparable = new File(this.mScreenshotPath);
        if (((File)comparable).exists()) {
            ((File)comparable).delete();
        }
        try {
            ((File)comparable).createNewFile();
        }
        catch (IOException iOException) {}
        try {
            object = new FileOutputStream((File)comparable);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)object);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void screenshotDialog() {
        Object object;
        WeakReference<View> weakReference = this.mView;
        if (weakReference != null && weakReference.get() != null) {
            try {
                weakReference = new SimpleDateFormat("yyyy_M_dd_HH_mm_ss");
                object = ((Format)((Object)weakReference)).format(System.currentTimeMillis());
                weakReference = new StringBuilder();
                ((StringBuilder)((Object)weakReference)).append(this.mMainPath);
                ((StringBuilder)((Object)weakReference)).append("rageshake_dialog_screenshot_");
                ((StringBuilder)((Object)weakReference)).append((String)object);
                ((StringBuilder)((Object)weakReference)).append(".jpg");
                this.mDialogScreenshotPath = ((StringBuilder)((Object)weakReference)).toString();
                object = ((View)this.mView.get()).getRootView();
                object.setDrawingCacheEnabled(true);
                weakReference = Bitmap.createBitmap((Bitmap)object.getDrawingCache());
                object.setDrawingCacheEnabled(false);
                object = new File(this.mDialogScreenshotPath);
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
                ((File)object).createNewFile();
            }
            catch (Exception exception) {
                this.mDialogScreenshotPath = null;
                return;
            }
        } else {
            this.mDialogScreenshotPath = null;
            return;
            catch (IOException iOException) {}
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            weakReference.compress(Bitmap.CompressFormat.JPEG, 90, fileOutputStream);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    public void addMoreButtons(String string2, String string3) {
        this.mButtons.add((Pair<String, String>)new Pair((Object)string2, (Object)string3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disableRageShake() {
        this.sharedPreference.edit().putBoolean(IS_RAGESHAKE_ENABLE_KEY, false).commit();
        try {
            ((SensorManager)this.mContext.getSystemService("sensor")).unregisterListener((SensorEventListener)this.mMySensorEventListener);
            this.mMySensorEventListener = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enableRageShake() {
        this.sharedPreference.edit().putBoolean(IS_RAGESHAKE_ENABLE_KEY, true).commit();
        try {
            if (this.mMySensorEventListener == null) {
                MySensorEventListener mySensorEventListener;
                this.mMySensorEventListener = mySensorEventListener = new MySensorEventListener();
                mySensorEventListener = (SensorManager)this.mContext.getSystemService("sensor");
                mySensorEventListener.registerListener(this.mMySensorEventListener, mySensorEventListener.getDefaultSensor(1), 3);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public ArrayBlockingQueue<String> getAPILogQueue() {
        return mLogQueue;
    }

    public Context getCurrentContext() {
        return this.mContextStack.peek();
    }

    public boolean isRageShakeEnable() {
        if (DevConfig.IS_RC) {
            return false;
        }
        return this.sharedPreference.getBoolean(IS_RAGESHAKE_ENABLE_KEY, true);
    }

    public void onButtonClickListener(String string2) {
    }

    public void putAPILog(String string2) {
        synchronized (this) {
            if (mLogQueue.size() == 16) {
                mLogQueue.poll();
            }
            string2 = string2.replace("Get", "#Get").replace("GET", "#Get").replace("get", "#Get").replace("Put", "#Put").replace("PUT", "#Put").replace("put", "#Put").replace("Post", "#Post").replace("POST", "#Post").replace("post", "#Post").replace("Delete", "#Delete").replace("DELETE", "#Delete").replace("delete", "#Delete");
            mLogQueue.add(string2);
            return;
        }
    }

    public void setTitle(String string2) {
        this.mTitle = string2;
    }

    public void setView(View view) {
        this.mView = new WeakReference<View>(view);
    }

    public void start(Context context) {
        if (this.isRageShakeEnable()) {
            this.mContextStack.push(context);
            if (this.mMySensorEventListener == null) {
                this.mMySensorEventListener = new MySensorEventListener();
                context = (SensorManager)context.getSystemService("sensor");
                context.registerListener((SensorEventListener)this.mMySensorEventListener, context.getDefaultSensor(1), 3);
            }
        }
    }

    public void stop(Context context) {
        this.mContextStack.remove(context);
        if (this.mContextStack.isEmpty()) {
            ((SensorManager)context.getSystemService("sensor")).unregisterListener((SensorEventListener)this.mMySensorEventListener);
            this.mMySensorEventListener = null;
        }
    }

    class MySensorEventListener
    implements SensorEventListener {
        long lastUpdate = 0L;
        float last_x;
        float last_y;
        float last_z;
        float x;
        float y;
        float z;

        MySensorEventListener() {
        }

        public void onAccuracyChanged(Sensor sensor, int n) {
        }

        public void onSensorChanged(SensorEvent sensorEvent) {
            long l;
            long l2;
            if (!BasicRageShake.this.isRageShakeEnable()) {
                return;
            }
            if (sensorEvent.sensor.getType() == 1 && (l2 = System.currentTimeMillis()) - (l = this.lastUpdate) > 60L) {
                float f;
                this.lastUpdate = l2;
                this.x = sensorEvent.values[0];
                this.y = sensorEvent.values[1];
                this.z = f = sensorEvent.values[2];
                if (Math.abs(this.x + this.y + f - this.last_x - this.last_y - this.last_z) / (float)(l2 - l) * 10000.0f > 900.0f) {
                    BasicRageShake.this.popup();
                }
                this.last_x = this.x;
                this.last_y = this.y;
                this.last_z = this.z;
            }
        }
    }

    private static class RageShakeView
    extends LinearLayout {
        public TextView apiLogcatText;
        public TextView logcatText;
        public TextView monitorNetworkText;
        public CheckBox rageshakeCheckBox;
        public TextView reportText;
        public TextView shareText;
        public TextView titleText;

        public RageShakeView(Context context) {
            super(context);
            TextView textView;
            this.setPadding(15, 15, 15, 15);
            this.setBackgroundColor(-1);
            this.setOrientation(1);
            this.titleText = textView = new TextView(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.titleText.setBackgroundColor(-14013902);
            this.titleText.setTextColor(-1);
            this.titleText.setGravity(17);
            this.titleText.setTextSize(15.0f);
            this.titleText.setPadding(0, 5, 0, 5);
            this.addView((View)this.titleText);
            textView = new View(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            textView.setBackgroundColor(-7829368);
            this.addView((View)textView);
            textView = new CheckBox(context);
            this.rageshakeCheckBox = textView;
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.rageshakeCheckBox.setTextColor(-16777216);
            this.rageshakeCheckBox.setGravity(17);
            this.rageshakeCheckBox.setTextSize(20.0f);
            this.rageshakeCheckBox.setText((CharSequence)"Enable Rage Shake");
            this.rageshakeCheckBox.setPadding(0, 5, 0, 5);
            this.addView((View)this.rageshakeCheckBox);
            textView = new View(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            textView.setBackgroundColor(-7829368);
            this.addView((View)textView);
            this.reportText = textView = new TextView(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.reportText.setTextColor(-16777216);
            this.reportText.setGravity(17);
            this.reportText.setTextSize(20.0f);
            this.reportText.setText((CharSequence)"Report");
            this.reportText.setBackgroundColor(1432756513);
            this.reportText.setPadding(0, 5, 0, 5);
            this.addView((View)this.reportText);
            textView = new View(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            textView.setBackgroundColor(-7829368);
            this.addView((View)textView);
            this.shareText = textView = new TextView(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.shareText.setTextColor(-16777216);
            this.shareText.setGravity(17);
            this.shareText.setTextSize(20.0f);
            this.shareText.setText((CharSequence)"Share Screenshot");
            this.shareText.setBackgroundColor(1432756513);
            this.shareText.setPadding(0, 5, 0, 5);
            this.addView((View)this.shareText);
            textView = new View(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            textView.setBackgroundColor(-7829368);
            this.addView((View)textView);
            this.logcatText = textView = new TextView(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.logcatText.setTextColor(-16777216);
            this.logcatText.setGravity(17);
            this.logcatText.setTextSize(20.0f);
            this.logcatText.setText((CharSequence)"Show Logcat");
            this.logcatText.setBackgroundColor(1432756513);
            this.logcatText.setPadding(0, 5, 0, 5);
            this.addView((View)this.logcatText);
            textView = new View(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            textView.setBackgroundColor(-7829368);
            this.addView((View)textView);
            this.apiLogcatText = textView = new TextView(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.apiLogcatText.setTextColor(-16777216);
            this.apiLogcatText.setGravity(17);
            this.apiLogcatText.setTextSize(20.0f);
            this.apiLogcatText.setText((CharSequence)"Show API Logcat");
            this.apiLogcatText.setBackgroundColor(1432756513);
            this.apiLogcatText.setPadding(0, 5, 0, 5);
            this.addView((View)this.apiLogcatText);
            textView = new View(context);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            textView.setBackgroundColor(-7829368);
            this.addView((View)textView);
            context = new TextView(context);
            this.monitorNetworkText = context;
            context.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.monitorNetworkText.setTextColor(-16777216);
            this.monitorNetworkText.setGravity(17);
            this.monitorNetworkText.setTextSize(20.0f);
            this.monitorNetworkText.setText((CharSequence)"Show Network Monitor");
            this.monitorNetworkText.setBackgroundColor(1432756513);
            this.monitorNetworkText.setPadding(0, 5, 0, 5);
            this.addView((View)this.monitorNetworkText);
        }

        public View addMoreButton(String string2, String string3) {
            string2 = new View(this.getContext());
            string2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            string2.setBackgroundColor(-7829368);
            this.addView((View)string2);
            string2 = new TextView(this.getContext());
            string2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            string2.setTextColor(-16777216);
            string2.setGravity(17);
            string2.setTextSize(20.0f);
            string2.setText((CharSequence)string3);
            string2.setBackgroundColor(1432756513);
            string2.setPadding(0, 5, 0, 5);
            this.addView((View)string2);
            return string2;
        }
    }
}

