/*
 * Decompiled with CFR 0.152.
 */
package com.gogolook.developmode;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import android.widget.Toast;
import com.gogolook.developmode.DevConfig;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DevUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private Context mContext;
    private Thread.UncaughtExceptionHandler mUncaughtExceptionHandler;

    public DevUncaughtExceptionHandler(Context context, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.mContext = context;
        this.mUncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    private static String getCurrentVersionName(Context object) {
        PackageManager packageManager = object.getPackageManager();
        object = object.getPackageName();
        try {
            object = packageManager.getPackageInfo((String)object, (int)0).versionName;
            return object;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static void init(Context context) {
        Thread.setDefaultUncaughtExceptionHandler(new DevUncaughtExceptionHandler(context, Thread.getDefaultUncaughtExceptionHandler()));
    }

    private void sendErrorMail(Context context, String string2) {
        StringBuilder stringBuilder;
        Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
        intent.setType("plain/text");
        intent.putExtra("android.intent.extra.EMAIL", DevConfig.RECIEVERS);
        if (string2.split("\n").length > 0) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("[Crash Report][");
            stringBuilder.append((Object)context.getApplicationInfo().loadLabel(context.getPackageManager()));
            stringBuilder.append("][");
            stringBuilder.append(DevUncaughtExceptionHandler.getCurrentVersionName(context));
            stringBuilder.append("][");
            stringBuilder.append(string2.split("\n")[0]);
            stringBuilder.append("]");
            intent.putExtra("android.intent.extra.SUBJECT", stringBuilder.toString());
        } else {
            stringBuilder = new StringBuilder();
            stringBuilder.append("[Crash Report][");
            stringBuilder.append((Object)context.getApplicationInfo().loadLabel(context.getPackageManager()));
            stringBuilder.append("][");
            stringBuilder.append(DevUncaughtExceptionHandler.getCurrentVersionName(context));
            stringBuilder.append("]");
            intent.putExtra("android.intent.extra.SUBJECT", stringBuilder.toString());
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append("Model: ");
        stringBuilder.append(Build.MODEL);
        stringBuilder.append("\n\n\nBrand: ");
        stringBuilder.append(Build.BRAND);
        stringBuilder.append("\n\n\n");
        stringBuilder.append(string2);
        stringBuilder.append("\n\n\n**Please attach the screenshot**\nDescribe your steps:\n");
        intent.putExtra("android.intent.extra.TEXT", stringBuilder.toString());
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    private void showDialog(Throwable object) {
        StringWriter stringWriter = new StringWriter();
        ((Throwable)object).printStackTrace(new PrintWriter(stringWriter));
        object = stringWriter.toString();
        Log.e((String)this.mContext.getPackageName(), (String)object);
        Toast.makeText((Context)this.mContext, (CharSequence)"Unfortunately, application has stopped.\n\nPlease press \"Report\" to send crash information to developers.", (int)1).show();
        this.sendErrorMail(this.mContext, (String)object);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            Process.killProcess((int)Process.myPid());
            System.exit(0);
        }
    }

    @Override
    public void uncaughtException(Thread thread2, Throwable throwable) {
        if (!DevConfig.IS_RC) {
            this.showDialog(throwable);
        } else {
            this.mUncaughtExceptionHandler.uncaughtException(thread2, throwable);
        }
    }
}

