/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import com.google.android.datatransport.Encoding;
import java.util.Arrays;
import java.util.Objects;

public final class EncodedPayload {
    private final byte[] bytes;
    private final Encoding encoding;

    public EncodedPayload(Encoding encoding, byte[] byArray) {
        Objects.requireNonNull(encoding, "encoding is null");
        Objects.requireNonNull(byArray, "bytes is null");
        this.encoding = encoding;
        this.bytes = byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EncodedPayload)) {
            return false;
        }
        object = (EncodedPayload)object;
        if (!this.encoding.equals(((EncodedPayload)object).encoding)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((EncodedPayload)object).bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public int hashCode() {
        return (this.encoding.hashCode() ^ 0xF4243) * 1000003 ^ Arrays.hashCode(this.bytes);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EncodedPayload{encoding=");
        stringBuilder.append(this.encoding);
        stringBuilder.append(", bytes=[...]}");
        return stringBuilder.toString();
    }
}

