/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import com.google.android.datatransport.runtime.logging.Logging;
import java.util.concurrent.Executor;

class SafeLoggingExecutor
implements Executor {
    private final Executor delegate;

    SafeLoggingExecutor(Executor executor) {
        this.delegate = executor;
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(new SafeLoggingRunnable(runnable));
    }

    static class SafeLoggingRunnable
    implements Runnable {
        private final Runnable delegate;

        SafeLoggingRunnable(Runnable runnable) {
            this.delegate = runnable;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            catch (Exception exception) {
                Logging.e("Executor", "Background execution failure.", exception);
            }
        }
    }
}

