/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.backends;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.google.android.datatransport.runtime.backends.BackendFactory;
import com.google.android.datatransport.runtime.backends.BackendRegistry;
import com.google.android.datatransport.runtime.backends.CreationContextFactory;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.backends.TransportBackendDiscovery;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class MetadataBackendRegistry
implements BackendRegistry {
    private static final String BACKEND_KEY_PREFIX = "backend:";
    private static final String TAG = "BackendRegistry";
    private final BackendFactoryProvider backendFactoryProvider;
    private final Map<String, TransportBackend> backends = new HashMap<String, TransportBackend>();
    private final CreationContextFactory creationContextFactory;

    @Inject
    MetadataBackendRegistry(Context context, CreationContextFactory creationContextFactory) {
        this(new BackendFactoryProvider(context), creationContextFactory);
    }

    MetadataBackendRegistry(BackendFactoryProvider backendFactoryProvider, CreationContextFactory creationContextFactory) {
        this.backendFactoryProvider = backendFactoryProvider;
        this.creationContextFactory = creationContextFactory;
    }

    @Override
    public TransportBackend get(String object) {
        synchronized (this) {
            Object object2;
            block6: {
                block5: {
                    if (!this.backends.containsKey(object)) break block5;
                    object = this.backends.get(object);
                    return object;
                }
                object2 = this.backendFactoryProvider.get((String)object);
                if (object2 != null) break block6;
                return null;
            }
            object2 = object2.create(this.creationContextFactory.create((String)object));
            this.backends.put((String)object, (TransportBackend)object2);
            return object2;
        }
    }

    static class BackendFactoryProvider {
        private final Context applicationContext;
        private Map<String, String> backendProviders = null;

        BackendFactoryProvider(Context context) {
            this.applicationContext = context;
        }

        private Map<String, String> discover(Context context) {
            if ((context = BackendFactoryProvider.getMetadata(context)) == null) {
                Log.w((String)MetadataBackendRegistry.TAG, (String)"Could not retrieve metadata, returning empty list of transport backends.");
                return Collections.emptyMap();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : context.keySet()) {
                Object object = context.get(string2);
                if (!(object instanceof String) || !string2.startsWith(MetadataBackendRegistry.BACKEND_KEY_PREFIX)) continue;
                String[] stringArray = ((String)object).split(",", -1);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    object = stringArray[i].trim();
                    if (((String)object).isEmpty()) continue;
                    hashMap.put((String)object, string2.substring(8));
                }
            }
            return hashMap;
        }

        private Map<String, String> getBackendProviders() {
            if (this.backendProviders == null) {
                this.backendProviders = this.discover(this.applicationContext);
            }
            return this.backendProviders;
        }

        private static Bundle getMetadata(Context context) {
            block7: {
                PackageManager packageManager;
                block6: {
                    try {
                        packageManager = context.getPackageManager();
                        if (packageManager != null) break block6;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.w((String)MetadataBackendRegistry.TAG, (String)"Application info not found.");
                        return null;
                    }
                    Log.w((String)MetadataBackendRegistry.TAG, (String)"Context has no PackageManager.");
                    return null;
                }
                ComponentName componentName = new ComponentName(context, TransportBackendDiscovery.class);
                context = packageManager.getServiceInfo(componentName, 128);
                if (context != null) break block7;
                Log.w((String)MetadataBackendRegistry.TAG, (String)"TransportBackendDiscovery has no service info.");
                return null;
            }
            context = context.metaData;
            return context;
        }

        BackendFactory get(String string2) {
            string2 = this.getBackendProviders().get(string2);
            if (string2 == null) {
                return null;
            }
            try {
                BackendFactory backendFactory = Class.forName(string2).asSubclass(BackendFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return backendFactory;
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.w((String)MetadataBackendRegistry.TAG, (String)String.format("Could not instantiate %s", string2), (Throwable)invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.w((String)MetadataBackendRegistry.TAG, (String)String.format("Could not instantiate %s", string2), (Throwable)noSuchMethodException);
            }
            catch (InstantiationException instantiationException) {
                Log.w((String)MetadataBackendRegistry.TAG, (String)String.format("Could not instantiate %s.", string2), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.w((String)MetadataBackendRegistry.TAG, (String)String.format("Could not instantiate %s.", string2), (Throwable)illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.w((String)MetadataBackendRegistry.TAG, (String)String.format("Class %s is not found.", string2), (Throwable)classNotFoundException);
            }
            return null;
        }
    }
}

