/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.dagger.internal;

import com.google.android.datatransport.runtime.dagger.internal.DaggerCollections;
import java.util.Collections;
import java.util.Map;

public final class MapBuilder<K, V> {
    private final Map<K, V> contributions;

    private MapBuilder(int n) {
        this.contributions = DaggerCollections.newLinkedHashMapWithExpectedSize(n);
    }

    public static <K, V> MapBuilder<K, V> newMapBuilder(int n) {
        return new MapBuilder<K, V>(n);
    }

    public Map<K, V> build() {
        if (this.contributions.size() != 0) {
            return Collections.unmodifiableMap(this.contributions);
        }
        return Collections.emptyMap();
    }

    public MapBuilder<K, V> put(K k, V v) {
        this.contributions.put(k, v);
        return this;
    }

    public MapBuilder<K, V> putAll(Map<K, V> map) {
        this.contributions.putAll(map);
        return this;
    }
}

