/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.dagger.internal;

import com.google.android.datatransport.runtime.dagger.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class SetBuilder<T> {
    private static final String SET_CONTRIBUTIONS_CANNOT_BE_NULL = "Set contributions cannot be null";
    private final List<T> contributions;

    private SetBuilder(int n) {
        this.contributions = new ArrayList<T>(n);
    }

    public static <T> SetBuilder<T> newSetBuilder(int n) {
        return new SetBuilder<T>(n);
    }

    public SetBuilder<T> add(T t) {
        this.contributions.add(Preconditions.checkNotNull(t, SET_CONTRIBUTIONS_CANNOT_BE_NULL));
        return this;
    }

    public SetBuilder<T> addAll(Collection<? extends T> collection) {
        Iterator<T> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Preconditions.checkNotNull(iterator2.next(), SET_CONTRIBUTIONS_CANNOT_BE_NULL);
        }
        this.contributions.addAll(collection);
        return this;
    }

    public Set<T> build() {
        int n = this.contributions.size();
        if (n != 0) {
            if (n != 1) {
                return Collections.unmodifiableSet(new HashSet<T>(this.contributions));
            }
            return Collections.singleton(this.contributions.get(0));
        }
        return Collections.emptySet();
    }
}

