/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.app.job.JobInfo;
import com.google.android.datatransport.Priority;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.AutoValue_SchedulerConfig;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.AutoValue_SchedulerConfig_ConfigValue;
import com.google.android.datatransport.runtime.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class SchedulerConfig {
    private static final long BACKOFF_LOG_BASE = 10000L;
    private static final long ONE_SECOND = 1000L;
    private static final long THIRTY_SECONDS = 30000L;
    private static final long TWENTY_FOUR_HOURS = 86400000L;

    private long adjustedExponentialBackoff(int n, long l) {
        long l2 = l > 1L ? l : 2L;
        double d = Math.max(1.0, Math.log(10000.0) / Math.log(l2 * (long)(--n)));
        return (long)(Math.pow(3.0, n) * (double)l * d);
    }

    public static Builder builder() {
        return new Builder();
    }

    static SchedulerConfig create(Clock clock, Map<Priority, ConfigValue> map) {
        return new AutoValue_SchedulerConfig(clock, map);
    }

    public static SchedulerConfig getDefault(Clock clock) {
        return SchedulerConfig.builder().addConfig(Priority.DEFAULT, ConfigValue.builder().setDelta(30000L).setMaxAllowedDelay(86400000L).build()).addConfig(Priority.HIGHEST, ConfigValue.builder().setDelta(1000L).setMaxAllowedDelay(86400000L).build()).addConfig(Priority.VERY_LOW, ConfigValue.builder().setDelta(86400000L).setMaxAllowedDelay(86400000L).setFlags(SchedulerConfig.immutableSetOf(Flag.NETWORK_UNMETERED, Flag.DEVICE_IDLE)).build()).setClock(clock).build();
    }

    private static <T> Set<T> immutableSetOf(T ... TArray) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(TArray)));
    }

    private void populateFlags(JobInfo.Builder builder, Set<Flag> set) {
        if (set.contains((Object)Flag.NETWORK_UNMETERED)) {
            builder.setRequiredNetworkType(2);
        } else {
            builder.setRequiredNetworkType(1);
        }
        if (set.contains((Object)Flag.DEVICE_CHARGING)) {
            builder.setRequiresCharging(true);
        }
        if (set.contains((Object)Flag.DEVICE_IDLE)) {
            builder.setRequiresDeviceIdle(true);
        }
    }

    public JobInfo.Builder configureJob(JobInfo.Builder builder, Priority priority, long l, int n) {
        builder.setMinimumLatency(this.getScheduleDelay(priority, l, n));
        this.populateFlags(builder, this.getValues().get((Object)priority).getFlags());
        return builder;
    }

    abstract Clock getClock();

    public Set<Flag> getFlags(Priority priority) {
        return this.getValues().get((Object)priority).getFlags();
    }

    public long getScheduleDelay(Priority object, long l, int n) {
        long l2 = this.getClock().getTime();
        object = this.getValues().get(object);
        return Math.min(Math.max(this.adjustedExponentialBackoff(n, ((ConfigValue)object).getDelta()), l - l2), ((ConfigValue)object).getMaxAllowedDelay());
    }

    abstract Map<Priority, ConfigValue> getValues();

    public static class Builder {
        private Clock clock;
        private Map<Priority, ConfigValue> values = new HashMap<Priority, ConfigValue>();

        public Builder addConfig(Priority priority, ConfigValue configValue) {
            this.values.put(priority, configValue);
            return this;
        }

        public SchedulerConfig build() {
            Objects.requireNonNull(this.clock, "missing required property: clock");
            if (this.values.keySet().size() >= Priority.values().length) {
                Map<Priority, ConfigValue> map = this.values;
                this.values = new HashMap<Priority, ConfigValue>();
                return SchedulerConfig.create(this.clock, map);
            }
            throw new IllegalStateException("Not all priorities have been configured");
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }
    }

    public static abstract class ConfigValue {
        public static Builder builder() {
            return new AutoValue_SchedulerConfig_ConfigValue.Builder().setFlags(Collections.<Flag>emptySet());
        }

        abstract long getDelta();

        abstract Set<Flag> getFlags();

        abstract long getMaxAllowedDelay();

        public static abstract class Builder {
            public abstract ConfigValue build();

            public abstract Builder setDelta(long var1);

            public abstract Builder setFlags(Set<Flag> var1);

            public abstract Builder setMaxAllowedDelay(long var1);
        }
    }

    public static final class Flag
    extends Enum<Flag> {
        private static final /* synthetic */ Flag[] $VALUES;
        public static final /* enum */ Flag DEVICE_CHARGING;
        public static final /* enum */ Flag DEVICE_IDLE;
        public static final /* enum */ Flag NETWORK_UNMETERED;

        static {
            Flag flag;
            Flag flag2;
            Flag flag3;
            NETWORK_UNMETERED = flag3 = new Flag();
            DEVICE_IDLE = flag2 = new Flag();
            DEVICE_CHARGING = flag = new Flag();
            $VALUES = new Flag[]{flag3, flag2, flag};
        }

        public static Flag valueOf(String string2) {
            return Enum.valueOf(Flag.class, string2);
        }

        public static Flag[] values() {
            return (Flag[])$VALUES.clone();
        }
    }
}

