/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.persistence;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.os.SystemClock;
import android.util.Base64;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.runtime.EncodedPayload;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.dagger.Lazy;
import com.google.android.datatransport.runtime.firebase.transport.ClientMetrics;
import com.google.android.datatransport.runtime.firebase.transport.GlobalMetrics;
import com.google.android.datatransport.runtime.firebase.transport.LogEventDropped;
import com.google.android.datatransport.runtime.firebase.transport.LogSourceMetrics;
import com.google.android.datatransport.runtime.firebase.transport.StorageMetrics;
import com.google.android.datatransport.runtime.firebase.transport.TimeWindow;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.persistence.ClientHealthMetricsStore;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStoreConfig;
import com.google.android.datatransport.runtime.scheduling.persistence.PersistedEvent;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda0;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda1;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda10;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda11;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda12;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda13;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda14;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda15;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda16;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda17;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda18;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda19;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda2;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda20;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda21;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda22;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda23;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda24;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda25;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda26;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda27;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda3;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda4;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda5;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda6;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda7;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda8;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$ExternalSyntheticLambda9;
import com.google.android.datatransport.runtime.scheduling.persistence.SchemaManager;
import com.google.android.datatransport.runtime.synchronization.SynchronizationException;
import com.google.android.datatransport.runtime.synchronization.SynchronizationGuard;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.android.datatransport.runtime.util.PriorityMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Singleton
public class SQLiteEventStore
implements EventStore,
SynchronizationGuard,
ClientHealthMetricsStore {
    private static final int LOCK_RETRY_BACK_OFF_MILLIS = 50;
    private static final String LOG_TAG = "SQLiteEventStore";
    static final int MAX_RETRIES = 16;
    private static final Encoding PROTOBUF_ENCODING = Encoding.of("proto");
    private final EventStoreConfig config;
    private final Clock monotonicClock;
    private final Lazy<String> packageName;
    private final SchemaManager schemaManager;
    private final Clock wallClock;

    @Inject
    SQLiteEventStore(Clock clock, Clock clock2, EventStoreConfig eventStoreConfig, SchemaManager schemaManager, @Named(value="PACKAGE_NAME") Lazy<String> lazy) {
        this.schemaManager = schemaManager;
        this.wallClock = clock;
        this.monotonicClock = clock2;
        this.config = eventStoreConfig;
        this.packageName = lazy;
    }

    private LogEventDropped.Reason convertToReason(int n) {
        if (n == LogEventDropped.Reason.REASON_UNKNOWN.getNumber()) {
            return LogEventDropped.Reason.REASON_UNKNOWN;
        }
        if (n == LogEventDropped.Reason.MESSAGE_TOO_OLD.getNumber()) {
            return LogEventDropped.Reason.MESSAGE_TOO_OLD;
        }
        if (n == LogEventDropped.Reason.CACHE_FULL.getNumber()) {
            return LogEventDropped.Reason.CACHE_FULL;
        }
        if (n == LogEventDropped.Reason.PAYLOAD_TOO_BIG.getNumber()) {
            return LogEventDropped.Reason.PAYLOAD_TOO_BIG;
        }
        if (n == LogEventDropped.Reason.MAX_RETRIES_REACHED.getNumber()) {
            return LogEventDropped.Reason.MAX_RETRIES_REACHED;
        }
        if (n == LogEventDropped.Reason.INVALID_PAYLOD.getNumber()) {
            return LogEventDropped.Reason.INVALID_PAYLOD;
        }
        if (n == LogEventDropped.Reason.SERVER_ERROR.getNumber()) {
            return LogEventDropped.Reason.SERVER_ERROR;
        }
        Logging.d(LOG_TAG, "%n is not valid. No matched LogEventDropped-Reason found. Treated it as REASON_UNKNOWN", (Object)n);
        return LogEventDropped.Reason.REASON_UNKNOWN;
    }

    private void ensureBeginTransaction(SQLiteDatabase sQLiteDatabase) {
        this.retryIfDbLocked(new SQLiteEventStore$$ExternalSyntheticLambda18(sQLiteDatabase), SQLiteEventStore$$ExternalSyntheticLambda16.INSTANCE);
    }

    private long ensureTransportContext(SQLiteDatabase sQLiteDatabase, TransportContext transportContext) {
        Long l = this.getTransportContextId(sQLiteDatabase, transportContext);
        if (l != null) {
            return l;
        }
        l = new ContentValues();
        l.put("backend_name", transportContext.getBackendName());
        l.put("priority", PriorityMapping.toInt(transportContext.getPriority()));
        l.put("next_request_ms", 0);
        if (transportContext.getExtras() != null) {
            l.put("extras", Base64.encodeToString((byte[])transportContext.getExtras(), (int)0));
        }
        return sQLiteDatabase.insert("transport_contexts", null, (ContentValues)l);
    }

    private GlobalMetrics getGlobalMetrics() {
        return GlobalMetrics.newBuilder().setStorageMetrics(StorageMetrics.newBuilder().setCurrentCacheSizeBytes(this.getByteSize()).setMaxCacheSizeBytes(EventStoreConfig.DEFAULT.getMaxStorageSizeInBytes()).build()).build();
    }

    private long getPageCount() {
        return this.getDb().compileStatement("PRAGMA page_count").simpleQueryForLong();
    }

    private long getPageSize() {
        return this.getDb().compileStatement("PRAGMA page_size").simpleQueryForLong();
    }

    private TimeWindow getTimeWindow() {
        return (TimeWindow)this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda11(this.wallClock.getTime()));
    }

    private Long getTransportContextId(SQLiteDatabase sQLiteDatabase, TransportContext object) {
        StringBuilder stringBuilder = new StringBuilder("backend_name = ? and priority = ?");
        String[] stringArray = new ArrayList(Arrays.asList(((TransportContext)object).getBackendName(), String.valueOf(PriorityMapping.toInt(((TransportContext)object).getPriority()))));
        if (((TransportContext)object).getExtras() != null) {
            stringBuilder.append(" and extras = ?");
            stringArray.add((String)Base64.encodeToString((byte[])((TransportContext)object).getExtras(), (int)0));
        } else {
            stringBuilder.append(" and extras is null");
        }
        object = stringBuilder.toString();
        stringArray = stringArray.toArray(new String[0]);
        return (Long)SQLiteEventStore.tryWithCursor(sQLiteDatabase.query("transport_contexts", new String[]{"_id"}, (String)object, stringArray, null, null, null), SQLiteEventStore$$ExternalSyntheticLambda8.INSTANCE);
    }

    private boolean isStorageAtLimit() {
        boolean bl = this.getPageCount() * this.getPageSize() >= this.config.getMaxStorageSizeInBytes();
        return bl;
    }

    private List<PersistedEvent> join(List<PersistedEvent> list, Map<Long, Set<Metadata>> map) {
        ListIterator<PersistedEvent> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            PersistedEvent persistedEvent = listIterator.next();
            if (!map.containsKey(persistedEvent.getId())) continue;
            EventInternal.Builder builder = persistedEvent.getEvent().toBuilder();
            for (Metadata metadata : map.get(persistedEvent.getId())) {
                builder.addMetadata(metadata.key, metadata.value);
            }
            listIterator.set(PersistedEvent.create(persistedEvent.getId(), persistedEvent.getTransportContext(), builder.build()));
        }
        return list;
    }

    static /* synthetic */ Object lambda$clearDb$13(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.delete("events", null, new String[0]);
        sQLiteDatabase.delete("transport_contexts", null, new String[0]);
        return null;
    }

    static /* synthetic */ Object lambda$ensureBeginTransaction$24(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.beginTransaction();
        return null;
    }

    static /* synthetic */ Object lambda$ensureBeginTransaction$25(Throwable throwable) {
        throw new SynchronizationException("Timed out while trying to acquire the lock.", throwable);
    }

    static /* synthetic */ SQLiteDatabase lambda$getDb$0(Throwable throwable) {
        throw new SynchronizationException("Timed out while trying to open db.", throwable);
    }

    static /* synthetic */ Long lambda$getNextCallTime$5(Cursor cursor) {
        if (cursor.moveToNext()) {
            return cursor.getLong(0);
        }
        return 0L;
    }

    static /* synthetic */ TimeWindow lambda$getTimeWindow$21(long l, Cursor cursor) {
        cursor.moveToNext();
        long l2 = cursor.getLong(0);
        return TimeWindow.newBuilder().setStartMs(l2).setEndMs(l).build();
    }

    static /* synthetic */ TimeWindow lambda$getTimeWindow$22(long l, SQLiteDatabase sQLiteDatabase) {
        return (TimeWindow)SQLiteEventStore.tryWithCursor(sQLiteDatabase.rawQuery("SELECT last_metrics_upload_ms FROM global_log_event_state LIMIT 1", new String[0]), new SQLiteEventStore$$ExternalSyntheticLambda0(l));
    }

    static /* synthetic */ Long lambda$getTransportContextId$2(Cursor cursor) {
        if (!cursor.moveToNext()) {
            return null;
        }
        return cursor.getLong(0);
    }

    static /* synthetic */ List lambda$loadActiveContexts$10(SQLiteDatabase sQLiteDatabase) {
        return (List)SQLiteEventStore.tryWithCursor(sQLiteDatabase.rawQuery("SELECT distinct t._id, t.backend_name, t.priority, t.extras FROM transport_contexts AS t, events AS e WHERE e.context_id = t._id", new String[0]), SQLiteEventStore$$ExternalSyntheticLambda9.INSTANCE);
    }

    static /* synthetic */ List lambda$loadActiveContexts$9(Cursor cursor) {
        ArrayList<TransportContext> arrayList = new ArrayList<TransportContext>();
        while (cursor.moveToNext()) {
            arrayList.add(TransportContext.builder().setBackendName(cursor.getString(1)).setPriority(PriorityMapping.valueOf(cursor.getInt(2))).setExtras(SQLiteEventStore.maybeBase64Decode(cursor.getString(3))).build());
        }
        return arrayList;
    }

    static /* synthetic */ Object lambda$loadMetadata$16(Map map, Cursor cursor) {
        while (cursor.moveToNext()) {
            HashSet<Metadata> hashSet;
            long l = cursor.getLong(0);
            HashSet<Metadata> hashSet2 = hashSet = (HashSet<Metadata>)map.get(l);
            if (hashSet == null) {
                hashSet2 = new HashSet<Metadata>();
                map.put(l, hashSet2);
            }
            hashSet2.add(new Metadata(cursor.getString(1), cursor.getString(2)));
        }
        return null;
    }

    static /* synthetic */ byte[] lambda$readPayload$15(Cursor object) {
        byte[] byArray;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = 0;
        while (object.moveToNext()) {
            byArray = object.getBlob(0);
            arrayList.add(byArray);
            n += byArray.length;
        }
        byArray = new byte[n];
        n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (byte[])arrayList.get(i);
            System.arraycopy(object, 0, byArray, n, ((Cursor)object).length);
            n += ((Cursor)object).length;
        }
        return byArray;
    }

    static /* synthetic */ Boolean lambda$recordLogEventDropped$17(Cursor cursor) {
        boolean bl = cursor.getCount() > 0;
        return bl;
    }

    static /* synthetic */ Object lambda$recordLogEventDropped$18(String string2, LogEventDropped.Reason reason, long l, SQLiteDatabase sQLiteDatabase) {
        if (!((Boolean)SQLiteEventStore.tryWithCursor(sQLiteDatabase.rawQuery("SELECT 1 FROM log_event_dropped WHERE log_source = ? AND reason = ?", new String[]{string2, Integer.toString(reason.getNumber())}), SQLiteEventStore$$ExternalSyntheticLambda12.INSTANCE)).booleanValue()) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("log_source", string2);
            contentValues.put("reason", Integer.valueOf(reason.getNumber()));
            contentValues.put("events_dropped_count", Long.valueOf(l));
            sQLiteDatabase.insert("log_event_dropped", null, contentValues);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("UPDATE log_event_dropped SET events_dropped_count = events_dropped_count + ");
            stringBuilder.append(l);
            stringBuilder.append(" WHERE log_source = ? AND reason = ?");
            sQLiteDatabase.execSQL(stringBuilder.toString(), (Object[])new String[]{string2, Integer.toString(reason.getNumber())});
        }
        return null;
    }

    static /* synthetic */ Object lambda$recordNextCallTime$7(long l, TransportContext transportContext, SQLiteDatabase sQLiteDatabase) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("next_request_ms", Long.valueOf(l));
        if (sQLiteDatabase.update("transport_contexts", contentValues, "backend_name = ? and priority = ?", new String[]{transportContext.getBackendName(), String.valueOf(PriorityMapping.toInt(transportContext.getPriority()))}) < 1) {
            contentValues.put("backend_name", transportContext.getBackendName());
            contentValues.put("priority", Integer.valueOf(PriorityMapping.toInt(transportContext.getPriority())));
            sQLiteDatabase.insert("transport_contexts", null, contentValues);
        }
        return null;
    }

    private List<PersistedEvent> loadEvents(SQLiteDatabase sQLiteDatabase, TransportContext transportContext) {
        ArrayList<PersistedEvent> arrayList = new ArrayList<PersistedEvent>();
        Object object = this.getTransportContextId(sQLiteDatabase, transportContext);
        if (object == null) {
            return arrayList;
        }
        object = ((Long)object).toString();
        int n = this.config.getLoadBatchSize();
        SQLiteEventStore.tryWithCursor(sQLiteDatabase.query("events", new String[]{"_id", "transport_name", "timestamp_ms", "uptime_ms", "payload_encoding", "payload", "code", "inline"}, "context_id = ?", new String[]{object}, null, null, null, String.valueOf(n)), new SQLiteEventStore$$ExternalSyntheticLambda3(this, arrayList, transportContext));
        return arrayList;
    }

    private Map<Long, Set<Metadata>> loadMetadata(SQLiteDatabase sQLiteDatabase, List<PersistedEvent> object) {
        HashMap<Long, Set<Metadata>> hashMap = new HashMap<Long, Set<Metadata>>();
        StringBuilder stringBuilder = new StringBuilder("event_id IN (");
        for (int i = 0; i < object.size(); ++i) {
            stringBuilder.append(object.get(i).getId());
            if (i >= object.size() - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        object = stringBuilder.toString();
        SQLiteEventStore.tryWithCursor(sQLiteDatabase.query("event_metadata", new String[]{"event_id", "name", "value"}, (String)object, null, null, null, null), new SQLiteEventStore$$ExternalSyntheticLambda6(hashMap));
        return hashMap;
    }

    private static byte[] maybeBase64Decode(String string2) {
        if (string2 == null) {
            return null;
        }
        return Base64.decode((String)string2, (int)0);
    }

    private void populateLogSourcesMetrics(ClientMetrics.Builder builder, Map<String, List<LogEventDropped>> object) {
        for (Map.Entry entry : object.entrySet()) {
            builder.addLogSourceMetrics(LogSourceMetrics.newBuilder().setLogSource((String)entry.getKey()).setLogEventDroppedList((List)entry.getValue()).build());
        }
    }

    private byte[] readPayload(long l) {
        return (byte[])SQLiteEventStore.tryWithCursor(this.getDb().query("event_payloads", new String[]{"bytes"}, "event_id = ?", new String[]{String.valueOf(l)}, null, null, "sequence_num"), SQLiteEventStore$$ExternalSyntheticLambda10.INSTANCE);
    }

    private <T> T retryIfDbLocked(Producer<T> producer, Function<Throwable, T> function) {
        long l = this.monotonicClock.getTime();
        while (true) {
            T t;
            try {
                t = producer.produce();
            }
            catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                if (this.monotonicClock.getTime() >= (long)this.config.getCriticalSectionEnterTimeoutMs() + l) {
                    return function.apply(sQLiteDatabaseLockedException);
                }
                SystemClock.sleep((long)50L);
                continue;
            }
            return t;
        }
    }

    private static Encoding toEncoding(String string2) {
        if (string2 == null) {
            return PROTOBUF_ENCODING;
        }
        return Encoding.of(string2);
    }

    private static String toIdList(Iterable<PersistedEvent> object) {
        StringBuilder stringBuilder = new StringBuilder("(");
        object = object.iterator();
        while (object.hasNext()) {
            stringBuilder.append(((PersistedEvent)object.next()).getId());
            if (!object.hasNext()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    static <T> T tryWithCursor(Cursor cursor, Function<Cursor, T> function) {
        try {
            function = function.apply(cursor);
            return (T)function;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public int cleanUp() {
        return (Integer)this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda24(this, this.wallClock.getTime() - this.config.getEventCleanUpAge()));
    }

    public void clearDb() {
        this.inTransaction(SQLiteEventStore$$ExternalSyntheticLambda14.INSTANCE);
    }

    @Override
    public void close() {
        this.schemaManager.close();
    }

    long getByteSize() {
        return this.getPageCount() * this.getPageSize();
    }

    SQLiteDatabase getDb() {
        SchemaManager schemaManager = this.schemaManager;
        Objects.requireNonNull(schemaManager);
        return (SQLiteDatabase)this.retryIfDbLocked(new SQLiteEventStore$$ExternalSyntheticLambda19(schemaManager), SQLiteEventStore$$ExternalSyntheticLambda17.INSTANCE);
    }

    @Override
    public long getNextCallTime(TransportContext transportContext) {
        return (Long)SQLiteEventStore.tryWithCursor(this.getDb().rawQuery("SELECT next_request_ms FROM transport_contexts WHERE backend_name = ? and priority = ?", new String[]{transportContext.getBackendName(), String.valueOf(PriorityMapping.toInt(transportContext.getPriority()))}), SQLiteEventStore$$ExternalSyntheticLambda7.INSTANCE);
    }

    @Override
    public boolean hasPendingEventsFor(TransportContext transportContext) {
        return (Boolean)this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda26(this, transportContext));
    }

    <T> T inTransaction(Function<SQLiteDatabase, T> function) {
        SQLiteDatabase sQLiteDatabase = this.getDb();
        sQLiteDatabase.beginTransaction();
        try {
            function = function.apply(sQLiteDatabase);
            sQLiteDatabase.setTransactionSuccessful();
            return (T)function;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    public /* synthetic */ Object lambda$cleanUp$11$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(Cursor cursor) {
        while (cursor.moveToNext()) {
            int n = cursor.getInt(0);
            String string2 = cursor.getString(1);
            this.recordLogEventDropped(n, LogEventDropped.Reason.MESSAGE_TOO_OLD, string2);
        }
        return null;
    }

    public /* synthetic */ Integer lambda$cleanUp$12$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(long l, SQLiteDatabase sQLiteDatabase) {
        String[] stringArray = new String[]{String.valueOf(l)};
        SQLiteEventStore.tryWithCursor(sQLiteDatabase.rawQuery("SELECT COUNT(*), transport_name FROM events WHERE timestamp_ms < ? GROUP BY transport_name", stringArray), new SQLiteEventStore$$ExternalSyntheticLambda21(this));
        return sQLiteDatabase.delete("events", "timestamp_ms < ?", stringArray);
    }

    public /* synthetic */ Boolean lambda$hasPendingEventsFor$6$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(TransportContext object, SQLiteDatabase sQLiteDatabase) {
        if ((object = this.getTransportContextId(sQLiteDatabase, (TransportContext)object)) == null) {
            return false;
        }
        return (Boolean)SQLiteEventStore.tryWithCursor(this.getDb().rawQuery("SELECT 1 FROM events WHERE context_id = ? LIMIT 1", new String[]{((Long)object).toString()}), SQLiteEventStore$$ExternalSyntheticLambda13.INSTANCE);
    }

    public /* synthetic */ List lambda$loadBatch$8$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(TransportContext object, SQLiteDatabase sQLiteDatabase) {
        object = this.loadEvents(sQLiteDatabase, (TransportContext)object);
        return this.join((List<PersistedEvent>)object, this.loadMetadata(sQLiteDatabase, (List<PersistedEvent>)object));
    }

    public /* synthetic */ ClientMetrics lambda$loadClientMetrics$19$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(Map map, ClientMetrics.Builder builder, Cursor cursor) {
        while (cursor.moveToNext()) {
            String string2 = cursor.getString(0);
            LogEventDropped.Reason reason = this.convertToReason(cursor.getInt(1));
            long l = cursor.getLong(2);
            if (!map.containsKey(string2)) {
                map.put(string2, new ArrayList());
            }
            ((List)map.get(string2)).add(LogEventDropped.newBuilder().setReason(reason).setEventsDroppedCount(l).build());
        }
        this.populateLogSourcesMetrics(builder, map);
        builder.setWindow(this.getTimeWindow());
        builder.setGlobalMetrics(this.getGlobalMetrics());
        builder.setAppNamespace(this.packageName.get());
        return builder.build();
    }

    public /* synthetic */ ClientMetrics lambda$loadClientMetrics$20$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(String string2, Map map, ClientMetrics.Builder builder, SQLiteDatabase sQLiteDatabase) {
        return (ClientMetrics)SQLiteEventStore.tryWithCursor(sQLiteDatabase.rawQuery(string2, new String[0]), new SQLiteEventStore$$ExternalSyntheticLambda4(this, map, builder));
    }

    public /* synthetic */ Object lambda$loadEvents$14$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(List list, TransportContext transportContext, Cursor cursor) {
        while (cursor.moveToNext()) {
            boolean bl = false;
            long l = cursor.getLong(0);
            if (cursor.getInt(7) != 0) {
                bl = true;
            }
            EventInternal.Builder builder = EventInternal.builder().setTransportName(cursor.getString(1)).setEventMillis(cursor.getLong(2)).setUptimeMillis(cursor.getLong(3));
            if (bl) {
                builder.setEncodedPayload(new EncodedPayload(SQLiteEventStore.toEncoding(cursor.getString(4)), cursor.getBlob(5)));
            } else {
                builder.setEncodedPayload(new EncodedPayload(SQLiteEventStore.toEncoding(cursor.getString(4)), this.readPayload(l)));
            }
            if (!cursor.isNull(6)) {
                builder.setCode(cursor.getInt(6));
            }
            list.add(PersistedEvent.create(l, transportContext, builder.build()));
        }
        return null;
    }

    public /* synthetic */ Long lambda$persist$1$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(EventInternal object, TransportContext object2, SQLiteDatabase sQLiteDatabase) {
        if (this.isStorageAtLimit()) {
            this.recordLogEventDropped(1L, LogEventDropped.Reason.CACHE_FULL, ((EventInternal)object).getTransportName());
            return -1L;
        }
        long l = this.ensureTransportContext(sQLiteDatabase, (TransportContext)object2);
        int n = this.config.getMaxBlobByteSizePerRow();
        Object object3 = ((EventInternal)object).getEncodedPayload().getBytes();
        int n2 = ((byte[])object3).length;
        boolean bl = n2 <= n;
        Object object4 = new ContentValues();
        object4.put("context_id", Long.valueOf(l));
        object4.put("transport_name", ((EventInternal)object).getTransportName());
        object4.put("timestamp_ms", Long.valueOf(((EventInternal)object).getEventMillis()));
        object4.put("uptime_ms", Long.valueOf(((EventInternal)object).getUptimeMillis()));
        object4.put("payload_encoding", ((EventInternal)object).getEncodedPayload().getEncoding().getName());
        object4.put("code", ((EventInternal)object).getCode());
        object4.put("num_attempts", Integer.valueOf(0));
        object4.put("inline", Boolean.valueOf(bl));
        object2 = bl ? (Object)object3 : (Object)new byte[0];
        object4.put("payload", (byte[])object2);
        l = sQLiteDatabase.insert("events", null, object4);
        if (!bl) {
            n2 = (int)Math.ceil((double)((byte[])object3).length / (double)n);
            for (int i = 1; i <= n2; ++i) {
                object4 = Arrays.copyOfRange((byte[])object3, (i - 1) * n, Math.min(i * n, ((Object)object3).length));
                object2 = new ContentValues();
                object2.put("event_id", Long.valueOf(l));
                object2.put("sequence_num", Integer.valueOf(i));
                object2.put("bytes", (byte[])object4);
                sQLiteDatabase.insert("event_payloads", null, (ContentValues)object2);
            }
        }
        object3 = ((EventInternal)object).getMetadata().entrySet().iterator();
        while (object3.hasNext()) {
            object = (Map.Entry)object3.next();
            object2 = new ContentValues();
            object2.put("event_id", Long.valueOf(l));
            object2.put("name", (String)object.getKey());
            object2.put("value", (String)object.getValue());
            sQLiteDatabase.insert("event_metadata", null, (ContentValues)object2);
        }
        return l;
    }

    public /* synthetic */ Object lambda$recordFailure$3$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(Cursor cursor) {
        while (cursor.moveToNext()) {
            int n = cursor.getInt(0);
            String string2 = cursor.getString(1);
            this.recordLogEventDropped(n, LogEventDropped.Reason.MAX_RETRIES_REACHED, string2);
        }
        return null;
    }

    public /* synthetic */ Object lambda$recordFailure$4$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(String string2, String string3, SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.compileStatement(string2).execute();
        SQLiteEventStore.tryWithCursor(sQLiteDatabase.rawQuery(string3, null), new SQLiteEventStore$$ExternalSyntheticLambda22(this));
        sQLiteDatabase.compileStatement("DELETE FROM events WHERE num_attempts >= 16").execute();
        return null;
    }

    public /* synthetic */ Object lambda$resetClientMetrics$23$com-google-android-datatransport-runtime-scheduling-persistence-SQLiteEventStore(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.compileStatement("DELETE FROM log_event_dropped").execute();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE global_log_event_state SET last_metrics_upload_ms=");
        stringBuilder.append(this.wallClock.getTime());
        sQLiteDatabase.compileStatement(stringBuilder.toString()).execute();
        return null;
    }

    @Override
    public Iterable<TransportContext> loadActiveContexts() {
        return (Iterable)this.inTransaction(SQLiteEventStore$$ExternalSyntheticLambda15.INSTANCE);
    }

    @Override
    public Iterable<PersistedEvent> loadBatch(TransportContext transportContext) {
        return (Iterable)this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda27(this, transportContext));
    }

    @Override
    public ClientMetrics loadClientMetrics() {
        ClientMetrics.Builder builder = ClientMetrics.newBuilder();
        return (ClientMetrics)this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda2(this, "SELECT log_source, reason, events_dropped_count FROM log_event_dropped", new HashMap(), builder));
    }

    @Override
    public PersistedEvent persist(TransportContext transportContext, EventInternal eventInternal) {
        Logging.d(LOG_TAG, "Storing event with priority=%s, name=%s for destination %s", new Object[]{transportContext.getPriority(), eventInternal.getTransportName(), transportContext.getBackendName()});
        long l = (Long)this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda25(this, eventInternal, transportContext));
        if (l < 1L) {
            return null;
        }
        return PersistedEvent.create(l, transportContext, eventInternal);
    }

    @Override
    public void recordFailure(Iterable<PersistedEvent> iterable) {
        if (!iterable.iterator().hasNext()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE events SET num_attempts = num_attempts + 1 WHERE _id in ");
        stringBuilder.append(SQLiteEventStore.toIdList(iterable));
        this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda1(this, stringBuilder.toString(), "SELECT COUNT(*), transport_name FROM events WHERE num_attempts >= 16 GROUP BY transport_name"));
    }

    @Override
    public void recordLogEventDropped(long l, LogEventDropped.Reason reason, String string2) {
        this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda5(string2, reason, l));
    }

    @Override
    public void recordNextCallTime(TransportContext transportContext, long l) {
        this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda20(l, transportContext));
    }

    @Override
    public void recordSuccess(Iterable<PersistedEvent> object) {
        if (!object.iterator().hasNext()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM events WHERE _id in ");
        stringBuilder.append(SQLiteEventStore.toIdList(object));
        object = stringBuilder.toString();
        this.getDb().compileStatement((String)object).execute();
    }

    @Override
    public void resetClientMetrics() {
        this.inTransaction(new SQLiteEventStore$$ExternalSyntheticLambda23(this));
    }

    @Override
    public <T> T runCriticalSection(SynchronizationGuard.CriticalSection<T> criticalSection) {
        SQLiteDatabase sQLiteDatabase = this.getDb();
        this.ensureBeginTransaction(sQLiteDatabase);
        try {
            criticalSection = criticalSection.execute();
            sQLiteDatabase.setTransactionSuccessful();
            return (T)criticalSection;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    static interface Function<T, U> {
        public U apply(T var1);
    }

    private static class Metadata {
        final String key;
        final String value;

        private Metadata(String string2, String string3) {
            this.key = string2;
            this.value = string3;
        }
    }

    static interface Producer<T> {
        public T produce();
    }
}

