/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.util;

import android.util.SparseArray;
import com.google.android.datatransport.Priority;
import java.util.HashMap;

public final class PriorityMapping {
    private static HashMap<Priority, Integer> PRIORITY_INT_MAP;
    private static SparseArray<Priority> PRIORITY_MAP;

    static {
        PRIORITY_MAP = new SparseArray();
        HashMap<Priority, Integer> hashMap = new HashMap<Priority, Integer>();
        PRIORITY_INT_MAP = hashMap;
        hashMap.put(Priority.DEFAULT, 0);
        PRIORITY_INT_MAP.put(Priority.VERY_LOW, 1);
        PRIORITY_INT_MAP.put(Priority.HIGHEST, 2);
        for (Priority priority : PRIORITY_INT_MAP.keySet()) {
            PRIORITY_MAP.append(PRIORITY_INT_MAP.get((Object)priority).intValue(), (Object)priority);
        }
    }

    public static int toInt(Priority priority) {
        Comparable<Integer> comparable = PRIORITY_INT_MAP.get((Object)priority);
        if (comparable != null) {
            return (Integer)comparable;
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append("PriorityMapping is missing known Priority value ");
        ((StringBuilder)comparable).append((Object)priority);
        throw new IllegalStateException(((StringBuilder)comparable).toString());
    }

    public static Priority valueOf(int n) {
        Object object = (Priority)((Object)PRIORITY_MAP.get(n));
        if (object != null) {
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unknown Priority for value ");
        ((StringBuilder)object).append(n);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }
}

